//
// See the file LICENSE for redistribution information.
//
// Copyright (c) 2002-2005
//	Sleepycat Software.  All rights reserved.
//
// $Id: XmlInputStreamWrapper.hpp,v 1.5 2005/04/05 16:44:03 bostic Exp $
//

#ifndef __XMLINPUTSTREAMWRAPPER_HPP
#define	__XMLINPUTSTREAMWRAPPER_HPP

#include <dbxml/XmlInputStream.hpp>
#include "Document.hpp"

#include <xercesc/sax/InputSource.hpp>
#include <xercesc/util/BinInputStream.hpp>

namespace DbXml
{

class XmlBinStream : public XERCES_CPP_NAMESPACE_QUALIFIER BinInputStream
{
public:
        XmlBinStream(XmlInputStream *is) : is_(is) {}
	virtual unsigned int curPos() const {
		return is_->curPos();
	}
	virtual unsigned int readBytes(XMLByte *const toFill,
				       const unsigned int max) {
		return is_->readBytes((char *)toFill, max);
	}
private:
	XmlInputStream *is_;
};

/**
 * Wrapper classes for XmlInputStream that implement Xerces
 * InputSource.  Oddly enough, the default implementations of
 * XmlInputStream *use* InputSource, but hide that info here,
 * to allow user-defined instances. Will hold a reference to a
 * Document object, if required to.
 */
class XmlInputStreamWrapper : public XERCES_CPP_NAMESPACE_QUALIFIER InputSource
{
public:
	XmlInputStreamWrapper(XmlInputStream **is)
		: is_(*is)
	{
		*is = 0;
	}
	virtual ~XmlInputStreamWrapper() {
		delete is_;
	}
	virtual XERCES_CPP_NAMESPACE_QUALIFIER BinInputStream *makeStream() const {
		return new XmlBinStream(is_);
	}
	virtual const XMLCh *getEncoding() const { return 0; }
	virtual const XMLCh *getPublicId() const { return 0; }
	virtual const XMLCh *getSystemId() const { return 0; }
private:
	XmlInputStream *is_;
};

}

#endif
