//
// See the file LICENSE for redistribution information.
//
// Copyright (c) 2002-2005
//	Sleepycat Software.  All rights reserved.
//
// $Id: VariableBindings.hpp,v 1.16 2005/04/05 16:44:03 bostic Exp $
//

#ifndef __VARIABLEBINDINGS_HPP
#define	__VARIABLEBINDINGS_HPP

#include <string>
#include <map>
#include "dbxml/XmlValue.hpp"

namespace DbXml
{

class VariableBindings
{
public:
	typedef std::map<std::string, XmlValue> Values;
	VariableBindings()
	{}
	;
	~VariableBindings()
	{}
	;
	VariableBindings(const VariableBindings &);
	VariableBindings & operator = (const VariableBindings &);

	bool getVariableValue(const std::string &name, XmlValue &value) const;
	void setVariableValue(const std::string &name, const XmlValue &value);
	const Values &getValues() const
	{
		return values_;
	}
private:
	Values values_;
};

}

#endif

