//
// See the file LICENSE for redistribution information.
//
// Copyright (c) 2002-2005
//	Sleepycat Software.  All rights reserved.
//
// $Id: VariableBindings.cpp,v 1.19 2005/04/20 18:31:29 bostic Exp $
//

#include "dbxml_config.h"
#include "dbxml/XmlPortability.hpp"
#include "dbxml/XmlException.hpp"
#include "VariableBindings.hpp"

using namespace DbXml;

// VariableBindings

VariableBindings::VariableBindings(const VariableBindings &o)
{
	*this = o;
}

VariableBindings &VariableBindings::operator = (const VariableBindings &o)
{
	if (this != &o) {
		values_ = o.values_;
	}
	return *this;
}

bool VariableBindings::getVariableValue(const std::string &name,
					XmlValue &value) const
{
	Values::const_iterator i = values_.find(name);
	if (i != values_.end()) {
		value = i->second;
	} else {
		value = XmlValue();
	}
	return !value.isNull();
}

void VariableBindings::setVariableValue(const std::string &name,
					const XmlValue &value)
{
  // prevent the type of a value from changing
	Values::const_iterator i = values_.find(name);
	if (i != values_.end()) {
		if(i->second.getType() != value.getType()) {
			throw XmlException(
				XmlException::INVALID_VALUE,
				"The type of a variable value cannot change");
		}
	}

	values_[name] = value;
}
