//
// See the file LICENSE for redistribution information.
//
// Copyright (c) 2002-2005
//	Sleepycat Software.  All rights reserved.
//
// $Id: Util.hpp,v 1.1 2005/03/18 15:04:04 gmf Exp $
//

#ifndef __UTIL_HPP
#define	__UTIL_HPP

#include <string>
#include "dbxml/XmlException.hpp"

namespace DbXml
{
// Some general utility interfaces

// Null pointer check/exception
static inline void checkNullPointer(const void *ptr, const char *message)
{
	if (ptr == 0) {
		std::string mesg = "Attempt to use uninitialized object: ";
		mesg += message;
		throw XmlException(XmlException::NULL_POINTER, mesg);
	}
}

}

#endif

