//
// See the file LICENSE for redistribution information.
//
// Copyright (c) 2002-2005
//	Sleepycat Software.  All rights reserved.
//
// $Id: ReferenceMinder.hpp,v 1.4 2005/04/05 16:44:02 bostic Exp $
//

#ifndef __REFERENCEMINDER_HPP
#define	__REFERENCEMINDER_HPP

#include <dbxml/XmlPortability.hpp>
#include <dbxml/XmlDocument.hpp>
#include <dbxml/XmlContainer.hpp>

#include <xercesc/dom/DOMNode.hpp>
#include <xercesc/dom/DOMDocument.hpp>

#include <map>

namespace DbXml
{

class Document;

class ReferenceMinder
{
public:
	void addContainer(TransactedContainer *container);
	void removeContainer(TransactedContainer *container);

	void addDocument(const XmlDocument &doc);
	void removeDocument(const XERCES_CPP_NAMESPACE_QUALIFIER DOMDocument *doc);
	/// Returns 0 if none found
	Document *findDocument(const XERCES_CPP_NAMESPACE_QUALIFIER DOMNode *node);
	/// Returns 0 if none found
	Document *findDocument(const std::string &id);

	void resetMinder();

private:
	static const XERCES_CPP_NAMESPACE_QUALIFIER DOMDocument *getOwnerDoc(const XERCES_CPP_NAMESPACE_QUALIFIER DOMNode *node);
	struct nodeCompare
	{
		bool operator()(const XERCES_CPP_NAMESPACE_QUALIFIER DOMDocument *n1, const XERCES_CPP_NAMESPACE_QUALIFIER DOMDocument *n2) const;
	};
	struct stringCompare
	{
		bool operator()(const std::string *s1, const std::string *s2) const;
	};

	typedef std::map<TransactedContainer *, XmlContainer> ContainerMap;

	// This holds real copies of the reference counting wrapper
	typedef std::map<const XERCES_CPP_NAMESPACE_QUALIFIER DOMDocument *, XmlDocument, nodeCompare> DOM2DocumentMap;
	// This holds the implementation, to save on copied wrapper objects
	typedef std::map<const std::string *, Document *, stringCompare> ID2DocumentMap;

	ContainerMap containers_;
	DOM2DocumentMap dom2documents_;
	ID2DocumentMap ids2documents_;
};

}

#endif
