//
// See the file LICENSE for redistribution information.
//
// Copyright (c) 2002-2005
//	Sleepycat Software.  All rights reserved.
//
// $Id: ReferenceMinder.cpp,v 1.9 2005/04/20 18:31:28 bostic Exp $
//

#include "ReferenceMinder.hpp"
#include "Document.hpp"

#include <xercesc/util/PlatformUtils.hpp>
#include <xercesc/util/XMLUri.hpp>
#include <xercesc/util/XMLString.hpp>
#if defined(XERCES_HAS_CPP_NAMESPACE)
XERCES_CPP_NAMESPACE_USE
#endif

using namespace DbXml;
using namespace std;

void ReferenceMinder::addContainer(TransactedContainer *container)
{
	containers_.insert(ContainerMap::value_type(container, container));
}

void ReferenceMinder::removeContainer(TransactedContainer *container)
{
	ContainerMap::iterator i = containers_.find(container);
	if(i != containers_.end()) containers_.erase(i);
}

void ReferenceMinder::addDocument(const XmlDocument &doc)
{
	dom2documents_.insert(DOM2DocumentMap::value_type(doc.getContentAsDOM(),
							  doc));
	Document *impl = (Document *)doc;
	// don't insert into id map if no identifier, or identifier already
	// exists in map
	if (impl->getIdentifier().empty() ||
	    findDocument(impl->getIdentifier()))
		return;
	ids2documents_.insert(ID2DocumentMap::value_type(&impl->getIdentifier(), impl));
}

void ReferenceMinder::removeDocument(const XERCES_CPP_NAMESPACE_QUALIFIER DOMDocument *doc)
{
	DOM2DocumentMap::iterator i = dom2documents_.find(doc);
	if(i != dom2documents_.end()) {
		const string &id = ((Document*)i->second)->getIdentifier();
		if (!id.empty()) {
			ID2DocumentMap::iterator i2 = ids2documents_.find(&id);
			ids2documents_.erase(i2);
		}
		dom2documents_.erase(i);
	}
}

Document *ReferenceMinder::findDocument(const DOMNode *node)
{
	DOM2DocumentMap::iterator i = dom2documents_.find(getOwnerDoc(node));
	if(i != dom2documents_.end()) {
		return (Document *)i->second;
	}
	return 0;
}

Document *ReferenceMinder::findDocument(const std::string &id)
{
	ID2DocumentMap::iterator i = ids2documents_.find(&id);
	if(i != ids2documents_.end()) {
		return i->second;
	}
	return 0;
}

const XERCES_CPP_NAMESPACE_QUALIFIER DOMDocument *ReferenceMinder::getOwnerDoc(const DOMNode *node)
{
	if(node->getNodeType() == DOMNode::DOCUMENT_NODE) {
		return (const XERCES_CPP_NAMESPACE_QUALIFIER DOMDocument *)node;
	}
	else {
		return node->getOwnerDocument();
	}
}

void ReferenceMinder::resetMinder()
{
	containers_.clear();
	dom2documents_.clear();
	ids2documents_.clear();
}

bool ReferenceMinder::nodeCompare::operator()(const XERCES_CPP_NAMESPACE_QUALIFIER DOMDocument *n1, const XERCES_CPP_NAMESPACE_QUALIFIER DOMDocument *n2) const
{
	if(n1->isSameNode(n2)) return false;
	return n1<n2;
}

bool ReferenceMinder::stringCompare::operator()(const std::string *s1, const std::string *s2) const
{
	return *s1 < *s2;
}
