//
// See the file LICENSE for redistribution information.
//
// Copyright (c) 2002-2005
//	Sleepycat Software.  All rights reserved.
//
// $Id: ReferenceCounted.hpp,v 1.15 2005/04/20 18:31:28 bostic Exp $
//

#ifndef __REFERENCECOUNTED_HPP
#define	__REFERENCECOUNTED_HPP

namespace DbXml
{

class ReferenceCounted
{
public:
	ReferenceCounted() : count_(0) {}
	virtual ~ReferenceCounted() {}
	virtual void acquire() { ++count_; }
	virtual void release() { if (--count_ == 0) delete this; }
protected:
	int count_;
};

template<class T> class RefCountJanitor
{
public:
	RefCountJanitor(T *p = 0) : p_(p) {
		if(p_) p_->acquire();
	}
	
	RefCountJanitor(const RefCountJanitor<T> &o) : p_(o.p_) {
		if(p_) p_->acquire();
	}

	RefCountJanitor &operator=(const RefCountJanitor<T> &o) {
		if(p_ != o.p_) {
			if(p_) p_->release();
			p_ = o.p_;
			if(p_) p_->acquire();
		}
		return *this;
	}

	~RefCountJanitor() {
		if(p_) p_->release();
	}

	T &operator*() const {
		return *p_;
	}

	T *operator->() const {
		return p_;
	}
	
	T *get() const {
		return p_;
	}

	operator bool() const {
		return p_ != 0;
	}
	
private:
	T *p_;
};

// ReferenceCountedProtected	
// a lock-protected instance of ReferenceCounted, that
// protects the count for free-threaded objects
//
class ReferenceCountedProtected : public ReferenceCounted
{
public:
	ReferenceCountedProtected();
	virtual ~ReferenceCountedProtected();
	virtual void acquire();
	virtual void release();
	void lock();
	void unlock();
private:
	void *mutex_;
};

class MutexLock
{
public:
	MutexLock(void *mutex);
	~MutexLock();
private:
	MutexLock(const MutexLock&);
	MutexLock &operator=(const MutexLock&);
	
	void *toLock_;
};

}

#endif

