//
// See the file LICENSE for redistribution information.
//
// Copyright (c) 2002-2005
//	Sleepycat Software.  All rights reserved.
//
// $Id: QueryExpression.hpp,v 1.21 2005/04/05 16:44:02 bostic Exp $
//

#ifndef __EXPRESSION_HPP
#define	__EXPRESSION_HPP

#include <string>
#include "dbxml/XmlQueryContext.hpp"
#include "dbxml/XmlContainer.hpp"
#include "ReferenceCounted.hpp"
#include "ReferenceMinder.hpp"

class XPath2MemoryManager;
class DataItem;

class XQContext;
class XQQuery;

namespace DbXml
{

class Results;
class Optimizer;
class Value;
class Transaction;

class QueryExpression : public ReferenceCountedProtected
{
public:
	virtual ~QueryExpression();
	
	const std::string &getQuery() const {
		return query_;
	}
	std::string getQueryPlan() const;
	
	XmlQueryContext &getContext() {
		return context_;
	}
	Results *execute(Transaction *txn, Value *contextItem,
			 XmlQueryContext &context, u_int32_t flags = 0);

	XQContext *getXQContext() const;
	XQQuery *getCompiledExpression() const;
	
protected:
	QueryExpression(const std::string &xpath, XmlQueryContext &context);
	
	void init(Transaction *txn);
	virtual Optimizer *createOptimizer(Transaction *txn) = 0;
	XPath2MemoryManager *getMemMgr();
	
	ReferenceMinder minder_;
	
private:
	QueryExpression(const QueryExpression&);
	QueryExpression &operator=(const QueryExpression &);
	
	std::string query_;
	XmlQueryContext context_;
	
	XPath2MemoryManager *memMgr_;
	XQContext *xqContext_;
	XQQuery *expr_;
};
	
class DatabaseQueryExpression : public QueryExpression
{
public:
	DatabaseQueryExpression(const std::string &query,
				XmlQueryContext &context, Transaction *txn);
	virtual ~DatabaseQueryExpression() {}
	
protected:
	virtual Optimizer *createOptimizer(Transaction *txn);
};
	
class ContainerQueryExpression : public QueryExpression
{
public:
	ContainerQueryExpression(const std::string &containerName,
				 const std::string &query,
				 XmlQueryContext &context, Transaction *txn);
	virtual ~ContainerQueryExpression() {}
	
protected:
	virtual Optimizer *createOptimizer(Transaction *txn);
	
private:
	std::string containerName_;
};

}

#endif
