//
// See the file LICENSE for redistribution information.
//
// Copyright (c) 2002-2005
//	Sleepycat Software.  All rights reserved.
//
// $Id: QueryExecutionContext.hpp,v 1.3 2005/04/05 16:44:02 bostic Exp $
//

#ifndef __QUERYEXECUTIONCONTEXT_HPP
#define	__QUERYEXECUTIONCONTEXT_HPP

#include <memory>
#include <string>

#include "shared_ptr.hpp"
#include "IDS.hpp"
#include "NamespaceMap.hpp"
#include "VariableBindings.hpp"
#include "Statistics.hpp"

namespace DbXml
{

class Container;
class QueryContext;

/**
 * This function pointer declaration is used by the
 * QueryExecutionContext class to declare a callback
 * to a cost calculation function. There is a feedback
 * mechanism within the query plan execution engine
 * so that candidate set construction can be short
 * circuited once it becomes cheaper to filter.
 */
typedef double (*CostFunctionPointer)(long numDocuments);

/**
 * QueryExecutionContext
 *
 * Note that the costTofilter mechanism below is provided so that
 * during evaluation a query plan node can compare the cost of
 * refining the candidate set further, or giving up and allowing
 * the documents to be retrieved and filtered through a complete
 * XPath to DOM implementation.
 */
class QueryExecutionContext
{
public:
	QueryExecutionContext(const Container &container, QueryContext &context, bool debugging);
	~QueryExecutionContext();

	const Container &getContainer() const;

  StatisticsReadCache &getStatisticsReadCache() { return statsReadCache_; }
  IDSReadCache &getIDSReadCache() { return idsReadCache_; }

	void setCostToFilterFunction(CostFunctionPointer cfp);
	double costToFilter(const IDS::SharedPtr &ids) const;

	void addExecutionStep(const std::string &step);
	std::string getExecutionPath() const;

	QueryContext &getContext() const { return context; }

	std::string toString() const;
private:
	// no need for copy and assignment
	QueryExecutionContext(const QueryExecutionContext&);
	QueryExecutionContext &operator=(const QueryExecutionContext &);

	const Container &container;
  StatisticsReadCache statsReadCache_;
  IDSReadCache idsReadCache_;

	QueryContext &context;

	CostFunctionPointer costToFilterPointer;

	// For debugging, and testing, keep track of the execution path.
	bool debugging_;
	std::string executionPath_;
};

}

#endif
