//
// See the file LICENSE for redistribution information.
//
// Copyright (c) 2002-2005
//	Sleepycat Software.  All rights reserved.
//
// $Id: QueryExecutionContext.cpp,v 1.3 2005/04/05 16:44:02 bostic Exp $
//

#include "QueryExecutionContext.hpp"
#include <float.h>

using namespace DbXml;
using namespace std;

QueryExecutionContext::QueryExecutionContext(const Container &container, QueryContext &context, bool debugging)
	: container(container),
    statsReadCache_(container),
    idsReadCache_(container),
    context(context),
    costToFilterPointer(0),
    debugging_(debugging)
{}

QueryExecutionContext::~QueryExecutionContext()
{}

const Container &QueryExecutionContext::getContainer() const
{
	return container;
}

void QueryExecutionContext::setCostToFilterFunction(CostFunctionPointer cfp)
{
	costToFilterPointer = cfp;
}

double QueryExecutionContext::costToFilter(const IDS::SharedPtr &ids) const
{
	double r = DBL_MAX; // Very costly... keep refining candidate set.
	if (costToFilterPointer != 0) {
		r = (*costToFilterPointer)((!ids ? 0 : ids->size()));
	}
	return r;
}

string QueryExecutionContext::toString() const
{
	return "QueryExecutionContext"; // jcm - could provide a description for debugging
}

void QueryExecutionContext::addExecutionStep(const string &step)
{
  if(debugging_) {
    executionPath_ += step;
    executionPath_ += ",";
  }
}

string QueryExecutionContext::getExecutionPath() const
{
	return executionPath_;
}

