//
// See the file LICENSE for redistribution information.
//
// Copyright (c) 2002-2005
//	Sleepycat Software.  All rights reserved.
//
// $Id: IDS.cpp,v 1.21 2005/04/05 16:44:01 bostic Exp $
//

#include "dbxml_config.h"
#include "dbxml/XmlPortability.hpp"
#include "dbxml/XmlException.hpp"
#include "IDS.hpp"
#include "TypeConversions.hpp"
#include "OperationContext.hpp"
#include "Container.hpp"
#include "Cursor.hpp"

using namespace std;
using namespace DbXml;

string IDS::toString() const
{
	string s;
	s += "[";
	s += DbXml::toString((u_int32_t)ids.size());
	s += "]";
	IDS::const_iterator p;
	for (p = ids.begin();p != ids.end();++p) {
		s += " ";
		s += DbXml::toString((u_int32_t)(*p).raw());
	}
	return s;
}

IDSReadCache::IDSReadCache(const Container &container)
	: container_(container)
{
}

void IDSReadCache::reset()
{
	idsMap_.clear();
}

const IDS::SharedPtr &IDSReadCache::getIDS(OperationContext &context, DbWrapper::Operation op1, Key k1,
                                           DbWrapper::Operation op2, Key k2)
{
	IDSKey idsKey(op1, k1, op2, k2);

	IDSMap::const_iterator it = idsMap_.find(idsKey);
	if(it != idsMap_.end()) {
		return it->second;
	}

	return lookupIDS(context, idsKey);
}

bool IDSReadCache::containsIDS(DbWrapper::Operation op1, Key k1,
                               DbWrapper::Operation op2, Key k2) const
{
	IDSKey idsKey(op1, k1, op2, k2);

	IDSMap::const_iterator it = idsMap_.find(idsKey);
	if(it != idsMap_.end()) {
		return true;
	}

	return false;
}

const IDS::SharedPtr &IDSReadCache::lookupIDS(OperationContext &context, const IDSKey &idsKey)
{
	IDS::SharedPtr ids(new IDS);

	const SyntaxDatabase *database = container_.getIndexDB(idsKey.key1.getSyntaxType());

	int err = database->getIDS(context, ids, idsKey.operation1, idsKey.key1, idsKey.operation2, idsKey.key2);
	if(err) throw XmlException(err);

	return idsMap_.insert(IDSMap::value_type(idsKey, ids)).first->second;
}

bool IDSReadCache::IDSKey::operator<(const IDSKey &o) const
{
	if(operation1 < o.operation1) return true;
	if(o.operation1 < operation1) return false;
	if(key1 < o.key1) return true;
	if(o.key1 < key1) return false;
	if(operation2 < o.operation2) return true;
	if(o.operation2 < operation2) return false;
	if(key2 < o.key2) return true;
	if(o.key2 < key2) return false;
	return false;
}
