//
// See the file LICENSE for redistribution information.
//
// Copyright (c) 2002-2005
//	Sleepycat Software.  All rights reserved.
//
// $Id: ID.hpp,v 1.24 2005/04/05 16:44:01 bostic Exp $
//

#ifndef __ID_HPP
#define	__ID_HPP

#include <iosfwd>
#include <db_cxx.h>

class Dbt;

namespace DbXml
{

class DbtOut;

class ID
{
public:
	ID() : id_(0)
	{}
	ID(u_int32_t id) : id_(id)
	{ }
	void reset()
	{
		id_ = 0;
	}
	u_int32_t raw() const
	{
		return id_;
	}
	void setThisFromDbt(const Dbt &dbt, bool swap = true);
	void setDbtFromThis(DbtOut &dbt, bool swap = true) const;
	int operator==(const ID &o) const
	{
		return id_ == o.id_;
	}
	int operator==(u_int32_t id) const
	{
		return id_ == id;
	}
	int operator!=(const ID &o) const
	{
		return id_ != o.id_;
	}
	int operator!=(u_int32_t id) const
	{
		return id_ != id;
	}
	bool operator<(const ID &o) const
	{
		return id_ < o.id_;
	}
	// default implementation
	// ID(const ID&);
	// void operator=(const ID &);
private:
	u_int32_t id_;
};

std::ostream& operator<<(std::ostream& s, ID id);

}

#endif

