//
// See the file LICENSE for redistribution information.
//
// Copyright (c) 2002-2005
//	Sleepycat Software.  All rights reserved.
//
// $Id: ID.cpp,v 1.19 2005/04/05 16:44:01 bostic Exp $
//

#include "dbxml_config.h"
#include "dbxml/XmlPortability.hpp"
#include "ID.hpp"
#include "ScopedDbt.hpp"
#include "Manager.hpp"

#include "db_utils.h"

using namespace DbXml;
#define SWAP_INT(i) if (Manager::isBigendian()) M_32_SWAP((i))

void ID::setThisFromDbt(const Dbt &dbt, bool swap)
{
	id_ = *(reinterpret_cast<u_int32_t*>(dbt.get_data())); // copies the data
	if (swap)
		SWAP_INT(id_);
}

void ID::setDbtFromThis(DbtOut &dbt, bool swap) const
{
	dbt.set(&id_, sizeof(id_)); // copies the data
	if (swap && Manager::isBigendian()) {
		u_int32_t *p = reinterpret_cast<u_int32_t*>(dbt.get_data());
		M_32_SWAP(*p);
	}
}

std::ostream& DbXml::operator<<(std::ostream& s, ID id)
{
	return s << id.raw();
}
