# See the file LICENSE for redistribution information.
#
# Copyright (c) 2000-2003
#	Sleepycat Software.  All rights reserved.
#
# $Id: xml013.tcl,v 1.18 2003/09/30 12:26:48 merrells Exp $
#
# TEST	xml013
# TEST	Document Metadata

proc xml013 { args } {
	puts "\nxml013: Document Metadata ($args)"
	source ./include.tcl

	# Determine whether test has been called within an environment, 
	# and whether it is a transactional environment.
	# If we are using an env, then the filename should just be the test 
	# number.  Otherwise it is the test directory and the test number.
	set eindex [lsearch -exact $args "-env"]
	set txnenv 0
	set tnum 13	
	set oargs [eval {set_openargs} $args]

	if { $eindex == -1 } {
		set env NULL
		set basename $testdir/$tnum
	} else {
		incr eindex
		set env [lindex $args $eindex]
		set txnenv [is_txnenv $env]
		set testdir [get_home $env]
		set basename $tnum
	}

	xml013_1 $env $txnenv $basename $oargs

	return
}

proc xml013_1 { {env "NULL"} {txnenv 0} {basename $tnum} oargs } {
	source ./include.tcl
	set txn NULL
	xml_cleanup $testdir $env	

	new XmlContainer container $env "$basename.1.dbxml" 0
	if { $txnenv == 1 } { set txn [start_txn $env] }
	$container open $txn $oargs 0
	if { $txnenv == 1 } { commit_txn $txn }

	puts "\txml013.1: Put/get type String"
	new XmlDocument xd
	$xd setContent "<hello/>"
	new XmlValue xv $XmlValue_STRING "bar"
	$xd setMetaData "" "" "foo" $xv

	if { $txnenv == 1 } { set txn [start_txn $env] }
	$container putDocument $txn $xd
	if { $txnenv == 1 } { commit_txn $txn }

	delete xd
	delete xv

	if { $txnenv == 1 } { set txn [start_txn $env] }
	wrap XmlDocument xd [$container getDocument $txn 1]
	if { $txnenv == 1 } { commit_txn $txn }

	new XmlValue xv $XmlValue_STRING ""
	$xd getMetaData "" "foo" $xv
	dbxml_error_check_good "13.1" [$xv isString] "1"
	dbxml_error_check_good "13.1" [$xv asString] "bar"
	delete xv
	delete xd

	puts "\txml013.2: Put/get type Number"
	new XmlDocument xd
	$xd setContent "<hello/>"
	new XmlValue xv $XmlValue_NUMBER 123
	$xd setMetaData "" "" "foo" $xv

	if { $txnenv == 1 } { set txn [start_txn $env] }
	$container putDocument $txn $xd
	if { $txnenv == 1 } { commit_txn $txn }

	delete xd
	delete xv

	if { $txnenv == 1 } { set txn [start_txn $env] }
	wrap XmlDocument xd [$container getDocument $txn 2]
	if { $txnenv == 1 } { commit_txn $txn }

	new XmlValue xv $XmlValue_NUMBER {}
	$xd getMetaData "" "foo" $xv
	dbxml_error_check_good "13.2" [$xv isNumber] 1
	dbxml_error_check_good "13.2" [$xv asString] 123
	delete xv
	delete xd

	puts "\txml013.3.1: Put/get type Boolean (true)"
	new XmlDocument xd
	$xd setContent "<hello/>"
	new XmlValue xv $XmlValue_BOOLEAN 1
	$xd setMetaData "" "" "foo" $xv

	if { $txnenv == 1 } { set txn [start_txn $env] }
	$container putDocument $txn $xd
	if { $txnenv == 1 } { commit_txn $txn }

	delete xd
	delete xv

	if { $txnenv == 1 } { set txn [start_txn $env] }
	wrap XmlDocument xd [$container getDocument $txn 3]
	if { $txnenv == 1 } { commit_txn $txn }

	new XmlValue xv $XmlValue_BOOLEAN {}
	$xd getMetaData "" "foo" $xv
	dbxml_error_check_good "13.3.1" [$xv isBoolean] 1
	dbxml_error_check_good "13.3.1" [$xv asString] true
	delete xv
	delete xd

	puts "\txml013.3.2: Put/get type Boolean (false)"
	new XmlDocument xd
	$xd setContent "<hello/>"
	new XmlValue xv $XmlValue_BOOLEAN {}
	$xd setMetaData "" "" "foo" $xv

	if { $txnenv == 1 } { set txn [start_txn $env] }
	$container putDocument $txn $xd
	if { $txnenv == 1 } { commit_txn $txn }

	delete xd
	delete xv

	if { $txnenv == 1 } { set txn [start_txn $env] }
	wrap XmlDocument xd [$container getDocument $txn 4]
	if { $txnenv == 1 } { commit_txn $txn }

	new XmlValue xv $XmlValue_BOOLEAN {}
	$xd getMetaData "" "foo" $xv
	dbxml_error_check_good "13.3.2" [$xv isBoolean] 1
	dbxml_error_check_good "13.3.2" [$xv asString] false
	delete xv
	delete xd

	puts "\txml013.4: Put/get type Document"
	new XmlDocument xd
	$xd setContent "<hello/>"
	new XmlValue xv $xd
	$xd setMetaData "" "" "foo" $xv

	if { $txnenv == 1 } { set txn [start_txn $env] }
	$container putDocument $txn $xd
	if { $txnenv == 1 } { commit_txn $txn }

	delete xd
	delete xv

	if { $txnenv == 1 } { set txn [start_txn $env] }
	wrap XmlDocument xd [$container getDocument $txn 5]
	if { $txnenv == 1 } { commit_txn $txn }

	new XmlValue xv $XmlValue_DOCUMENT {}
	$xd getMetaData "" "foo" $xv
	dbxml_error_check_good "13.3.4" [$xv isDocument] 1
	dbxml_error_check_good "13.3.4" [$xv asString] "<hello/>"
	delete xd
	delete xv

	puts "\txml013.5: type Node"
	new XmlDocument xd
	$xd setContent "<hello/>"
	new XmlValue xv $XmlValue_NODE {}
	catch { $xd setMetaData "" "" "foo" $xv } ret
	dbxml_error_check_good "13.5" [is_substr $ret "setMetaData expects"] 1
	delete xd
	delete xv

	puts "\txml013.6: type Variable"
	new XmlDocument xd
	$xd setContent "<hello/>"
	new XmlValue xv $XmlValue_VARIABLE {}
	catch { $xd setMetaData "" "" "foo" $xv } ret
	dbxml_error_check_good "13.5" [is_substr $ret "setMetaData expects"] 1
	dbxml_error_check_good "13.6" [$xv isVariable] 1
	dbxml_error_check_good "13.6" [$xv isBoolean] 0
	dbxml_error_check_good "13.6" [$xv isDocument] 0
	dbxml_error_check_good "13.6" [$xv isNode] 0
	dbxml_error_check_good "13.6" [$xv isNumber] 0
	dbxml_error_check_good "13.6" [$xv isString] 0
	delete xd
	delete xv

	$container close
	delete container
}
