# See the file LICENSE for redistribution information.
#
# Copyright (c) 2000-2003
#	Sleepycat Software.  All rights reserved.
#
# $Id: xml012.tcl,v 1.17 2003/12/09 14:02:45 merrells Exp $
#
# TEST	xml012
# TEST	Delete Document

proc xml012 { args } {
	puts "\nxml012: Delete Document ($args)"
	source ./include.tcl

	# Determine whether test has been called within an environment, 
	# and whether it is a transactional environment.
	# If we are using an env, then the filename should just be the test 
	# number.  Otherwise it is the test directory and the test number.
	set eindex [lsearch -exact $args "-env"]
	set txnenv 0
	set tnum 12	
	set oargs [eval {set_openargs} $args]

	if { $eindex == -1 } {
		set env NULL
		set basename $testdir/$tnum
	} else {
		incr eindex
		set env [lindex $args $eindex]
		set txnenv [is_txnenv $env]
		set testdir [get_home $env]
		set basename $tnum
	}

	xml012_1 $env $txnenv $basename $oargs
	xml012_2 $env $txnenv $basename $oargs
	xml012_3 $env $txnenv $basename $oargs
	xml012_4 $env $txnenv "$basename.4" $oargs
	xml012_5 $env $txnenv $basename $oargs
	xml012_6 $env $txnenv $basename $oargs

	return
}

proc xml012_1 { {env "NULL"} {txnenv 0} {basename $tnum} oargs } {
	puts "\txml012.1: Delete document with document ID that does not exist (should fail)."
	source ./include.tcl
	set txn NULL
	xml_cleanup $testdir $env	

	new XmlContainer container $env "$basename.1.dbxml" 0
	if { $txnenv == 1 } { set txn [start_txn $env] }
	$container open $txn $oargs 0
	if { $txnenv == 1 } { commit_txn $txn }

	if { $txnenv == 1 } { set txn [start_txn $env] }
	catch {$container deleteDocumentByID $txn 1} ret
	if { $txnenv == 1 } { commit_txn $txn }

	dbxml_error_check_good "12.1" $ret "Error: Document not found."

	$container close
	delete container
}

proc xml012_2 { {env "NULL"} {txnenv 0} {basename $tnum} oargs } {
	puts "\txml012.2: Delete document with document ID."
	source ./include.tcl
	set txn NULL
	xml_cleanup $testdir $env
	
	new XmlContainer container $env "$basename.2.dbxml" 0
	if { $txnenv == 1 } { set txn [start_txn $env] }
	$container open $txn $oargs 0
	if { $txnenv == 1 } { commit_txn $txn }

	new XmlDocument xd
	$xd setContent "<hello/>"

	if { $txnenv == 1 } { set txn [start_txn $env] }
	set id [$container putDocument $txn $xd]
	catch {$container deleteDocumentByID $txn $id} ret
	if { $txnenv == 1 } { commit_txn $txn }

	dbxml_error_check_good "12.2" $ret ""
	delete xd

	$container close
	delete container
}

proc xml012_3 { {env "NULL"} {txnenv 0} {basename $tnum} oargs } {
	puts "\txml012.3: Delete document with XmlDocument object."
	source ./include.tcl
	set txn NULL
	xml_cleanup $testdir $env
	
	new XmlContainer container $env "$basename.3.dbxml" 0
	if { $txnenv == 1 } { set txn [start_txn $env] }
	$container open $txn $oargs 0
	if { $txnenv == 1 } { commit_txn $txn }

	new XmlDocument xd
	$xd setContent "<hello/>"
	if { $txnenv == 1 } { set txn [start_txn $env] }
	$container putDocument $txn $xd
	if { $txnenv == 1 } { commit_txn $txn }

	if { $txnenv == 1 } { set txn [start_txn $env] }
	catch {$container deleteDocument $txn $xd} ret
	if { $txnenv == 1 } { commit_txn $txn }

	dbxml_error_check_good "12.3" $ret ""
	delete xd

	$container close
	delete container
}

proc xml012_4 { {env "NULL"} {txnenv 0} {basename $tnum} oargs } {
	puts "\txml012.4: "
	xml010_2_and_xml012_4 "12.4" 1 $env $txnenv $basename $oargs
}

proc xml012_5 { {env "NULL"} {txnenv 0} {basename $tnum} oargs } {
	puts "\txml012.5: Delete document with XmlDocument object that does not exist (should fail)."
	source ./include.tcl
	set txn NULL
	xml_cleanup $testdir $env
	
	new XmlContainer container $env "$basename.5.dbxml" 0
	if { $txnenv == 1 } { set txn [start_txn $env] }
	$container open $txn $oargs 0
	if { $txnenv == 1 } { commit_txn $txn }

	new XmlDocument xd
	$xd setContent "<hello/>"

	if { $txnenv == 1 } { set txn [start_txn $env] }
	catch {$container deleteDocument $txn $xd} ret
	if { $txnenv == 1 } { commit_txn $txn }

	dbxml_error_check_good "12.5" $ret "Error: Document not found."
	delete xd

	$container close
	delete container
}

proc xml012_6 { {env "NULL"} {txnenv 0} {basename $tnum} oargs } {
	puts "\txml012.6: updateDocument."
	source ./include.tcl
	set txn NULL
	xml_cleanup $testdir $env
	
	new XmlContainer container $env "$basename.5.dbxml" 0
	if { $txnenv == 1 } { set txn [start_txn $env] }
	$container open $txn $oargs 0
	$container addIndex $txn "" "a" "node-element-presence-none"
	$container addIndex $txn "" "b" "node-element-presence-none"
	$container addIndex $txn "" "c" "node-element-presence-none"
	if { $txnenv == 1 } { commit_txn $txn }

	new XmlDocument xd
	$xd setContent "<a><b></b></a>"
	if { $txnenv == 1 } { set txn [start_txn $env] }
	$container putDocument $txn $xd
	if { $txnenv == 1 } { commit_txn $txn }
	set statistics [getDocumentContent $container $txn 0]
	dbxml_error_check_good "12.5" [string match "*a' indexed='1'*" $statistics] 1
	dbxml_error_check_good "12.5" [string match "*b' indexed='1'*" $statistics] 1

	$xd setContent "<a><c></c></a>"
	if { $txnenv == 1 } { set txn [start_txn $env] }
	catch {$container updateDocument $txn $xd} ret
	if { $txnenv == 1 } { commit_txn $txn }
	set statistics [getDocumentContent $container $txn 0]
	dbxml_error_check_good "12.5" [string match "*a' indexed='1'*" $statistics] 1
	dbxml_error_check_good "12.5" [string match "*b' indexed='0'*" $statistics] 1
	dbxml_error_check_good "12.5" [string match "*c' indexed='1'*" $statistics] 1

	delete xd

	$container close
	delete container
}
