# See the file LICENSE for redistribution information.
#
# Copyright (c) 2000-2003
#	Sleepycat Software.  All rights reserved.
#
# Test 11: Query Processor 	
#
# $Id: xml011.tcl,v 1.50 2003/12/09 14:02:45 merrells Exp $
#
# TEST	xml011
# TEST	Query Processor

proc xml011 { args } {
	puts "\nxml011: Query Processor ($args)"
	source ./include.tcl

	# Determine whether procedure has been called within an environment, 
	# and whether it is a transactional environment.
	# If we are using an env, then the filename should just be the test 
	# number.  Otherwise it is the test directory and the test number.
	set eindex [lsearch -exact $args "-env"]
	set txnenv 0
	set tnum 11	
	set oargs [eval {set_openargs} $args]

	if { $eindex == -1 } {
		set env NULL
		set basename $testdir/$tnum
	} else {
		incr eindex
		set env [lindex $args $eindex]
		set txnenv [is_txnenv $env]
		set testdir [get_home $env]
		set basename $tnum
	}

	xml011_1 $env $txnenv $basename $oargs
	xml011_2 $env $txnenv $basename $oargs
	xml011_3 $env $txnenv $basename $oargs
	xml011_4 $env $txnenv $basename $oargs
	xml011_5 $env $txnenv $basename $oargs
	xml011_6 $env $txnenv $basename $oargs
	xml011_7 $env $txnenv $basename $oargs
	xml011_8 $env $txnenv $basename $oargs
	xml011_9 $env $txnenv $basename $oargs
	xml011_10 $env $txnenv $basename $oargs
	xml011_11 $env $txnenv $basename $oargs
	xml011_12 $env $txnenv $basename $oargs
	xml011_13 $env $txnenv $basename $oargs
	xml011_14 $env $txnenv $basename $oargs
	xml011_15 $env $txnenv $basename $oargs
	xml011_16 $env $txnenv $basename $oargs
}

proc xml011_1 { {env "NULL"} {txnenv 0} {basename $tnum} oargs } {
	puts "\txml011.1: Test of XPath parsing."
	source ./include.tcl
	set txn NULL
	xml_cleanup $testdir $env

	new XmlContainer container $env "$basename.1.dbxml" 0

	if { $txnenv == 1 } { set txn [start_txn $env] }
	$container open $txn $oargs 0
	if { $txnenv == 1 } { commit_txn $txn }

	new XmlQueryContext context
	$context set "dbxml:debug" "result"

	assertXPathParses "11.1.1" $container {ancestor::foo} \
	    "" $context $env $txnenv $oargs
	assertXPathParses "11.1.2" $container {ancestor-or-self::foo} \
	    "" $context $env $txnenv $oargs
	assertXPathParses "11.1.3" $container {attribute::foo} \
	    "" $context $env $txnenv $oargs
	assertXPathParses "11.1.4" $container {child::foo} \
	    "" $context $env $txnenv $oargs
	assertXPathParses "11.1.5" $container {descendant::foo} \
	    "" $context $env $txnenv $oargs
	assertXPathParses "11.1.6" $container {descendant-or-self::foo} \
	    "" $context $env $txnenv $oargs
	assertXPathParses "11.1.7" $container {following::foo} \
	    "" $context $env $txnenv $oargs
	assertXPathParses "11.1.8" $container {following-sibling::foo} \
	    "" $context $env $txnenv $oargs
	assertXPathParses "11.1.9" $container {namespace::foo} \
	    "" $context $env $txnenv $oargs
	assertXPathParses "11.1.10" $container {parent::foo} \
	    "" $context $env $txnenv $oargs
	assertXPathParses "11.1.11" $container {preceding::foo} \
	    "" $context $env $txnenv $oargs
	assertXPathParses "11.1.12" $container {preceding-sibling::foo} \
	    "" $context $env $txnenv $oargs
	assertXPathParses "11.1.13" $container {self::foo} \
	    "" $context $env $txnenv $oargs
	assertXPathParses "11.1.14" $container {/foo} \
	    "" $context $env $txnenv $oargs
	assertXPathParses "11.1.15" $container {//foo} \
	    "" $context $env $txnenv $oargs
	assertXPathParses "11.1.16" $container {./foo} \
	    "" $context $env $txnenv $oargs
	assertXPathParses "11.1.17" $container {../foo} \
	    "" $context $env $txnenv $oargs
	assertXPathParses "11.1.18" $container {@foo} \
	    "" $context $env $txnenv $oargs
	assertXPathParses "11.1.19" $container {*} \
	    "" $context $env $txnenv $oargs
	assertXPathParses "11.1.20" $container {@*} \
	    "" $context $env $txnenv $oargs
	assertXPathParses "11.1.21" $container {text()} \
	    "" $context $env $txnenv $oargs
	assertXPathParses "11.1.22" $container {comment()} \
	    "" $context $env $txnenv $oargs
	assertXPathParses "11.1.23" $container {processing-instruction('hello')} \
	    "" $context $env $txnenv $oargs
	assertXPathParses "11.1.24" $container {foo[true() or true()]} \
	    "" $context $env $txnenv $oargs
	assertXPathParses "11.1.25" $container {foo[true() and true()]} \
	    "" $context $env $txnenv $oargs
	assertXPathParses "11.1.26" $container {foo['a'='a']} \
	    "" $context $env $txnenv $oargs
	assertXPathParses "11.1.27" $container {foo['a'!='a']} \
	    "" $context $env $txnenv $oargs
	assertXPathParses "11.1.28" $container {foo[1>1]} \
	    "" $context $env $txnenv $oargs
	assertXPathParses "11.1.29" $container {foo[1<1]} \
	    "" $context $env $txnenv $oargs
	assertXPathParses "11.1.30" $container {foo[1<=1]} \
	    "" $context $env $txnenv $oargs
	assertXPathParses "11.1.31" $container {foo[1>=1]} \
	    "" $context $env $txnenv $oargs
	assertXPathParses "11.1.32" $container {foo[1+1]} \
	    "" $context $env $txnenv $oargs
	assertXPathParses "11.1.33" $container {foo[1-1]} \
	    "" $context $env $txnenv $oargs
	assertXPathParses "11.1.34" $container {foo[1*1]} \
	    "" $context $env $txnenv $oargs
	assertXPathParses "11.1.35" $container {foo[1 div 1]} \
	    "" $context $env $txnenv $oargs
	assertXPathParses "11.1.36" $container {foo[1 mod 1]} \
	    "" $context $env $txnenv $oargs
	assertXPathParses "11.1.37" $container {foo[-1]} \
	    "" $context $env $txnenv $oargs
	assertXPathParses "11.1.38" $container {foo[bar|baz]} \
	    "" $context $env $txnenv $oargs
	assertXPathParses "11.1.39" $container {foo[/bar/baz]} \
	    "" $context $env $txnenv $oargs

	$context set "bar" "baz"
	assertXPathParses "11.1.40" $container {foo[$bar]} \
	    "" $context $env $txnenv $oargs
	assertXPathParses "11.1.41" $container {foo[1]} \
	    "" $context $env $txnenv $oargs
	assertXPathParses "11.1.42" $container {foo[1.1]} \
	    "" $context $env $txnenv $oargs
	assertXPathParses "11.1.43" $container {foo['1']} \
	    "" $context $env $txnenv $oargs

	$context setNamespace "ns" "http://www.foo.com"
	assertXPathParses "11.1.44" $container {ns:foo} \
	    "" $context $env $txnenv $oargs

	assertXPathParses "11.1.45" $container {/parent} \
	    "" $context $env $txnenv $oargs

	$context setNamespace "ns" "http://www.foo.com"
	assertXPathParses "11.1.46" $container {ns:div} \
	    "" $context $env $txnenv $oargs

	$container close
	delete container
	delete context
}

proc xml011_2 { {env "NULL"} {txnenv 0} {basename $tnum} oargs } {
	puts "\txml011.2: Tests from XPath recommendation document:\n \
	    \t\t\tunabbreviated syntax."
	source ./include.tcl
	set txn NULL
	xml_cleanup $testdir $env

	new XmlContainer container $env "$basename.2.dbxml" 0

	if { $txnenv == 1 } { set txn [start_txn $env] }
	$container open $txn $oargs 0
	if { $txnenv == 1 } { commit_txn $txn }

	new XmlQueryContext context
	$context set "dbxml:debug" "result"

	assertXPathParses "11.2.1" $container \
	    "child::para" "" $context $env $txnenv $oargs

	assertXPathParses "11.2.2" $container \
	    "child::*" "" $context $env $txnenv $oargs

	assertXPathParses "11.2.3" $container \
	    "child::text()" "" $context $env $txnenv $oargs

	assertXPathParses "11.2.4" $container \
	    "child::node()" "" $context $env $txnenv $oargs

	assertXPathParses "11.2.5" $container \
	    "attribute::name" "" $context $env $txnenv $oargs

	assertXPathParses "11.2.6" $container \
	    "attribute::*" "" $context $env $txnenv $oargs

	assertXPathParses "11.2.7" $container \
	    "descendant::para" "" $context $env $txnenv $oargs

	assertXPathParses "11.2.8" $container \
	    "ancestor::div" "" $context $env $txnenv $oargs

	assertXPathParses "11.2.9" $container \
	    "ancestor-or-self::div" "" $context $env $txnenv $oargs

	assertXPathParses "11.2.10" $container \
	    "descendant-or-self::para" "" $context $env $txnenv $oargs

	assertXPathParses "11.2.11" $container \
	    "self::para" "" $context $env $txnenv $oargs

	assertXPathParses "11.2.12" $container \
	    "child::chapter/descendant::para" "" $context $env $txnenv $oargs

	assertXPathParses "11.2.13" $container \
	    "child::*/child::para" "" $context $env $txnenv $oargs

	assertXPathParses "11.2.14" $container \
	    "/" "" $context $env $txnenv $oargs

	assertXPathParses "11.2.15" $container \
	    "/descendant::para" "" $context $env $txnenv $oargs

	assertXPathParses "11.2.16" $container \
	    "/descendant::olist/child::item" "" $context $env $txnenv $oargs

	assertXPathParses "11.2.17" $container \
	    "child::para\[position()=1\]" "" $context $env $txnenv $oargs

	assertXPathParses "11.2.18" $container \
	    "child::para\[position()=last()\]" "" $context $env $txnenv $oargs

	assertXPathParses "11.2.19" $container \
	    "child::para\[position()=last()-1\]" "" $context $env $txnenv $oargs

	assertXPathParses "11.2.20" $container \
	    "child::para\[position()>1\]" "" $context $env $txnenv $oargs

	assertXPathParses "11.2.21" $container \
	    "following-sibling::chapter\[position()=1\]" "" \
	    $context $env $txnenv $oargs

	assertXPathParses "11.2.22" $container \
	    "preceding-sibling::chapter\[position()=1\]" "" \
	    $context $env $txnenv $oargs

	assertXPathParses "11.2.23" $container \
	    "/descendant::figure\[position()=42\]" "" \
	    $context $env $txnenv $oargs

	assertXPathParses "11.2.24" $container \
	    "/child::doc/child::chapter\[position()=5\]/child::section\[position()=2\]" \
	     "" $context $env $txnenv $oargs

	assertXPathParses "11.2.25" $container \
	    "child::para\[attribute::type='warning'\]" \
	    "" $context $env $txnenv $oargs

	assertXPathParses "11.2.26" $container \
	    "child::para\[attribute::type='warning'\]\[position()=5\]" \
	    "" $context $env $txnenv $oargs

	assertXPathParses "11.2.27" $container \
	    "child::para\[position()=5\]\[attribute::type='warning'\]" \
	    "" $context $env $txnenv $oargs

	assertXPathParses "11.2.28" $container \
	    "child::chapter\[child::title='Introduction'\]" \
	    "" $context $env $txnenv $oargs

	assertXPathParses "11.2.29" $container \
	    "child::chapter\[child::title\]" "" $context $env $txnenv $oargs

	assertXPathParses "11.2.30" $container \
	    "child::*\[self::chapter or self::appendix\]" \
	    "" $context $env $txnenv $oargs

	assertXPathParses "11.2.31" $container \
	    "child::*\[self::chapter or self::appendix\]\[position()=last()\]"\
	     "" $context $env $txnenv $oargs

	$container close
	delete container	
	delete context
}

proc xml011_3 { {env "NULL"} {txnenv 0} {basename $tnum} oargs } {
	puts "\txml011.3: XPath recommendation document tests:\n \
	    \t\t\tabbreviated syntax."
	source ./include.tcl
	set txn NULL
	xml_cleanup $testdir $env

	new XmlContainer container $env "$basename.3.dbxml" 0

	if { $txnenv == 1 } { set txn [start_txn $env] }
	$container open $txn $oargs 0
	if { $txnenv == 1 } { commit_txn $txn }

	new XmlQueryContext context
	$context set "dbxml:debug" "result"

	assertXPathParses "11.3.1" $container "para" \
	    "" $context $env $txnenv $oargs
	assertXPathParses "11.3.2" $container "*" \
	    "" $context $env $txnenv $oargs
	assertXPathParses "11.3.3" $container "text()" \
	    "" $context $env $txnenv $oargs
	assertXPathParses "11.3.4" $container "@name" \
	    "" $context $env $txnenv $oargs
	assertXPathParses "11.3.5" $container "@*" \
	    "" $context $env $txnenv $oargs
	assertXPathParses "11.3.6" $container "para\[1\]" \
	    "" $context $env $txnenv $oargs
	assertXPathParses "11.3.7" $container "para\[last()\]" \
	    "" $context $env $txnenv $oargs
	assertXPathParses "11.3.8" $container "*/para" \
	    "" $context $env $txnenv $oargs
	assertXPathParses "11.3.9" $container "/doc/chapter\[5\]/section\[2\]" \
	    "" $context $env $txnenv $oargs
	assertXPathParses "11.3.10" $container "chapter//para" \
	    "" $context $env $txnenv $oargs
	assertXPathParses "11.3.11" $container "//para" \
	    "" $context $env $txnenv $oargs
	assertXPathParses "11.3.12" $container "//olist/item" \
	    "" $context $env $txnenv $oargs
	assertXPathParses "11.3.13" $container "." \
	    "" $context $env $txnenv $oargs
	assertXPathParses "11.3.14" $container ".//para" \
	    "" $context $env $txnenv $oargs
	assertXPathParses "11.3.15" $container ".." \
	    "" $context $env $txnenv $oargs
	assertXPathParses "11.3.16" $container "../@lang" \
	    "" $context $env $txnenv $oargs
	assertXPathParses "11.3.17" $container "para\[@type='warning'\]" \
	    "" $context $env $txnenv $oargs
	assertXPathParses "11.3.18" $container "para\[@type='warning'\]\[5\]" \
	    "" $context $env $txnenv $oargs
	assertXPathParses "11.3.19" $container "para\[5\]\[@type='warning'\]" \
	    "" $context $env $txnenv $oargs
	assertXPathParses "11.3.20" $container "chapter\[title='Introduction'\]" \
	    "" $context $env $txnenv $oargs
	assertXPathParses "11.3.21" $container "chapter\[title\]" \
	    "" $context $env $txnenv $oargs
	assertXPathParses "11.3.22" $container \
	    "employee\[@secretary and @assistant\]" \
	    "" $context $env $txnenv $oargs

	$container close
	delete container
	delete context
}

proc xml011_4 { {env "NULL"} {txnenv 0} {basename $tnum} oargs } {
	puts "\txml011.4: Query plan generator tests."
	source ./include.tcl
	set txn NULL
	xml_cleanup $testdir $env

	new XmlContainer container $env "$basename.4.dbxml" 0

	if { $txnenv == 1 } { set txn [start_txn $env] }
	$container open $txn $oargs 0
	if { $txnenv == 1 } { commit_txn $txn }

	if { $txnenv == 1 } { set txn [start_txn $env] }
	$container addIndex $txn "" "id" "node-attribute-equality-string"
	$container addIndex $txn "" "y" "node-element-equality-string"
	$container addIndex $txn "" "y" "node-element-equality-number"
	if { $txnenv == 1 } { commit_txn $txn }

	new XmlQueryContext context
	$context set "dbxml:debug" "result"

	assertXPathParses "11.4.1" $container {//*[last()]} \
	    "" $context $env $txnenv $oargs
	assertXPathParses "11.4.2" $container {//*[position()]} \
	    "" $context $env $txnenv $oargs
	assertXPathParses "11.4.3" $container {//*[count(bar)]} \
	    "" $context $env $txnenv $oargs
	assertXPathParses "11.4.4" $container {//*[id('bar')]} \
	    "RA(RI(node-attribute-equality-string,=,id,bar))" \
	    $context $env $txnenv $oargs
	assertXPathParses "11.4.5" $container {//*[local-name()]} \
	    "" $context $env $txnenv $oargs
	assertXPathParses "11.4.6" $container {//*[local-name(bar)]} \
	    "" $context $env $txnenv $oargs
	assertXPathParses "11.4.7" $container {//*[namespace-uri()]} \
	    "" $context $env $txnenv $oargs
	assertXPathParses "11.4.8" $container {//*[namespace-uri(bar)]} \
	    "" $context $env $txnenv $oargs
	assertXPathParses "11.4.9" $container {//*[name()]} \
	    "" $context $env $txnenv $oargs
	assertXPathParses "11.4.10" $container {//*[name(bar)]} \
	    "" $context $env $txnenv $oargs
	#
	# string
	#
	assertXPathParses "11.4.11" $container {//*[y=string((1 div 0)*0)]} \
	    "RF(RA(RI(node-element-equality-string,=,y,NaN)))" \
	    $context $env $txnenv $oargs
	assertXPathParses "11.4.12" $container {//*[y=string(0)]} \
	    "RF(RA(RI(node-element-equality-string,=,y,0)))" \
	    $context $env $txnenv $oargs
	# TODO: optimization
	#assertXPathParses "11.4.13" $container {//*[y=string(-0)]} \
	    "RF(RA(RI(node-element-equality-string,=,y,0)))" \
	    $context $env $txnenv $oargs
	assertXPathParses "11.4.14" $container {//*[y=string(1 div 0)]} \
	    "RF(RA(RI(node-element-equality-string,=,y,Infinity)))" \
	    $context $env $txnenv $oargs
	assertXPathParses "11.4.15" $container {//*[y=string(-1 div 0)]} \
	    "RF(RA(RI(node-element-equality-string,=,y,-Infinity)))" \
	    $context $env $txnenv $oargs
	assertXPathParses "11.4.16" $container {//*[y=string(1)]} \
	    "RF(RA(RI(node-element-equality-string,=,y,1)))" \
	    $context $env $txnenv $oargs
	assertXPathParses "11.4.17" $container {//*[y=string(-1)]} \
	    "RF(RA(RI(node-element-equality-string,=,y,-1)))" \
	    $context $env $txnenv $oargs
	assertXPathParses "11.4.18" $container {//*[y=string(1.0)]} \
	    "RF(RA(RI(node-element-equality-string,=,y,1)))" \
	    $context $env $txnenv $oargs
	assertXPathParses "11.4.19" $container {//*[y=string(-1.0)]} \
	    "RF(RA(RI(node-element-equality-string,=,y,-1)))" \
	    $context $env $txnenv $oargs
	assertXPathParses "11.4.20" $container {//*[y=string(0.1)]} \
	    "RF(RA(RI(node-element-equality-string,=,y,0.1)))" \
	    $context $env $txnenv $oargs
	assertXPathParses "11.4.21" $container {//*[y=string(-0.1)]} \
	    "RF(RA(RI(node-element-equality-string,=,y,-0.1)))" \
	    $context $env $txnenv $oargs
	assertXPathParses "11.4.22" $container {//*[y=string(true())]} \
	    "RF(RA(RI(node-element-equality-string,=,y,true)))" \
	    $context $env $txnenv $oargs
	assertXPathParses "11.4.23" $container {//*[y=string(false())]} \
	    "RF(RA(RI(node-element-equality-string,=,y,false)))" \
	    $context $env $txnenv $oargs
	#
	# concat
	#
	assertXPathParses "11.4.24" $container {//*[y=concat('','ab')]} \
	    "RF(RA(RI(node-element-equality-string,=,y,ab)))" \
	    $context $env $txnenv $oargs
	assertXPathParses "11.4.25" $container {//*[y=concat('a','b')]} \
	    "RF(RA(RI(node-element-equality-string,=,y,ab)))" \
	    $context $env $txnenv $oargs
	assertXPathParses "11.4.26" $container {//*[y=concat('ab','')]} \
	    "RF(RA(RI(node-element-equality-string,=,y,ab)))" \
	    $context $env $txnenv $oargs
	#
	# starts-with
	#
	assertXPathParses "11.4.27" $container \
	    {//*[y=string(starts-with('a','a'))]} \
	    "RF(RA(RI(node-element-equality-string,=,y,true)))" \
	    $context $env $txnenv $oargs
	assertXPathParses "11.4.28" $container \
	    {//*[y=string(starts-with('a','b'))]} \
	    "RF(RA(RI(node-element-equality-string,=,y,false)))" \
	    $context $env $txnenv $oargs
	assertXPathParses "11.4.29" $container \
	    {//*[y=string(starts-with('a',''))]} \
	    "RF(RA(RI(node-element-equality-string,=,y,true)))" \
	    $context $env $txnenv $oargs
	assertXPathParses "11.4.30" $container \
	    {//*[y=string(starts-with('','b'))]} \
	    "RF(RA(RI(node-element-equality-string,=,y,false)))" \
	    $context $env $txnenv $oargs
	assertXPathParses "11.4.31" $container \
	    {//*[y=string(starts-with('',''))]} \
	    "RF(RA(RI(node-element-equality-string,=,y,true)))" \
	    $context $env $txnenv $oargs
	#
	# contains
	#
	assertXPathParses "11.4.32" $container \
	    {//*[y=string(contains('',''))]} \
	    "RF(RA(RI(node-element-equality-string,=,y,true)))" \
	    $context $env $txnenv $oargs
	assertXPathParses "11.4.33" $container \
	    {//*[y=string(contains('a',''))]} \
	    "RF(RA(RI(node-element-equality-string,=,y,true)))" \
	    $context $env $txnenv $oargs
	assertXPathParses "11.4.34" $container \
	    {//*[y=string(contains('','b'))]} \
	    "RF(RA(RI(node-element-equality-string,=,y,false)))" \
	    $context $env $txnenv $oargs
	assertXPathParses "11.4.35" $container \
	    {//*[y=string(contains('a','a'))]} \
	    "RF(RA(RI(node-element-equality-string,=,y,true)))" \
	    $context $env $txnenv $oargs
	assertXPathParses "11.4.36" $container \
	    {//*[y=string(contains('a','b'))]} \
	    "RF(RA(RI(node-element-equality-string,=,y,false)))" \
	    $context $env $txnenv $oargs
	assertXPathParses "11.4.37" $container \
	    {//*[y=string(contains('abc','b'))]} \
	    "RF(RA(RI(node-element-equality-string,=,y,true)))" \
	    $context $env $txnenv $oargs
	assertXPathParses "11.4.38" $container \
	    {//*[y=string(contains('abc','c'))]} \
	    "RF(RA(RI(node-element-equality-string,=,y,true)))" \
	    $context $env $txnenv $oargs
	#						
	# substring-before
	#
	assertXPathParses "11.4.39" $container \
	    {//*[y=substring-before('','')]} \
	    "RF(RA(RI(node-element-equality-string,=,y,)))" \
	    $context $env $txnenv $oargs
	assertXPathParses "11.4.40" $container \
	    {//*[y=substring-before('a','')]} \
	    "RF(RA(RI(node-element-equality-string,=,y,)))" \
	    $context $env $txnenv $oargs
	assertXPathParses "11.4.41" $container \
	    {//*[y=substring-before('a','a')]} \
	    "RF(RA(RI(node-element-equality-string,=,y,)))" \
	    $context $env $txnenv $oargs
	assertXPathParses "11.4.42" $container \
	    {//*[y=substring-before('ab','')]} \
	    "RF(RA(RI(node-element-equality-string,=,y,)))" \
	    $context $env $txnenv $oargs
	assertXPathParses "11.4.43" $container \
	    {//*[y=substring-before('ab','a')]} \
	    "RF(RA(RI(node-element-equality-string,=,y,)))" \
	    $context $env $txnenv $oargs
	assertXPathParses "11.4.44" $container \
	    {//*[y=substring-before('ab','b')]} \
	    "RF(RA(RI(node-element-equality-string,=,y,a)))" \
	    $context $env $txnenv $oargs
	#
	# substring-after
	#
	assertXPathParses "11.4.45" $container \
	    {//*[y=substring-after('','')]} \
	    "RF(RA(RI(node-element-equality-string,=,y,)))" \
	    $context $env $txnenv $oargs
	assertXPathParses "11.4.46" $container \
	    {//*[y=substring-after('a','')]} \
	    "RF(RA(RI(node-element-equality-string,=,y,a)))" \
	    $context $env $txnenv $oargs
	assertXPathParses "11.4.47" $container \
	    {//*[y=substring-after('a','a')]} \
	    "RF(RA(RI(node-element-equality-string,=,y,)))" \
	    $context $env $txnenv $oargs
	assertXPathParses "11.4.48" $container \
	    {//*[y=substring-after('ab','')]} \
	    "RF(RA(RI(node-element-equality-string,=,y,ab)))" \
	    $context $env $txnenv $oargs
	assertXPathParses "11.4.49" $container \
	    {//*[y=substring-after('ab','a')]} \
	    "RF(RA(RI(node-element-equality-string,=,y,b)))" \
	    $context $env $txnenv $oargs
	assertXPathParses "11.4.50" $container \
	    {//*[y=substring-after('ab','b')]} \
	    "RF(RA(RI(node-element-equality-string,=,y,)))" \
	    $context $env $txnenv $oargs
	#
	# substring
	#
	assertXPathParses "11.4.51" $container {//*[y=substring('',1)]} \
	    "RF(RA(RI(node-element-equality-string,=,y,)))" \
	    $context $env $txnenv $oargs
	assertXPathParses "11.4.52" $container {//*[y=substring('a',0)]} \
	    "RF(RA(RI(node-element-equality-string,=,y,a)))" \
	    $context $env $txnenv $oargs
	assertXPathParses "11.4.53" $container {//*[y=substring('a',1)]} \
	    "RF(RA(RI(node-element-equality-string,=,y,a)))" \
	    $context $env $txnenv $oargs
	assertXPathParses "11.4.54" $container {//*[y=substring('a',1.1)]} \
	    "RF(RA(RI(node-element-equality-string,=,y,a)))" \
	    $context $env $txnenv $oargs
	assertXPathParses "11.4.55" $container {//*[y=substring('a',2)]} \
	    "RF(RA(RI(node-element-equality-string,=,y,)))" \
	    $context $env $txnenv $oargs
	assertXPathParses "11.4.56" $container {//*[y=substring('ab',0)]} \
	    "RF(RA(RI(node-element-equality-string,=,y,ab)))" \
	    $context $env $txnenv $oargs
	assertXPathParses "11.4.57" $container {//*[y=substring('ab',1)]} \
	    "RF(RA(RI(node-element-equality-string,=,y,ab)))" \
	    $context $env $txnenv $oargs
	assertXPathParses "11.4.58" $container {//*[y=substring('ab',1.1)]} \
	    "RF(RA(RI(node-element-equality-string,=,y,ab)))" \
	    $context $env $txnenv $oargs
	assertXPathParses "11.4.59" $container {//*[y=substring('ab',1.9)]} \
	    "RF(RA(RI(node-element-equality-string,=,y,b)))" \
	    $context $env $txnenv $oargs
	assertXPathParses "11.4.60" $container {//*[y=substring('ab',2)]} \
	    "RF(RA(RI(node-element-equality-string,=,y,b)))" \
	    $context $env $txnenv $oargs
	#
	# string-length
	#
	assertXPathParses "11.4.61" $container {//*[y=string-length('')]} \
	    "RF(RA(RI(node-element-equality-number,=,y,0)))" \
	    $context $env $txnenv $oargs
	assertXPathParses "11.4.62" $container {//*[y=string-length('a')]} \
	    "RF(RA(RI(node-element-equality-number,=,y,1)))" \
	    $context $env $txnenv $oargs
	assertXPathParses "11.4.63" $container {//*[y=string-length('ab')]} \
	    "RF(RA(RI(node-element-equality-number,=,y,2)))" \
	    $context $env $txnenv $oargs
	#
	# normalize-space
	#
	assertXPathParses "11.4.64" $container \
	    {//*[y=normalize-space('')]} \
	    "RF(RA(RI(node-element-equality-string,=,y,)))" \
	    $context $env $txnenv $oargs
	assertXPathParses "11.4.65" $container \
	    {//*[y=normalize-space(' ')]} \
	    "RF(RA(RI(node-element-equality-string,=,y,)))" \
	    $context $env $txnenv $oargs
	assertXPathParses "11.4.66" $container \
	    {//*[y=normalize-space('a')]} \
	    "RF(RA(RI(node-element-equality-string,=,y,a)))" \
	    $context $env $txnenv $oargs
	assertXPathParses "11.4.67" $container \
	    {//*[y=normalize-space(' a')]} \
	    "RF(RA(RI(node-element-equality-string,=,y,a)))" \
	    $context $env $txnenv $oargs
	assertXPathParses "11.4.70" $container \
	    {//*[y=normalize-space('a ')]} \
	    "RF(RA(RI(node-element-equality-string,=,y,a)))" \
	    $context $env $txnenv $oargs
	assertXPathParses "11.4.71" $container \
	    {//*[y=normalize-space('a  ')]} \
	    "RF(RA(RI(node-element-equality-string,=,y,a)))" \
	    $context $env $txnenv $oargs
	assertXPathParses "11.4.72" $container \
	    {//*[y=normalize-space(' a ')]} \
	    "RF(RA(RI(node-element-equality-string,=,y,a)))" \
	    $context $env $txnenv $oargs
	assertXPathParses "11.4.73" $container \
	    {//*[y=normalize-space('  a  ')]} \
	    "RF(RA(RI(node-element-equality-string,=,y,a)))" \
	    $context $env $txnenv $oargs
	assertXPathParses "11.4.74" $container \
	    {//*[y=normalize-space('a b')]} \
	    "RF(RA(RI(node-element-equality-string,=,y,a b)))" \
	    $context $env $txnenv $oargs
	assertXPathParses "11.4.75" $container \
	    {//*[y=normalize-space(' a b ')]} \
	    "RF(RA(RI(node-element-equality-string,=,y,a b)))" \
	    $context $env $txnenv $oargs
	assertXPathParses "11.4.76" $container \
	    {//*[y=normalize-space('  a b  ')]} \
	    "RF(RA(RI(node-element-equality-string,=,y,a b)))" \
	    $context $env $txnenv $oargs
	#
	# translate
	#
	assertXPathParses "11.4.77" $container {//*[y=translate('','','')]} \
	    "RF(RA(RI(node-element-equality-string,=,y,)))" \
	    $context $env $txnenv $oargs
	assertXPathParses "11.4.78" $container {//*[y=translate('a','','')]} \
	    "RF(RA(RI(node-element-equality-string,=,y,)))" \
	    $context $env $txnenv $oargs
	assertXPathParses "11.4.79" $container {//*[y=translate('','a','')]} \
	    "RF(RA(RI(node-element-equality-string,=,y,)))" \
	    $context $env $txnenv $oargs
	assertXPathParses "11.4.80" $container {//*[y=translate('','','a')]} \
	    "RF(RA(RI(node-element-equality-string,=,y,)))" \
	    $context $env $txnenv $oargs
	assertXPathParses "11.4.81" $container {//*[y=translate('a','a','b')]} \
	    "RF(RA(RI(node-element-equality-string,=,y,b)))" \
	    $context $env $txnenv $oargs
	assertXPathParses "11.4.82" $container {//*[y=translate('b','a','b')]} \
	    "RF(RA(RI(node-element-equality-string,=,y,)))" \
	    $context $env $txnenv $oargs
	assertXPathParses "11.4.83" $container {//*[y=translate('a','a','')]} \
	    "RF(RA(RI(node-element-equality-string,=,y,)))" \
	    $context $env $txnenv $oargs
	assertXPathParses "11.4.84" $container {//*[y=translate('b','a','')]} \
	    "RF(RA(RI(node-element-equality-string,=,y,)))" \
	    $context $env $txnenv $oargs
	assertXPathParses "11.4.85" $container {//*[y=translate('a','','a')]} \
	    "RF(RA(RI(node-element-equality-string,=,y,)))" \
	    $context $env $txnenv $oargs
	assertXPathParses "11.4.86" $container {//*[y=translate('b','','a')]} \
	    "RF(RA(RI(node-element-equality-string,=,y,)))" \
	    $context $env $txnenv $oargs
	assertXPathParses "11.4.87" $container {//*[y=translate('abcdef','abcdef','FEDCBA')]} \
	    "RF(RA(RI(node-element-equality-string,=,y,FEDCBA)))" \
	    $context $env $txnenv $oargs
	#
	# Boolean - Functions
	#
	assertXPathParses "11.4.88" $container {//*[y=string(boolean(1))]} \
	    "RF(RA(RI(node-element-equality-string,=,y,true)))" \
	    $context $env $txnenv $oargs
	assertXPathParses "11.4.89" $container {//*[y=string(boolean(0))]} \
	    "RF(RA(RI(node-element-equality-string,=,y,false)))" \
	    $context $env $txnenv $oargs
	assertXPathParses "11.4.90" $container {//*[y=string(boolean(number('NaN')))]} \
	    "RF(RA(RI(node-element-equality-string,=,y,false)))" \
	    $context $env $txnenv $oargs
	assertXPathParses "11.4.91" $container {//*[y=string(boolean('a'))]} \
	    "RF(RA(RI(node-element-equality-string,=,y,true)))" \
	    $context $env $txnenv $oargs
	assertXPathParses "11.4.92" $container {//*[y=string(boolean(''))]} \
	    "RF(RA(RI(node-element-equality-string,=,y,false)))" \
	    $context $env $txnenv $oargs
	assertXPathParses "11.4.93" $container {//*[y=string(not(false()))]} \
	    "RF(RA(RI(node-element-equality-string,=,y,true)))" \
	    $context $env $txnenv $oargs
	assertXPathParses "11.4.94" $container {//*[y=string(true())]} \
	    "RF(RA(RI(node-element-equality-string,=,y,true)))" \
	    $context $env $txnenv $oargs
	assertXPathParses "11.4.95" $container {//*[y=string(false())]} \
	    "RF(RA(RI(node-element-equality-string,=,y,false)))" \
	    $context $env $txnenv $oargs
	#
	# lang
	#
	assertXPathParses "11.4.96" $container {//*[lang('en')]} \
	    "" $context $env $txnenv $oargs
	#
	# Number - Functions
	#
	assertXPathParses "11.4.97" $container {//*[y=number(' -1.1')]} \
	    "RF(RA(RI(node-element-equality-number,=,y,-1.1)))" \
	    $context $env $txnenv $oargs
	assertXPathParses "11.4.98" $container {//*[y=number(true())]} \
	    "RF(RA(RI(node-element-equality-number,=,y,1)))" \
	    $context $env $txnenv $oargs
	assertXPathParses "11.4.99" $container {//*[y=number(false())]} \
	    "RF(RA(RI(node-element-equality-number,=,y,0)))" \
	    $context $env $txnenv $oargs
	#
	# sum
	#
	assertXPathParses "11.4.100" $container {//*[y=sum(bar)]} \
	    "" $context $env $txnenv $oargs
	#
	# floor
	#
	assertXPathParses "11.4.101" $container {//*[y=floor(1.0)]} \
	    "RF(RA(RI(node-element-equality-number,=,y,1)))" \
	    $context $env $txnenv $oargs
	assertXPathParses "11.4.102" $container {//*[y=floor(1.1)]} \
	    "RF(RA(RI(node-element-equality-number,=,y,1)))" \
	    $context $env $txnenv $oargs
	assertXPathParses "11.4.103" $container {//*[y=floor(1.9)]} \
	    "RF(RA(RI(node-element-equality-number,=,y,1)))" \
	    $context $env $txnenv $oargs
	assertXPathParses "11.4.104" $container {//*[y=floor(-1.1)]} \
	    "RF(RA(RI(node-element-equality-number,=,y,-2)))" \
	    $context $env $txnenv $oargs
	assertXPathParses "11.4.105" $container {//*[y=floor(-1.0)]} \
	    "RF(RA(RI(node-element-equality-number,=,y,-1)))" \
	    $context $env $txnenv $oargs
	assertXPathParses "11.4.106" $container {//*[y=floor(-1.9)]} \
	    "RF(RA(RI(node-element-equality-number,=,y,-2)))" \
	    $context $env $txnenv $oargs
	#
	# ceiling
	#
	assertXPathParses "11.4.107" $container {//*[y=ceiling(1.0)]} \
	    "RF(RA(RI(node-element-equality-number,=,y,1)))" \
	    $context $env $txnenv $oargs
	assertXPathParses "11.4.108" $container {//*[y=ceiling(1.1)]} \
	    "RF(RA(RI(node-element-equality-number,=,y,2)))" \
	    $context $env $txnenv $oargs
	assertXPathParses "11.4.109" $container {//*[y=ceiling(1.9)]} \
	    "RF(RA(RI(node-element-equality-number,=,y,2)))" \
	    $context $env $txnenv $oargs
	assertXPathParses "11.4.110" $container {//*[y=ceiling(-1.0)]} \
	    "RF(RA(RI(node-element-equality-number,=,y,-1)))" \
	    $context $env $txnenv $oargs
	assertXPathParses "11.4.111" $container {//*[y=ceiling(-1.1)]} \
	    "RF(RA(RI(node-element-equality-number,=,y,-1)))" \
	    $context $env $txnenv $oargs
	assertXPathParses "11.4.112" $container {//*[y=ceiling(-1.9)]} \
	    "RF(RA(RI(node-element-equality-number,=,y,-1)))" \
	    $context $env $txnenv $oargs
	#
	# round
	#
	assertXPathParses "11.4.113" $container {//*[y=round(1.0)]} \
	    "RF(RA(RI(node-element-equality-number,=,y,1)))" \
	    $context $env $txnenv $oargs
	assertXPathParses "11.4.114" $container {//*[y=round(1.1)]} \
	    "RF(RA(RI(node-element-equality-number,=,y,1)))" \
	    $context $env $txnenv $oargs
	assertXPathParses "11.4.115" $container {//*[y=round(1.9)]} \
	    "RF(RA(RI(node-element-equality-number,=,y,2)))" \
	    $context $env $txnenv $oargs
	assertXPathParses "11.4.116" $container {//*[y=round(-1.0)]} \
	    "RF(RA(RI(node-element-equality-number,=,y,-1)))" \
	    $context $env $txnenv $oargs
	assertXPathParses "11.4.117" $container {//*[y=round(-1.1)]} \
	    "RF(RA(RI(node-element-equality-number,=,y,-1)))" \
	    $context $env $txnenv $oargs
	assertXPathParses "11.4.118" $container {//*[y=round(-1.9)]} \
	    "RF(RA(RI(node-element-equality-number,=,y,-2)))" \
	    $context $env $txnenv $oargs
	#
	# substring (#2)
	#
	assertXPathParses "11.4.119" $container {//*[y=substring('ab',1,1)]} \
	    "RF(RA(RI(node-element-equality-string,=,y,a)))" \
	    $context $env $txnenv $oargs
	assertXPathParses "11.4.120" $container {//*[y=substring('ab',1,1)]} \
	    "RF(RA(RI(node-element-equality-string,=,y,a)))" \
	    $context $env $txnenv $oargs
	assertXPathParses "11.4.121" $container {//*[y=substring('ab',2,1)]} \
	    "RF(RA(RI(node-element-equality-string,=,y,b)))" \
	    $context $env $txnenv $oargs
	assertXPathParses "11.4.122" $container {//*[y=substring('ab',1,2)]} \
	    "RF(RA(RI(node-element-equality-string,=,y,ab)))" \
	    $context $env $txnenv $oargs
	assertXPathParses "11.4.123" $container {//*[y=substring('ab',1,0)]} \
	    "RF(RA(RI(node-element-equality-string,=,y,)))" \
	    $context $env $txnenv $oargs
	assertXPathParses "11.4.124" $container {//*[y=substring('12345',1.5,2.6)]} \
	    "RF(RA(RI(node-element-equality-string,=,y,234)))" \
	    $context $env $txnenv $oargs
	assertXPathParses "11.4.125" $container {//*[y=substring('12345',0,3)]} \
	    "RF(RA(RI(node-element-equality-string,=,y,12)))" \
	    $context $env $txnenv $oargs
	assertXPathParses "11.4.126" $container {//*[y=substring('12345',1,number('Nan'))]} \
	    "RF(RA(RI(node-element-equality-string,=,y,)))" \
	    $context $env $txnenv $oargs
	assertXPathParses "11.4.127" $container {//*[y=substring('12345',-42,1 div 0)]} \
	    "RF(RA(RI(node-element-equality-string,=,y,12345)))" \
	    $context $env $txnenv $oargs
	assertXPathParses "11.4.128" $container {//*[y=substring('12345',-1 div 0,1 div 0)]} \
	    "RF(RA(RI(node-element-equality-string,=,y,)))" \
	    $context $env $txnenv $oargs

	$container close
	delete container
	delete context
}

proc xml011_5 { {env "NULL"} {txnenv 0} {basename $tnum} oargs } {
	puts "\txml011.5: Query plan generator with constant folding."
	source ./include.tcl
	set txn NULL
	xml_cleanup $testdir $env

	new XmlContainer container $env "$basename.5.dbxml" 0

	if { $txnenv == 1 } { set txn [start_txn $env] }
	$container open $txn $oargs 0
	if { $txnenv == 1 } { commit_txn $txn }

	if { $txnenv == 1 } { set txn [start_txn $env] }
	$container addIndex $txn "" "y" "node-element-equality-string"
	$container addIndex $txn "" "y" "node-element-equality-number"
	if { $txnenv == 1 } { commit_txn $txn }

	new XmlQueryContext context
	$context set "dbxml:debug" "result"

	assertXPathParses "11.5.1" $container {//*[y=1-1]} \
	    "RF(RA(RI(node-element-equality-number,=,y,0)))" \
	    $context $env $txnenv $oargs
	assertXPathParses "11.5.2" $container {//*[y=1-1-1]} \
	    "RF(RA(RI(node-element-equality-number,=,y,-1)))" \
	    $context $env $txnenv $oargs
	assertXPathParses "11.5.3" $container {//*[y=1+1]} \
	    "RF(RA(RI(node-element-equality-number,=,y,2)))" \
	    $context $env $txnenv $oargs
	assertXPathParses "11.5.4" $container {//*[y=1+1+1]} \
	    "RF(RA(RI(node-element-equality-number,=,y,3)))" \
	    $context $env $txnenv $oargs
	assertXPathParses "11.5.5" $container {//*[y=2*2]} \
	    "RF(RA(RI(node-element-equality-number,=,y,4)))" \
	    $context $env $txnenv $oargs
	assertXPathParses "11.5.6" $container {//*[y=2 mod 2]} \
	    "RF(RA(RI(node-element-equality-number,=,y,0)))" \
	    $context $env $txnenv $oargs
	assertXPathParses "11.5.7" $container {//*[y=2 div 2]} \
	    "RF(RA(RI(node-element-equality-number,=,y,1)))" \
	    $context $env $txnenv $oargs
	assertXPathParses "11.5.8" $container {//*[y=0.5-0.5]} \
	    "RF(RA(RI(node-element-equality-number,=,y,0)))" \
	    $context $env $txnenv $oargs
	assertXPathParses "11.5.9" $container {//*[y=0.5+0.4]} \
	    "RF(RA(RI(node-element-equality-number,=,y,0.9)))" \
	    $context $env $txnenv $oargs
	assertXPathParses "11.5.10" $container {//*[y=string(1=1)]} \
	    "RF(RA(RI(node-element-equality-string,=,y,true)))" \
	    $context $env $txnenv $oargs
	assertXPathParses "11.5.11" $container {//*[y=string(true()=true())]} \
	    "RF(RA(RI(node-element-equality-string,=,y,true)))" \
	    $context $env $txnenv $oargs
	assertXPathParses "11.5.12" $container {//*[y=string('a'='a')]} \
	    "RF(RA(RI(node-element-equality-string,=,y,true)))" \
	    $context $env $txnenv $oargs
	assertXPathParses "11.5.13" $container {//*[y=string(1!=1)]} \
	    "RF(RA(RI(node-element-equality-string,=,y,false)))" \
	    $context $env $txnenv $oargs
	assertXPathParses "11.5.14" $container {//*[y=string(true()!=true())]} \
	    "RF(RA(RI(node-element-equality-string,=,y,false)))" \
	    $context $env $txnenv $oargs
	assertXPathParses "11.5.15" $container {//*[y=string('a'!='a')]} \
	    "RF(RA(RI(node-element-equality-string,=,y,false)))" \
	    $context $env $txnenv $oargs
	assertXPathParses "11.5.16" $container {//*[y=string(1<1)]} \
	    "RF(RA(RI(node-element-equality-string,=,y,false)))" \
	    $context $env $txnenv $oargs
	assertXPathParses "11.5.17" $container {//*[y=string(1>1)]} \
	    "RF(RA(RI(node-element-equality-string,=,y,false)))" \
	    $context $env $txnenv $oargs
	assertXPathParses "11.5.18" $container {//*[y=string(1<=1)]} \
	    "RF(RA(RI(node-element-equality-string,=,y,true)))" \
	    $context $env $txnenv $oargs
	assertXPathParses "11.5.19" $container {//*[y=string(1>=1)]} \
	    "RF(RA(RI(node-element-equality-string,=,y,true)))" \
	    $context $env $txnenv $oargs
	assertXPathParses "11.5.20" $container {//*[y=string(true() and true())]} \
	    "RF(RA(RI(node-element-equality-string,=,y,true)))" \
	    $context $env $txnenv $oargs
	assertXPathParses "11.5.21" $container {//*[y=string(true() or true())]} \
	    "RF(RA(RI(node-element-equality-string,=,y,true)))" \
	    $context $env $txnenv $oargs
	assertXPathParses "11.5.22" $container {//*[y=-1]} \
	    "RF(RA(RI(node-element-equality-number,=,y,-1)))" \
	    $context $env $txnenv $oargs

	$container close
	delete container
	delete context
}

proc xml011_6 { {env "NULL"} {txnenv 0} {basename $tnum} oargs } {
	puts "\txml011.6: Detecting syntax errors."
	source ./include.tcl
	set txn NULL
	xml_cleanup $testdir $env

	new XmlContainer container $env "$basename.6.dbxml" 0

	if { $txnenv == 1 } { set txn [start_txn $env] }
	$container open $txn $oargs 0
	if { $txnenv == 1 } { commit_txn $txn }

	new XmlQueryContext context
	$context set "dbxml:debug" "result"

	assertXPathDoesNotParse "11.6.1" $container {} $env $txnenv $oargs
	assertXPathDoesNotParse "11.6.2" $container {1} $env $txnenv $oargs
	assertXPathDoesNotParse "11.6.3" $container {'a'} $env $txnenv $oargs
	assertXPathDoesNotParse "11.6.4" $container {a::b} $env $txnenv $oargs
	assertXPathDoesNotParse "11.6.5" $container {!@#$%^&*()} $env $txnenv $oargs
	assertXPathDoesNotParse "11.6.6" $container {count(/foo)} $env $txnenv $oargs
	assertXPathDoesNotParse "11.6.7" $container {text((} $env $txnenv $oargs

	$container close
	delete container
	delete context
}

proc xml011_7 { {env "NULL"} {txnenv 0} {basename $tnum} oargs } {
	puts "\txml011.7: Detect parser errors."
	source ./include.tcl
	set txn NULL
	xml_cleanup $testdir $env

	new XmlContainer container $env "$basename.7.dbxml" 0

	if { $txnenv == 1 } { set txn [start_txn $env] }
	$container open $txn $oargs 0
	if { $txnenv == 1 } { commit_txn $txn }

	new XmlQueryContext context
	$context set "dbxml:debug" "result"

	assertXPathDoesNotParse "11.7.1" $container {///} $env $txnenv $oargs
	assertXPathDoesNotParse "11.7.2" $container {/foo///} $env $txnenv $oargs
	assertXPathDoesNotParse "11.7.3" $container {/a::foo//} $env $txnenv $oargs
	assertXPathDoesNotParse "11.7.4" $container {foo[[} $env $txnenv $oargs
	assertXPathDoesNotParse "11.7.5" $container {/*[foo()]} $env $txnenv $oargs

	$container close
	delete container
	delete context
}

proc xml011_8 { {env "NULL"} {txnenv 0} {basename $tnum} oargs } {
	puts "\txml011.8: Detect semantic errors. "
	source ./include.tcl
	set txn NULL
	xml_cleanup $testdir $env

	new XmlContainer container $env "$basename.8.dbxml" 0

	if { $txnenv == 1 } { set txn [start_txn $env] }
	$container open $txn $oargs 0
	if { $txnenv == 1 } { commit_txn $txn }

	new XmlQueryContext context
	$context set "dbxml:debug" "result"

	assertXPathDoesNotParse "11.8.1" $container {/foo[bar=-'hello']} \
	    $env $txnenv $oargs
	assertXPathDoesNotParse "11.8.2" $container {/foo[bar=$baz]} \
	    $env $txnenv $oargs
	assertXPathDoesNotParse "11.8.3" $container {/foo:bar} \
	    $env $txnenv $oargs
	assertXPathDoesNotParse "11.8.4" $container {/foo[bar<'123']} \
	    $env $txnenv $oargs
	assertXPathDoesNotParse "11.8.5" $container {/foo[bar>'123']} \
	    $env $txnenv $oargs
	assertXPathDoesNotParse "11.8.6" $container {/foo[bar<='123']} \
	    $env $txnenv $oargs
	assertXPathDoesNotParse "11.8.7" $container {/foo[bar>='123']} \
	    $env $txnenv $oargs

	$container close
	delete container
	delete context
}

proc xml011_9 { {env "NULL"} {txnenv 0} {basename $tnum} oargs } {
	puts "\txml011.9: Operations | or and !=. Functions text() id() name()."
	source ./include.tcl
	set txn NULL
	xml_cleanup $testdir $env

	new XmlContainer container $env "$basename.9.dbxml" 0

	if { $txnenv == 1 } { set txn [start_txn $env] }
	$container open $txn $oargs 0
	if { $txnenv == 1 } { commit_txn $txn }

	if { $txnenv == 1 } { set txn [start_txn $env] }
	$container addIndex $txn "" "foo" "node-element-equality-string"
	$container addIndex $txn "" "bar" "node-element-presence-none"
	$container addIndex $txn "" "id" "node-attribute-equality-string"
	$container addIndex $txn "" "baz" "edge-element-equality-string"
	if { $txnenv == 1 } { commit_txn $txn }

	new XmlQueryContext context
	$context set "dbxml:debug" "result"

	assertXPathParses "11.9.1" $container {/*[/foo | /bar]} \
		"RF(RA(u(RI(node-element-equality-string,prefix,foo),RI(node-element-presence-none,=,bar))))"  \
		$context $env $txnenv $oargs
	assertXPathParses "11.9.2" $container {/*[foo or bar]}  \
		"RF(RA(u(RI(node-element-equality-string,prefix,foo),RI(node-element-presence-none,=,bar))))"  \
		$context $env $txnenv $oargs
	assertXPathParses "11.9.3" $container {/*[foo and bar]}  \
		"RF(RA(n(RI(node-element-equality-string,prefix,foo),RI(node-element-presence-none,=,bar))))"  \
		$context $env $txnenv $oargs
	assertXPathParses "11.9.4" $container {/*[foo!='123']}  \
		"RF(RA(SS))"  \
		$context $env $txnenv $oargs
	assertXPathParses "11.9.5" $container {/foo[text()='123']}  \
		"RF(RA(RI(node-element-equality-string,=,foo,123)))"  \
		$context $env $txnenv $oargs
	assertXPathParses "11.9.6" $container {/*[text()='123']}  \
		"RF(RA(SS))"  \
		$context $env $txnenv $oargs
	assertXPathParses "11.9.7" $container {/*[id('1')]}  \
		"RA(RI(node-attribute-equality-string,=,id,1))"  \
		$context $env $txnenv $oargs
	assertXPathParses "11.9.8" $container {/*[id('1 2')]}  \
		"RA(u(RI(node-attribute-equality-string,=,id,2),RI(node-attribute-equality-string,=,id,1)))"  \
		$context $env $txnenv $oargs
	assertXPathParses "11.9.9" $container {/*[id('1 2 3')]}  \
		"RA(u(RI(node-attribute-equality-string,=,id,3),u(RI(node-attribute-equality-string,=,id,2),RI(node-attribute-equality-string,=,id,1))))"  \
		$context $env $txnenv $oargs
	assertXPathParses "11.9.10" $container {/foo[name()='foo']}  \
		"RF(RA(RI(node-element-equality-string,prefix,foo)))"  \
		$context $env $txnenv $oargs

	#enableDebugLog
	#assertXPathParses "11.9.11" $container {/*[name()='foo']} "RF(RA(RI(node-element-equality-string,prefix,foo)))" $context
	#disableDebugLog

	$context set "foo" "foo"
	assertXPathParses "11.9.12" $container {/*[name()=$foo]}  \
		"RF(RA(SS))"  \
		$context $env $txnenv $oargs
	assertXPathParses "11.9.13" $container {/*[foo][bar]}  \
		"RF(RA(n(RI(node-element-equality-string,prefix,foo),RI(node-element-presence-none,=,bar))))"  \
		$context $env $txnenv $oargs
	assertXPathParses "11.9.14" $container {/*[true() | true()]}  \
		"RA(SS)"  \
		$context $env $txnenv $oargs
	assertXPathParses "11.9.15" $container {//*[id('1')]}  \
		"RA(RI(node-attribute-equality-string,=,id,1))"  \
		$context $env $txnenv $oargs
	assertXPathParses "11.9.16" $container {//*[id('1 2')]}  \
		"RA(u(RI(node-attribute-equality-string,=,id,2),RI(node-attribute-equality-string,=,id,1)))"  \
		$context $env $txnenv $oargs
	assertXPathParses "11.9.17" $container {//*[id('1 2 3')]}  \
		"RA(u(RI(node-attribute-equality-string,=,id,3),u(RI(node-attribute-equality-string,=,id,2),RI(node-attribute-equality-string,=,id,1))))"  \
		$context $env $txnenv $oargs
	assertXPathParses "11.9.18" $container {/foo[.='123']}  \
		"RF(RA(RI(node-element-equality-string,=,foo,123)))"  \
		$context $env $txnenv $oargs
	assertXPathParses "11.9.19" $container {/*[.='123']}  \
		"RF(RA(SS))"  \
		$context $env $txnenv $oargs
	# (SR#8528) Pathan used to have a problem with the union operator
	assertXPathParses "11.9.20" $container {/a | /b} \
		"RF(RA(SS))"  \
		$context $env $txnenv $oargs
	assertXPathParses "11.9.21" $container {/a | /b | /c} \
		"RF(RA(SS))"  \
		$context $env $txnenv $oargs
	assertXPathParses "11.9.22" $container {/a | /b | /c | /d} \
		"RF(RA(SS))"  \
		$context $env $txnenv $oargs
	# (SR#8527) edge indexes and text() had a problem
	assertXPathParses "11.9.23" $container {/foo/baz/text()} \
		"RF(RA(RI(edge-element-equality-string,prefix,foo.baz)))" \
		$context $env $txnenv $oargs
	assertXPathParses "11.9.24" $container {/foo/baz[text()='abc']} \
		"RF(RA(RI(edge-element-equality-string,=,foo.baz,abc)))" \
		$context $env $txnenv $oargs
	# This query produces a poor plan... the query planner isn't smart enough for this.
	#assertXPathParses "11.9.25" $container {/foo/baz[text()='abc' or text()='123']} \
	#		"RF(RA(SS))"  \
	#	$context $env $txnenv $oargs

	$container close
	delete container
	delete context
}

proc xml011_10 { {env "NULL"} {txnenv 0} {basename $tnum} oargs } {
	puts "\txml011.10: Sequential scan optimizations."

	test_11_10_x "$basename.10.1" "" "" \
	    {/*[foo and bar]} "RF(RA(SS))" \
	    $env $txnenv $oargs

	test_11_10_x "$basename.10.2" "foo" "node-element-presence-none" \
	    {/*[foo and bar]} "RF(RA(RI(node-element-presence-none,=,foo)))" \
	    $env $txnenv $oargs

	test_11_10_x "$basename.10.3" "foo" "node-element-presence-none" \
	    {/*[bar and foo]} "RF(RA(RI(node-element-presence-none,=,foo)))" \
	    $env $txnenv $oargs

	test_11_10_x "$basename.10.4" "" "" \
	    {//*} "RA(SS)" \
	    $env $txnenv $oargs

	test_11_10_x "$basename.10.5" "foo" "node-element-presence-none" \
	    {//foo} "RA(RI(node-element-presence-none,=,foo))" \
	    $env $txnenv $oargs

	test_11_10_x "$basename.10.6" "" "" \
	    {/*[foo or bar]} "RF(RA(SS))" \
	    $env $txnenv $oargs

	test_11_10_x "$basename.10.7" "foo" "node-element-presence-none" \
	    {/*[foo or bar]} "RF(RA(SS))" \
	    $env $txnenv $oargs

	test_11_10_x "$basename.10.8" "foo" "node-element-presence-none" \
	    {/*[bar or foo]} "RF(RA(SS))" \
	    $env $txnenv $oargs

}

proc test_11_10_x { basename nodename index query oqp \
	    {env "NULL"} {txnenv 0} oargs } {
	source ./include.tcl
	set txn NULL
	xml_cleanup $testdir $env

	new XmlContainer container $env "$basename.dbxml" 0

	if { $txnenv == 1 } { set txn [start_txn $env] }
	$container open $txn $oargs 0
	if { $txnenv == 1 } { commit_txn $txn }

	if {$nodename != "" } {
		if { $txnenv == 1 } { set txn [start_txn $env] }
		$container addIndex $txn "" $nodename $index
		if { $txnenv == 1 } { commit_txn $txn }
	}
	new XmlQueryContext context
	$context set "dbxml:debug" "result"

	assertXPathParses $basename $container $query $oqp $context \
	    $env $txnenv $oargs

	$container close
	delete container
}

proc xml011_11 { {env "NULL"} {txnenv 0} {basename $tnum} oargs } {
	puts "\txml011.11: Edge index lookup optimizations."
	source ./include.tcl
	set txn NULL
	xml_cleanup $testdir $env

	new XmlContainer container $env "$basename.11.dbxml" 0

	if { $txnenv == 1 } { set txn [start_txn $env] }
	$container open $txn $oargs 0
	if { $txnenv == 1 } { commit_txn $txn }

	if { $txnenv == 1 } { set txn [start_txn $env] }
	$container addIndex $txn "" "foo" "edge-element-presence"
	$container addIndex $txn "" "bar" "edge-element-presence"
	$container addIndex $txn "" "baz" "edge-element-presence"
	$container addIndex $txn "" "boo" "edge-element-presence"
	if { $txnenv == 1 } { commit_txn $txn }

	new XmlQueryContext context
	$context set "dbxml:debug" "result"

	assertXPathParses "11.11.1" $container {/foo/bar} \
	    "RF(RA(RI(edge-element-presence-none,=,foo.bar)))"  \
	    $context $env $txnenv $oargs
	assertXPathParses "11.11.2" $container {/foo/bar/baz}  \
	    "RF(RA(n(RI(edge-element-presence-none,=,foo.bar),RI(edge-element-presence-none,=,bar.baz))))"  \
	    $context $env $txnenv $oargs
	assertXPathParses "11.11.3" $container {/foo/bar/baz/boo}  \
	    "RF(RA(n(RI(edge-element-presence-none,=,foo.bar),n(RI(edge-element-presence-none,=,bar.baz),RI(edge-element-presence-none,=,baz.boo)))))"  \
	    $context $env $txnenv $oargs

	delete context
	$container close
	delete container
}

proc xml011_12 { {env "NULL"} {txnenv 0} {basename $tnum} oargs } {
	puts "\txml011.12: Candidate set = result set optimization."
	source ./include.tcl
	set txn NULL
	xml_cleanup $testdir $env

	new XmlContainer container $env "$basename.12.dbxml" 0

	if { $txnenv == 1 } { set txn [start_txn $env] }
	$container open $txn $oargs 0
	if { $txnenv == 1 } { commit_txn $txn }

	if { $txnenv == 1 } { set txn [start_txn $env] }
	$container addIndex $txn "" "foo" "node-element-equality-string"
	if { $txnenv == 1 } { commit_txn $txn }

	new XmlQueryContext context
	$context set "dbxml:debug" "result"

	assertXPathParses "11.12.1" $container {//foo} \
	    "RA(RI(node-element-equality-string,prefix,foo))"  \
	    $context $env $txnenv $oargs
	assertXPathParses "11.12.2" $container {//foo[text()='bar']}  \
	    "RA(RI(node-element-equality-string,=,foo,bar))"  \
	    $context $env $txnenv $oargs
	assertXPathParses "11.12.3" $container {//foo[text()='bar' or text()='baz']}  \
	    "RA(u(RI(node-element-equality-string,=,foo,bar),RI(node-element-equality-string,=,foo,baz)))"  \
	    $context $env $txnenv $oargs
	assertXPathParses "11.12.4" $container {//foo[text()='bar' and text()='baz']}  \
	    "RA(n(RI(node-element-equality-string,=,foo,bar),RI(node-element-equality-string,=,foo,baz)))"  \
	    $context $env $txnenv $oargs
	assertXPathParses "11.12.5" $container {//*[text()='bar' or text()='baz']}  \
	    "RF(RA(SS))"  \
	    $context $env $txnenv $oargs
	assertXPathParses "11.12.6" $container {//*[text()='bar' and text()='baz']}  \
	    "RF(RA(SS))"  \
	    $context $env $txnenv $oargs

	$container close
	delete container
	delete context
}

proc xml011_13 { {env "NULL"} {txnenv 0} {basename $tnum} oargs } {
	puts "\txml011.13: XmlContainer query, XmlQueryContext,\
	    and XmlResults interfaces."
	source ./include.tcl
	set txn NULL

	puts "\t\t11.13.1: Get namespace before setting namespace."
	new XmlQueryContext context
	set n [$context getNamespace "foo"]
	dbxml_error_check_good "get_before_set" $n ""
	delete context

	puts "\t\t11.13.2: Get namespace after setting namespace."
	new XmlQueryContext context
	$context setNamespace "foo" "bar"	
	set n [$context getNamespace "foo"]
	dbxml_error_check_good "get_namespace" $n "bar"
	delete context

	puts "\t\t11.13.3: Remove namespace."
	new XmlQueryContext context
	set n [$context getNamespace "foo"]
	dbxml_error_check_good "11.13.3" $n ""
	$context removeNamespace "foo"
	set n [$context getNamespace "foo"]
	dbxml_error_check_good "remove_namespace" $n ""
	delete context

	puts "\t\t11.13.4: Get after remove of namespace."
	new XmlQueryContext context
	$context setNamespace "foo" "bar"	
	$context removeNamespace "foo"
	set n [$context getNamespace "foo"]
	dbxml_error_check_good "get_after_remove" $n ""
	delete context

	puts "\t\t11.13.5: Get after clear of namespace."
	new XmlQueryContext context
	$context setNamespace "foo" "bar"	
	$context clearNamespaces
	set n [$context getNamespace "foo"]
	dbxml_error_check_good "get_after_clear" $n ""
	delete context

	puts "\t\t11.13.6: Get variable before setting."
	new XmlQueryContext context
	set n [$context get "foo"]
	dbxml_error_check_good "get_variable_before_set" $n ""
	delete context
	
	puts "\t\t11.13.7: Get variable after setting."
	new XmlQueryContext context
	$context set "foo" "bar"
	set n [$context get "foo"]
	dbxml_error_check_good "get_variable" $n "bar"
	delete context

	# Set up container for result document and result value tests.
	xml_cleanup $testdir $env
	new XmlContainer container $env "$basename.13.dbxml" 0

	if { $txnenv == 1 } { set txn [start_txn $env] }
	$container open $txn $oargs 0
	if { $txnenv == 1 } { commit_txn $txn }

	new XmlQueryContext context
	new XmlDocument xd
	$xd setContent "<a><b>c</b></a>"

	if { $txnenv == 1 } { set txn [start_txn $env] }
	$container putDocument $txn $xd
	if { $txnenv == 1 } { commit_txn $txn }

	puts "\t\t11.13.8: Query for document in container (eager)."
	$context setReturnType $XmlQueryContext_ResultDocuments
	$context setEvaluationType $XmlQueryContext_Eager
	assertXPathReturnsValue "11.13.8" $container {/a/b} \
	    [$xd getContent] $context $env $txnenv $oargs

	puts "\t\t11.13.9: Query for result values in container (eager)."
	$context setReturnType $XmlQueryContext_ResultValues
	$context setEvaluationType $XmlQueryContext_Eager
	assertXPathReturnsValue "11.13.9" $container {/a/b} \
	    "<b>c</b>" $context $env $txnenv $oargs

	puts "\t\t11.13.10: Query for document in container (lazy)."
	$context setReturnType $XmlQueryContext_ResultDocuments
	$context setEvaluationType $XmlQueryContext_Lazy
	assertXPathReturnsValue "11.13.10" $container {/a/b} \
	    [$xd getContent] $context $env $txnenv $oargs

	puts "\t\t11.13.11: Query for result values in container (lazy)."
	$context setReturnType $XmlQueryContext_ResultValues
	$context setEvaluationType $XmlQueryContext_Lazy
	assertXPathReturnsValue "11.13.11" $container {/a/b} \
	    "<b>c</b>" $context $env $txnenv $oargs

	delete xd
	delete context
	$container close

	# Remove underlying files so the next tests will work
	if { $txnenv == 1 } { set txn [start_txn $env] }
	$container remove $txn
	if { $txnenv == 1 } { commit_txn $txn }

	delete container

	# Set up new container for candidate documents test.
	xml_cleanup $testdir $env
	new XmlContainer container $env "$basename.13" 0

	if { $txnenv == 1 } { set txn [start_txn $env] }
	$container open $txn $oargs 0
	if { $txnenv == 1 } { commit_txn $txn }

	new XmlQueryContext context
	new XmlDocument xd
	$xd setContent "<d><e>f</e></d>"

	if { $txnenv == 1 } { set txn [start_txn $env] }
	$container putDocument $txn $xd
	if { $txnenv == 1 } { commit_txn $txn }

	new XmlValue xv

	puts "\t\t11.13.12: Query for candidate documents (eager)."
	$context setReturnType $XmlQueryContext_CandidateDocuments
	$context setEvaluationType $XmlQueryContext_Eager

	if { $txnenv == 1 } { set txn [start_txn $env] }
	wrap XmlResults xr [$container queryWithXPath $txn "/a/b" $context]
	$xr next $xv
	if { $txnenv == 1 } { commit_txn $txn }

	dbxml_error_check_good "check_content" [$xv asString] [$xd getContent]
	dbxml_error_check_good "size_of_result_set" [$xr size] 1

	puts "\t\t11.13.13: Reset a result set."
	$xr reset

	if { $txnenv == 1 } { set txn [start_txn $env] }
	$xr next $xv
	if { $txnenv == 1 } { commit_txn $txn }

	dbxml_error_check_good "check_content" [$xv asString] [$xd getContent]
	dbxml_error_check_good "size_of_result_set" [$xr size] 1

	puts "\t\t11.13.16: Add a value to the result set."
	$xr add $xv
	$xr reset

	if { $txnenv == 1 } { set txn [start_txn $env] }
	$xr next $xv
	if { $txnenv == 1 } { commit_txn $txn }
	dbxml_error_check_good "check_content" [$xv asString] [$xd getContent]

	if { $txnenv == 1 } { set txn [start_txn $env] }
	$xr next $xv
	if { $txnenv == 1 } { commit_txn $txn }
	dbxml_error_check_good "check_content_again" [$xv asString] [$xd getContent]
	dbxml_error_check_good "size_of_result_set" [$xr size] 2
	delete xr

	puts "\t\t11.13.14: Call size on lazy result set."
	puts "\t\t11.13.15: Call reset on lazy result set."
	$context setReturnType $XmlQueryContext_ResultDocuments
	$context setEvaluationType $XmlQueryContext_Lazy

	if { $txnenv == 1 } { set txn [start_txn $env] }
	wrap XmlResults xr [$container queryWithXPath $txn "/a/b" $context]
	if { $txnenv == 1 } { commit_txn $txn }

	catch {[$xr size]} ret
	dbxml_error_check_good "11.13.14" [string match "*lazily evaluated*" $ret] 1
	catch {[$xr reset]} ret
	dbxml_error_check_good "11.13.15" [string match "*lazily evaluated*" $ret] 1
	delete xr

	puts "\t\t11.13.17: Query with parseXPathExpression."
	$context setEvaluationType $XmlQueryContext_Eager

	if { $txnenv == 1 } { set txn [start_txn $env] }
	wrap XmlQueryExpression xe [$container parseXPathExpression $txn "/d/e" $context]
	wrap XmlResults xr [$container queryWithXPathExpression $txn $xe]
	$xr next $xv
	if { $txnenv == 1 } { commit_txn $txn }

	dbxml_error_check_good "11.13.17" [$xr size] 1
	dbxml_error_check_good "11.13.17" [$xv asString] [$xd getContent]
	delete xr

	puts "\t\t11.13.18: Reuse XPathExpression object."

	if { $txnenv == 1 } { set txn [start_txn $env] }
	wrap XmlResults xr [$container queryWithXPathExpression NULL $xe]
	$xr next $xv
	if { $txnenv == 1 } { commit_txn $txn }

	dbxml_error_check_good "11.13.18" [$xr size] 1
	dbxml_error_check_good "11.13.18" [$xv asString] [$xd getContent]
	delete xe
	delete xr

	puts "\t\t11.13.19: Query with parseXPathExpression (no context)."
	$context setEvaluationType $XmlQueryContext_Eager

	if { $txnenv == 1 } { set txn [start_txn $env] }
	wrap XmlQueryExpression xe [$container parseXPathExpression $txn "/d/e"]
	wrap XmlResults xr [$container queryWithXPathExpression $txn $xe]
	$xr next $xv
	if { $txnenv == 1 } { commit_txn $txn }

	dbxml_error_check_good "11.13.19" [$xr size] 1
	dbxml_error_check_good "11.13.19" [$xv asString] [$xd getContent]
	delete xe
	delete xr

	puts "\t\t11.13.20: Query for document in container (no context)."

	if { $txnenv == 1 } { set txn [start_txn $env] }
	wrap XmlResults xr [$container queryWithXPath $txn "/d/e"]
	$xr next $xv
	if { $txnenv == 1 } { commit_txn $txn }

	dbxml_error_check_good "11.13.20" [$xr size] 1
	dbxml_error_check_good "11.13.20" [$xv asString] [$xd getContent]
	delete xr

	delete xv
	delete xd
	delete context
	$container close
	delete container
}

proc xml011_14 { {env "NULL"} {txnenv 0} {basename $tnum} oargs } {
	puts "\txml011.14: "
	source ./include.tcl
	set txn NULL
	xml_cleanup $testdir $env

	new XmlContainer container $env "$basename.14.dbxml" 0

	if { $txnenv == 1 } { set txn [start_txn $env] }
	$container open $txn $oargs 0
	if { $txnenv == 1 } { commit_txn $txn }

	new XmlQueryContext context
	$context set "dbxml:debug" "result"

	assertXPathParses "11.14.1" $container {//foo[bar=baz]} \
	    "RF(RA(SS))" $context $env $txnenv $oargs
	assertXPathParses "11.14.2" $container {//foo[bar!=baz]}  \
	    "RF(RA(SS))" $context $env $txnenv $oargs
	assertXPathParses "11.14.3" $container {//foo[bar>baz]} \
	    "RF(RA(SS))" $context $env $txnenv $oargs
	assertXPathParses "11.14.4" $container {//foo[bar>=baz]} \
	    "RF(RA(SS))" $context $env $txnenv $oargs
	assertXPathParses "11.14.5" $container {//foo[bar<baz]} \
	    "RF(RA(SS))" $context $env $txnenv $oargs
	assertXPathParses "11.14.6" $container {//foo[bar<=baz]} \
	    "RF(RA(SS))" $context $env $txnenv $oargs
	assertXPathParses "11.14.7" $container {//foo[bar or baz]} \
	    "RF(RA(SS))" $context $env $txnenv $oargs
	assertXPathParses "11.14.8" $container {//foo[bar and baz]} \
	    "RF(RA(SS))" $context $env $txnenv $oargs
	assertXPathParses "11.14.9" $container {//foo[bar=1+baz]} \
	    "RF(RA(SS))" $context $env $txnenv $oargs
	assertXPathParses "11.14.10" $container {//foo[1+bar and 1+baz]} \
	    "RF(RA(SS))" $context $env $txnenv $oargs
	assertXPathParses "11.14.11" $container {//foo[1-bar and 1-baz]} \
	    "RF(RA(SS))" $context $env $txnenv $oargs
	assertXPathParses "11.14.12" $container {//foo[bar=baz and bar=baz]} \
	    "RF(RA(SS))" $context $env $txnenv $oargs
	assertXPathParses "11.14.13" $container {//foo[bar!=baz and bar!=baz]} \
	    "RF(RA(SS))" $context $env $txnenv $oargs
	assertXPathParses "11.14.14" $container {//foo[bar>baz and bar>baz]} \
	    "RF(RA(SS))" $context $env $txnenv $oargs
	assertXPathParses "11.14.15" $container {//foo[bar>=baz and bar>=baz]} \
	    "RF(RA(SS))" $context $env $txnenv $oargs
	assertXPathParses "11.14.16" $container {//foo[bar<baz and bar<baz]} \
	    "RF(RA(SS))" $context $env $txnenv $oargs
	assertXPathParses "11.14.17" $container {//foo[bar<=baz and bar<=baz]} \
	    "RF(RA(SS))" $context $env $txnenv $oargs
	assertXPathParses "11.14.18" $container {//foo[1+bar or 1+baz]} \
	    "RF(RA(SS))" $context $env $txnenv $oargs
	assertXPathParses "11.14.19" $container {//foo[1-bar or 1-baz]} \
	    "RF(RA(SS))" $context $env $txnenv $oargs
	assertXPathParses "11.14.20" $container {//foo[bar=baz or bar=baz]} \
	    "RF(RA(SS))" $context $env $txnenv $oargs
	assertXPathParses "11.14.21" $container {//foo[bar!=baz or bar!=baz]} \
	    "RF(RA(SS))" $context $env $txnenv $oargs
	assertXPathParses "11.14.22" $container {//foo[bar>baz or bar>baz]} \
	    "RF(RA(SS))" $context $env $txnenv $oargs
	assertXPathParses "11.14.23" $container {//foo[bar>=baz or bar>=baz]} \
	    "RF(RA(SS))" $context $env $txnenv $oargs
	assertXPathParses "11.14.24" $container {//foo[bar<baz or bar<baz]} \
	    "RF(RA(SS))" $context $env $txnenv $oargs
	assertXPathParses "11.14.25" $container {//foo[bar<=baz or bar<=baz]} \
	    "RF(RA(SS))" $context $env $txnenv $oargs
	assertXPathParses "11.14.26" $container {//foo[last() and last()]} \
	    "RF(RA(SS))" $context $env $txnenv $oargs
	assertXPathParses "11.14.27" $container {//foo[starts-with(bar) and starts-with(bar)]} \
	    "RF(RA(SS))" $context $env $txnenv $oargs

	$container close
	delete container
	delete context
}

proc xml011_15 { {env "NULL"} {txnenv 0} {basename $tnum} oargs } {
	puts "\txml011.15: "
	source ./include.tcl
	set txn NULL
	xml_cleanup $testdir $env

	new XmlContainer container $env "$basename.15.dbxml" 0
	if { $txnenv == 1 } { set txn [start_txn $env] }
	$container open $txn $oargs 0
	if { $txnenv == 1 } { commit_txn $txn }

	if { $txnenv == 1 } { set txn [start_txn $env] }
	$container addIndex $txn "" "foo" "node-element-equality-string"
	$container addIndex $txn "" "foo" "node-attribute-equality-string"
	if { $txnenv == 1 } { commit_txn $txn }

	new XmlQueryContext context
	$context set "dbxml:debug" "result"

	assertXPathParses "11.15.1" $container {/} \
	    "RA(SS)" $context $env $txnenv $oargs
#	assertXPathParses "11.15.2" $container {//} \
#	    "?" $context $env $txnenv $oargs
	assertXPathParses "11.15.3" $container {/*} \
	    "RA(SS)" $context $env $txnenv $oargs
	assertXPathParses "11.15.4" $container {//*} \
	    "RA(SS)" $context $env $txnenv $oargs
	assertXPathParses "11.15.5" $container {/foo} \
	    "RF(RA(RI(node-element-equality-string,prefix,foo)))" \
	    $context $env $txnenv $oargs
	assertXPathParses "11.15.6" $container {//foo} \
	    "RA(RI(node-element-equality-string,prefix,foo))" \
	    $context $env $txnenv $oargs
	assertXPathParses "11.15.7" $container {//*[foo='bar']} \
	    "RF(RA(RI(node-element-equality-string,=,foo,bar)))" \
	    $context $env $txnenv $oargs
	assertXPathParses "11.15.8" $container {//*[@foo='bar']} \
	    "RA(RI(node-attribute-equality-string,=,foo,bar))" \
	    $context $env $txnenv $oargs
	assertXPathParses "11.15.9" $container {//foo[bar and text()='bar']} \
	    "RF(RA(RI(node-element-equality-string,=,foo,bar)))" \
	    $context $env $txnenv $oargs
	assertXPathParses "11.15.10" $container {/bar} \
	    "RF(RA(SS))" $context $env $txnenv $oargs
	assertXPathParses "11.15.11" $container {//bar} \
	    "RF(RA(SS))" $context $env $txnenv $oargs
	assertXPathParses "11.15.12" $container {//*[bar='foo']} \
	    "RF(RA(SS))" $context $env $txnenv $oargs

	$container close
	delete container
	delete context
}
proc xml011_16 { {env "NULL"} {txnenv 0} {basename $tnum} oargs } {
	puts "\txml011.16: "
	source ./include.tcl
	set txn NULL
	xml_cleanup $testdir $env

	new XmlContainer container $env "$basename.16.dbxml" 0
	if { $txnenv == 1 } { set txn [start_txn $env] }
	$container open $txn $oargs 0
	if { $txnenv == 1 } { commit_txn $txn }

	new XmlDocument xd
	$xd setContent "<hello/>"
	if { $txnenv == 1 } { set txn [start_txn $env] }
	$container putDocument $txn $xd
	if { $txnenv == 1 } { commit_txn $txn }

	new XmlQueryContext context
	$context setReturnType $XmlQueryContext_ResultValues
	$context set "dbxml:debug" "result"

	assertXPathReturnsValue "11.16.1" $container {1} \
	    "1" $context $env $txnenv $oargs
	assertXPathReturnsValue "11.16.2" $container {'hello'} \
	    "hello" $context $env $txnenv $oargs
	assertXPathReturnsValue "11.16.3" $container {true()} \
	    "true" $context $env $txnenv $oargs
	assertXPathReturnsValue "11.16.4" $container {count(.)} \
	    "1" $context $env $txnenv $oargs

	$container close
	delete container
	delete context
}

proc assertXPathParses { testid container query oqp context \
	    {env "NULL"} {txnenv 0} oargs } {
	puts "\t\t$testid: Query $query"
	set txn NULL
	
	if { $txnenv == 1 } { set txn [start_txn $env] }
	if { [catch {$container queryWithXPath $txn $query $context} ret] != 0 } {
		dbxml_error_check_good $testid $ret ""
	} else {
		if { $oqp != "" } {
			dbxml_error_check_good $testid [$context get "result._oqp"] $oqp
		}
	if { $txnenv == 1 } { commit_txn $txn }
	}
}

proc assertXPathDoesNotParse { testid container query {env "NULL"} {txnenv 0} oargs } {
	puts "\t\t$testid: Query $query"

	if { $txnenv == 1 } { set txn [start_txn $env] }
	if { [catch {$container queryWithXPath $txn $query $context} ret] == 0 } {
		dbxml_error_check_good $testid $ret ""
	}
	if { $txnenv == 1 } { commit_txn $txn }
}

proc assertXPathReturnsValue { testid container query result context \
	    {env "NULL"} {txnenv 0} oargs } {
	puts "\t\t$testid: Query $query expected to return $result"
	set txn NULL
	
	if { $txnenv == 1 } { set txn [start_txn $env] }
	wrap XmlResults xr [$container queryWithXPath $txn $query $context]
	new XmlValue xv
	$xr next $xv
	if { $txnenv == 1 } { commit_txn $txn }
	dbxml_error_check_good "$testid ($xv isNull)" [$xv isNull] 0
	dbxml_error_check_good "$testid ($xv asString)" [$xv asString] $result
	delete xr
	delete xv
}
