# See the file LICENSE for redistribution information.
#
# Copyright (c) 2000-2003
#	Sleepycat Software.  All rights reserved.
#
# $Id: xml010.tcl,v 1.67 2004/01/27 00:31:06 merrells Exp $
#
# TEST	xml010
# TEST	XML Indexer

proc xml010 { args } {
	puts "\nxml010: Container Indexing ($args)"
	source ./include.tcl

	# Determine whether procedure has been called within an environment, 
	# and whether it is a transactional environment.
	# If we are using an env, then the filename should just be the test 
	# number.  Otherwise it is the test directory and the test number.
	set eindex [lsearch -exact $args "-env"]
	set txnenv 0
	set tnum 10	
	set oargs [eval {set_openargs} $args]

	if { $eindex == -1 } {
		set env NULL
		set basename $testdir/$tnum
	} else {
		incr eindex
		set env [lindex $args $eindex]
		set txnenv [is_txnenv $env]
		set testdir [get_home $env]
		set basename $tnum
	}

	xml010_1 $env $txnenv $basename $oargs
	xml010_2 $env $txnenv $basename $oargs
	xml010_3 "10" 0 $env $txnenv $basename $oargs
	xml010_4 $env $txnenv $basename $oargs
	xml010_5 $env $txnenv $basename $oargs
}

proc xml010_1 { {env "NULL"} {txnenv 0} {basename $tnum} oargs } {
	puts "\txml010.1: Indexing tests"
	xml010_1_1 $env $txnenv $basename $oargs
	xml010_1_2 $env $txnenv $basename $oargs
	xml010_1_3 $env $txnenv $basename $oargs
	xml010_1_4 $env $txnenv $basename $oargs
	xml010_1_5 $env $txnenv $basename $oargs
	xml010_1_6 $env $txnenv $basename $oargs
	xml010_1_7 $env $txnenv $basename $oargs
	xml010_1_8 $env $txnenv $basename $oargs
	xml010_1_9 $env $txnenv $basename $oargs
	xml010_1_10 $env $txnenv $basename $oargs
	xml010_1_11 $env $txnenv $basename $oargs
	xml010_1_12 $env $txnenv $basename $oargs
	xml010_1_13 $env $txnenv $basename $oargs
	xml010_1_14 $env $txnenv $basename $oargs
	xml010_1_15 $env $txnenv $basename $oargs
	xml010_1_16 $env $txnenv $basename $oargs
}

proc xml010_1_1 {{env "NULL"} {txnenv 0} {basename $tnum} oargs } {
	puts "\t\txml010.1.1: getIndexSpecifiction on a closed container (should fail)."
	source ./include.tcl
	set txn NULL
	xml_cleanup $testdir $env

	new XmlContainer container $env "$basename.1.1.dbxml" 0

	if { $txnenv == 1 } { set txn [start_txn $env] }
	catch {
		$container getIndexSpecification txn
	} ret
	if { $txnenv == 1 } { commit_txn $txn }

	dbxml_error_check_good "10.1.1" $ret\
	    "Error: getIndexSpecification() not allowed on closed XmlContainer"
	delete container
}

proc xml010_1_2 { {env "NULL"} {txnenv 0} {basename $tnum} oargs } {
	puts "\t\txml010.1.2: getIndexSpecifiction on an open container."

	source ./include.tcl
	set txn NULL
	xml_cleanup $testdir $env

	new XmlContainer container $env "$basename.1.2.dbxml" 0

	if { $txnenv == 1 } { set txn [start_txn $env] }
	$container open $txn $oargs 0
	if { $txnenv == 1 } { commit_txn $txn }

	catch {
		if { $txnenv == 1 } { set txn [start_txn $env] }
		$container getIndexSpecification txn
		if { $txnenv == 1 } { commit_txn $txn }
	} ret

	$container close
	dbxml_error_check_good "10.1.2" $ret ""
	delete container
}

proc xml010_1_3 {{env "NULL"} {txnenv 0} {basename $tnum} oargs } {
	puts "\t\txml010.1.3: setIndexSpecification on a closed container (should fail)."
	source ./include.tcl
	set txn NULL
	xml_cleanup $testdir $env

	new XmlContainer container $env "$basename.1.3.dbxml" 0

	if { $txnenv == 1 } { set txn [start_txn $env] }
	$container open $txn $oargs 0
	wrap XmlIndexSpecification xis [$container getIndexSpecification $txn]
	if { $txnenv == 1 } { commit_txn $txn }
	$container close

	if { $txnenv == 1 } { set txn [start_txn $env] }
	catch {
		$container setIndexSpecification $txn $xis
	} ret
	if { $txnenv == 1 } { commit_txn $txn }
	delete xis

	dbxml_error_check_good "10.1.3" $ret\
	    "Error: setIndexSpecification() not allowed on closed XmlContainer"
	delete container
}

proc xml010_1_4 { {env "NULL"} {txnenv 0} {basename $tnum} oargs } {
	puts "\t\txml010.1.4: setIndexSpecification on an open container."

	source ./include.tcl
	set txn NULL
	xml_cleanup $testdir $env

	new XmlContainer container $env "$basename.1.4.dbxml" 0

	if { $txnenv == 1 } { set txn [start_txn $env] }
	$container open $txn $oargs 0
	if { $txnenv == 1 } { commit_txn $txn }

	catch {
		if { $txnenv == 1 } { set txn [start_txn $env] }
		wrap XmlIndexSpecification xis [$container getIndexSpecification $txn]
		$xis addIndex "" "foo" "node-element-presence-none"
		$container setIndexSpecification $txn $xis
		delete xis
		if { $txnenv == 1 } { commit_txn $txn }
	} ret

	$container close
	dbxml_error_check_good "10.1.4" $ret ""
	delete container
}

proc xml010_1_5 { {env "NULL"} {txnenv 0} {basename $tnum} oargs } {
	puts "\t\txml010.1.5: setIndexSpecification on non-empty container."
	source ./include.tcl
	set txn NULL
	xml_cleanup $testdir $env

	new XmlContainer container $env "$basename.1.5.dbxml" 0
	if { $txnenv == 1 } { set txn [start_txn $env] }
	$container open $txn $oargs 0
	putFileInContainer $container \
	    "$test_path/document_set_10_2/document_10_2_match.xml" $txn
	if { $txnenv == 1 } { commit_txn $txn }

	if { $txnenv == 1 } { set txn [start_txn $env] }
	catch {
		$container addIndex $txn "" "foo" "node-element-presence-none"
	} ret
	if { $txnenv == 1 } { commit_txn $txn }

	$container close
	dbxml_error_check_good "10.1.5" $ret ""
	delete container
}

proc xml010_1_6 { {env "NULL"} {txnenv 0} {basename $tnum} oargs } {
	puts "\t\txml010.1.6: Index specification persists after close."
	source ./include.tcl
	set txn NULL
	xml_cleanup $testdir $env

	new XmlContainer container $env "$basename.1.6.dbxml" 0
	if { $txnenv == 1 } { set txn [start_txn $env] }
	$container open $txn $oargs 0
	if { $txnenv == 1 } { commit_txn $txn }

	set uri www.uri.com
	set name foo
	set index node-element-presence-none
	catch {
		if { $txnenv == 1 } { set txn [start_txn $env] }
		$container addIndex $txn $uri $name $index
		if { $txnenv == 1 } { commit_txn $txn }
	} ret
	$container close
	dbxml_error_check_good "10.1.6" $ret ""

	if { $txnenv == 1 } { set txn [start_txn $env] }
	$container open $txn $oargs 0
	if { $txnenv == 1 } { commit_txn $txn }

	# Test that index spec was persisted.
	wrap XmlIndexSpecification xis [$container getIndexSpecification NULL]
	set idecl [$xis find $uri $name]
	delete xis
	dbxml_error_check_bad foundindex $idecl NULL

	wrap XmlIndexDeclaration xid $idecl
	set retindex [$xid get_index]
	delete xid
	dbxml_error_check_good index $index $retindex

	$container close
	delete container
}

proc xml010_1_7 { {env "NULL"} {txnenv 0} {basename $tnum} oargs } {
	puts "\t\txml010.1.7: Index specification persists after destroy."
	source ./include.tcl
	set txn NULL
	xml_cleanup $testdir $env

	new XmlContainer container1 $env "$basename.1.7.dbxml" 0
	if { $txnenv == 1 } { set txn [start_txn $env] }
	$container1 open $txn $oargs 0
	if { $txnenv == 1 } { commit_txn $txn }

	set uri www.uri.com
	set name foo
	set index node-element-presence-none
	catch {
		if { $txnenv == 1 } { set txn [start_txn $env] }
		$container1 addIndex $txn $uri $name $index
		if { $txnenv == 1 } { commit_txn $txn }
	} ret

	$container1 close
	dbxml_error_check_good "10.1.7" $ret ""
	delete container1

	new XmlContainer container2 $env "$basename.1.7.dbxml" 0
	if { $txnenv == 1 } { set txn [start_txn $env] }
	$container2 open $txn $oargs 0
	if { $txnenv == 1 } { commit_txn $txn }

	# Test that index spec was persisted.
	wrap XmlIndexSpecification xis [$container2 getIndexSpecification NULL]
	set idecl [$xis find $uri $name]
	delete xis
	dbxml_error_check_bad foundindex $idecl NULL

	wrap XmlIndexDeclaration xid $idecl
	set retindex [$xid get_index]
	delete xid
	dbxml_error_check_good index $index $retindex

	$container2 close
	delete container2
}

proc xml010_1_8 { {env "NULL"} {txnenv 0} {basename $tnum} oargs } {
	puts "\t\txml010.1.8: XmlIndexSpecification::deleteIndex on non-empty container."
	source ./include.tcl
	set txn NULL
	xml_cleanup $testdir $env

	new XmlContainer container $env "$basename.1.8.dbxml" 0
	if { $txnenv == 1 } { set txn [start_txn $env] }
	$container open $txn $oargs 0
	putFileInContainer $container \
	    "$test_path/document_set_10_2/document_10_2_match.xml" $txn
	if { $txnenv == 1 } { commit_txn $txn }

	if { $txnenv == 1 } { set txn [start_txn $env] }
	catch {
		wrap XmlIndexSpecification xis [$container getIndexSpecification $txn]
		$xis addIndex "" "person" "node-element-presence-none"
		$xis addIndex "" "person" "node-element-equality-string"
		$xis addIndex "" "name" "node-element-presence-none"
		$container setIndexSpecification $txn $xis
		delete xis
		wrap XmlIndexSpecification xis [$container getIndexSpecification $txn]
		$xis deleteIndex "" "person" "node-element-equality-string"
		$xis deleteIndex "" "name" "node-element-presence-none"
		$container setIndexSpecification $txn $xis
		delete xis
	} ret
	if { $txnenv == 1 } { commit_txn $txn }

	# Test that index spec was persisted.
	wrap XmlIndexSpecification xis [$container getIndexSpecification NULL]
	dbxml_error_check_good findindex [$xis find "" "name"] NULL
	wrap XmlIndexDeclaration xid [$xis find "" "person"]
	dbxml_error_check_good index [$xid get_index] "node-element-presence-none" 
	delete xid
	delete xis

	$container close
	dbxml_error_check_good "10.1.8" $ret ""
	delete container
}

proc xml010_1_9 { {env "NULL"} {txnenv 0} {basename $tnum} oargs } {
	puts "\t\txml010.1.9: XmlIndexSpecification::replaceIndex on non-empty container."
	source ./include.tcl
	set txn NULL
	xml_cleanup $testdir $env

	new XmlContainer container $env "$basename.1.9.dbxml" 0
	if { $txnenv == 1 } { set txn [start_txn $env] }
	$container open $txn $oargs 0
	putFileInContainer $container \
	    "$test_path/document_set_10_2/document_10_2_match.xml" $txn
	if { $txnenv == 1 } { commit_txn $txn }

	if { $txnenv == 1 } { set txn [start_txn $env] }
	catch {
		wrap XmlIndexSpecification xis [$container getIndexSpecification $txn]
		$xis addIndex "" "person" "node-element-presence-none"
		$xis addIndex "" "person" "node-element-equality-string"
		$container setIndexSpecification $txn $xis
		delete xis
		wrap XmlIndexSpecification xis [$container getIndexSpecification $txn]
		$xis replaceIndex "" "person" "edge-element-presence-none edge-element-equality-string"
		$container setIndexSpecification $txn $xis
		delete xis
	} ret
	if { $txnenv == 1 } { commit_txn $txn }

	# Test that index spec was persisted.
	wrap XmlIndexSpecification xis [$container getIndexSpecification NULL]
	wrap XmlIndexDeclaration xid [$xis find "" "person"]
	dbxml_error_check_good index [$xid get_index] "edge-element-presence-none edge-element-equality-string" 
	delete xid
	delete xis

	$container close
	dbxml_error_check_good "10.1.9" $ret ""
	delete container
}

proc xml010_1_10 { {env "NULL"} {txnenv 0} {basename $tnum} oargs } {
	puts "\t\txml010.1.10: addIndex on an open container."

	source ./include.tcl
	set txn NULL
	xml_cleanup $testdir $env

	new XmlContainer container $env "$basename.1.10.dbxml" 0

	if { $txnenv == 1 } { set txn [start_txn $env] }
	$container open $txn $oargs 0
	if { $txnenv == 1 } { commit_txn $txn }

	catch {
		if { $txnenv == 1 } { set txn [start_txn $env] }
		$container addIndex $txn "" "foo" "node-element-presence-none"
		if { $txnenv == 1 } { commit_txn $txn }
	} ret

	$container close
	dbxml_error_check_good "10.1.10" $ret ""
	delete container
}

proc xml010_1_11 { {env "NULL"} {txnenv 0} {basename $tnum} oargs } {
	puts "\t\txml010.1.11: deleteIndex on an open container."

	source ./include.tcl
	set txn NULL
	xml_cleanup $testdir $env

	new XmlContainer container $env "$basename.1.11.dbxml" 0

	if { $txnenv == 1 } { set txn [start_txn $env] }
	$container open $txn $oargs 0
	if { $txnenv == 1 } { commit_txn $txn }

	catch {
		if { $txnenv == 1 } { set txn [start_txn $env] }
		$container deleteIndex $txn "" "foo" "node-element-presence-none"
		if { $txnenv == 1 } { commit_txn $txn }
	} ret

	$container close
	dbxml_error_check_good "10.1.11" $ret ""
	delete container
}

proc xml010_1_12 { {env "NULL"} {txnenv 0} {basename $tnum} oargs } {
	puts "\t\txml010.1.12: replaceIndex on an open container."

	source ./include.tcl
	set txn NULL
	xml_cleanup $testdir $env

	new XmlContainer container $env "$basename.1.12.dbxml" 0

	if { $txnenv == 1 } { set txn [start_txn $env] }
	$container open $txn $oargs 0
	if { $txnenv == 1 } { commit_txn $txn }

	catch {
		if { $txnenv == 1 } { set txn [start_txn $env] }
		$container replaceIndex $txn "" "foo" "node-element-presence-none"
		if { $txnenv == 1 } { commit_txn $txn }
	} ret

	$container close
	dbxml_error_check_good "10.1.12" $ret ""
	delete container
}

proc xml010_1_13 { {env "NULL"} {txnenv 0} {basename $tnum} oargs } {
	puts "\t\txml010.1.13: addIndex and reindex"
	source ./include.tcl
	set txn NULL
	xml_cleanup $testdir $env

	new XmlContainer container $env "$basename.1.13.dbxml" 0
	if { $txnenv == 1 } { set txn [start_txn $env] }
	$container open $txn $oargs 0
	putFileInContainer $container \
	    "$test_path/document_set_10_2/document_10_2_match.xml" $txn
	if { $txnenv == 1 } { commit_txn $txn }

	if { $txnenv == 1 } { set txn [start_txn $env] }
	catch {
		wrap XmlIndexSpecification xis [$container getIndexSpecification $txn]
		$xis addIndex "" "person" "node-element-equality-string"
		$container setIndexSpecification $txn $xis
		delete xis
		set statistics [getDocumentContent $container $txn 0]
		dbxml_error_check_good "10.1.13" [string match "*person' indexed='1'*" $statistics] 1
	} ret
	if { $txnenv == 1 } { commit_txn $txn }

	$container close
	dbxml_error_check_good "10.1.13" $ret ""
	delete container
}

proc xml010_1_14 { {env "NULL"} {txnenv 0} {basename $tnum} oargs } {
	puts "\t\txml010.1.14: deleteIndex and reindex"
	source ./include.tcl
	set txn NULL
	xml_cleanup $testdir $env

	new XmlContainer container $env "$basename.1.14.dbxml" 0
	if { $txnenv == 1 } { set txn [start_txn $env] }
	$container open $txn $oargs 0
	putFileInContainer $container \
	    "$test_path/document_set_10_2/document_10_2_match.xml" $txn
	if { $txnenv == 1 } { commit_txn $txn }

	if { $txnenv == 1 } { set txn [start_txn $env] }
	catch {
		wrap XmlIndexSpecification xis [$container getIndexSpecification $txn]
		$xis addIndex "" "person" "node-element-equality-string"
		$container setIndexSpecification $txn $xis
		set statistics [getDocumentContent $container $txn 0]
		dbxml_error_check_good "10.1.14" [string match "*person' indexed='1'*" $statistics] 1
		$xis deleteIndex "" "person" "node-element-equality-string"
		$container setIndexSpecification $txn $xis
		delete xis
		set statistics [getDocumentContent $container $txn 0]
		dbxml_error_check_good "10.1.14" [string match "*person' indexed='0'*" $statistics] 1
	} ret
	if { $txnenv == 1 } { commit_txn $txn }

	$container close
	dbxml_error_check_good "10.1.14" $ret ""
	delete container
}

proc xml010_1_15 { {env "NULL"} {txnenv 0} {basename $tnum} oargs } {
	puts "\t\txml010.1.15: reindexing"
	source ./include.tcl
	set txn NULL
	xml_cleanup $testdir $env

	new XmlContainer container $env "$basename.1.15.dbxml" 0
	if { $txnenv == 1 } { set txn [start_txn $env] }
	$container open $txn $oargs 0
	putFileInContainer $container \
	    "$test_path/document_set_10_2/document_10_2_match.xml" $txn
	if { $txnenv == 1 } { commit_txn $txn }

	if { $txnenv == 1 } { set txn [start_txn $env] }
	catch {
		wrap XmlIndexSpecification xis [$container getIndexSpecification $txn]
		$xis addIndex "" "name" "node-element-presence-none"
		$xis addIndex "" "person" "node-element-equality-string"
		$container setIndexSpecification $txn $xis
		delete xis
		set statistics [getDocumentContent $container $txn 0]
		dbxml_error_check_good "10.1.15" [string match "*person' indexed='1'*" $statistics] 1
		dbxml_error_check_good "10.1.15" [string match "*name' indexed='1'*" $statistics] 1
		wrap XmlIndexSpecification xis [$container getIndexSpecification $txn]
		$xis deleteIndex "" "person" "node-element-equality-string"
		$xis addIndex "" "age" "node-attribute-equality-string"
		$container setIndexSpecification $txn $xis
		delete xis
		set statistics [getDocumentContent $container $txn 0]
		dbxml_error_check_good "10.1.15" [string match "*person' indexed='0'*" $statistics] 1
		dbxml_error_check_good "10.1.15" [string match "*name' indexed='1'*" $statistics] 1
		dbxml_error_check_good "10.1.15" [string match "*age' indexed='1'*" $statistics] 1
	} ret
	if { $txnenv == 1 } { commit_txn $txn }

	$container close
	dbxml_error_check_good "10.1.15" $ret ""
	delete container
}

proc xml010_1_16 { {env "NULL"} {txnenv 0} {basename $tnum} oargs } {
	puts "\t\txml010.1.16: regression - index multiple attributes of element"
	source ./include.tcl
	set txn NULL
	xml_cleanup $testdir $env
	new XmlContainer container $env "$basename.1.16.dbxml" 0
	if { $txnenv == 1 } { set txn [start_txn $env] }
	$container open $txn $oargs 0
	putFileInContainer $container \
	    "$test_path/document_set_10_2/document_10_2_match.xml" $txn
	if { $txnenv == 1 } { commit_txn $txn }

	if { $txnenv == 1 } { set txn [start_txn $env] }
	catch {
		wrap XmlIndexSpecification xis [$container getIndexSpecification $txn]
		$xis addIndex "" "age" "node-attribute-equality-string"
		$xis addIndex "" "drink" "node-attribute-equality-string"
		$container setIndexSpecification $txn $xis
		delete xis
		set statistics [getDocumentContent $container $txn 0]
		dbxml_error_check_good "10.1.16" [string match "*age' indexed='1'*" $statistics] 1
		dbxml_error_check_good "10.1.16" [string match "*drink' indexed='1'*" $statistics] 1
		new XmlQueryContext context
		wrap XmlResults xr [$container queryWithXPath $txn "/person" $context]
		dbxml_error_check_good "size_of_result_set" [$xr size] 1
		delete xr
		delete context
	} ret
	if { $txnenv == 1 } { commit_txn $txn }

	$container close
	dbxml_error_check_good "10.1.16 - exception thrown" $ret ""
	delete container
}

proc xml010_2 { {env "NULL"} {txnenv 0} {basename $tnum} oargs } {
	puts "\txml010.2: Test indexing with query processor."
	xml010_2_and_xml012_4 "10" 0 $env $txnenv $basename $oargs
}

proc xml010_2_and_xml012_4 { testid delete {env "NULL"} {txnenv 0} {basename $tnum} oargs } {
	source ./include.tcl
	set txn NULL
	xml_cleanup $testdir $env

	# The test number.
	# The test type. 
	# The documents to add to the container.
	# The node URI to be indexed.
	# The node name to be indexed.
	# The index to be declared for the node name.
	# The query to perform.
	# The expected optimized query plan.
	# The expected query plan operation execution order.
	# Should we add a document (10_2), or add and delete (12_4) a document.
	# The index keys that we expect statistics for.
	# The statistics number for the indexed keys. 

	set documents {
		document_set_10_2/document_10_2_match.xml
		document_set_10_2/document_10_2_not_match_1.xml
		document_set_10_2/document_10_2_not_match_2.xml
	}

 	assertIndexUsed \
		"$basename.2.1.1" \
		"equality" \
		$documents \
		"" "person" "node-element-presence" \
		"/person" \
		"RF(RA(RI(node-element-presence-none,=,person)))" \
		"RI(node-element-presence-none,=,person),RA,RF," \
		$delete \
		{person} 1 \
		$env $txnenv $basename $oargs

 	assertIndexUsed \
		"$basename.2.1.2" \
		"equality" \
		$documents \
		"" "name" "node-element-presence" \
		{//*[name='Bloggs']} \
		"RF(RA(RI(node-element-presence-none,=,name)))" \
		"RI(node-element-presence-none,=,name),RA,RF," \
		$delete \
		{name} 1 \
		$env $txnenv $basename $oargs

	assertIndexUsed \
		"$basename.2.2.1" \
		"equality" \
		$documents \
		"" "age" "node-attribute-presence" \
		{/person[@age]} \
		"RF(RA(RI(node-attribute-presence-none,=,age)))" \
		"RI(node-attribute-presence-none,=,age),RA,RF," \
		$delete \
		{age} 1 \
		$env $txnenv $basename $oargs

	assertIndexUsed \
		"$basename.2.2.2" \
		"equality" \
		$documents \
		"" "age" "node-attribute-presence" \
		{/person[@age=33]} \
		"RF(RA(RI(node-attribute-presence-none,=,age)))" \
		"RI(node-attribute-presence-none,=,age),RA,RF," \
		$delete \
		{age} 1 \
		$env $txnenv $basename $oargs

	assertIndexUsed \
		"$basename.2.3" \
		"equality" \
		$documents \
		"" "name" "node-element-equality-string" \
		{/person[name='Bloggs']} \
		"RF(RA(RI(node-element-equality-string,=,name,Bloggs)))" \
		"RI(node-element-equality-string,=,name,Bloggs),RA,RF," \
		$delete \
		{name} 1 \
		$env $txnenv $basename $oargs

	assertIndexUsed \
		"$basename.2.3.1" \
		"equality" \
		$documents \
		"" "fruit" "node-element-equality-string" \
		{/person[lunch/fruit='apple']} \
		"RF(RA(RI(node-element-equality-string,=,fruit,apple)))" \
		"RI(node-element-equality-string,=,fruit,apple),RA,RF," \
		$delete \
		{fruit} 1 \
		$env $txnenv $basename $oargs

	assertIndexUsed \
		"$basename.2.4" \
		"prefix" \
		$documents \
		"" "name" "node-element-equality-string" \
		{/person[starts-with(name,'Blog')]} \
		"RF(RA(RI(node-element-equality-string,prefix,name,Blog)))" \
		"RI(node-element-equality-string,prefix,name,Blog),RA,RF," \
		$delete \
		{name} 1 \
		$env $txnenv $basename $oargs

	assertIndexUsed \
		"$basename.2.5" \
		"equality" \
		$documents \
		"" "balance" "node-element-equality-number" \
		{/person[balance=123]} \
		"RF(RA(RI(node-element-equality-number,=,balance,123)))" \
		"RI(node-element-equality-number,=,balance,123),RA,RF," \
		$delete \
		{balance} 1 \
		$env $txnenv $basename $oargs

	assertIndexUsed \
		"$basename.2.6.1" \
		"less than" \
		$documents \
		"" "balance" "node-element-equality-number" \
		{/person[balance<124]} \
		"RF(RA(RI(node-element-equality-number,<,balance,124)))" \
		"RI(node-element-equality-number,<,balance,124),RA,RF," \
		$delete \
		{balance} 1 \
		$env $txnenv $basename $oargs

	assertIndexUsed \
		"$basename.2.6.2" \
		"greater than" \
		$documents \
		"" "balance" "node-element-equality-number" \
		{/person[balance>122]} \
		"RF(RA(RI(node-element-equality-number,>,balance,122)))" \
		"RI(node-element-equality-number,>,balance,122),RA,RF," \
		$delete \
		{balance} 1 \
		$env $txnenv $basename $oargs

	assertIndexUsed \
		"$basename.2.6.3" \
		"<=" \
		$documents \
		"" "balance" "node-element-equality-number" \
		{/person[balance<=123]} \
		"RF(RA(RI(node-element-equality-number,<=,balance,123)))" \
		"RI(node-element-equality-number,<=,balance,123),RA,RF," \
		$delete \
		{balance} 1 \
		$env $txnenv $basename $oargs

	assertIndexUsed \
		"$basename.2.6.4" \
		">=" \
		$documents \
		"" "balance" "node-element-equality-number" \
		{/person[balance>=123]} \
		"RF(RA(RI(node-element-equality-number,>=,balance,123)))" \
		"RI(node-element-equality-number,>=,balance,123),RA,RF," \
		$delete \
		{balance} 1 \
		$env $txnenv $basename $oargs

	assertIndexUsed \
		"$basename.2.6.5" \
		"range (with and)" \
		$documents \
		"" "balance" "node-element-equality-number" \
		{/person[balance>122 and balance<124]} \
		"RF(RA(RI(node-element-equality-number,range,balance,122,124)))" \
		"RI(node-element-equality-number,range,balance,122,124),RA,RF," \
		$delete \
		{balance} 1 \
		$env $txnenv $basename $oargs

	assertIndexUsed \
		"$basename.2.6.6" \
		"range" \
		$documents \
		"" "balance" "node-element-equality-number" \
		{/person[balance>122][balance<124]} \
		"RF(RA(RI(node-element-equality-number,range,balance,122,124)))" \
		"RI(node-element-equality-number,range,balance,122,124),RA,RF," \
		$delete \
		{balance} 1 \
		$env $txnenv $basename $oargs

	assertIndexUsed \
		"$basename.2.7" \
		"prefix" \
		$documents \
		"" "balance" "node-element-equality-number" \
		{/person/balance} \
		"RF(RA(RI(node-element-equality-number,prefix,balance)))" \
		"RI(node-element-equality-number,prefix,balance),RA,RF," \
		$delete \
		{balance} 1 \
		$env $txnenv $basename $oargs

	assertIndexUsed \
		"$basename.2.8.1" \
		"equality" \
		$documents \
		"" "name" "node-element-substring-string" \
		{/person[contains(name,'Blo')]} \
		"RF(RA(RI(node-element-substring-string,=,name,blo)))" \
		"RI(node-element-substring-string,=,name,blo),RA,RF," \
		$delete \
		{blo log ogg ggs} 1 \
		$env $txnenv $basename $oargs

	assertIndexUsed \
		"$basename.2.8.2" \
		"equality" \
		$documents \
		"" "name" "node-element-substring-string" \
		{/person[contains(name,'log')]} \
		"RF(RA(RI(node-element-substring-string,=,name,log)))" \
		"RI(node-element-substring-string,=,name,log),RA,RF," \
		$delete \
		{blo log ogg ggs} 1 \
		$env $txnenv $basename $oargs

	assertIndexUsed \
		"$basename.2.8.3" \
		"equality" \
		$documents \
		"" "name" "node-element-substring-string" \
		{/person[contains(name,'ggs')]} \
		"RF(RA(RI(node-element-substring-string,=,name,ggs)))" \
		"RI(node-element-substring-string,=,name,ggs),RA,RF," \
		$delete \
		{blo log ogg ggs} 1 \
		$env $txnenv $basename $oargs

	assertIndexUsed \
		"$basename.2.8.4" \
		"equality" \
		$documents \
		"" 	"name" "node-element-substring-string" \
		{//person[contains(name,'Blog')]} \
		"RF(RA(n(RI(node-element-substring-string,=,name,blo),RI(node-element-substring-string,=,name,log))))" \
		"RI(node-element-substring-string,=,name,blo),RI(node-element-substring-string,=,name,log),n,RA,RF," \
		0 \
		{blo log ogg ggs} 1 \
		$env $txnenv $basename $oargs

	assertIndexUsed \
		"$basename.2.8.5" \
		"equality" \
		$documents \
		"" "name" "node-element-substring-string" \
		{/person[substring-before(name,'ggs')]} \
		"RF(RA(RI(node-element-substring-string,=,name,ggs)))" \
		"RI(node-element-substring-string,=,name,ggs),RA,RF," \
		$delete \
		{blo log ogg ggs} 1 \
		$env $txnenv $basename $oargs

	assertIndexUsed \
		"$basename.2.8.6" \
		"equality" \
		$documents \
		"" "name" "node-element-substring-string" \
		{/person[substring-after(name,'Blo')]} \
		"RF(RA(RI(node-element-substring-string,=,name,blo)))" \
		"RI(node-element-substring-string,=,name,blo),RA,RF," \
		$delete \
		{blo log ogg ggs} 1 \
		$env $txnenv $basename $oargs

	assertIndexUsed \
		"$basename.2.8.7" \
		"equality" \
		$documents \
		"" "name" "node-element-substring-string" \
		{/person[starts-with(name,'Blo')]} \
		"RF(RA(RI(node-element-substring-string,=,name,blo)))" \
		"RI(node-element-substring-string,=,name,blo),RA,RF," \
		$delete \
		{blo log ogg ggs} 1 \
		$env $txnenv $basename $oargs

	assertIndexUsed \
		"$basename.2.8.8" \
		"equality" \
		$documents \
		"" 	"name" "node-element-substring-string" \
		{//person[contains(name,'Blogg')]} \
		"RF(RA(n(RI(node-element-substring-string,=,name,blo),n(RI(node-element-substring-string,=,name,log),RI(node-element-substring-string,=,name,ogg)))))" \
		"RI(node-element-substring-string,=,name,blo),RI(node-element-substring-string,=,name,log),RI(node-element-substring-string,=,name,ogg),n,n,RA,RF," \
		0 \
		{blo log ogg ggs} 1 \
		$env $txnenv $basename $oargs

	assertIndexUsed \
		"$basename.2.8.9" \
		"equality" \
		$documents \
		"" "name" "node-element-substring-string" \
		{/person[contains(name,'Blo')]} \
		"RF(RA(RI(node-element-substring-string,=,name,blo)))" \
		"RI(node-element-substring-string,=,name,blo),RA,RF," \
		$delete \
		{blo log ogg ggs} 1 \
		$env $txnenv $basename $oargs

	assertIndexUsed \
		"$basename.2.9" \
		"equality" \
		$documents \
		"" "first" "node-attribute-equality-string" \
		{/person/name[@first='fred']} \
		"RF(RA(RI(node-attribute-equality-string,=,first,fred)))" \
		"RI(node-attribute-equality-string,=,first,fred),RA,RF," \
		$delete \
		{first} 1 \
		$env $txnenv $basename $oargs

	assertIndexUsed \
		"$basename.2.10" \
		"prefix" \
		$documents \
		"" "first" "node-attribute-equality-string" \
		{/person/name/@first} \
		"RF(RA(RI(node-attribute-equality-string,prefix,first)))" \
		"RI(node-attribute-equality-string,prefix,first),RA,RF," \
		$delete \
		{first} 1 \
		$env $txnenv $basename $oargs

	assertIndexUsed \
		"$basename.2.11" \
		"equality" \
		$documents \
		"" "age" "node-attribute-equality-number" \
		{/person[@age=33]} \
		"RF(RA(RI(node-attribute-equality-number,=,age,33)))" \
		"RI(node-attribute-equality-number,=,age,33),RA,RF," \
		$delete \
		{age} 1 \
		$env $txnenv $basename $oargs

	assertIndexUsed \
		"$basename.2.12.1" \
		"less than" \
		$documents \
		"" "age" "node-attribute-equality-number" \
		{/person[@age<34]} \
		"RF(RA(RI(node-attribute-equality-number,<,age,34)))" \
		"RI(node-attribute-equality-number,<,age,34),RA,RF," \
		$delete \
		{age} 1 \
		$env $txnenv $basename $oargs

	assertIndexUsed \
		"$basename.2.12.2" \
		"greater than" \
		$documents \
		"" "age" "node-attribute-equality-number" \
		{/person[@age>32]} \
		"RF(RA(RI(node-attribute-equality-number,>,age,32)))" \
		"RI(node-attribute-equality-number,>,age,32),RA,RF," \
		$delete \
		{age} 1 \
		$env $txnenv $basename $oargs

	assertIndexUsed \
		"$basename.2.12.3" \
		"<=" \
		$documents \
		"" "age" "node-attribute-equality-number" \
		{/person[@age<=33]} \
		"RF(RA(RI(node-attribute-equality-number,<=,age,33)))" \
		"RI(node-attribute-equality-number,<=,age,33),RA,RF," \
		$delete \
		{age} 1 \
		$env $txnenv $basename $oargs

	assertIndexUsed \
		"$basename.2.12.4" \
		">=" \
		$documents \
		"" "age" "node-attribute-equality-number" \
		{/person[@age>=33]} \
		"RF(RA(RI(node-attribute-equality-number,>=,age,33)))" \
		"RI(node-attribute-equality-number,>=,age,33),RA,RF," \
		$delete \
		{age} 1 \
		$env $txnenv $basename $oargs

	assertIndexUsed \
		"$basename.2.12.5" \
		"range (with and)" \
		$documents \
		"" "age" "node-attribute-equality-number" \
		{/person[@age>32 and @age<34]} \
		"RF(RA(RI(node-attribute-equality-number,range,age,32,34)))" \
		"RI(node-attribute-equality-number,range,age,32,34),RA,RF," \
		$delete \
		{age} 1 \
		$env $txnenv $basename $oargs

	assertIndexUsed \
		"$basename.2.12.6" \
		"range" \
		$documents \
		"" "age" "node-attribute-equality-number" \
		{/person[@age>32][@age<34]} \
		"RF(RA(RI(node-attribute-equality-number,range,age,32,34)))" \
		"RI(node-attribute-equality-number,range,age,32,34),RA,RF," \
		$delete \
		{age} 1 \
		$env $txnenv $basename $oargs

	assertIndexUsed \
		"$basename.2.13" \
		"prefix" \
		$documents \
		"" "age" "node-attribute-equality-number" \
		{/person/@age} \
		"RF(RA(RI(node-attribute-equality-number,prefix,age)))" \
		"RI(node-attribute-equality-number,prefix,age),RA,RF," \
		$delete \
		{age} 1 \
		$env $txnenv $basename $oargs

	assertIndexUsed \
		"$basename.2.14.1" \
		"equality" \
		$documents \
		"" "first" "node-attribute-substring-string" \
		{/*/*[contains(@first,'fre')]} \
		"RF(RA(RI(node-attribute-substring-string,=,first,fre)))" \
		"RI(node-attribute-substring-string,=,first,fre),RA,RF," \
		$delete \
		{fre red} 1 \
		$env $txnenv $basename $oargs

	assertIndexUsed \
		"$basename.2.14.2" \
		"equality" \
		$documents \
		"" "first" "node-attribute-substring-string" \
		{/*/*[contains(@first,'red')]} \
		"RF(RA(RI(node-attribute-substring-string,=,first,red)))" \
		"RI(node-attribute-substring-string,=,first,red),RA,RF," \
		$delete \
		{fre red} 1 \
		$env $txnenv $basename $oargs

	assertIndexUsed \
		"$basename.2.15" \
		"equality" \
		$documents \
		"" "name" "edge-element-presence" \
		{/person/name} \
		"RF(RA(RI(edge-element-presence-none,=,person.name)))" \
		"RI(edge-element-presence-none,=,person.name),RA,RF," \
		$delete \
		{person.name} 1 \
		$env $txnenv $basename $oargs

	assertIndexUsed \
		"$basename.2.16" \
		"equality" \
		$documents \
		"" "age" "edge-attribute-presence" \
		{/person/@age} \
		"RF(RA(RI(edge-attribute-presence-none,=,person.age)))" \
		"RI(edge-attribute-presence-none,=,person.age),RA,RF," \
		$delete \
		{person.age} 1 \
		$env $txnenv $basename $oargs

	assertIndexUsed \
		"$basename.2.17" \
		"equality" \
		$documents \
		"" "name" "edge-element-equality-string" \
		{/person[name='Bloggs']} \
		"RF(RA(RI(edge-element-equality-string,=,person.name,Bloggs)))" \
		"RI(edge-element-equality-string,=,person.name,Bloggs),RA,RF," \
		$delete \
		{person.name} 1 \
		$env $txnenv $basename $oargs

	assertIndexUsed \
		"$basename.2.17.1" \
		"equality" \
		$documents \
		"" "fruit" "edge-element-equality-string" \
		{/person[lunch/fruit='apple']} \
		"RF(RA(RI(edge-element-equality-string,=,lunch.fruit,apple)))" \
		"RI(edge-element-equality-string,=,lunch.fruit,apple),RA,RF," \
		$delete \
		{lunch.fruit} 1 \
		$env $txnenv $basename $oargs

	assertIndexUsed \
		"$basename.2.18" \
		"prefix" \
		$documents \
		"" "name" "edge-element-equality-string" \
		{/person/name} \
		"RF(RA(RI(edge-element-equality-string,prefix,person.name)))" \
		"RI(edge-element-equality-string,prefix,person.name),RA,RF," \
		$delete \
		{person.name} 1 \
		$env $txnenv $basename $oargs

	assertIndexUsed \
		"$basename.2.19" \
		"equality" \
		$documents \
		"" "balance" "edge-element-equality-number" \
		{/person[balance=123]} \
		"RF(RA(RI(edge-element-equality-number,=,person.balance,123)))" \
		"RI(edge-element-equality-number,=,person.balance,123),RA,RF," \
		$delete \
		{person.balance} 1 \
		$env $txnenv $basename $oargs

	assertIndexUsed \
		"$basename.2.20.1" \
		"less than" \
		$documents \
		"" "balance" "edge-element-equality-number" \
		{/person[balance<124]} \
		"RF(RA(RI(edge-element-equality-number,<,person.balance,124)))" \
		"RI(edge-element-equality-number,<,person.balance,124),RA,RF," \
		$delete \
		{person.balance} 1 \
		$env $txnenv $basename $oargs

	assertIndexUsed \
		"$basename.2.20.2" \
		"greater than" \
		$documents \
		"" "balance" "edge-element-equality-number" \
		{/person[balance>122]} \
		"RF(RA(RI(edge-element-equality-number,>,person.balance,122)))" \
		"RI(edge-element-equality-number,>,person.balance,122),RA,RF," \
		$delete \
		{person.balance} 1 \
		$env $txnenv $basename $oargs

	assertIndexUsed \
		"$basename.2.20.3" \
		"<=" \
		$documents \
		"" "balance" "edge-element-equality-number" \
		{/person[balance<=123]} \
		"RF(RA(RI(edge-element-equality-number,<=,person.balance,123)))" \
		"RI(edge-element-equality-number,<=,person.balance,123),RA,RF," \
		$delete \
		{person.balance} 1 \
		$env $txnenv $basename $oargs

	assertIndexUsed \
		"$basename.2.20.4" \
		">=" \
		$documents \
		"" "balance" "edge-element-equality-number" \
		{/person[balance>=123]} \
		"RF(RA(RI(edge-element-equality-number,>=,person.balance,123)))" \
		"RI(edge-element-equality-number,>=,person.balance,123),RA,RF," \
		$delete \
		{person.balance} 1 \
		$env $txnenv $basename $oargs

	assertIndexUsed \
		"$basename.2.20.5" \
		"range (with and)" \
		$documents \
		"" "balance" "edge-element-equality-number" \
		{/person[balance>122 and balance<124]} \
		"RF(RA(RI(edge-element-equality-number,range,person.balance,122,124)))" \
		"RI(edge-element-equality-number,range,person.balance,122,124),RA,RF," \
		$delete \
		{person.balance} 1 \
		$env $txnenv $basename $oargs

	assertIndexUsed \
		"$basename.2.20.6" \
		"range" \
		$documents \
		"" "balance" "edge-element-equality-number" \
		{/person[balance>122][balance<124]} \
		"RF(RA(RI(edge-element-equality-number,range,person.balance,122,124)))" \
		"RI(edge-element-equality-number,range,person.balance,122,124),RA,RF," \
		$delete \
		{person.balance} 1 \
		$env $txnenv $basename $oargs

	assertIndexUsed \
		"$basename.2.21" \
		"prefix" \
		$documents \
		"" "balance" "edge-element-equality-number" \
		{/person/balance} \
		"RF(RA(RI(edge-element-equality-number,prefix,person.balance)))" \
		"RI(edge-element-equality-number,prefix,person.balance),RA,RF," \
		$delete \
		{person.balance} 1 \
		$env $txnenv $basename $oargs

	assertIndexUsed \
		"$basename.2.22" \
		"equality" \
		$documents \
		"" "name" "edge-element-substring-string" \
		{/person[contains(name,'log')]} \
		"RF(RA(RI(edge-element-substring-string,=,person.name,log)))" \
		"RI(edge-element-substring-string,=,person.name,log),RA,RF," \
		$delete \
		{blo log ogg ggs} 1 \
		$env $txnenv $basename $oargs

	assertIndexUsed \
		"$basename.2.23" \
		"equality" \
		$documents \
		"" "first" "edge-attribute-equality-string" \
		{/*/name[@first='fred']} \
		"RF(RA(RI(edge-attribute-equality-string,=,name.first,fred)))" \
		"RI(edge-attribute-equality-string,=,name.first,fred),RA,RF," \
		$delete \
		{name.first} 1 \
		$env $txnenv $basename $oargs

	assertIndexUsed \
		"$basename.2.24" \
		"prefix" \
		$documents \
		"" "first" "edge-attribute-equality-string" \
		{/person/name/@first} \
		"RF(RA(RI(edge-attribute-equality-string,prefix,name.first)))" \
		"RI(edge-attribute-equality-string,prefix,name.first),RA,RF," \
		$delete \
		{name.first} 1 \
		$env $txnenv $basename $oargs

	assertIndexUsed \
		"$basename.2.25" \
		"equality" \
		$documents \
		"" "age" "edge-attribute-equality-number" \
		{/person[@age=33]} \
		"RF(RA(RI(edge-attribute-equality-number,=,person.age,33)))" \
		"RI(edge-attribute-equality-number,=,person.age,33),RA,RF," \
		$delete \
		{person.age} 1 \
		$env $txnenv $basename $oargs

	assertIndexUsed \
		"$basename.2.26.1" \
		"less than" \
		$documents \
		"" "age" "edge-attribute-equality-number" \
		{/person[@age<34]} \
		"RF(RA(RI(edge-attribute-equality-number,<,person.age,34)))" \
		"RI(edge-attribute-equality-number,<,person.age,34),RA,RF," \
		$delete \
		{person.age} 1 \
		$env $txnenv $basename $oargs

	assertIndexUsed \
		"$basename.2.26.2" \
		"greater than" \
		$documents \
		"" "age" "edge-attribute-equality-number" \
		{/person[@age>32]} \
		"RF(RA(RI(edge-attribute-equality-number,>,person.age,32)))" \
		"RI(edge-attribute-equality-number,>,person.age,32),RA,RF," \
		$delete \
		{person.age} 1 \
		$env $txnenv $basename $oargs

	assertIndexUsed \
		"$basename.2.26.3" \
		"<=" \
		$documents \
		"" "age" "edge-attribute-equality-number" \
		{/person[@age<=33]} \
		"RF(RA(RI(edge-attribute-equality-number,<=,person.age,33)))" \
		"RI(edge-attribute-equality-number,<=,person.age,33),RA,RF," \
		$delete \
		{person.age} 1 \
		$env $txnenv $basename $oargs

	assertIndexUsed \
		"$basename.2.26.4" \
		">=" \
		$documents \
		"" "age" "edge-attribute-equality-number" \
		{/person[@age>=33]} \
		"RF(RA(RI(edge-attribute-equality-number,>=,person.age,33)))" \
		"RI(edge-attribute-equality-number,>=,person.age,33),RA,RF," \
		$delete \
		{person.age} 1 \
		$env $txnenv $basename $oargs

	assertIndexUsed \
		"$basename.2.26.5" \
		"range (with and)" \
		$documents \
		"" "age" "edge-attribute-equality-number" \
		{/person[@age>32 and @age<34]} \
		"RF(RA(RI(edge-attribute-equality-number,range,person.age,32,34)))" \
		"RI(edge-attribute-equality-number,range,person.age,32,34),RA,RF," \
		$delete \
		{person.age} 1 \
		$env $txnenv $basename $oargs

	assertIndexUsed \
		"$basename.2.26.6" \
		"range" \
		$documents \
		"" "age" "edge-attribute-equality-number" \
		{/person[@age>32][@age<34]} \
		"RF(RA(RI(edge-attribute-equality-number,range,person.age,32,34)))" \
		"RI(edge-attribute-equality-number,range,person.age,32,34),RA,RF," \
		$delete \
		{person.age} 1 \
		$env $txnenv $basename $oargs

	assertIndexUsed \
		"$basename.2.27" \
		"prefix" \
		$documents \
		"" "age" "edge-attribute-equality-number" \
		{/person[@age]} \
		"RF(RA(RI(edge-attribute-equality-number,prefix,person.age)))" \
		"RI(edge-attribute-equality-number,prefix,person.age),RA,RF," \
		$delete \
		{person.age} 1 \
		$env $txnenv $basename $oargs

	assertIndexUsed \
		"$basename.2.28.1" \
		"equality" \
		$documents \
		"" "first" "edge-attribute-substring-string" \
		{/*/name[contains(@first,'fre')]} \
		"RF(RA(RI(edge-attribute-substring-string,=,name.first,fre)))" \
		"RI(edge-attribute-substring-string,=,name.first,fre),RA,RF," \
		$delete \
		{fre red} 1 \
		$env $txnenv $basename $oargs

	assertIndexUsed \
		"$basename.2.28.2" \
		"equality" \
		$documents \
		"" "first" "edge-attribute-substring-string" \
		{/*/name[contains(@first,'red')]} \
		"RF(RA(RI(edge-attribute-substring-string,=,name.first,red)))" \
		"RI(edge-attribute-substring-string,=,name.first,red),RA,RF," \
		$delete \
		{fre red} 1 \
		$env $txnenv $basename $oargs

	assertIndexUsed \
		"$basename.2.29" \
		"equality" \
		$documents \
		"http://www.sleepycat.com/2002/dbxml" "name" "node-attribute-equality-string" \
		"/*\[@dbxml:name='$test_path/document_set_10_2/document_10_2_match.xml'\]" \
		"RF(RA(RI(node-attribute-equality-string,=,http://www.sleepycat.com/2002/dbxml:name,$test_path/document_set_10_2/document_10_2_match.xml)))" \
		"RI(node-attribute-equality-string,=,http://www.sleepycat.com/2002/dbxml:name,$test_path/document_set_10_2/document_10_2_match.xml),RA,RF," \
		$delete \
		{http://www.sleepycat.com/2002/dbxml,dbxml,name\}} 3 \
		$env $txnenv $basename $oargs

	if { $delete == 0 } { 
		assertIndexUsed \
			"$basename.2.30.1" \
			"equality" \
			$documents \
			"" "" "" \
			"/*\[@dbxml:id='1'\]" \
			"RA(GD(1))" \
			"GD,RA," \
			$delete \
			{} 0 \
			$env $txnenv $basename $oargs

		assertIndexUsed \
			"$basename.2.30.2" \
			"equality" \
			$documents \
			"" "" "" \
			"/*\[@dbxml:id='1'\]/name" \
			"RF(RA(GD(1)))" \
			"GD,RA,RF," \
			$delete \
			{} 0 \
			$env $txnenv $basename $oargs
	}

	return
}

proc xml010_3 { testid delete {env "NULL"} {txnenv 0} {basename $tnum} oargs } {
	source ./include.tcl
	xml_cleanup $testdir $env
	puts "\txml010.3: "

	# The test number.
	# The test type.
	# The documents to add to the container.
	# The node name to be indexed.
	# The index to be declared for the node name.
	# The query to perform.
	# The expected optimized query plan.
	# The expected query plan operation execution order.
	# Should we add a document (10_2), or add and delete (12_4) a document.
	# The index keys that we expect statistics for.

	set documents {
		document_set_10_2/document_10_2_match.xml
		document_set_10_2/document_10_2_not_match_1.xml
		document_set_10_2/document_10_2_not_match_2.xml
	}

	assertIndexUsed \
		"$basename.3.1" \
		"equality" \
		$documents \
		"" "person" "node-element-presence" \
		"//person" \
		"RA(RI(node-element-presence-none,=,person))" \
		"RI(node-element-presence-none,=,person),RA," \
		$delete \
		{person} 1 \
		$env $txnenv $basename $oargs

	assertIndexUsed \
		"$basename.3.2" \
		"equality" \
		$documents \
		"" "age" "node-attribute-presence" \
		{//@age} \
		"RA(RI(node-attribute-presence-none,=,age))" \
		"RI(node-attribute-presence-none,=,age),RA," \
		$delete \
		{age} 1 \
		$env $txnenv $basename $oargs

	assertIndexUsed \
		"$basename.3.3" \
		"equality" \
		$documents \
		"" "name" "node-element-equality-string" \
		{//name[text()='Bloggs']} \
		"RA(RI(node-element-equality-string,=,name,Bloggs))" \
		"RI(node-element-equality-string,=,name,Bloggs),RA," \
		$delete \
		{name} 1 \
		$env $txnenv $basename $oargs

	assertIndexUsed \
		"$basename.3.4" \
		"prefix" \
		$documents \
		"" "name" "node-element-equality-string" \
		{//name[starts-with(text(),'Blog')]} \
		"RA(RI(node-element-equality-string,prefix,name,Blog))" \
		"RI(node-element-equality-string,prefix,name,Blog),RA," \
		$delete \
		{name} 1 \
		$env $txnenv $basename $oargs

	assertIndexUsed \
		"$basename.3.5" \
		"equality" \
		$documents \
		"" "balance" "node-element-equality-number" \
		{//balance[text()=123]} \
		"RA(RI(node-element-equality-number,=,balance,123))" \
		"RI(node-element-equality-number,=,balance,123),RA," \
		$delete \
		{balance} 1 \
		$env $txnenv $basename $oargs

	assertIndexUsed \
		"$basename.3.6.1" \
		"less than" \
		$documents \
		"" "balance" "node-element-equality-number" \
		{//balance[text()<124]} \
		"RA(RI(node-element-equality-number,<,balance,124))" \
		"RI(node-element-equality-number,<,balance,124),RA," \
		$delete \
		{balance} 1 \
		$env $txnenv $basename $oargs

	assertIndexUsed \
		"$basename.3.6.2" \
		"greater than" \
		$documents \
		"" "balance" "node-element-equality-number" \
		{//balance[text()>122]} \
		"RA(RI(node-element-equality-number,>,balance,122))" \
		"RI(node-element-equality-number,>,balance,122),RA," \
		$delete \
		{balance} 1 \
		$env $txnenv $basename $oargs

	assertIndexUsed \
		"$basename.3.6.3" \
		"<=" \
		$documents \
		"" "balance" "node-element-equality-number" \
		{//balance[text()<=123]} \
		"RA(RI(node-element-equality-number,<=,balance,123))" \
		"RI(node-element-equality-number,<=,balance,123),RA," \
		$delete \
		{balance} 1 \
		$env $txnenv $basename $oargs

	assertIndexUsed \
		"$basename.3.6.4" \
		">=" \
		$documents \
		"" "balance" "node-element-equality-number" \
		{//balance[text()>=123]} \
		"RA(RI(node-element-equality-number,>=,balance,123))" \
		"RI(node-element-equality-number,>=,balance,123),RA," \
		$delete \
		{balance} 1 \
		$env $txnenv $basename $oargs

	assertIndexUsed \
		"$basename.3.6.5" \
		"range (with and)" \
		$documents \
		"" "balance" "node-element-equality-number" \
		{//balance[text()>122 and text()<124]} \
		"RA(RI(node-element-equality-number,range,balance,122,124))" \
		"RI(node-element-equality-number,range,balance,122,124),RA," \
		$delete \
		{balance} 1 \
		$env $txnenv $basename $oargs

	assertIndexUsed \
		"$basename.3.6.6" \
		"range" \
		$documents \
		"" "balance" "node-element-equality-number" \
		{//balance[text()>122][text()<124]} \
		"RA(RI(node-element-equality-number,range,balance,122,124))" \
		"RI(node-element-equality-number,range,balance,122,124),RA," \
		$delete \
		{balance} 1 \
		$env $txnenv $basename $oargs

	assertIndexUsed \
		"$basename.3.7" \
		"prefix" \
		$documents \
		"" "balance" "node-element-equality-number" \
		{//balance} \
		"RA(RI(node-element-equality-number,prefix,balance))" \
		"RI(node-element-equality-number,prefix,balance),RA," \
		$delete \
		{balance} 1 \
		$env $txnenv $basename $oargs

	assertIndexUsed \
		"$basename.3.8.1" \
		"equality" \
		$documents \
		"" "name" "node-element-substring-string" \
		{//name[contains(text(),'Blo')]} \
		"RF(RA(RI(node-element-substring-string,=,name,blo)))" \
		"RI(node-element-substring-string,=,name,blo),RA,RF," \
		$delete \
		{blo log ogg ggs} 1 \
		$env $txnenv $basename $oargs

	assertIndexUsed \
		"$basename.3.8.2" \
		"equality" \
		$documents \
		"" "name" "node-element-substring-string" \
		{//name[contains(text(),'log')]} \
		"RF(RA(RI(node-element-substring-string,=,name,log)))" \
		"RI(node-element-substring-string,=,name,log),RA,RF," \
		$delete \
		{blo log ogg ggs} 1 \
		$env $txnenv $basename $oargs

	assertIndexUsed \
		"$basename.3.8.3" \
		"equality" \
		$documents \
		"" "name" "node-element-substring-string" \
		{//name[contains(text(),'ggs')]} \
		"RF(RA(RI(node-element-substring-string,=,name,ggs)))" \
		"RI(node-element-substring-string,=,name,ggs),RA,RF," \
		$delete \
		{blo log ogg ggs} 1 \
		$env $txnenv $basename $oargs

	assertIndexUsed \
		"$basename.3.9" \
		"equality" \
		$documents \
		"" "first" "node-attribute-equality-string" \
		{//*[@first='fred']} \
		"RA(RI(node-attribute-equality-string,=,first,fred))" \
		"RI(node-attribute-equality-string,=,first,fred),RA," \
		$delete \
		{first} 1 \
		$env $txnenv $basename $oargs

	assertIndexUsed \
		"$basename.3.10" \
		"prefix" \
		$documents \
		"" "first" "node-attribute-equality-string" \
		{//@first} \
		"RA(RI(node-attribute-equality-string,prefix,first))" \
		"RI(node-attribute-equality-string,prefix,first),RA," \
		$delete \
		{first} 1 \
		$env $txnenv $basename $oargs

	assertIndexUsed \
		"$basename.3.11" \
		"equality" \
		$documents \
		"" "age" "node-attribute-equality-number" \
		{//*[@age=33]} \
		"RA(RI(node-attribute-equality-number,=,age,33))" \
		"RI(node-attribute-equality-number,=,age,33),RA," \
		$delete \
		{age} 1 \
		$env $txnenv $basename $oargs

	assertIndexUsed \
		"$basename.3.12.1" \
		"less than" \
		$documents \
		"" "age" "node-attribute-equality-number" \
		{//*[@age<34]} \
		"RA(RI(node-attribute-equality-number,<,age,34))" \
		"RI(node-attribute-equality-number,<,age,34),RA," \
		$delete \
		{age} 1 \
		$env $txnenv $basename $oargs

	assertIndexUsed \
		"$basename.3.12.2" \
		"greater than" \
		$documents \
		"" "age" "node-attribute-equality-number" \
		{//*[@age>32]} \
		"RA(RI(node-attribute-equality-number,>,age,32))" \
		"RI(node-attribute-equality-number,>,age,32),RA," \
		$delete \
		{age} 1 \
		$env $txnenv $basename $oargs

	assertIndexUsed \
		"$basename.3.12.3" \
		"<=" \
		$documents \
		"" "age" "node-attribute-equality-number" \
		{//*[@age<=33]} \
		"RA(RI(node-attribute-equality-number,<=,age,33))" \
		"RI(node-attribute-equality-number,<=,age,33),RA," \
		$delete \
		{age} 1 \
		$env $txnenv $basename $oargs

	assertIndexUsed \
		"$basename.3.12.4" \
		">=" \
		$documents \
		"" "age" "node-attribute-equality-number" \
		{//*[@age>=33]} \
		"RA(RI(node-attribute-equality-number,>=,age,33))" \
		"RI(node-attribute-equality-number,>=,age,33),RA," \
		$delete \
		{age} 1 \
		$env $txnenv $basename $oargs

	assertIndexUsed \
		"$basename.3.12.5" \
		"range (with and)" \
		$documents \
		"" "age" "node-attribute-equality-number" \
		{//*[@age>32 and @age<34]} \
		"RA(RI(node-attribute-equality-number,range,age,32,34))" \
		"RI(node-attribute-equality-number,range,age,32,34),RA," \
		$delete \
		{age} 1 \
		$env $txnenv $basename $oargs

	assertIndexUsed \
		"$basename.3.12.6" \
		"range" \
		$documents \
		"" "age" "node-attribute-equality-number" \
		{//*[@age>32][@age<34]} \
		"RA(RI(node-attribute-equality-number,range,age,32,34))" \
		"RI(node-attribute-equality-number,range,age,32,34),RA," \
		$delete \
		{age} 1 \
		$env $txnenv $basename $oargs

	assertIndexUsed \
		"$basename.3.13" \
		"prefix" \
		$documents \
		"" "age" "node-attribute-equality-number" \
		{//@age} \
		"RA(RI(node-attribute-equality-number,prefix,age))" \
		"RI(node-attribute-equality-number,prefix,age),RA," \
		$delete \
		{age} 1 \
		$env $txnenv $basename $oargs

	assertIndexUsed \
		"$basename.3.14.1" \
		"equality" \
		$documents \
		"" "first" "node-attribute-substring-string" \
		{//*[contains(@first,'fre')]} \
		"RF(RA(RI(node-attribute-substring-string,=,first,fre)))" \
		"RI(node-attribute-substring-string,=,first,fre),RA,RF," \
		$delete \
		{fre red} 1 \
		$env $txnenv $basename $oargs

	assertIndexUsed \
		"$basename.3.14.2" \
		"equality" \
		$documents \
		"" "first" "node-attribute-substring-string" \
		{//*[contains(@first,'red')]} \
		"RF(RA(RI(node-attribute-substring-string,=,first,red)))" \
		"RI(node-attribute-substring-string,=,first,red),RA,RF," \
		$delete \
		{fre red} 1 \
		$env $txnenv $basename $oargs

	assertIndexUsed \
		"$basename.3.15" \
		"equality" \
		$documents \
		"" "name" "edge-element-presence" \
		{//person/name} \
		"RA(RI(edge-element-presence-none,=,person.name))" \
		"RI(edge-element-presence-none,=,person.name),RA," \
		$delete \
		{person.name} 1 \
		$env $txnenv $basename $oargs

	assertIndexUsed \
		"$basename.3.16" \
		"equality" \
		$documents \
		"" "age" "edge-attribute-presence" \
		{//person/@age} \
		"RA(RI(edge-attribute-presence-none,=,person.age))" \
		"RI(edge-attribute-presence-none,=,person.age),RA," \
		$delete \
		{person.age} 1 \
		$env $txnenv $basename $oargs

	assertIndexUsed \
		"$basename.3.17" \
		"equality" \
		$documents \
		"" "name" "edge-element-equality-string" \
		{//person[name='Bloggs']} \
		"RA(RI(edge-element-equality-string,=,person.name,Bloggs))" \
		"RI(edge-element-equality-string,=,person.name,Bloggs),RA," \
		$delete \
		{person.name} 1 \
		$env $txnenv $basename $oargs

	assertIndexUsed \
		"$basename.3.18" \
		"prefix" \
		$documents \
		"" "name" "edge-element-equality-string" \
		{//person/name} \
		"RA(RI(edge-element-equality-string,prefix,person.name))" \
		"RI(edge-element-equality-string,prefix,person.name),RA," \
		$delete \
		{person.name} 1 \
		$env $txnenv $basename $oargs

	assertIndexUsed \
		"$basename.3.19" \
		"equality" \
		$documents \
		"" "balance" "edge-element-equality-number" \
		{//person[balance=123]} \
		"RA(RI(edge-element-equality-number,=,person.balance,123))" \
		"RI(edge-element-equality-number,=,person.balance,123),RA," \
		$delete \
		{person.balance} 1 \
		$env $txnenv $basename $oargs

	assertIndexUsed \
		"$basename.3.20.1" \
		"less than" \
		$documents \
		"" "balance" "edge-element-equality-number" \
		{//person[balance<124]} \
		"RA(RI(edge-element-equality-number,<,person.balance,124))" \
		"RI(edge-element-equality-number,<,person.balance,124),RA," \
		$delete \
		{person.balance} 1 \
		$env $txnenv $basename $oargs

	assertIndexUsed \
		"$basename.3.20.2" \
		"greater than" \
		$documents \
		"" "balance" "edge-element-equality-number" \
		{//person[balance>122]} \
		"RA(RI(edge-element-equality-number,>,person.balance,122))" \
		"RI(edge-element-equality-number,>,person.balance,122),RA," \
		$delete \
		{person.balance} 1 \
		$env $txnenv $basename $oargs

	assertIndexUsed \
		"$basename.3.20.3" \
		"<=" \
		$documents \
		"" "balance" "edge-element-equality-number" \
		{//person[balance<=123]} \
		"RA(RI(edge-element-equality-number,<=,person.balance,123))" \
		"RI(edge-element-equality-number,<=,person.balance,123),RA," \
		$delete \
		{person.balance} 1 \
		$env $txnenv $basename $oargs

	assertIndexUsed \
		"$basename.3.20.4" \
		">=" \
		$documents \
		"" "balance" "edge-element-equality-number" \
		{//person[balance>=123]} \
		"RA(RI(edge-element-equality-number,>=,person.balance,123))" \
		"RI(edge-element-equality-number,>=,person.balance,123),RA," \
		$delete \
		{person.balance} 1 \
		$env $txnenv $basename $oargs

# JCM - The RF here should be optimized away... 
	assertIndexUsed \
		"$basename.3.20.5" \
		"range" \
		$documents \
		"" "balance" "edge-element-equality-number" \
		{//person[balance>122 and balance<124]} \
		"RF(RA(RI(edge-element-equality-number,range,person.balance,122,124)))" \
		"RI(edge-element-equality-number,range,person.balance,122,124),RA,RF," \
		$delete \
		{person.balance} 1 \
		$env $txnenv $basename $oargs

# JCM - The RF here should be optimized away... 
	assertIndexUsed \
		"$basename.3.20.6" \
		"range" \
		$documents \
		"" "balance" "edge-element-equality-number" \
		{//person[balance>122][balance<124]} \
		"RF(RA(RI(edge-element-equality-number,range,person.balance,122,124)))" \
		"RI(edge-element-equality-number,range,person.balance,122,124),RA,RF," \
		$delete \
		{person.balance} 1 \
		$env $txnenv $basename $oargs

	assertIndexUsed \
		"$basename.3.21" \
		"prefix" \
		$documents \
		"" "balance" "edge-element-equality-number" \
		{//person/balance} \
		"RA(RI(edge-element-equality-number,prefix,person.balance))" \
		"RI(edge-element-equality-number,prefix,person.balance),RA," \
		$delete \
		{person.balance} 1 \
		$env $txnenv $basename $oargs

	assertIndexUsed \
		"$basename.3.22" \
		"equality" \
		$documents \
		"" "name" "edge-element-substring-string" \
		{//person[contains(name,'log')]} \
		"RF(RA(RI(edge-element-substring-string,=,person.name,log)))" \
		"RI(edge-element-substring-string,=,person.name,log),RA,RF," \
		$delete \
		{blo log ogg ggs} 1 \
		$env $txnenv $basename $oargs

	assertIndexUsed \
		"$basename.3.23" \
		"equality" \
		$documents \
		"" "first" "edge-attribute-equality-string" \
		{//name[@first='fred']} \
		"RA(RI(edge-attribute-equality-string,=,name.first,fred))" \
		"RI(edge-attribute-equality-string,=,name.first,fred),RA," \
		$delete \
		{name.first} 1 \
		$env $txnenv $basename $oargs

	assertIndexUsed \
		"$basename.3.24" \
		"prefix" \
		$documents \
		"" "first" "edge-attribute-equality-string" \
		{//name/@first} \
		"RA(RI(edge-attribute-equality-string,prefix,name.first))" \
		"RI(edge-attribute-equality-string,prefix,name.first),RA," \
		$delete \
		{name.first} 1 \
		$env $txnenv $basename $oargs

	assertIndexUsed \
		"$basename.3.25" \
		"equality" \
		$documents \
		"" "age" "edge-attribute-equality-number" \
		{//person[@age=33]} \
		"RA(RI(edge-attribute-equality-number,=,person.age,33))" \
		"RI(edge-attribute-equality-number,=,person.age,33),RA," \
		$delete \
		{person.age} 1 \
		$env $txnenv $basename $oargs

	assertIndexUsed \
		"$basename.3.26.1" \
		"less than" \
		$documents \
		"" "age" "edge-attribute-equality-number" \
		{//person[@age<34]} \
		"RA(RI(edge-attribute-equality-number,<,person.age,34))" \
		"RI(edge-attribute-equality-number,<,person.age,34),RA," \
		$delete \
		{person.age} 1 \
		$env $txnenv $basename $oargs

	assertIndexUsed \
		"$basename.3.26.2" \
		"greater than" \
		$documents \
		"" "age" "edge-attribute-equality-number" \
		{//person[@age>32]} \
		"RA(RI(edge-attribute-equality-number,>,person.age,32))" \
		"RI(edge-attribute-equality-number,>,person.age,32),RA," \
		$delete \
		{person.age} 1 \
		$env $txnenv $basename $oargs

	assertIndexUsed \
		"$basename.3.26.3" \
		"<=" \
		$documents \
		"" "age" "edge-attribute-equality-number" \
		{//person[@age<=33]} \
		"RA(RI(edge-attribute-equality-number,<=,person.age,33))" \
		"RI(edge-attribute-equality-number,<=,person.age,33),RA," \
		$delete \
		{person.age} 1 \
		$env $txnenv $basename $oargs

	assertIndexUsed \
		"$basename.3.26.4" \
		">=" \
		$documents \
		"" "age" "edge-attribute-equality-number" \
		{//person[@age>=33]} \
		"RA(RI(edge-attribute-equality-number,>=,person.age,33))" \
		"RI(edge-attribute-equality-number,>=,person.age,33),RA," \
		$delete \
		{person.age} 1 \
		$env $txnenv $basename $oargs

# JCM - The RF here should be optimized away... 
	assertIndexUsed \
		"$basename.3.26.5" \
		"range (with and)" \
		$documents \
		"" "age" "edge-attribute-equality-number" \
		{//person[@age>32 and @age<34]} \
		"RF(RA(RI(edge-attribute-equality-number,range,person.age,32,34)))" \
		"RI(edge-attribute-equality-number,range,person.age,32,34),RA,RF," \
		$delete \
		{person.age} 1 \
		$env $txnenv $basename $oargs

# JCM - The RF here should be optimized away... 
	assertIndexUsed \
		"$basename.3.26.6" \
		"range" \
		$documents \
		"" "age" "edge-attribute-equality-number" \
		{//person[@age>32][@age<34]} \
		"RF(RA(RI(edge-attribute-equality-number,range,person.age,32,34)))" \
		"RI(edge-attribute-equality-number,range,person.age,32,34),RA,RF," \
		$delete \
		{person.age} 1 \
		$env $txnenv $basename $oargs

	assertIndexUsed \
		"$basename.3.27" \
		"prefix" \
		$documents \
		"" "age" "edge-attribute-equality-number" \
		{//person[@age]} \
		"RA(RI(edge-attribute-equality-number,prefix,person.age))" \
		"RI(edge-attribute-equality-number,prefix,person.age),RA," \
		$delete \
		{person.age} 1 \
		$env $txnenv $basename $oargs

	assertIndexUsed \
		"$basename.3.28.1" \
		"equality" \
		$documents \
		"" "first" "edge-attribute-substring-string" \
		{//name[contains(@first,'fre')]} \
		"RF(RA(RI(edge-attribute-substring-string,=,name.first,fre)))" \
		"RI(edge-attribute-substring-string,=,name.first,fre),RA,RF," \
		$delete \
		{fre red} 1 \
		$env $txnenv $basename $oargs

	assertIndexUsed \
		"$basename.3.28.2" \
		"equality" \
		$documents \
		"" "first" "edge-attribute-substring-string" \
		{//name[contains(@first,'red')]} \
		"RF(RA(RI(edge-attribute-substring-string,=,name.first,red)))" \
		"RI(edge-attribute-substring-string,=,name.first,red),RA,RF," \
		$delete \
		{fre red} 1 \
		$env $txnenv $basename $oargs

	assertIndexUsed \
		"$basename.3.29" \
		"equality" \
		$documents \
		"http://www.sleepycat.com/2002/dbxml" "name" "node-attribute-equality-string" \
		"//*\[@dbxml:name='$test_path/document_set_10_2/document_10_2_match.xml'\]" \
		"RA(RI(node-attribute-equality-string,=,http://www.sleepycat.com/2002/dbxml:name,$test_path/document_set_10_2/document_10_2_match.xml))" \
		"RI(node-attribute-equality-string,=,http://www.sleepycat.com/2002/dbxml:name,$test_path/document_set_10_2/document_10_2_match.xml),RA," \
		$delete \
		{} 0 \
		$env $txnenv $basename $oargs

	if { $delete == 0 } { 
		assertIndexUsed \
			"$basename.3.30.1" \
			"equality" \
			$documents \
			"" "" "" \
			"//*\[@dbxml:id='1'\]" \
			"RA(GD(1))" \
			"GD,RA," \
			$delete \
			{} 0 \
			$env $txnenv $basename $oargs

		assertIndexUsed \
			"$basename.3.30.2" \
			"equality" \
			$documents \
			"" "" "" \
			"/*\[@dbxml:id='1'\]/name" \
			"RF(RA(GD(1)))" \
			"GD,RA,RF," \
			$delete \
			{} 0 \
			$env $txnenv $basename $oargs
	}

	return
}

proc xml010_4 { {env "NULL"} {txnenv 0} {basename $tnum} oargs } {
	puts "\txml010.4: extended inequality tests"
	source ./include.tcl
	set txn NULL
	xml_cleanup $testdir $env

	# Create an _indexed_ container
	new XmlContainer container $env "$basename.4.dbxml" 0
	if { $txnenv == 1 } { set txn [start_txn $env] }
	$container open $txn $oargs 0
	if { $txnenv == 1 } { commit_txn $txn }

	catch {
		if { $txnenv == 1 } { set txn [start_txn $env] }
		$container addIndex $txn "" "n" "node-element-equality-number"
		if { $txnenv == 1 } { commit_txn $txn }
	} ret

	new XmlDocument xd

	foreach x {1 2 3 4} {
		# Add some documents.
		foreach value {"2.0" "1" "0" "-1" " -2.0"} {
			$xd setContent "<n><n>$value</n></n>"
			if { $txnenv == 1 } { set txn [start_txn $env] }
			$container putDocument $txn $xd
			if { $txnenv == 1 } { commit_txn $txn }
		}

		assertInequality $env $txnenv $container "10.4.1.1" {/n[n=2]} [expr $x*1]
		assertInequality $env $txnenv $container "10.4.1.2" {/n[n=1]} [expr $x*1]
		assertInequality $env $txnenv $container "10.4.1.3" {/n[n=0]} [expr $x*1]
		assertInequality $env $txnenv $container "10.4.1.4" {/n[n=-1]} [expr $x*1]
		assertInequality $env $txnenv $container "10.4.1.5" {/n[n=-2]} [expr $x*1]

		assertInequality $env $txnenv $container "10.4.2.1" {/n[n<2]} [expr $x*4]
		assertInequality $env $txnenv $container "10.4.2.2" {/n[n<1]} [expr $x*3]
		assertInequality $env $txnenv $container "10.4.2.3" {/n[n<0]} [expr $x*2]
		assertInequality $env $txnenv $container "10.4.2.4" {/n[n<-1]} [expr $x*1]
		assertInequality $env $txnenv $container "10.4.2.5" {/n[n<-2]} [expr $x*0]

		assertInequality $env $txnenv $container "10.4.3.1" {/n[n<=2]} [expr $x*5]
		assertInequality $env $txnenv $container "10.4.3.2" {/n[n<=1]} [expr $x*4]
		assertInequality $env $txnenv $container "10.4.3.3" {/n[n<=0]} [expr $x*3]
		assertInequality $env $txnenv $container "10.4.3.4" {/n[n<=-1]} [expr $x*2]
		assertInequality $env $txnenv $container "10.4.3.5" {/n[n<=-2]} [expr $x*1]

		assertInequality $env $txnenv $container "10.4.4.1" {/n[n>2]} [expr $x*0]
		assertInequality $env $txnenv $container "10.4.4.2" {/n[n>1]} [expr $x*1]
		assertInequality $env $txnenv $container "10.4.4.3" {/n[n>0]} [expr $x*2]
		assertInequality $env $txnenv $container "10.4.4.4" {/n[n>-1]} [expr $x*3]
		assertInequality $env $txnenv $container "10.4.4.5" {/n[n>-2]} [expr $x*4]

		assertInequality $env $txnenv $container "10.4.5.1" {/n[n>=2]} [expr $x*1]
		assertInequality $env $txnenv $container "10.4.5.2" {/n[n>=1]} [expr $x*2]
		assertInequality $env $txnenv $container "10.4.5.3" {/n[n>=0]} [expr $x*3]
		assertInequality $env $txnenv $container "10.4.5.4" {/n[n>=-1]} [expr $x*4]
		assertInequality $env $txnenv $container "10.4.5.5" {/n[n>=-2]} [expr $x*5]
	}

	$container close
	delete container
}

proc xml010_5 { {env "NULL"} {txnenv 0} {basename $tnum} oargs } {
	puts "\txml010.4: extended inequality tests #2"
	source ./include.tcl
	set txn NULL
	xml_cleanup $testdir $env

	# Create an _indexed_ container
	new XmlContainer container $env "$basename.4.dbxml" 0
	if { $txnenv == 1 } { set txn [start_txn $env] }
	$container open $txn $oargs 0
	if { $txnenv == 1 } { commit_txn $txn }

	catch {
		if { $txnenv == 1 } { set txn [start_txn $env] }
		$container addIndex $txn "" "n" "node-element-equality-number"
		if { $txnenv == 1 } { commit_txn $txn }
	} ret

	new XmlDocument xd

	# Add some documents.
	foreach value {"NaN" "-Infinity" "-0.123456789" "0.123456788" "0.123456789" "Infinity"} {
		$xd setContent "<n><n>$value</n></n>"
		if { $txnenv == 1 } { set txn [start_txn $env] }
		$container putDocument $txn $xd
		if { $txnenv == 1 } { commit_txn $txn }
	}

#	assertInequality $env $txnenv $container "10.5.1.1" {/n[n=number('NaN')]} 1
#	assertInequality $env $txnenv $container "10.5.1.2" {/n[n=number('-Infinity')]} 1
	assertInequality $env $txnenv $container "10.5.1.3" {/n[n= 0.123456789]} 1
	assertInequality $env $txnenv $container "10.5.1.4" {/n[n= 0.123456788]} 1
	assertInequality $env $txnenv $container "10.5.1.5" {/n[n=-0.123456789]} 1
#	assertInequality $env $txnenv $container "10.5.1.6" {/n[n=number('Infinity')]} 1

#	assertInequality $env $txnenv $container "10.5.2.1" {/n[n<number('Infinity')]} 5
	assertInequality $env $txnenv $container "10.5.2.2" {/n[n< 0.123456789]} 2
	assertInequality $env $txnenv $container "10.5.2.3" {/n[n< 0.123456788]} 1
	assertInequality $env $txnenv $container "10.5.2.4" {/n[n<-0.123456789]} 0
#	assertInequality $env $txnenv $container "10.5.2.5" {/n[n<number('-Infinity')]} 1
#	assertInequality $env $txnenv $container "10.5.2.6" {/n[n<number('NaN')]} 0

#	assertInequality $env $txnenv $container "10.5.3.1" {/n[n<=number('Infinity')]} 6
	assertInequality $env $txnenv $container "10.5.3.2" {/n[n<= 0.123456789]} 3
	assertInequality $env $txnenv $container "10.5.3.3" {/n[n<= 0.123456788]} 2
	assertInequality $env $txnenv $container "10.5.3.4" {/n[n<=-0.123456789]} 1
#	assertInequality $env $txnenv $container "10.5.3.5" {/n[n<=number('-Infinity')]} 2
#	assertInequality $env $txnenv $container "10.5.3.6" {/n[n<=number('NaN')]} 1

#	assertInequality $env $txnenv $container "10.5.4.1" {/n[n>number('Infinity')]} 0
	assertInequality $env $txnenv $container "10.5.4.2" {/n[n> 0.123456789]} 0
	assertInequality $env $txnenv $container "10.5.4.3" {/n[n> 0.123456788]} 1
	assertInequality $env $txnenv $container "10.5.4.4" {/n[n>-0.123456789]} 2
#	assertInequality $env $txnenv $container "10.5.4.5" {/n[n>number('-Infinity')]} 4
#	assertInequality $env $txnenv $container "10.5.4.6" {/n[n>number('NaN')]} 5

 #	assertInequality $env $txnenv $container "10.5.5.1" {/n[n>=number('Infinity')]} 1
	assertInequality $env $txnenv $container "10.5.5.2" {/n[n>= 0.123456789]} 1
	assertInequality $env $txnenv $container "10.5.5.3" {/n[n>= 0.123456788]} 2
	assertInequality $env $txnenv $container "10.5.5.4" {/n[n>=-0.123456789]} 3
#	assertInequality $env $txnenv $container "10.5.5.5" {/n[n>=number('-Infinity')]} 5
#	assertInequality $env $txnenv $container "10.5.5.6" {/n[n>=number('NaN')]} 6

	$container close
	delete container
}

proc assertInequality { {env "NULL"} {txnenv 0} container testid query size} {
	puts "\t\t$testid: $query"
	set txn NULL
	new XmlQueryContext context
	$context set "dbxml:debug" "result"
	new XmlValue xv

	if { $txnenv == 1 } { set txn [start_txn $env] }
	wrap XmlResults xr [$container queryWithXPath $txn $query $context]
	$xr next $xv
	if { $txnenv == 1 } { commit_txn $txn }

	dbxml_error_check_good $testid [$xr size] $size

	delete xr
	delete context
}

#
# This utility function is used for both the 10.2 tests and
# the 12.4 test. For 10.2 a document is added, for 12.4 a 
# document is added and deleted.
#
proc assertIndexUsed { testid testtype documents uri nodename index query oqp eqp \
    delete keys indexcount {env "NULL"} {txnenv 0} {basename $tnum} oargs } {
	puts "\t\t$testid: $index: $testtype"
	source ./include.tcl
	set txn NULL
	xml_cleanup $testdir $env

	# Create an _indexed_ container
	new XmlContainer container $env "$testid.dbxml" 0
	if { $txnenv == 1 } { set txn [start_txn $env] }
	$container open $txn $oargs 0
	if { $txnenv == 1 } { commit_txn $txn }

	catch {
		if { $txnenv == 1 } { set txn [start_txn $env] }
		$container addIndex $txn $uri $nodename $index
		if { $txnenv == 1 } { commit_txn $txn }
	} ret

	# Add some documents.
	foreach document $documents {
		if { $txnenv == 1 } { set txn [start_txn $env] }
		if { [putFileInContainer $container "$test_path/$document" $txn] == 0 } {
			puts "Couldn't load $document."
		}
		if { $txnenv == 1 } { commit_txn $txn }
	}

	# If requested, delete the first document.
	if { $delete } {
		if { $txnenv == 1 } { set txn [start_txn $env] }
		$container deleteDocumentByID $txn 1
		if { $txnenv == 1 } { commit_txn $txn }

		# We expect the statistics entry to be 0.
		set indexed [expr $indexcount-1]
		# We expect no documents to be returned.
		set rids {[0]} 
	} else {
		# We expect the statistics entry to be $indexcount.
		set indexed $indexcount
		# We expect one document to be returned.
		set rids {[1] 1}
	}

	set statistics [getDocumentContent $container $txn 0]
	new XmlQueryContext context
	$context set "dbxml:debug" "result"


	if { $txnenv == 1 } { set txn [start_txn $env] }
	wrap XmlResults xr [$container queryWithXPath $txn $query $context]
	delete xr
	if { $txnenv == 1 } { commit_txn $txn }


	# Check that
	# 1. The optimized query plan is correct.
	# 2. The query plan operations were executed in the correct order.
	# 3. The result was correct.
	set oqpret [dbxml_error_check_good oqp($testid) [$context get "result._oqp"] $oqp]
	set eqpret [dbxml_error_check_good eqp($testid) [$context get "result._eqp"] $eqp]
	set ridsret [dbxml_error_check_good rids($testid) [$context get "result._rids"] $rids]
	if { [llength $oqpret] > 0 || [llength $eqpret] > 0 || [llength $ridsret] > 0 } {		
		puts "- Raw Query Plan: [$context get "result._rqp"]"
		puts "- Optimized Query Plan: [$context get "result._oqp"]"
		puts "- Executed Query Plan: [$context get "result._eqp"]"
		puts "- Result ID Set: [$context get "result._rids"]"
		puts "- Result: [$context get "result"]"
	}
	# Check that the statistics were updated correctly.
	foreach key $keys {
		set ret [dbxml_error_check_good indexed($testid:$key) \
		    [string match "*$key' indexed='$indexed'*" $statistics] 1]
		if { [llength $ret] > 0 } {
			puts [string match "*$key' indexed='$indexed'*" $statistics]
			puts "Failed to find *$key' indexed='$indexed'* in the statistics..."
			puts $statistics
		}
	}

	set indexedResult [$context get "result._rids"]
	delete context
	$container close
	delete container

	# Create an _unindexed_ container
	xml_cleanup $testdir $env
	new XmlContainer container $env "$testid.dbxml" 0

	if { $txnenv == 1 } { set txn [start_txn $env] }
	$container open $txn $oargs 0
	if { $txnenv == 1 } { commit_txn $txn }

	# Add some documents.
	foreach document $documents {
		if { $txnenv == 1 } { set txn [start_txn $env] }
		if { [putFileInContainer $container "$test_path/$document" $txn] == 0 } {
			puts "Couldn't load $document."
		}
		if { $txnenv == 1 } { commit_txn $txn }
	}
	# If requested, delete the first document.
	if { $delete } {
		if { $txnenv == 1 } { set txn [start_txn $env] }
		$container deleteDocumentByID $txn 1
		if { $txnenv == 1 } { commit_txn $txn }
	}

	new XmlQueryContext context
	$context set "dbxml:debug" "result"

	if { $txnenv == 1 } { set txn [start_txn $env] }
	wrap XmlResults xr [$container queryWithXPath $txn $query $context]
	delete xr
	if { $txnenv == 1 } { commit_txn $txn }

	# Check that the indexed and unindexed containers give the same result.
	set unindexedResult [$context get "result._rids"]
	delete context

	$container close
	delete container
	dbxml_error_check_good unindexed($testid) $unindexedResult $indexedResult
}


