# See the file LICENSE for redistribution information.
#
# Copyright (c) 2000-2003
#	Sleepycat Software.  All rights reserved.
#
# $Id: xml009.tcl,v 1.26 2003/08/25 17:52:04 mjc Exp $
#
# TEST	xml009
# TEST	Container Document Storage

proc xml009 { {args ""} } {
	puts "\nxml009: Container Document Storage ($args)"
	source ./include.tcl

	# Determine whether procedure has been called within an environment, 
	# and whether it is a transactional environment.
	# If we are using an env, then the filename should just be the test 
	# number.  Otherwise it is the test directory and the test number.
	set eindex [lsearch -exact $args "-env"]
	set txnenv 0
	set tnum 9
	set txn NULL
	set oargs [eval {set_openargs} $args]

	if { $eindex == -1 } {
		set env NULL
		set basename $testdir/$tnum
	} else {
		incr eindex
		set env [lindex $args $eindex]
		set txnenv [is_txnenv $env]
		if { $txnenv == 1 } {
		}
		set testdir [get_home $env]
		set basename $tnum
	}

	xml_cleanup $testdir $env

	new XmlContainer container $env "$basename.1.dbxml" 0

	if { $txnenv == 1 } { set txn [start_txn $env] }
	$container open $txn $oargs 0
	if { $txnenv == 1 } { commit_txn $txn }

	new XmlQueryContext context
	$context set "dbxml:debug" "result"

	# Test Group 9.1

	puts "\txml009.1: Returned document identical to original document"
	xml009_assertDocumentPut "9.1.1: Document with prolog" $container \
	    $test_path/document_set_9_1/9_1_1_with_prolog.xml $env $txn 
	xml009_assertDocumentPut "9.1.2: Document without prolog" $container \
	    $test_path/document_set_9_1/9_1_2_without_prolog.xml $env $txn
	xml009_assertDocumentPut "9.1.3: Well-formed document" $container \
	    $test_path/document_set_9_1/9_1_3_well_formed.xml $env $txn
	xml009_assertDocumentNotPut "9.1.4: Reject badly-formed document" $container \
	    $test_path/document_set_9_1/9_1_4_not_well_formed.xml $env $txn
	xml009_assertDocumentPut "9.1.5: Document with CDATA" $container \
	    $test_path/document_set_9_1/9_1_5_with_cdata.xml $env $txn
	xml009_assertDocumentPut "9.1.6: Document with comments" $container \
	    $test_path/document_set_9_1/9_1_6_with_comment.xml $env $txn
	xml009_assertDocumentPut "9.1.7: Doc with processing instruction" $container \
	    $test_path/document_set_9_1/9_1_7_with_pi.xml $env $txn
	xml009_assertDocumentPut "9.1.8: Doc with internal DTD" $container \
	    $test_path/document_set_9_1/9_1_8_internal_dtd.xml $env $txn
	xml009_assertDocumentPut "9.1.9: Doc with external DTD" $container \
	    $test_path/document_set_9_1/9_1_9_external_dtd.xml $env $txn
	xml009_assertDocumentPut "9.1.10: Standalone document definition" $container \
	    $test_path/document_set_9_1/9_1_10_standalone.xml $env $txn
	xml009_assertDocumentPut "9.1.11: Elements" $container \
	    $test_path/document_set_9_1/9_1_11_elements.xml $env $txn
	xml009_assertDocumentPut "9.1.12: Empty elements" $container \
	    $test_path/document_set_9_1/9_1_12_empty_elements.xml $env $txn
	xml009_assertDocumentPut "9.1.13: Mixed content" $container \
	    $test_path/document_set_9_1/9_1_13_mixed_content.xml $env $txn
	xml009_assertDocumentPut "9.1.14: Attributes" $container \
	    $test_path/document_set_9_1/9_1_14_attributes.xml $env $txn
	xml009_assertDocumentPut "9.1.15: Character references" $container \
	    $test_path/document_set_9_1/9_1_15_character_references.xml $env $txn
	xml009_assertDocumentNotPut "9.1.16: Internal entities" $container \
	    $test_path/document_set_9_1/9_1_16_internal_entities.xml $env $txn
	xml009_assertDocumentNotPut "9.1.17: Reject external entities" $container \
	    $test_path/document_set_9_1/9_1_17_external_entities.xml $env $txn
	xml009_assertDocumentNotPut "9.1.18: Reject syntax error" $container \
	    $test_path/document_set_9_1/9_1_18_syntax_error.xml $env $txn
	xml009_assertDocumentPut "9.1.19: Doc with external DTD missing" $container \
	    $test_path/document_set_9_1/9_1_19_external_dtd_missing.xml $env $txn
	xml009_assertDocumentPut "9.1.20: Doc with XML Schema" $container \
	    $test_path/document_set_9_1/9_1_20_xml_schema.xml $env $txn
	xml009_assertDocumentPut "9.1.21: Doc with XML Schema missing" $container \
	    $test_path/document_set_9_1/9_1_21_xml_schema_missing.xml $env $txn
	xml009_assertDocumentPut "9.1.22: Deep document" $container \
	    $test_path/document_set_9_1/9_1_22_deep.xml $env $txn

	# Test Group 9.2

	puts "\txml009.2: Returned document identical to original - with namespaces"
	xml009_assertDocumentPut "9.2.1: Document with namespace declaration" $container \
	    $test_path/document_set_9_2/9_2_1_namespace.xml $env $txn
	xml009_assertDocumentPut "9.2.2: Default namespace declaration" $container \
	    $test_path/document_set_9_2/9_2_2_default_namespace.xml $env $txn

	delete context
	$container close
	delete container
	return
}

proc xml009_assertDocumentPut { testid container filename {env "NULL"} {txn "NULL"} } {
	set txnenv 0
	if { $env != "NULL" } {
		set txnenv [is_txnenv $env]
	}

	if { $txnenv == 1 } { set txn [start_txn $env] }
	catch {set id [putFileInContainer $container $filename $txn]}
	if { $txnenv == 1 } { commit_txn $txn }

	set data_in [readFile $filename]
	set data_out [getDocumentContent $container $txn $id]
	dbxml_error_check_good $testid $data_out $data_in
}

proc xml009_assertDocumentNotPut { testid container filename {env "NULL"} {txn "NULL"} } {
	set txnenv 0
	if { $env != "NULL" } {
		set txnenv [is_txnenv $env]
	}

	if { $txnenv == 1 } { set txn [start_txn $env] }
	catch {set id [putFileInContainer $container $filename $txn]}
	if { $txnenv == 1 } { commit_txn $txn }

	dbxml_error_check_good $testid $id 0
}
