# See the file LICENSE for redistribution information.
#
# Copyright (c) 2000-2003
#	Sleepycat Software.  All rights reserved.
#
# $Id: xml008.tcl,v 1.16 2003/05/23 16:27:18 merrells Exp $
#
# TEST	xml008
# TEST	Container Management

proc xml008 { {args ""} } {
	puts "\nXml008: Container management ($args)"
	source ./include.tcl

	# Determine whether procedure has been called within an environment, 
	# and whether it is a transactional environment.
	# If we are using an env, then the filename should just be the test 
	# number.  Otherwise it is the test directory and the test number.
	set eindex [lsearch -exact $args "-env"]
	set txnenv 0
	set tnum 8
	set oargs [eval {set_openargs} $args]

	if { $eindex == -1 } {
		set env NULL
		set basename $testdir/$tnum
	} else {
		incr eindex
		set env [lindex $args $eindex]
		set txnenv [is_txnenv $env]
		if { $txnenv == 1 } {
		}
		set testdir [get_home $env]
		set basename $tnum
	}

	xml008_1 $env $txnenv $basename $oargs
#	xml008_2 $env $txnenv $basename $oargs
	xml008_3 $env $txnenv $basename $oargs

	return
}

proc xml008_1 { {env "NULL"} {txnenv 0} {basename $tnum} oargs } {
	puts "\tXml008.1: Create two containers"
	source ./include.tcl
	set txn NULL
	
	xml_cleanup $testdir $env
	
	new XmlContainer container1 $env "$basename.1.1.dbxml" 0
	new XmlContainer container2 $env "$basename.1.2.dbxml" 0

	catch {
		if { $txnenv == 1 } { set txn [start_txn $env] }
		$container1 open $txn $oargs 0
		$container2 open $txn $oargs 0
		if { $txnenv == 1 } { commit_txn $txn }

		$container1 close
		$container2 close
	} ret	

	dbxml_error_check_good "8.1: Multiple containers" $ret ""

	delete container1
	delete container2
	
}

proc xml008_3 { {env "NULL"} {txnenv 0} {basename $tnum} oargs } {
	puts "\tXml008.3: Test container methods"
	xml008_3_1 $env $txnenv $basename $oargs
	xml008_3_2 $env $txnenv $basename $oargs
	xml008_3_3 $env $txnenv	$basename $oargs
	xml008_3_4 $env $txnenv	$basename $oargs
	xml008_3_5 $env $txnenv	$basename $oargs
	xml008_3_6 $env $txnenv	$basename $oargs
}

proc xml008_3_1 { {env "NULL"} {txnenv 0} {basename $tnum} oargs } {
	puts "\t\tXml008.3.1: Open, close, open and close again"
	source ./include.tcl
	set txn "0"

	xml_cleanup $testdir $env
	new XmlContainer container $env "$basename.3.1.dbxml" 0

	if { $txnenv == 1 } { set txn [start_txn $env] }
	$container open $txn $oargs 0
	if { $txnenv == 1 } { commit_txn $txn }

	$container close
	
	catch {
		if { $txnenv == 1 } { set txn [start_txn $env] }
		$container open $txn 0 0
		if { $txnenv == 1 } { commit_txn $txn }

		$container close
	} ret

	dbxml_error_check_good "8.3.1: reopen, reclose" $ret ""
	delete container
}

proc xml008_3_2 { {env "NULL"} {txnenv 0} {basename $tnum} oargs } {
	puts "\t\tXml008.3.2: Open, close, rename, open and close"
	source ./include.tcl
	set txn NULL

	xml_cleanup $testdir $env
	new XmlContainer container $env "$basename.3.2.dbxml" 0

	if { $txnenv == 1 } { set txn [start_txn $env] }
	$container open $txn $oargs 0
	if { $txnenv == 1 } { commit_txn $txn }

	$container close

	if { $txnenv == 1 } { set txn [start_txn $env] }
	$container rename $txn "$basename.3.2.renamed"
	if { $txnenv == 1 } { commit_txn $txn }

	catch {
		$container setName "$basename.3.2.renamed"
		if { $txnenv == 1 } { set txn [start_txn $env] }
		$container open $txn 0 0
		if { $txnenv == 1 } { commit_txn $txn }

		$container close
	} ret

	dbxml_error_check_good "8.3.2: open & close after rename" $ret ""
	delete container
}

proc xml008_3_3 { {env "NULL"} {txnenv 0} {basename $tnum} oargs } {
	puts "\t\tXml008.3.3: Open, close, remove, open and close"
	source ./include.tcl
	set txn NULL

	xml_cleanup $testdir $env
	new XmlContainer container $env "$basename.3.3.dbxml" 0

	if { $txnenv == 1 } { set txn [start_txn $env] }
	$container open $txn $oargs 0
	if { $txnenv == 1 } { commit_txn $txn }

	$container close

	if { $txnenv == 1 } { set txn [start_txn $env] }
	$container remove $txn
	if { $txnenv == 1 } { commit_txn $txn }

	catch {
		if { $txnenv == 1 } { set txn [start_txn $env] }
		$container open $txn $oargs 0
		if { $txnenv == 1 } { commit_txn $txn }

		$container close
	} ret

	dbxml_error_check_good "8.3.3: open & close after remove" $ret ""
	delete container
}

proc xml008_3_4 { {env "NULL"} {txnenv 0} {basename $tnum} oargs } {
	puts "\t\tXml008.3.4: Verify that rename renames underlying files"
	source ./include.tcl
	set txn NULL
	
	xml_cleanup $testdir $env
	new XmlContainer container $env "$basename.3.4.dbxml" 0

	if { $txnenv == 1 } { set txn [start_txn $env] }
	$container open $txn $oargs 0
	if { $txnenv == 1 } { commit_txn $txn }

	$container close

	dbxml_error_check_good "8.3.4: container exists" \
	    [file exists $testdir/8.3.4.dbxml] 1

	if { $txnenv == 1 } { set txn [start_txn $env] }
	$container rename $txn "$basename.3.4.renamed.dbxml"
	if { $txnenv == 1 } { commit_txn $txn }

	dbxml_error_check_good "8.3.4: container renamed" \
	    [file exists $testdir/8.3.4.dbxml] 0

	dbxml_error_check_good "8.3.5: renamed container exists" \
	    [file exists $testdir/8.3.4.renamed.dbxml] 1

	delete container
}

proc xml008_3_5 { {env "NULL"} {txnenv 0} {basename $tnum} oargs } {
	puts "\t\tXml008.3.5: Verify that remove removes underlying files"
	source ./include.tcl
	set txn NULL

	xml_cleanup $testdir $env
	new XmlContainer container $env "$basename.3.5.dbxml" 0

	if { $txnenv == 1 } { set txn [start_txn $env] }
	$container open $txn $oargs 0
	if { $txnenv == 1 } { commit_txn $txn }

	$container close

	dbxml_error_check_good "8.3.5: container exists" \
	    [file exists $testdir/8.3.5.dbxml] 1

	if { $txnenv == 1 } { set txn [start_txn $env] }
	$container remove $txn
	if { $txnenv == 1 } { commit_txn $txn }

	dbxml_error_check_good "8.3.5: container removed" \
	    [file exists $testdir/8.3.5.dbxml] 0

	delete container
}


proc xml008_3_6 { {env "NULL"} {txnenv 0} {basename $tnum} oargs } {
	puts "\t\tXml008.3.6: isOpen"
	source ./include.tcl
	set txn "0"

	xml_cleanup $testdir $env
	new XmlContainer container $env "$basename.3.1.dbxml" 0

	dbxml_error_check_good "8.3.6: isOpen - never opened" [$container isOpen] 0

	if { $txnenv == 1 } { set txn [start_txn $env] }
	$container open $txn $oargs 0
	if { $txnenv == 1 } { commit_txn $txn }

	dbxml_error_check_good "8.3.6: isOpen - opened" [$container isOpen] 1

	$container close
	
	dbxml_error_check_good "8.3.6: isOpen - closed" [$container isOpen] 0

	catch {
		if { $txnenv == 1 } { set txn [start_txn $env] }
		$container open $txn 0 0
		if { $txnenv == 1 } { commit_txn $txn }

		dbxml_error_check_good "8.3.6: isOpen - reopened" [$container isOpen] 1

		$container close

		dbxml_error_check_good "8.3.6: isOpen - reclosed" [$container isOpen] 0
	} ret

	delete container
}

