# See the file LICENSE for redistribution information.
#
# Copyright (c) 2000-2003
#	Sleepycat Software.  All rights reserved.
#
# $Id: xml006_utf8.tcl,v 1.15 2004/01/27 09:46:56 merrells Exp $
#
# TEST	xml006_utf8

proc xml006_2_utf8 { {env "NULL"} {txnenv 0} {basename $tnum} oargs } {
	puts "\txml006.2: Retrieve documents using XPath expressions: \n \
	    \t\t\tunusual UTF-8 characters"

	# Arguments for assertIndexUsed:
	# The test number.
	# The test type.
	# The documents to add to the container.
	# The uri to be indexed.
	# The node name to be indexed.
	# The index to be declared for the node name.
	# The query to perform.
	# The expected optimized query plan.
	# The expected query plan operation execution order.
	# Should we add a document (10_2), or add and delete (12_4) a document.
	# The index keys that we expect statistics for.

	set documents {
		document_set_6_2/document_6_2_match.xml
		document_set_6_2/document_6_2_not_match_1.xml
		document_set_6_2/document_6_2_not_match_2.xml
	}

	assertIndexUsed \
		"$basename.2.1" \
		"equality" \
		$documents \
		"" \
		"món" \
		"node-element-presence" \
		"//món" \
		"RA(RI(node-element-presence-none,=,món))" \
		"RI(node-element-presence-none,=,món),RA," \
		0 \
		{món} 1 \
		$env $txnenv $basename $oargs

	assertIndexUsed \
		"$basename.2.2" \
		"equality" \
		$documents \
		"" \
		"Når" "node-attribute-presence" \
		{//@Når} \
		"RA(RI(node-attribute-presence-none,=,Når))" \
		"RI(node-attribute-presence-none,=,Når),RA," \
		0 \
		{Når} 1 \
		$env $txnenv $basename $oargs

	assertIndexUsed \
		"$basename.2.3" \
		"equality" \
		$documents \
		"" \
		"כאשר" "node-element-equality-string" \
		{//כאשר[text()='bloggs']} \
		"RA(RI(node-element-equality-string,=,כאשר,bloggs))" \
		"RI(node-element-equality-string,=,כאשר,bloggs),RA," \
		0 \
		{כאשר} 1 \
		$env $txnenv $basename $oargs

	assertIndexUsed \
		"$basename.2.4" \
		"prefix" \
		$documents \
		"" \
		"כאשר" "node-element-equality-string" \
		{//כאשר[starts-with(text(),'blog')]} \
		"RA(RI(node-element-equality-string,prefix,כאשר,blog))" \
		"RI(node-element-equality-string,prefix,כאשר,blog),RA," \
		0 \
		{כאשר} 1 \
		$env $txnenv $basename $oargs

	assertIndexUsed \
		"$basename.2.5" \
		"equality" \
		$documents \
		"" \
		"världen" "node-element-equality-number" \
		{//världen[text()=123]} \
		"RA(RI(node-element-equality-number,=,världen,123))" \
		"RI(node-element-equality-number,=,världen,123),RA," \
		0 \
		{världen} 1 \
		$env $txnenv $basename $oargs

	assertIndexUsed \
		"$basename.2.6.1" \
		"less than" \
		$documents \
		"" \
		"världen" "node-element-equality-number" \
		{//världen[text()<124]} \
		"RA(RI(node-element-equality-number,<,världen,124))" \
		"RI(node-element-equality-number,<,världen,124),RA," \
		0 \
		{världen} 1 \
		$env $txnenv $basename $oargs

	assertIndexUsed \
		"$basename.2.6.2" \
		"greater than" \
		$documents \
		"" \
		"världen" "node-element-equality-number" \
		{//världen[text()>122]} \
		"RA(RI(node-element-equality-number,>,världen,122))" \
		"RI(node-element-equality-number,>,världen,122),RA," \
		0 \
		{världen} 1 \
		$env $txnenv $basename $oargs

	assertIndexUsed \
		"$basename.2.6.2" \
		"<=" \
		$documents \
		"" \
		"världen" "node-element-equality-number" \
		{//världen[text()<=123]} \
		"RA(RI(node-element-equality-number,<=,världen,123))" \
		"RI(node-element-equality-number,<=,världen,123),RA," \
		0 \
		{världen} 1 \
		$env $txnenv $basename $oargs

	assertIndexUsed \
		"$basename.2.6.4" \
		">=" \
		$documents \
		"" \
		"världen" "node-element-equality-number" \
		{//världen[text()>=123]} \
		"RA(RI(node-element-equality-number,>=,världen,123))" \
		"RI(node-element-equality-number,>=,världen,123),RA," \
		0 \
		{världen} 1 \
		$env $txnenv $basename $oargs

	assertIndexUsed \
		"$basename.2.6.5" \
		"range (and)" \
		$documents \
		"" \
		"världen" "node-element-equality-number" \
		{//världen[text()>122 and text()<124]} \
		"RA(RI(node-element-equality-number,range,världen,122,124))" \
		"RI(node-element-equality-number,range,världen,122,124),RA," \
		0 \
		{världen} 1 \
		$env $txnenv $basename $oargs

	assertIndexUsed \
		"$basename.2.6.6" \
		"range" \
		$documents \
		"" \
		"världen" "node-element-equality-number" \
		{//världen[text()>122][text()<124]} \
		"RA(RI(node-element-equality-number,range,världen,122,124))" \
		"RI(node-element-equality-number,range,världen,122,124),RA," \
		0 \
		{världen} 1 \
		$env $txnenv $basename $oargs

	assertIndexUsed \
		"$basename.2.7" \
		"prefix" \
		$documents \
		"" \
		"världen" "node-element-equality-number" \
		{//världen} \
		"RA(RI(node-element-equality-number,prefix,världen))" \
		"RI(node-element-equality-number,prefix,världen),RA," \
		0 \
		{världen} 1 \
		$env $txnenv $basename $oargs

	assertIndexUsed \
		"$basename.2.8.1" \
		"equality" \
		$documents \
		"" \
		"כאשר" "node-element-substring-string" \
		{//כאשר[contains(text(),'blo')]} \
		"RF(RA(RI(node-element-substring-string,=,כאשר,blo)))" \
		"RI(node-element-substring-string,=,כאשר,blo),RA,RF," \
		0 \
		{blo log ogg ggs} 1 \
		$env $txnenv $basename $oargs

	assertIndexUsed \
		"$basename.2.8.2" \
		"equality" \
		$documents \
		"" \
		"כאשר" "node-element-substring-string" \
		{//כאשר[contains(text(),'log')]} \
		"RF(RA(RI(node-element-substring-string,=,כאשר,log)))" \
		"RI(node-element-substring-string,=,כאשר,log),RA,RF," \
		0 \
		{blo log ogg ggs} 1 \
		$env $txnenv $basename $oargs

	assertIndexUsed \
		"$basename.2.8.3" \
		"equality" \
		$documents \
		"" \
		"כאשר" "node-element-substring-string" \
		{//כאשר[contains(text(),'ggs')]} \
		"RF(RA(RI(node-element-substring-string,=,כאשר,ggs)))" \
		"RI(node-element-substring-string,=,כאשר,ggs),RA,RF," \
		0 \
		{blo log ogg ggs} 1 \
		$env $txnenv $basename $oargs

	assertIndexUsed \
		"$basename.2.8.4" \
		"equality" \
		$documents \
		"" \
		"כאשר" "node-element-substring-string" \
		{//כאשר[contains(text(),'blog')]} \
		"RF(RA(n(RI(node-element-substring-string,=,כאשר,blo),RI(node-element-substring-string,=,כאשר,log))))" \
		"RI(node-element-substring-string,=,כאשר,blo),RI(node-element-substring-string,=,כאשר,log),n,RA,RF," \
		0 \
		{blo log ogg ggs} 1 \
		$env $txnenv $basename $oargs

	assertIndexUsed \
		"$basename.2.9" \
		"equality" \
		$documents \
		"" \
		"Если" "node-attribute-equality-string" \
		{//*[@Если='fred']} \
		"RA(RI(node-attribute-equality-string,=,Если,fred))" \
		"RI(node-attribute-equality-string,=,Если,fred),RA," \
		0 \
		{Если} 1 \
		$env $txnenv $basename $oargs

	assertIndexUsed \
		"$basename.2.10" \
		"prefix" \
		$documents \
		"" \
		"Если" "node-attribute-equality-string" \
		{//@Если} \
		"RA(RI(node-attribute-equality-string,prefix,Если))" \
		"RI(node-attribute-equality-string,prefix,Если),RA," \
		0 \
		{Если} 1 \
		$env $txnenv $basename $oargs

	assertIndexUsed \
		"$basename.2.11" \
		"equality" \
		$documents \
		"" \
		"Når" "node-attribute-equality-number" \
		{//*[@Når=33]} \
		"RA(RI(node-attribute-equality-number,=,Når,33))" \
		"RI(node-attribute-equality-number,=,Når,33),RA," \
		0 \
		{Når} 1 \
		$env $txnenv $basename $oargs

	assertIndexUsed \
		"$basename.2.12.1" \
		"less than" \
		$documents \
		"" \
		"Når" "node-attribute-equality-number" \
		{//*[@Når<34]} \
		"RA(RI(node-attribute-equality-number,<,Når,34))" \
		"RI(node-attribute-equality-number,<,Når,34),RA," \
		0 \
		{Når} 1 \
		$env $txnenv $basename $oargs

	assertIndexUsed \
		"$basename.2.12.2" \
		"greater than" \
		$documents \
		"" \
		"Når" "node-attribute-equality-number" \
		{//*[@Når>32]} \
		"RA(RI(node-attribute-equality-number,>,Når,32))" \
		"RI(node-attribute-equality-number,>,Når,32),RA," \
		0 \
		{Når} 1 \
		$env $txnenv $basename $oargs

	assertIndexUsed \
		"$basename.2.12.3" \
		"<=" \
		$documents \
		"" \
		"Når" "node-attribute-equality-number" \
		{//*[@Når<=33]} \
		"RA(RI(node-attribute-equality-number,<=,Når,33))" \
		"RI(node-attribute-equality-number,<=,Når,33),RA," \
		0 \
		{Når} 1 \
		$env $txnenv $basename $oargs

	assertIndexUsed \
		"$basename.2.12.4" \
		">=" \
		$documents \
		"" \
		"Når" "node-attribute-equality-number" \
		{//*[@Når>=33]} \
		"RA(RI(node-attribute-equality-number,>=,Når,33))" \
		"RI(node-attribute-equality-number,>=,Når,33),RA," \
		0 \
		{Når} 1 \
		$env $txnenv $basename $oargs

	assertIndexUsed \
		"$basename.2.12.5" \
		"range (and)" \
		$documents \
		"" \
		"Når" "node-attribute-equality-number" \
		{//*[@Når>32 and @Når<34]} \
		"RA(RI(node-attribute-equality-number,range,Når,32,34))" \
		"RI(node-attribute-equality-number,range,Når,32,34),RA," \
		0 \
		{Når} 1 \
		$env $txnenv $basename $oargs

	assertIndexUsed \
		"$basename.2.12.6" \
		"range" \
		$documents \
		"" \
		"Når" "node-attribute-equality-number" \
		{//*[@Når>32][@Når<34]} \
		"RA(RI(node-attribute-equality-number,range,Når,32,34))" \
		"RI(node-attribute-equality-number,range,Når,32,34),RA," \
		0 \
		{Når} 1 \
		$env $txnenv $basename $oargs

	assertIndexUsed \
		"$basename.2.13" \
		"prefix" \
		$documents \
		"" \
		"Når" "node-attribute-equality-number" \
		{//@Når} \
		"RA(RI(node-attribute-equality-number,prefix,Når))" \
		"RI(node-attribute-equality-number,prefix,Når),RA," \
		0 \
		{Når} 1 \
		$env $txnenv $basename $oargs

	assertIndexUsed \
		"$basename.2.14.1" \
		"equality" \
		$documents \
		"" \
		"Если" "node-attribute-substring-string" \
		{//*[contains(@Если,'fre')]} \
		"RF(RA(RI(node-attribute-substring-string,=,Если,fre)))" \
		"RI(node-attribute-substring-string,=,Если,fre),RA,RF," \
		0 \
		{fre red} 1 \
		$env $txnenv $basename $oargs

	assertIndexUsed \
		"$basename.2.14.2" \
		"equality" \
		$documents \
		"" \
		"Если" "node-attribute-substring-string" \
		{//*[contains(@Если,'red')]} \
		"RF(RA(RI(node-attribute-substring-string,=,Если,red)))" \
		"RI(node-attribute-substring-string,=,Если,red),RA,RF," \
		0 \
		{fre red} 1 \
		$env $txnenv $basename $oargs

	assertIndexUsed \
		"$basename.2.15" \
		"equality" \
		$documents \
		"" \
		"כאשר" "edge-element-presence" \
		{//món/כאשר} \
		"RA(RI(edge-element-presence-none,=,món.כאשר))" \
		"RI(edge-element-presence-none,=,món.כאשר),RA," \
		0 \
		{món.כאשר} 1 \
		$env $txnenv $basename $oargs

	assertIndexUsed \
		"$basename.2.16" \
		"equality" \
		$documents \
		"" \
		"Når" "edge-attribute-presence" \
		{//món/@Når} \
		"RA(RI(edge-attribute-presence-none,=,món.Når))" \
		"RI(edge-attribute-presence-none,=,món.Når),RA," \
		0 \
		{món.Når} 1 \
		$env $txnenv $basename $oargs

	assertIndexUsed \
		"$basename.2.17" \
		"equality" \
		$documents \
		"" \
		"כאשר" "edge-element-equality-string" \
		{//món[כאשר='bloggs']} \
		"RA(RI(edge-element-equality-string,=,món.כאשר,bloggs))" \
		"RI(edge-element-equality-string,=,món.כאשר,bloggs),RA," \
		0 \
		{món.כאשר} 1 \
		$env $txnenv $basename $oargs

	assertIndexUsed \
		"$basename.2.18" \
		"prefix" \
		$documents \
		"" \
		"כאשר" "edge-element-equality-string" \
		{//món/כאשר} \
		"RA(RI(edge-element-equality-string,prefix,món.כאשר))" \
		"RI(edge-element-equality-string,prefix,món.כאשר),RA," \
		0 \
		{món.כאשר} 1 \
		$env $txnenv $basename $oargs

	assertIndexUsed \
		"$basename.2.19" \
		"equality" \
		$documents \
		"" \
		"världen" "edge-element-equality-number" \
		{//món[världen=123]} \
		"RA(RI(edge-element-equality-number,=,món.världen,123))" \
		"RI(edge-element-equality-number,=,món.världen,123),RA," \
		0 \
		{món.världen} 1 \
		$env $txnenv $basename $oargs

	assertIndexUsed \
		"$basename.2.20.1" \
		"less than" \
		$documents \
		"" \
		"världen" "edge-element-equality-number" \
		{//món[världen<124]} \
		"RA(RI(edge-element-equality-number,<,món.världen,124))" \
		"RI(edge-element-equality-number,<,món.världen,124),RA," \
		0 \
		{món.världen} 1 \
		$env $txnenv $basename $oargs

	assertIndexUsed \
		"$basename.2.20.2" \
		"greater than" \
		$documents \
		"" \
		"världen" "edge-element-equality-number" \
		{//món[världen>122]} \
		"RA(RI(edge-element-equality-number,>,món.världen,122))" \
		"RI(edge-element-equality-number,>,món.världen,122),RA," \
		0 \
		{món.världen} 1 \
		$env $txnenv $basename $oargs

	assertIndexUsed \
		"$basename.2.20.3" \
		"<=" \
		$documents \
		"" \
		"världen" "edge-element-equality-number" \
		{//món[världen<=123]} \
		"RA(RI(edge-element-equality-number,<=,món.världen,123))" \
		"RI(edge-element-equality-number,<=,món.världen,123),RA," \
		0 \
		{món.världen} 1 \
		$env $txnenv $basename $oargs

	assertIndexUsed \
		"$basename.2.20.4" \
		">=" \
		$documents \
		"" \
		"världen" "edge-element-equality-number" \
		{//món[världen>=123]} \
		"RA(RI(edge-element-equality-number,>=,món.världen,123))" \
		"RI(edge-element-equality-number,>=,món.världen,123),RA," \
		0 \
		{món.världen} 1 \
		$env $txnenv $basename $oargs

# JCM - optimization not supported yet
#	assertIndexUsed \
#		"$basename.2.20.5" \
#		"range (and)" \
#		$documents \
#		"" \
#		"världen" "edge-element-equality-number" \
#		{/món[världen>122 and världen<124]} \
#		"RA(RI(edge-element-equality-number,range,món.världen,122,124))" \
#		"RI(edge-element-equality-number,range,món.världen,122,124),RA," \
#		0 \
#		{ } 1 \
#		$env $txnenv $basename $oargs

# JCM - optimization not supported yet
#	assertIndexUsed \
#		"$basename.2.20.6" \
#		"range" \
#		$documents \
#		"" \
#		"världen" "edge-element-equality-number" \
#		{/món[världen>122][världen<124]} \
#		"RA(RI(edge-element-equality-number,range,món.världen,122,124))" \
#		"RI(edge-element-equality-number,range,món.världen,1222,124),RA," \
#		0 \
#		{ } 1 \
#		$env $txnenv $basename $oargs

	assertIndexUsed \
		"$basename.2.21" \
		"prefix" \
		$documents \
		"" \
		"världen" "edge-element-equality-number" \
		{//món/världen} \
		"RA(RI(edge-element-equality-number,prefix,món.världen))" \
		"RI(edge-element-equality-number,prefix,món.världen),RA," \
		0 \
		{món.världen} 1 \
		$env $txnenv $basename $oargs

	assertIndexUsed \
		"$basename.2.22" \
		"equality" \
		$documents \
		"" \
		"כאשר" "edge-element-substring-string" \
		{//món[contains(כאשר,'log')]} \
		"RF(RA(RI(edge-element-substring-string,=,món.כאשר,log)))" \
		"RI(edge-element-substring-string,=,món.כאשר,log),RA,RF," \
		0 \
		{blo log ogg ggs} 1 \
		$env $txnenv $basename $oargs

	assertIndexUsed \
		"$basename.2.23" \
		"equality" \
		$documents \
		"" \
		"Если" "edge-attribute-equality-string" \
		{//כאשר[@Если='fred']} \
		"RA(RI(edge-attribute-equality-string,=,כאשר.Если,fred))" \
		"RI(edge-attribute-equality-string,=,כאשר.Если,fred),RA," \
		0 \
		{כאשר.Если} 1 \
		$env $txnenv $basename $oargs

	assertIndexUsed \
		"$basename.2.24" \
		"prefix" \
		$documents \
		"" \
		"Если" "edge-attribute-equality-string" \
		{//כאשר/@Если} \
		"RA(RI(edge-attribute-equality-string,prefix,כאשר.Если))" \
		"RI(edge-attribute-equality-string,prefix,כאשר.Если),RA," \
		0 \
		{כאשר.Если} 1 \
		$env $txnenv $basename $oargs

	assertIndexUsed \
		"$basename.2.25" \
		"equality" \
		$documents \
		"" \
		"Når" "edge-attribute-equality-number" \
		{//món[@Når=33]} \
		"RA(RI(edge-attribute-equality-number,=,món.Når,33))" \
		"RI(edge-attribute-equality-number,=,món.Når,33),RA," \
		0 \
		{món.Når} 1 \
		$env $txnenv $basename $oargs

	assertIndexUsed \
		"$basename.2.26.1" \
		"less than" \
		$documents \
		"" \
		"Når" "edge-attribute-equality-number" \
		{//món[@Når<34]} \
		"RA(RI(edge-attribute-equality-number,<,món.Når,34))" \
		"RI(edge-attribute-equality-number,<,món.Når,34),RA," \
		0 \
		{món.Når} 1 \
		$env $txnenv $basename $oargs

	assertIndexUsed \
		"$basename.2.26.2" \
		"greater than" \
		$documents \
		"" \
		"Når" "edge-attribute-equality-number" \
		{//món[@Når>32]} \
		"RA(RI(edge-attribute-equality-number,>,món.Når,32))" \
		"RI(edge-attribute-equality-number,>,món.Når,32),RA," \
		0 \
		{món.Når} 1 \
		$env $txnenv $basename $oargs

	assertIndexUsed \
		"$basename.2.26.3" \
		"<=" \
		$documents \
		"" \
		"Når" "edge-attribute-equality-number" \
		{//món[@Når<=33]} \
		"RA(RI(edge-attribute-equality-number,<=,món.Når,33))" \
		"RI(edge-attribute-equality-number,<=,món.Når,33),RA," \
		0 \
		{món.Når} 1 \
		$env $txnenv $basename $oargs

	assertIndexUsed \
		"$basename.2.26.4" \
		">=" \
		$documents \
		"" \
		"Når" "edge-attribute-equality-number" \
		{//món[@Når>=33]} \
		"RA(RI(edge-attribute-equality-number,>=,món.Når,33))" \
		"RI(edge-attribute-equality-number,>=,món.Når,33),RA," \
		0 \
		{món.Når} 1 \
		$env $txnenv $basename $oargs

# JCM - optimization not supported yet
#	assertIndexUsed \
#		"$basename.2.26.5" \
#		"range (and)" \
#		$documents \
#		"" \
#		"Når" "edge-attribute-equality-number" \
#		{/món[@Når>32 and @Når<34]} \
#		"RA(RI(edge-attribute-equality-number,range,món.Når,32,34))" \
#		"RI(edge-attribute-equality-number,range,món.Når,32,34),RA," \
#		0 \
#		{món.Når} 1 \
#		$env $txnenv $basename $oargs

# JCM - optimization not supported yet
#	assertIndexUsed \
#		"$basename.2.26.6" \
#		"range" \
#		$documents \
#		"" \
#		"Når" "edge-attribute-equality-number" \
#		{/món[@Når>32][@Når<34]} \
#		"RA(RI(edge-attribute-equality-number,range,món.Når,32,34))" \
#		"RI(edge-attribute-equality-number,range,món.Når,32,34),RA," \
#		0 \
#		{món.Når} 1 \
#		$env $txnenv $basename $oargs

	assertIndexUsed \
		"$basename.2.27" \
		"prefix" \
		$documents \
		"" \
		"Når" "edge-attribute-equality-number" \
		{//món[@Når]} \
		"RA(RI(edge-attribute-equality-number,prefix,món.Når))" \
		"RI(edge-attribute-equality-number,prefix,món.Når),RA," \
		0 \
		{món.Når} 1 \
		$env $txnenv $basename $oargs

	assertIndexUsed \
		"$basename.2.28.1" \
		"equality" \
		$documents \
		"" \
		"Если" "edge-attribute-substring-string" \
		{//כאשר[contains(@Если,'fre')]} \
		"RF(RA(RI(edge-attribute-substring-string,=,כאשר.Если,fre)))" \
		"RI(edge-attribute-substring-string,=,כאשר.Если,fre),RA,RF," \
		0 \
		{fre red} 1 \
		$env $txnenv $basename $oargs

	assertIndexUsed \
		"$basename.2.28.2" \
		"equality" \
		$documents \
		"" \
		"Если" "edge-attribute-substring-string" \
		{//כאשר[contains(@Если,'red')]} \
		"RF(RA(RI(edge-attribute-substring-string,=,כאשר.Если,red)))" \
		"RI(edge-attribute-substring-string,=,כאשר.Если,red),RA,RF," \
		0 \
		{fre red} 1 \
		$env $txnenv $basename $oargs

	return
}
