# See the file LICENSE for redistribution information.
#
# Copyright (c) 2000-2003
#	Sleepycat Software.  All rights reserved.
#
# $Id: xml006.tcl,v 1.23 2003/05/07 07:30:33 mjc Exp $
#
# TEST	xml006
# TEST	I18N & L10N
# TEST	Test storage, querying, and retrieval of XML documents
# TEST	that contain multi-byte characters.  UTF-8 should be 
# TEST	accepted, others should be rejected.

proc xml006 { args } {
	source ./include.tcl
	puts "\nxml006: I18N & L10N ($args)"

	# Determine whether procedure has been called within an environment, 
	# and whether it is a transactional environment.
	# If we are using an env, then the filename should just be the test 
	# number.  Otherwise it is the test directory and the test number.
	set eindex [lsearch -exact $args "-env"]
	set txnenv 0
	set tnum 6	
	set oargs [eval {set_openargs} $args]

	if { $eindex == -1 } {
		set env NULL
		set basename $testdir/$tnum
	} else {
		incr eindex
		set env [lindex $args $eindex]
		set txnenv [is_txnenv $env]
		set testdir [get_home $env]
		set basename $tnum
	}

	xml006_1 $env $txnenv $basename $oargs
	xml006_2 $env $txnenv $basename $oargs
}

proc xml006_1 { {env "NULL"} {txnenv 0} {basename $tnum} oargs } {
	source ./include.tcl
	puts "\txml006.1: "

	set txn NULL
	
	xml_cleanup $testdir $env
	
	new XmlContainer container $env "$basename.1.dbxml" 0
	if { $txnenv == 1 } { set txn [start_txn $env] }
	$container open $txn $oargs 0
	if { $txnenv == 1 } { commit_txn $txn }

	# Test Group 6.1

	puts "\tXml006: Test of multi-byte characters."

	puts "\tXml006: UTF-8"
	xml006_assertDocumentPut "utf_8_regular" $container \
	    $test_path/document_set_6_1/utf_8_regular.xml $env $txn
	xml006_assertDocumentPut "utf_8_special" $container \
	    $test_path/document_set_6_1/utf_8_special.xml $env $txn
	puts "\tXml006: UTF-16"
	xml006_assertDocumentPut "utf_16_le" $container \
	    $test_path/document_set_6_1/utf_16_le.xml  $env $txn
	xml006_assertDocumentPut "utf_16_be" $container \
	    $test_path/document_set_6_1/utf_16_be.xml  $env $txn
	puts "\tXml006: UCS2 and UCS4"
	xml006_assertDocumentNotPut "ucs_4_le" $container \
	    $test_path/document_set_6_1/ucs_4_le.xml  $env $txn
	xml006_assertDocumentNotPut "ucs_4_be" $container \
	    $test_path/document_set_6_1/ucs_4_be.xml  $env $txn
	# Disabled - depends on Xerces configuration
	# xml006_assertDocumentNotPut "big_5" $container \
	#     $test_path/document_set_6_1/big_5.xml  $env $txn
	puts "\tXml006: UTF-8 ISO-8859"
	# Disabled - depends on Xerces configuration
	# xml006_assertDocumentNotPut "iso_8859_5_russian" $container \
	#    $test_path/document_set_6_1/iso_8859_5_russian.xml  $env $txn
	puts "\tXml006: UTF-8, UCS-4, and UTF-16"
	xml006_assertDocumentNotPut "shift_jis_japanese" $container \
	    $test_path/document_set_6_1/shift_jis_japanese.xml $env $txn
	xml006_assertDocumentNotPut "ucs_4_japanese" $container \
	    $test_path/document_set_6_1/ucs_4_japanese.xml $env $txn
	xml006_assertDocumentPut "utf_16_japanese" $container \
	    $test_path/document_set_6_1/utf_16_japanese.xml $env $txn

	$container close
	delete container
}

proc xml006_assertDocumentPut { testid container filename {env "NULL"} {txn "NULL"} } {
	set txnenv 0
	if { $env != "NULL" } {
		set txnenv [is_txnenv $env]
	}

	if { $txnenv == 1 } { set txn [start_txn $env] }
	catch {set id [putFileInContainer $container $filename $txn]}
	if { $txnenv == 1 } { commit_txn $txn }

	dbxml_error_check_bad $testid $id 0
}

proc xml006_assertDocumentNotPut { testid container filename {env "NULL"} {txn "NULL"} } {
	set txnenv 0
	if { $env != "NULL" } {
		set txnenv [is_txnenv $env]
	}

	if { $txnenv == 1 } { set txn [start_txn $env] }
	catch {set id [putFileInContainer $container $filename $txn]}
	if { $txnenv == 1 } { commit_txn $txn }

	dbxml_error_check_good $testid $id 0
}

proc xml006_2 { {env "NULL"} {txnenv 0} {basename $tnum} oargs } {
	source ./include.tcl
	set fd [open "$test_path/xml006_utf8.tcl" r]
	fconfigure $fd -encoding utf-8
	set script [read $fd]
	close $fd
	eval $script
	xml006_2_utf8 $env $txnenv $basename $oargs
}
