#!/usr/bin/env python
#
# Setup script for Berkeley DB XML package
# $Id: setup.py.in,v 1.5 2003/12/17 19:35:36 gmf Exp $

import os, sys
from distutils.core import setup, Extension

#
# Posix:
#
# db_home, pathan_home, and xerces_home assume
# that these products are installed in their default
# location of /usr/local.  This can be overridden
# with the --with-berkeleydb, --with-xerces, and --with-pathan
# arguments.
#
# Windows: may require further editing to reflect site specifics.
#
db_home = "/usr/local/BerkeleyDB.4.2"
pathan_home = "/usr/local"
if os.name == "posix":
  xerces_home = "/usr/local"
else:
  xerces_home = "../../lib/xerces-c-src2_4_0"

for arg in sys.argv:
  if arg.startswith('--with-berkeleydb='):
    db_home = arg.split('=')[1]
  elif arg.startswith('--with-xerces='):
    xerces_home = arg.split('=')[1]
  elif arg.startswith('--with-pathan='):
    pathan_home = arg.split('=')[1]

sys.argv = filter(lambda x: not x.startswith("--with-"), sys.argv)

debug = "--debug" in sys.argv or "-g" in sys.argv

# setup complains when passed debug flags for install
if "install" in sys.argv and not "build" in sys.argv:
  sys.argv = filter(lambda x: (x != "--debug") and (x != "-g"), sys.argv)

if os.name == "posix":
  INCLUDES =    ["../../include",
                 os.path.join(db_home, "include"),
                 os.path.join(pathan_home, "include"),
                 os.path.join(xerces_home, "include")]

  LIBDIRS =     ["../../build_unix/.libs",
                 os.path.join(db_home, "lib"),
                 os.path.join(pathan_home, "lib"),
                 os.path.join(xerces_home, "lib")]

  LIBS =        ["dbxml-1.2",
                 "db_cxx-4.2",
                 "pathan", "xerces-c"]

  DATAFILES =   []

elif os.name == "nt":
  INCLUDES =    ["../../include",
                 os.path.join(db_home, "build_win32"),
                 os.path.join(db_home, "dbinc"),
                 os.path.join(pathan_home, "include"),
                 os.path.join(xerces_home, "include")]

  if debug:
    LIBDIRS =   ["../../build_win32/Debug",
                 os.path.join(db_home, "build_win32/Debug"),
                 os.path.join(pathan_home, "lib"),
                 os.path.join(xerces_home, "lib")]
  
    LIBS =      ["libdbxml12D",
                 "libdb42D",
                 "pathanD", "xerces-c_2D"]

    DATAFILES = [("", ["../../build_win32/Debug/libdbxml12D.dll",
                       os.path.join(db_home, "/build_win32/Debug/libdb42D.dll"),
                       os.path.join(pathan_home, "/lib/PathanD.dll"),
                       os.path.join(xerces_home, "/lib/xerces-c_2_4_0D.dll")])]
  else:
    LIBDIRS =   ["../../build_win32/Release",
                 os.path.join(db_home, "build_win32/Release"),
                 os.path.join(pathan_home, "lib"),
                 os.path.join(xerces_home, "lib")]
  
    LIBS =      ["libdbxml12",
                 "libdb42",
                 "pathan", "xerces-c_2"]

    DATAFILES = [("", ["../../build_win32/Release/libdbxml12.dll",
                       os.path.join(db_home, "build_win32/Release/libdb42.dll"),
                       os.path.join(pathan_home, "lib/Pathan.dll"),
                       os.path.join(xerces_home, "lib/xerces-c_2_4_0.dll")])]

else:
  print "I don't know anything about your platform '%s'." % os.name
  print "Please check the build instructions for more information"
  sys.exit(1)

# Now run with whatever settings we've got
setup(name = "dbxml",
      version = "1.2.1",
      description = "Berkeley DB XML Python API",
      author = "Sleepycat Software",
      author_email = "support@sleepycat.com",
      url = "http://www.sleepycat.com/products/xml.shtml",
      py_modules = ["dbxml"],
      ext_modules = [Extension("_dbxml", ["dbxml_python_wrap.cpp"],
                               include_dirs = INCLUDES,
                               library_dirs = LIBDIRS,
                               libraries = LIBS)],
      data_files = DATAFILES)
