<?php

/* ----------------------------------------------------------------------------
 * This file is a very simple example of using PHP with DB XML.
 * If the DB XML PHP module is properly installed, it should run
 * with the command line:
 *    php dbxml_example.php
 * It will create a file, test.dbxml, which can be removed.
 * The script doesn't do anything useful. It's mostly a smoke test.
 * Interesting things to note on PHP Syntax using SWIG-generated code:
 *   o NULL is passed using the string, "NULL"
 *   o PHP doesn't support function overloads, so all arguments must
 *     be passed, even what would be defaults in C++ or other script.
 *   o Class instances are created using $instance = new MyClass(arguments);
 *   o Class functions are referenced by $instance->functionName();
 *   o PHP takes care of deletion of objects (there does not
 *     appear to be any way to delete in a script).
 *
 * If there are problems running this script, check your DB XML installation,
 * as well as the PHP module installation.
 *
 * ----------------------------------------------------------------------------- */

global $DBXML_PHP4_LOADED__;
if ($DBXML_PHP4_LOADED__) return;
$DBXML_PHP4_LOADED__ = true;

/* if our extension has not been loaded, do what we can */
if (!extension_loaded("dbxml_php4")) {
	if (!dl("dbxml_php4.so")) return;
}

/*
 * Simple: create an XmlDocument with simple content and put it in a new
 *  XmlContainer.  For something else to do, modify it slightly.
 */

/* the document */
$xd = new XmlDocument();
$xd->setContent("<?xml version='1.0' ?><root/>");
echo "Document content is:\n\t" . $xd->getContent() . "\n";

/* the container */
$cont = new XmlContainer("NULL", "test.dbxml");
$cont->open("NULL", DB_CREATE, 0);
$id = $cont->putDocument("NULL", $xd, "NULL");
echo "Created document in the container, id is " . $id . "\n";

/* 
 * modify the document; do this with a container operation.  It
 * could just as easily use XmlDocument::modifyDocument.
 */
$xmod = new XmlModify("/root", XmlModify_Append, XmlModify_Element, "newelem", "", -1);
$cont->modifyDocument("NULL", $xmod, "NULL", 0);

/* get the modified document, and echo it */
$xd1 = $cont->getDocument("NULL", $id, 0);
echo "Modified document, from container, modified content is:\n\t" . $xd1->getContent() . "\n";

?>
