dnl $Id: config.m4,v 1.1 2004/01/21 18:52:19 gmf Exp $
dnl ***********************************************************************
dnl ** THIS config.m4 is provided for PHPIZE and PHP's consumption NOT
dnl ** for any part of the rest of the dbxml_php4 build system
dnl ***********************************************************************

PHP_ARG_ENABLE(dbxml_php4, whether to enable dbxml_php4 support,
[  --enable-dbxml_php4             Enable dbxml_php4 support])

if test "$PHP_DBXML_PHP4" != "no"; then

  PHP_SUBST(DBXML_PHP4_SHARED_LIBADD)

  # As this is a C++ module..
  PHP_REQUIRE_CXX
  AC_CHECK_LIB(stdc++, cin)
  AC_DEFINE(HAVE_DBXML_PHP4, 1, [ ])
dnl  AC_DEFINE_UNQUOTED(PHP_DBXML_PHP4_DIR, "$DBXML_PHP4_DIR", [ ])
  PHP_EXTENSION(dbxml_php4, $ext_shared)
fi

dnl  BerkeleyDB
if test -z "$PHP_BERKELEYDB"; then
  PHP_ARG_WITH(berkeleydb, for the location of Berkeley DB,
  --with-berkeleydb[=DIR]  DBXML_PHP: define location of Berkeley DB,
  /usr/local/BerkeleyDB.4.2, no)
fi

dnl  DBXML
if test -z "$PHP_DBXML_DIR"; then
  PHP_ARG_WITH(dbxml-dir, for the location of Berkeley DB XML,
  --with-dbxml-dir[=DIR]  DBXML_PHP: define location of Berkeley DB XML,
  /usr/local/BerkeleyDBXML.1.2, no)
fi

dnl  Xerces
if test -z "$PHP_XERCES"; then
  PHP_ARG_WITH(xerces, for the location of Xerces,
  --with-xerces[=DIR]  DBXML_PHP: define location of Xerces installation,
  /usr/local, no)
fi

dnl  Pathan
if test -z "$PHP_PATHAN"; then
  PHP_ARG_WITH(pathan, for the location of Xerces,
  --with-pathan[=DIR]  DBXML_PHP: define location of Pathan installation,
  /usr/local, no)
fi

dnl Add DBXML include/lib
dnl NOTE: this checks for the static lib, *.a.  This may need to
dnl change, based on particular build choices.  Just use a library
dnl that should exist.
if test -f $PHP_DBXML_DIR/lib/libdbxml-1.2.a; then
   PHP_ADD_LIBRARY_WITH_PATH(dbxml, $PHP_DBXML_DIR/lib, EXTRA_LDFLAGS)
   PHP_ADD_INCLUDE($PHP_DBXML_DIR/include)
else
  AC_MSG_WARN([If configure fails, try --with-dbxml-dir=<DIR>])
fi

dnl Add DB include/lib
dnl NOTE: this checks for the static lib, *.a.  This may need to
dnl change, based on particular build choices.  Just use a library
dnl that should exist.
if test -f $PHP_BERKELEYDB/lib/libdb_cxx.a; then
   PHP_ADD_LIBRARY_WITH_PATH(db_cxx, $PHP_BERKELEYDB/lib, EXTRA_LDFLAGS)
   PHP_ADD_INCLUDE($PHP_BERKELEYDB/include)
else
  AC_MSG_WARN([If configure fails, try --with-berkeleydb=<DIR>])
fi

dnl Add Pathan include/lib
dnl NOTE: this checks for the static lib, *.a.  This may need to
dnl change, based on particular build choices.  Just use a library
dnl that should exist.
if test -f $PHP_PATHAN/lib/libpathan.a; then
   PHP_ADD_LIBRARY_WITH_PATH(pathan, $PHP_PATHAN/lib, EXTRA_LDFLAGS)
   PHP_ADD_INCLUDE($PHP_PATHAN/include)
else
  AC_MSG_WARN([If configure fails, try --with-pathan=<DIR>])
fi

dnl Add Xerces include/lib
dnl NOTE: this checks for the dynamic lib, *.so.  This may need to
dnl change, based on particular build choices, and platform (e.g)
dnl OS X uses .dylib.  Just use a library that should exist.
if test -f $PHP_XERCES/lib/libxerces-c.so; then
   PHP_ADD_LIBRARY_WITH_PATH(xerces-c, $PHP_XERCES/lib, EXTRA_LDFLAGS)
   PHP_ADD_INCLUDE($PHP_XERCES/include)
else
  AC_MSG_WARN([If configure fails, try --with-xerces=<DIR>])
fi




