
use strict;
use warnings;

use Cwd ;
use File::Path;

my $here = cwd ;
my $temp_dir = "./tmp" ;
my $example_dir = "../../examples" ;

use Test::More tests => 33 ;

sub runExample
{
    my $command = shift ;
    my $expected_output = shift ;
    my $expected_stderr = shift || "";
    

    rmtree $temp_dir ;
    mkdir $temp_dir ;
    chdir $temp_dir ;

    #warn "# Running $^X -Mblib $example_dir/$command 2>stderr\n";
    my $data = `$^X -Mblib $example_dir/$command 2>stderr`;

    is $?, 0, "$command - exited with 0";

    open F, "<stderr" || die "Cannot open stderr: $!\n" ;
    local $/;
    my $stderr = <F>;
    close F;
    unlink "stderr";

    $stderr =~ s#^Using\s+.*?blib\n##;

    is $data, $expected_output, "$command - expected output ok" ;
    is $stderr, $expected_stderr, "$command - expected stderr ok" ;

    chdir $here ;
    rmtree $temp_dir ;

    return $data ;
}

{
    # example 1

    runExample "example1", <<EOM;
1  = 	    <book>
	        <title>
		    Knowledge Discovery in Databases.
		</title>
	    </book>

EOM

}
    
{
    # example 2

    runExample "example2", <<EOM;
1 = 	    <book>
	        <title>
		    Knowledge Discovery in Databases.
		</title>
	    </book>

EOM

}
    
{
    # example 3

    runExample "example3", <<EOM;
1 = 	<book xmlns:books1='http://foo.bar.com/books.dtd'>
	    <books1:title>Knowledge Discovery in Databases.</books1:title>
	</book>

EOM

}
    
{
    # example 4

    runExample "example4", <<EOM;
1 = <book><title>Knowledge Discovery in Databases.</title></book>
EOM

}
    
{
    # example 5

    runExample "example5", <<EOM;
1 = <book><title>Knowledge Discovery in Databases.</title></book>
EOM

}
    
{
    # example 6

    runExample "example6", "", <<EOM;
Error: DbEnv::dbrename: File exists in ../../examples/example6, line 21
EOM

}
    
{
    # example 7

    runExample "example7", <<EOM;
1 = <book><title>Knowledge Discovery in Databases.</title></book>
EOM

}
    
{
    # example 8

    runExample "example8", <<EOM;
1 = <book><title>Knowledge Discovery in Databases.</title></book>
EOM

}
    
{
    # example 9

    runExample "example9", <<EOM;
EOM

}
    
{
    # example 10

    runExample "example10", <<EOM;
EOM

}
    
#{
#    # example 11 
#
#    runExample "example11", <<EOM;
#EOM
#
#}
    
{
    # example 12 

    runExample "example12", <<EOM;
:title node-element-equality-string edge-element-equality-string
EOM

}
    
