use 5.006001;
use ExtUtils::MakeMaker;
use lib '..';

use Config;

require 'util';

my %parsed = parseConfig("..");

my $libs = join " ", 
           map { $a = $parsed{$_}; $a = "-l$a" unless $a =~ /^-l/; $a } 
	   qw( DBXML_LIB_NAME BDB_LIB_NAME PATHAN_LIB_NAME XERCES_LIB_NAME) ;

if ($^O eq 'solaris' && $Config{'cc'} eq 'cc')
{
    $libs = ' -lCstd -lCrun -lm ' ;
}



WriteMakefile(
    'NAME'		=> 'Sleepycat::DbXml',
    'VERSION_FROM'	=> 'DbXml.pm', 
    ($] >= 5.005 ?    
      (#ABSTRACT_FROM => 'DbXml.pm', # retrieve abstract from module
       AUTHOR     => 'Paul Marquess <pmqs@cpan.org>') : ()),
    'LIBS'		=> ["$parsed{LIBS} $libs "], 
    'DEFINE'		=> '', 
    'INC'		=> $parsed{INCS}, 
    'XSOPT'		=> '-noprototypes -C++ -typemap ../typemap',
    'macro'		=> { 'CC' => $parsed{CC}, 'LD'	=> '$(CC)' } ,
);

if  (eval {require ExtUtils::Constant; 1}) {
  # If you edit these definitions to change the constants used by this module,
  # you will need to use the generated const-c.inc and const-xs.inc
  # files to replace their "fallback" counterparts before distributing your
  # changes.
  my @names = ();

  push @names,  map { 
	  { name => "DbXml::$_", 
	    macro => 1 } 
	 } (

	# enum LogLevel

	'LEVEL_NONE',
	'LEVEL_DEBUG',
	'LEVEL_INFO',
	'LEVEL_WARNING',
	'LEVEL_ERROR',
	'LEVEL_ALL',


	# enum LogCategory

	'CATEGORY_NONE',
	'CATEGORY_INDEXER',
	'CATEGORY_QUERY',
	'CATEGORY_OPTIMIZER',
	'CATEGORY_DICTIONARY',
	'CATEGORY_CONTAINER',
	'CATEGORY_ALL',

);

  push @names,  map { 
	  { name => $_, 
	    macro => 1 } 
	 } qw(

	DBXML_VERSION_MAJOR
	DBXML_VERSION_MINOR
	DBXML_VERSION_PATCH

);

  push @names,  map { 
	  { name => "DbXml::$_", 
            type => 'PVN',
	    #pre => "\tint tmp = $_;", 
	    value => [$_, length($_)], 
	    macro => 1 } 
	 } qw(

	 metaDataNamespace_uri
	 metaDataName_uri_id
	 metaDataName_uri_default
	 metaDataNamespace_prefix
	 metaDataName_id
	 metaDataName_name
	 metaDataName_content
	 metaDataName_default
	 metaDataNamespace_prefix_debug

	 DBXML_VERSION_STRING

) ;

  # enum XmlException::ExceptionCode
  push @names,  map { 
	  { name => "XmlException::$_", 
            pre => "\tDbXml::XmlException::ExceptionCode tmp = XmlException::$_ ;", 
	    value => "(IV)tmp", 
	    macro => 1 } 
	 } qw(

	
	INTERNAL_ERROR
	CONTAINER_OPEN
	CONTAINER_CLOSED
	CONTAINER_PASSED_WRONG_OBJECT
	INDEXER_PARSER_ERROR
	DATABASE_ERROR
	XPATH_PARSER_ERROR
	DOM_PARSER_ERROR
	XPATH_EVALUATION_ERROR
	NO_VARIABLE_BINDING
	LAZY_EVALUATION
	DOCUMENT_NOT_FOUND
	CONTAINER_EXISTS
	UNKNOWN_INDEX
	INVALID_VALUE
	VERSION_MISMATCH
	);
	

  # enum XmlQueryContext::ReturnType
  push @names,  map { 
	  { name => "XmlQueryContext::$_", 
            pre => "\tDbXml::XmlQueryContext::ReturnType tmp = XmlQueryContext::$_;", 
	    value => "(IV)tmp", 
	    macro => 1 } 
	 } qw(
	
	ResultDocuments
	ResultValues
	CandidateDocuments
	ResultDocumentsAndValues
	);

  # enum XmlQueryContext::EvaluationType
  push @names,  map { 
	  { name => "XmlQueryContext::$_", 
            pre => "\tDbXml::XmlQueryContext::EvaluationType tmp = XmlQueryContext::$_;", 
	    value => "(IV)tmp", 
	    macro => 1 } 
	 } qw(
	
	Eager
	Lazy
	);


  # enum XmlValue::Type
  push @names,  map { 
	  { name => "XmlValue::$_", 
            pre => "\tDbXml::XmlValue::Type tmp = XmlValue::$_;", 
	    value => "(IV)tmp", 
	    macro => 1 } 
	 } qw(
	
            NONE
            STRING
            NUMBER
            BOOLEAN
            DOCUMENT
            NODE
            VARIABLE
            BINARY

	);


  # enum XmlModify::ModificationType
  push @names,  map { 
	  { name => "XmlModify::$_", 
            pre => "\tDbXml::XmlModify::ModificationType tmp = XmlModify::$_;", 
	    value => "(IV)tmp", 
	    macro => 1 } 
	 } qw(
	
                InsertAfter
                InsertBefore
                Append
                Update
                Remove
                Rename
                Empty
	 
	);

	  
  # enum XmlModify::XmlObject
  push @names,  map { 
	  { name => "XmlModify::$_", 
            pre => "\tDbXml::XmlModify::XmlObject tmp = XmlModify::$_;", 
	    value => "(IV)tmp", 
	    macro => 1 } 
	 } qw(
	
                Element
                Attribute
                Text
                ProcessingInstruction
                Comment
                None
	 
	);

	  
  ExtUtils::Constant::WriteConstants(
                                     NAME         => 'DbXml',
                                     NAMES        => \@names,
                                     DEFAULT_TYPE => 'IV',
                                     C_FILE       => 'const-c.inc',
                                     XS_FILE      => 'const-xs.inc',
                                  );

}
else {
  use File::Copy;
  use File::Spec;
  foreach my $file ('const-c.inc', 'const-xs.inc') {
    my $fallback = File::Spec->catfile('fallback', $file);
    copy ($fallback, $file) or die "Can't copy $fallback to $file: $!";
  }
}
