
//#include <iostream>
#include <fstream>
//#include <math.h> //for isnan
#include "dbxml/DbXml.hpp"

using namespace std;
using namespace DbXml;

extern "C" {

  #include "EXTERN.h"
  #include "perl.h"
  #include "XSUB.h"
  
  #include "../ppport.h"
  
  #include "const-c.inc"

}

#include "../common.h"

typedef Dbt DbtPtr ;


typedef std::string	std__string;

//typedef struct {
//	DbXml::XmlContainer *	container ;
//	//DbEnv *			env ;
//
//    } ContainType;
//
//typedef ContainType * DbXml__XmlContainer ;

typedef	XmlQueryContext::ReturnType XmlQueryContext__ReturnType;
typedef	XmlQueryContext::EvaluationType XmlQueryContext__EvaluationType;
typedef	XmlException::ExceptionCode XmlException__ExceptionCode;
typedef	XmlValue::Type XmlValue__Type;
typedef	XmlModify::ModificationType XmlModify__ModificationType;
typedef	XmlModify::XmlObject XmlModify__XmlObject;

typedef Dbt	Dbt_or_pv;


#if 0
	catch(XmlException & e)
	{
	    cout << "Caught Exception in XSUB " << e.what() << endl ;

	 if (1)
	 {
	    // Take a copy of the C++ exception
	    XmlException * e_copy = new XmlException(e);

	    // Store it in an SV
            SV * except = sv_newmortal();
            sv_setref_pv(except, "XmlException", (void*)e_copy);
            SV * errsv = get_sv("@", TRUE);
	    sv_setsv(errsv, except);
	    croak(Nullch);
	}
	if (0)
	{
	    text = (char*)e.what();
	    value = (int)e.getExceptionCode();
	    dberr = e.getDbErrno();

	    //HV * hash = newHV();
	    //my_hv_store(hash, "-text", newSVpv(e.what(), 0));
	    //my_hv_store(hash, "-value", newSViv((IV)e.getExceptionCode()));
	    //my_hv_store(hash, "-dberrno", newSViv(e.getDbErrno()));
	    //exc = newRV((SV*)hash);
	}
	    if (0)
	    {
	    HV * hash = newHV();


	    //my_hv_store(hash, "-text", newSVpv(e.what(), 0));
	    my_hv_store(hash, "-value", newSViv((IV)e.getExceptionCode()));
	    my_hv_store(hash, "-dberrno", newSViv(e.getDbErrno()));
	    //my_hv_store(except, "__INNER__", newSViv(e_copy)));

	    SV * except = newRV((SV*)hash);

	    sv_bless((SV*)except, gv_stashpv("XmlException", FALSE));
	    //newSVrv((SV*)except, "DbXml::XmlException");

	    // do a die $object
            SV * errsv = get_sv("@", TRUE);
	    sv_setsv(errsv, (SV*)except);
	    croak(Nullch);
	    }
	}
#endif

#if 0

XmlContainer*
XmlContainer::new(...)
	INIT:
	    MY_TRY
	CODE:
	{
		//XmlContainer::new(char * name, u_int32_t flags=0)
	    // Valid forms are
	    //    new(env, name, flags)
	    //    new(env, name)
	    //    new(name)
	    //    new(name, flags)
	    //
	    if (items < 2 || items > 4)
	        Perl_croak(aTHX_ "Usage");

	    DbEnv * env = NULL;
	    u_int32_t flags = 0;
	    int index = 1;

	    // Deal with optional environment first
	    if (Sv_ISA(1, "DbEnv")) {
	        env = GetObjPointer(0, DbEnv);
		++ index ;
	    }

	    if (items < 1)
	        Perl_croak(aTHX_ "Usage");

	    // next thing must be a the name
	    const char* name = GetStringPointer(index) ;

	    if (items == 2)
	        flags = GetUV(index+1, u_int32_t);

	    RETVAL = new XmlContainer(env, name, flags);
	}
	OUTPUT:
	    RETVAL
	CLEANUP:
	    MY_CATCH

#endif


static void
dumpXmlValue(XmlValue & value, XmlQueryContext * context=NULL)
{
    if (value.isNull())
        cout << "value is NULL\n" ;
    else
    {
	XmlValue::Type type = value.getType(context);
	if (type == XmlValue::BOOLEAN)
	    cout << "Type is Boolean, value is " << value.asBoolean(context) << endl;
	else if (type == XmlValue::NUMBER)
	    cout << "Type is Number, value is " << value.asNumber(context) << endl;
	else if (type == XmlValue::STRING)
	    cout << "Type is String, value is " << value.asString(context) << endl;
	else if (type == XmlValue::DOCUMENT) {
	    cout << "Type is Document, value is "<<  value.asString(context) << endl;

	}
	else if (type == XmlValue::NODE)
	    cout << "Type is Node"  << endl;
	else if (type == XmlValue::VARIABLE)
	    cout << "Type is Variable"  << endl;
	else if (type == XmlValue::BINARY)
	    cout << "Type is Binary"  << endl;
	else if (type == XmlValue::NONE)
	    cout << "Type is None"  << endl;
	else 
	    cout << "Type is Unknown"  << endl;
    }

}


MODULE = DbXml		PACKAGE = DbXml		

INCLUDE: const-xs.inc

MODULE = DbXml		PACKAGE = DbXml		

void
setLogLevel(int level, bool enabled)
	INIT:
	    MY_TRY
	CODE:
	{
	    setLogLevel((LogLevel)level, enabled);
	}
	CLEANUP:
	    MY_CATCH

void
setLogCategory(int category, bool enabled)
	INIT:
	    MY_TRY
	CODE:
	{
	    setLogCategory((LogCategory)category, enabled);
	}
	CLEANUP:
	    MY_CATCH

const char*
dbxml_version(int major, int minor, int patch)
	INIT:
	    MY_TRY
	CODE:
	{
            RETVAL = dbxml_version(&major, &minor, &patch);
	}
	OUTPUT:
	    major
	    minor
	    patch
	    RETVAL
	CLEANUP:
	    MY_CATCH


const char*
xerces_version()
	CODE:
	{
            RETVAL = gXercesFullVersionStr;
	}
	OUTPUT:
	    RETVAL

MODULE = _XmlContainer	PACKAGE = _XmlContainer

XmlContainer*
XmlContainer::new(DbEnv* env, string name, u_int32_t flags=0)
	INIT:
	    MY_TRY
	OUTPUT:
	    RETVAL
	CLEANUP:
	    MY_CATCH

MODULE = XmlContainer	PACKAGE = XmlContainer

void
XmlContainer::DESTROY()
	INIT:
	    MY_TRY
	CLEANUP:
	    MY_CATCH

bool
XmlContainer::_exists(DbTxn* txnid)
	INIT:
	    MY_TRY
	CODE:
	{
	    RETVAL = THIS->exists(txnid);
	}
	OUTPUT:
	    RETVAL
	CLEANUP:
	    MY_CATCH


void
XmlContainer::_open(DbTxn* txnid, u_int32_t flags=0, int mode=0)
	INIT:
	    MY_TRY
	CODE:
	{
	    THIS->open(txnid, flags, mode);
	}
	CLEANUP:
	    MY_CATCH


void
XmlContainer::close(u_int32_t flags=0)
	INIT:
	    MY_TRY
	CLEANUP:
	    MY_CATCH

void
XmlContainer::upgrade(u_int32_t flags=0)
	INIT:
	    MY_TRY
	CLEANUP:
	    MY_CATCH

void
XmlContainer::deleteDocument_1(DbTxn* txnid, XmlDocument* document, XmlUpdateContext *context=0, u_int32_t flags=0)
	INIT:
	    MY_TRY
	CODE:
	{
            THIS->deleteDocument(txnid, *document, context, flags);
	}
	CLEANUP:
	    MY_CATCH

void
XmlContainer::_updateDocument(DbTxn* txnid, XmlDocument* document, XmlUpdateContext *context=0)
	INIT:
	    MY_TRY
	CODE:
	{
            THIS->deleteDocument(txnid, *document, context);
	}
	CLEANUP:
	    MY_CATCH


void
XmlContainer::deleteDocument_2(DbTxn* txnid, u_int32_t id, XmlUpdateContext *context=0, u_int32_t flags=0)
	INIT:
	    MY_TRY
	CODE:
	{
            THIS->deleteDocument(txnid, id, context, flags);
	}
	CLEANUP:
	    MY_CATCH

void
XmlContainer::dump(const char* filename, u_int32_t flags=0)
	INIT:
	    MY_TRY
	CODE:
	{
	    std::ofstream out(filename) ;
	    THIS->dump(&out, flags);
	}
	CLEANUP:
	    MY_CATCH

void
XmlContainer::_setIndexSpecification(DbTxn *txnid, XmlIndexSpecification * index)
	INIT:
	    MY_TRY
	CODE:
	{
	    THIS->setIndexSpecification(txnid, *index);
	}
	CLEANUP:
	    MY_CATCH

XmlIndexSpecification *
XmlContainer::_getIndexSpecification(DbTxn *txnid)
	char *	CLASS = (char *)"XmlIndexSpecification";
	INIT:
	    MY_TRY
	CODE:
	{
	    RETVAL = new XmlIndexSpecification(
			    THIS->getIndexSpecification(txnid));
	}
	OUTPUT:
	    RETVAL
	CLEANUP:
	    MY_CATCH

void	    
XmlContainer::_addIndex(DbTxn * txnid, string uri, string name, string index)
	INIT:
	    MY_TRY
	CODE:
	{
	        THIS->addIndex(txnid, uri, name, index);
	}
	CLEANUP:
	    MY_CATCH

void	    
XmlContainer::_deleteIndex(DbTxn * txnid, string uri, string name, string index)
	INIT:
	    MY_TRY
	CODE:
	{
	        THIS->addIndex(txnid, uri, name, index);
	}
	CLEANUP:
	    MY_CATCH

void	    
XmlContainer::_replaceIndex(DbTxn * txnid, string uri, string name, string index)
	INIT:
	    MY_TRY
	CODE:
	{
	        THIS->addIndex(txnid, uri, name, index);
	}
	CLEANUP:
	    MY_CATCH

bool
XmlContainer::isOpen()
	INIT:
	    MY_TRY
	CLEANUP:
	    MY_CATCH

void
XmlContainer::verify(const char* filename, u_int32_t flags=0)
	INIT:
	    MY_TRY
	CODE:
	{
	        std::ofstream out(filename) ;
	        THIS->dump(&out, flags);
	}
	CLEANUP:
	    MY_CATCH

void
XmlContainer::_load(const char* filename, unsigned long lineno, u_int32_t flags=0)
	INIT:
	    MY_TRY
	CODE:
	{
	    std::ifstream in(filename) ;
	    THIS->load(&in, &lineno, flags);
	}
	OUTPUT:
	    lineno
	CLEANUP:
	    MY_CATCH

void
XmlContainer::_modifyDocument(DbTxn* txnid, XmlModify * xmlModify, XmlUpdateContext * context=NULL, u_int32_t flags=0)
	INIT:
	    MY_TRY
	CODE:
	{
	    THIS->modifyDocument(txnid, *xmlModify, context, flags);

	}
	CLEANUP:
	    MY_CATCH

string
XmlContainer::getName()
	INIT:
	    MY_TRY
	OUTPUT:
	    RETVAL
	CLEANUP:
	    MY_CATCH

void
XmlContainer::setName(string newName)
	INIT:
	    MY_TRY
	CLEANUP:
	    MY_CATCH

void
XmlContainer::_rename(DbTxn* txnid, char * newName, u_int32_t flags=0)
	INIT:
	    MY_TRY
	CODE:
	{
	    THIS->rename(txnid, newName, flags);
	}
	CLEANUP:
	    MY_CATCH

void
XmlContainer::_remove(DbTxn* txnid=NULL, u_int32_t flags=0)
	INIT:
	    MY_TRY
	CODE:
	{
	    THIS->remove(txnid, flags);
	}
	CLEANUP:
	    MY_CATCH

u_int32_t
XmlContainer::_putDocument(DbTxn* txnid, XmlDocument * document, XmlUpdateContext *context=0, u_int32_t flags=0)
	INIT:
	  MY_TRY
	CODE:
	{
	    RETVAL = THIS->putDocument(txnid, *document, context, flags);
	}
	OUTPUT:
	    RETVAL
	CLEANUP:
	    MY_CATCH

XmlDocument* 	
XmlContainer::_getDocument(DbTxn* txnid, u_int32_t id, u_int32_t flags=0)
	char *	CLASS = (char *)"XmlDocument";
	INIT:
	    MY_TRY
	CODE:
	{
	    RETVAL = new XmlDocument(THIS->getDocument(txnid, id, flags));
	}
	OUTPUT:
	    RETVAL
	CLEANUP:
	    MY_CATCH


XmlQueryExpression* 	
XmlContainer::_parseXPathExpression(DbTxn* txnid, string xpath, XmlQueryContext* context=NULL)
	char *	CLASS = (char *)"XmlQueryExpression";
	INIT:
	    MY_TRY
	CODE:
	{
	    RETVAL = new XmlQueryExpression(
			    THIS->parseXPathExpression(txnid, xpath, context));
	}
	OUTPUT:
	    RETVAL
	CLEANUP:
	    MY_CATCH


XmlResults* 	
XmlContainer::_queryWithXPath_1(DbTxn * txnid, string query, XmlQueryContext* context=NULL, u_int32_t flags=0)
	char *	CLASS = (char *)"XmlResults";
	INIT:
	    MY_TRY
	CODE:
	{
	    RETVAL = new XmlResults(
			    THIS->queryWithXPath(txnid, query, context, flags));
	}
	OUTPUT:
	    RETVAL
	CLEANUP:
	    MY_CATCH

XmlResults* 	
XmlContainer::_queryWithXPath_2(DbTxn * txnid, XmlQueryExpression * expression, u_int32_t flags=0)
	char *	CLASS = (char *)"XmlResults";
	INIT:
	    MY_TRY
	CODE:
	{
	    RETVAL = new XmlResults(
			    THIS->queryWithXPath(txnid, *expression, flags));
	}
	OUTPUT:
	    RETVAL
	CLEANUP:
	    MY_CATCH


void
XmlContainer::setPageSize(u_int32_t pagesize)
	INIT:
	    MY_TRY
	CLEANUP:
	    MY_CATCH


MODULE = XmlDocument	PACKAGE = XmlDocument

XmlDocument*
XmlDocument::new()
	INIT:
	    MY_TRY
	CLEANUP:
	    MY_CATCH

void
XmlDocument::DESTROY()
	INIT:
	    MY_TRY
	CLEANUP:
	    MY_CATCH

XmlResults* 	
XmlDocument::_queryWithXPath_1(string query, XmlQueryContext* context=NULL)
	char *	CLASS = (char *)"XmlResults";
	INIT:
	    MY_TRY
	CODE:
	{
	    RETVAL = new XmlResults(
			    THIS->queryWithXPath(query, context));
	}
	OUTPUT:
	    RETVAL
	CLEANUP:
	    MY_CATCH

XmlResults* 	
XmlDocument::_queryWithXPath_2(XmlQueryExpression * expression)
	char *	CLASS = (char *)"XmlResults";
	INIT:
	    MY_TRY
	CODE:
	{
	    RETVAL = new XmlResults(
			    THIS->queryWithXPath(*expression));
	}
	OUTPUT:
	    RETVAL
	CLEANUP:
	    MY_CATCH


void
XmlDocument::_setContentXX(SV * content)
	INIT:
	    MY_TRY
	CODE:
	{
		// TODO merge the two setContent's into one
		// need a better test for a Dbt
	    if (content == &PL_sv_undef || SvTYPE(content) == SVt_NULL)
	        THIS->setContent("");
	    else if (sv_isobject(content) && (SvTYPE(SvRV(content)) == SVt_PVMG)){
		Dbt* to = (Dbt*)SvIV((SV*)SvRV( content ));
	        THIS->setContent(*to);
	    }
	    else {
	        char * ptr = SvPV_nolen(content);
	        THIS->setContent(ptr);
	    }
	}
	CLEANUP:
	    MY_CATCH

void
XmlDocument::_setContent_dbt(Dbt * content)
	INIT:
	    MY_TRY
	CODE:
	{
	    THIS->setContent(*content);
	}
	CLEANUP:
	    MY_CATCH

void
XmlDocument::_setContent_string(string content)
	INIT:
	    MY_TRY
	CODE:
	{
	    THIS->setContent(content);
	}
	CLEANUP:
	    MY_CATCH

void
XmlDocument::setName(string name)
	INIT:
	    MY_TRY
	CLEANUP:
	    MY_CATCH

u_int32_t
XmlDocument::getID()
	INIT:
	    MY_TRY
	CLEANUP:
	    MY_CATCH

string
XmlDocument::getContentAsString()
	INIT:
	    MY_TRY
	CODE:
	{
	    THIS->getContentAsString(RETVAL);
	}
	OUTPUT:
	    RETVAL
	CLEANUP:
	    MY_CATCH

const DbtPtr*
XmlDocument::getContent()
	char *	CLASS = (char *)"DbtPtr";
	INIT:
	    MY_TRY
	OUTPUT:
	    RETVAL
	CLEANUP:
	    MY_CATCH

string
XmlDocument::getName()
	INIT:
	    MY_TRY
	OUTPUT:
	    RETVAL
	CLEANUP:
	    MY_CATCH

void
XmlDocument::_setMetaData_XmlValue(string uri, string prefix, string name, XmlValue* value)
	INIT:
	    MY_TRY
	CODE:
	{
	    THIS->setMetaData(uri, prefix, name, *value);
	}
	CLEANUP:
	    MY_CATCH

void
XmlDocument::_setMetaData_Dbt(string uri, string prefix, string name, SV* value)
	INIT:
	    MY_TRY
	CODE:
	{
	            
	    Dbt* dbt_value ;
	    bool del_value = false ;
	    STRLEN len ;

	    getDBT(value, dbt_value, del_value);
	    //cout << "PUT " << (char*)dbt_value->get_data() <<endl ;

	    THIS->setMetaData(uri, prefix, name, *dbt_value);

	    if (del_value)
	        delete dbt_value ;
	}
	CLEANUP:
	    MY_CATCH

bool
XmlDocument::_getMetaData_XmlValue(string uri, string name, XmlValue* value)
	INIT:
	    MY_TRY
	CODE:
	{
	    RETVAL = THIS->getMetaData(uri, name, *value);
	}
	OUTPUT:
	    RETVAL
	CLEANUP:
	    MY_CATCH

bool
XmlDocument::_getMetaData_Dbt(string uri, string name, SV* value)
	INIT:
	    MY_TRY
	CODE:
	{
	    Dbt* dbt_value ;
	    bool del_value = false ;
	    STRLEN len ;

	    getDBT(value, dbt_value, del_value);

	    RETVAL = THIS->getMetaData(uri, name, *dbt_value);

	    //if (RETVAL)
		    //cout << "GOT " << (char*)dbt_value->get_data() <<endl ;
    	    if (del_value) {
		if (RETVAL) 
		    putDBT(value, dbt_value);
	        delete dbt_value;
	    }

	}
	OUTPUT:
	    RETVAL
	CLEANUP:
	    MY_CATCH

void
XmlDocument::modifyDocument(XmlModify * xmlModify)
	INIT:
	    MY_TRY
	CODE:
	{
	    THIS->modifyDocument(*xmlModify);
	}
	CLEANUP:
	    MY_CATCH


MODULE = XmlQueryContext	PACKAGE = XmlQueryContext


XmlQueryContext*
XmlQueryContext::new(rt=XmlQueryContext::ResultDocuments, et=XmlQueryContext::Eager)
	XmlQueryContext::ReturnType		rt
	XmlQueryContext::EvaluationType		et
	INIT:
	    MY_TRY
	CLEANUP:
	    MY_CATCH
	

void
XmlQueryContext::DESTROY()
	INIT:
	    MY_TRY
	CLEANUP:
	    MY_CATCH

void
XmlQueryContext::clearNamespaces()
	INIT:
	    MY_TRY
	CLEANUP:
	    MY_CATCH
	
void
XmlQueryContext::setNamespace(string prefix, string uri)
	INIT:
	    MY_TRY
	CLEANUP:
	    MY_CATCH
	
string
XmlQueryContext::getNamespace(string prefix)
	INIT:
	    MY_TRY
	OUTPUT:
	    RETVAL
	CLEANUP:
	    MY_CATCH

void
XmlQueryContext::removeNamespace(string prefix)
	INIT:
	    MY_TRY
	CLEANUP:
	    MY_CATCH
	
void
XmlQueryContext::setEvaluationType(XmlQueryContext::EvaluationType type)
	INIT:
	    MY_TRY
	CLEANUP:
	    MY_CATCH
	
XmlQueryContext::EvaluationType
XmlQueryContext::getEvaluationType()
	INIT:
	    MY_TRY
	OUTPUT:
	    RETVAL
	CLEANUP:
	    MY_CATCH


void
XmlQueryContext::setReturnType(XmlQueryContext::ReturnType type);
	INIT:
	    MY_TRY
	CLEANUP:
	    MY_CATCH
	
XmlQueryContext::ReturnType
XmlQueryContext::getReturnType()
	INIT:
	    MY_TRY
	OUTPUT:
	    RETVAL
	CLEANUP:
	    MY_CATCH


void
XmlQueryContext::setVariableValue(string prefix, SV * value);
	INIT:
	    MY_TRY
	CODE:
	{
	    if (! SV_IS_OBJECT(value)) {
		STRLEN len;
		char * ptr = SvPV(value, len);
		const string str(ptr, len);
	        THIS->setVariableValue(prefix, str);
	    }
	    else if (sv_derived_from(value, "XmlValue"))
	        THIS->setVariableValue(prefix, *GetObjPointer(value, XmlValue));
	    else 
	        croak("SetVariableValue parameter 2 should be an XmlValue or a string");
	}
	CLEANUP:
	    MY_CATCH

void
XmlQueryContext::getVariableValue(string prefix, XmlValue * value);
	INIT:
	    MY_TRY
	CODE:
	{
	    THIS->getVariableValue(prefix, *value);
	}
	CLEANUP:
	    MY_CATCH


void
XmlQueryContext::setWithMetaData(bool withMetaData);
	INIT:
	    MY_TRY
	CLEANUP:
	    MY_CATCH

bool
XmlQueryContext::getWithMetaData();
	INIT:
	    MY_TRY
	OUTPUT:
	    RETVAL
	CLEANUP:
	    MY_CATCH

MODULE = XmlValue	PACKAGE = XmlValue

XmlValue*
XmlValue::new(...)
	INIT:
	    MY_TRY
	CODE:
	{
	    if (items == 1)
	        RETVAL = new XmlValue();
	    else if (items == 2)
	    {
	        STRLEN len;
	        char* ptr = SvPV(ST(1), len);
	        const string str(ptr, len);
	        RETVAL = new XmlValue(XmlValue::STRING, str);
	    }
	    else if (items == 3)
	    {
	        XmlValue::Type type = (XmlValue::Type)SvUV(ST(1));
	        SV * value = ST(2);

	        if (type == XmlValue::BOOLEAN)
		    // The Solaris C++ compiler doesn't like this
		    // so create a boolean in a more roundabout way.
	            //RETVAL = new XmlValue((bool)SvIV(value));
	            RETVAL = new XmlValue(type, SvIV(value) ? "true" : "false");
	        else if (type == XmlValue::NUMBER)
	            RETVAL = new XmlValue((double)SvNV(value));
	        else {
	            STRLEN len;
	            char* ptr = SvPV(value, len);
	            const string str(ptr, len);
	            RETVAL = new XmlValue(type, str);
	        }
	    }
	    else 
	    {
	        croak("XmlValue::new expects between 0 & 2 parameters");
	    }
	}
	OUTPUT:
	    RETVAL
	CLEANUP:
	    MY_CATCH

void
XmlValue::DESTROY()
	INIT:
	    MY_TRY
	CLEANUP:
	    MY_CATCH

XmlValue::Type
XmlValue::getType(XmlQueryContext * context=NULL)
	INIT:
	    MY_TRY
	CLEANUP:
	    MY_CATCH

bool
XmlValue::isNumber(XmlQueryContext * context=NULL)
	INIT:
	    MY_TRY
	CLEANUP:
	    MY_CATCH

bool
XmlValue::isString(XmlQueryContext * context=NULL)
	INIT:
	    MY_TRY
	CLEANUP:
	    MY_CATCH

bool
XmlValue::isBoolean(XmlQueryContext * context=NULL)
	INIT:
	    MY_TRY
	CLEANUP:
	    MY_CATCH

bool
XmlValue::isDocument(XmlQueryContext * context=NULL)
	INIT:
	    MY_TRY
	CLEANUP:
	    MY_CATCH

bool
XmlValue::isVariable(XmlQueryContext * context=NULL)
	INIT:
	    MY_TRY
	CLEANUP:
	    MY_CATCH

bool
XmlValue::isNode(XmlQueryContext * context=NULL)
	INIT:
	    MY_TRY
	CLEANUP:
	    MY_CATCH


bool
XmlValue::isNull()
	INIT:
	    MY_TRY
	CLEANUP:
	    MY_CATCH

SV*
XmlValue::asNumber(XmlQueryContext * context=NULL)
	INIT:
	    MY_TRY
	CODE:
	{
	    double num = THIS->asNumber(context);
	    if (isnan(num))
		RETVAL = &PL_sv_undef ;
	    else
                RETVAL = newSVnv(num);

	}
	OUTPUT:
	    RETVAL
	CLEANUP:
	    MY_CATCH

string
XmlValue::asString(XmlQueryContext * context=NULL)
	INIT:
	    MY_TRY
	CODE:
	{
	    RETVAL = THIS->asString(context);
	}
	OUTPUT:
	    RETVAL
	CLEANUP:
	    MY_CATCH

bool
XmlValue::asBoolean(XmlQueryContext * context=NULL)
	INIT:
	    MY_TRY
	CLEANUP:
	    MY_CATCH

XmlDocument*
XmlValue::asDocument(XmlQueryContext * context=NULL)
	char *	CLASS = (char *)"XmlDocument";
	INIT:
	    MY_TRY
	CODE:
	{
	    RETVAL = new XmlDocument(THIS->asDocument(context));
	}
	OUTPUT:
	    RETVAL
	CLEANUP:
	    MY_CATCH


bool 
XmlValue::equals(XmlValue *v, XmlQueryContext *context=NULL) 
	INIT:
	    MY_TRY
	CODE:
	{
	    RETVAL = THIS->equals(*v, context);
	}
	CLEANUP:
	    MY_CATCH

char*
XmlValue::_getTypeName(XmlQueryContext * context=NULL)
	INIT:
	    MY_TRY
	CODE:
	{
            XmlValue::Type type = THIS->getType(context);
	    switch (type)
	    {
	        case XmlValue::BOOLEAN :
		    RETVAL = "BOOLEAN";
		    break;
	        case XmlValue::STRING :
		    RETVAL = "STRING";
		    break;
	        case XmlValue::NUMBER :
		    RETVAL = "NUMBER";
		    break;
	        case XmlValue::NONE :
		    RETVAL = "NONE";
		    break;
	        case XmlValue::VARIABLE :
		    RETVAL = "VARIABLE";
		    break;
	        case XmlValue::DOCUMENT :
		    RETVAL = "DOCUMENT";
		    break;
	        case XmlValue::NODE :
		    RETVAL = "NODE";
		    break;
	        case XmlValue::BINARY :
		    RETVAL = "BINARY";
		    break;
		default:
		    RETVAL = "Unknown";
		    break;
	    }
	}
	OUTPUT:
	    RETVAL
	CLEANUP:
	    MY_CATCH


MODULE = XmlResults	PACKAGE = XmlResults


void
XmlResults::DESTROY()
	INIT:
	    MY_TRY
	CLEANUP:
	    MY_CATCH

bool
XmlResults::_next1(DbTxn* txnid, XmlValue * value)
	INIT:
	    MY_TRY
	CODE:
	{
	    if (txnid == NULL)
	        RETVAL = THIS->next(*value);
	    else
	        RETVAL = THIS->next(txnid, *value);
	}
	OUTPUT:
	    RETVAL
	CLEANUP:
	    MY_CATCH

bool
XmlResults::_next2(DbTxn* txnid, XmlDocument * document)
	INIT:
	    MY_TRY
	CODE:
	{
	    if (txnid == NULL)
	        RETVAL = THIS->next(*document);
	    else
	        RETVAL = THIS->next(txnid, *document);
	}
	OUTPUT:
	    RETVAL
	CLEANUP:
	    MY_CATCH

bool
XmlResults::_next3(DbTxn* txnid, XmlDocument* document, XmlValue * value)
	INIT:
	    MY_TRY
	CODE:
	{
	    RETVAL = THIS->next(txnid, *document, *value);
	}
	OUTPUT:
	    RETVAL
	CLEANUP:
	    MY_CATCH


size_t
XmlResults::size()
	INIT:
	    MY_TRY
	CLEANUP:
	    MY_CATCH

void
XmlResults::reset()
	INIT:
	    MY_TRY
	CLEANUP:
	    MY_CATCH

MODULE = XmlUpdateContext	PACKAGE = XmlUpdateContext

XmlUpdateContext*
XmlUpdateContext::new(XmlContainer * container)
	INIT:
	    MY_TRY
	CODE:
	{
	    RETVAL = new XmlUpdateContext(*container);
	}
	CLEANUP:
	    MY_CATCH

void
XmlUpdateContext::DESTROY()
	INIT:
	    MY_TRY
	CLEANUP:
	    MY_CATCH

MODULE = XmlException	PACKAGE = XmlException

void
MyXmlException::DESTROY()
	INIT:
	    MY_TRY
	CLEANUP:
	    MY_CATCH

int
MyXmlException::getDbErrno()
	INIT:
	    MY_TRY
	CLEANUP:
	    MY_CATCH

XmlException::ExceptionCode
MyXmlException::getExceptionCode()
	INIT:
	    MY_TRY
	CLEANUP:
	    MY_CATCH

MODULE = XmlIndexSpecification	PACKAGE = XmlIndexSpecification

XmlIndexSpecification*
XmlIndexSpecification::new()
	INIT:
	    MY_TRY
	CLEANUP:
	    MY_CATCH

void
XmlIndexSpecification::DESTROY()
	INIT:
	    MY_TRY
	CLEANUP:
	    MY_CATCH

void	    
XmlIndexSpecification::addIndex(string uri, string name, string index)
	INIT:
	    MY_TRY
	CLEANUP:
	    MY_CATCH

void	    
XmlIndexSpecification::deleteIndex(string uri, string name, string index)
	INIT:
	    MY_TRY
	CLEANUP:
	    MY_CATCH

void	    
XmlIndexSpecification::replaceIndex(string uri, string name, string index)
	INIT:
	    MY_TRY
	CLEANUP:
	    MY_CATCH

bool	    
XmlIndexSpecification::find(uri, name, index)
	INPUT:
	    string uri
	    string name
	    string index = NO_INIT
	INIT:
	    MY_TRY
	OUTPUT:
	    RETVAL
	    index
	CLEANUP:
	    MY_CATCH

bool	    
XmlIndexSpecification::next(uri, name, index)
	INPUT:
	    string uri = NO_INIT
	    string name = NO_INIT
	    string index = NO_INIT
	INIT:
	    MY_TRY
	OUTPUT:
	    RETVAL
	    uri
	    name
	    index
	CLEANUP:
	    MY_CATCH

void	    
XmlIndexSpecification::reset()
	INIT:
	    MY_TRY
	CLEANUP:
	    MY_CATCH

MODULE = XmlQueryExpression	PACKAGE = XmlQueryExpression

void
XmlQueryExpression::DESTROY()
	INIT:
	    MY_TRY
	CLEANUP:
	    MY_CATCH

string
XmlQueryExpression::getXPathQuery()
        INIT:
            MY_TRY
        OUTPUT:
            RETVAL
        CLEANUP:
            MY_CATCH

MODULE = _XmlModify1	PACKAGE = _XmlModify1

XmlModify *
XmlModify::new(XmlQueryExpression *expression, XmlModify::ModificationType operation, XmlModify::XmlObject type, string name, string content, int location = -1)
	INIT:
	    MY_TRY
	CODE:
	{
	    RETVAL = new XmlModify(*expression, operation, type, name, content, location);
	}
	OUTPUT:
	    RETVAL
	CLEANUP:
	    MY_CATCH

MODULE = _XmlModify2	PACKAGE = _XmlModify2

XmlModify *
XmlModify::new(string xpath, XmlModify::ModificationType operation, XmlModify::XmlObject type, string name, string content, int location = -1, XmlQueryContext *context = 0)
	INIT:
	    MY_TRY
	CODE:
	{
	    RETVAL = new XmlModify(xpath, operation, type, name, content, location, context);
	}
	OUTPUT:
	    RETVAL
	CLEANUP:
	    MY_CATCH


MODULE = XmlModify	PACKAGE = XmlModify

void
XmlModify::DESTROY()
	INIT:
	    MY_TRY
	CLEANUP:
	    MY_CATCH


int 
XmlModify::getNumModifications() 
	INIT:
	    MY_TRY
	CLEANUP:
	    MY_CATCH

void
XmlModify::setNewEncoding(string newEncoding)
	INIT:
	    MY_TRY
	CLEANUP:
	    MY_CATCH

	    
MODULE = Sleepycat::DbXml		PACKAGE = Sleepycat::DbXml		


