/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 1.3.19
 * 
 * This file is not intended to be easily readable and contains a number of 
 * coding conventions designed to improve portability and efficiency. Do not make
 * changes to this file unless you know what you are doing--modify the SWIG 
 * interface file instead. 
 * ----------------------------------------------------------------------------- */


#ifdef __cplusplus
template<class T> class SwigValueWrapper {
    T *tt;
public:
    inline SwigValueWrapper() : tt(0) { }
    inline ~SwigValueWrapper() { if (tt) delete tt; } 
    inline SwigValueWrapper& operator=(const T& t) { tt = new T(t); return *this; }
    inline operator T&() const { return *tt; }
    inline T *operator&() { return tt; }
};                                                    
#endif


#if defined(__GNUC__)
    typedef long long __int64; /*For gcc on Windows */
#endif
#include <jni.h>
#include <stdlib.h>
#include <string.h>


/* Support for throwing Java exceptions */
typedef enum {
  SWIG_JavaOutOfMemoryError = 1, 
  SWIG_JavaIOException, 
  SWIG_JavaRuntimeException, 
  SWIG_JavaIndexOutOfBoundsException,
  SWIG_JavaArithmeticException,
  SWIG_JavaIllegalArgumentException,
  SWIG_JavaNullPointerException,
  SWIG_JavaUnknownError
} SWIG_JavaExceptionCodes;

typedef struct {
  SWIG_JavaExceptionCodes code;
  const char *java_exception;
} SWIG_JavaExceptions_t;

#if defined(SWIG_NOINCLUDE)
void SWIG_JavaThrowException(JNIEnv *jenv, SWIG_JavaExceptionCodes code, const char *msg);
#else


void SWIG_JavaThrowException(JNIEnv *jenv, SWIG_JavaExceptionCodes code, const char *msg) {
  jclass excep;
  static const SWIG_JavaExceptions_t java_exceptions[] = {
    { SWIG_JavaOutOfMemoryError, "java/lang/OutOfMemoryError" },
    { SWIG_JavaIOException, "java/io/IOException" },
    { SWIG_JavaRuntimeException, "java/lang/RuntimeException" },
    { SWIG_JavaIndexOutOfBoundsException, "java/lang/IndexOutOfBoundsException" },
    { SWIG_JavaArithmeticException, "java/lang/ArithmeticException" },
    { SWIG_JavaIllegalArgumentException, "java/lang/IllegalArgumentException" },
    { SWIG_JavaNullPointerException, "java/lang/NullPointerException" },
    { SWIG_JavaUnknownError,  "java/lang/UnknownError" },
    { (SWIG_JavaExceptionCodes)0,  "java/lang/UnknownError" } };
  const SWIG_JavaExceptions_t *except_ptr = java_exceptions;

  while (except_ptr->code != code && except_ptr->code)
    except_ptr++;

  jenv->ExceptionClear();
  excep = jenv->FindClass(except_ptr->java_exception);
  if (excep)
    jenv->ThrowNew(excep, msg);
}


#endif


#define  SWIG_MemoryError    1
#define  SWIG_IOError        2
#define  SWIG_RuntimeError   3
#define  SWIG_IndexError     4
#define  SWIG_TypeError      5
#define  SWIG_DivisionByZero 6
#define  SWIG_OverflowError  7
#define  SWIG_SyntaxError    8
#define  SWIG_ValueError     9
#define  SWIG_SystemError   10
#define  SWIG_UnknownError  99


static void SWIG_JavaException(JNIEnv *jenv, int code, const char *msg) {
  SWIG_JavaExceptionCodes exception_code = SWIG_JavaUnknownError;
  switch(code) {
  case SWIG_MemoryError:
    exception_code = SWIG_JavaOutOfMemoryError;
    break;
  case SWIG_IOError:
    exception_code = SWIG_JavaIOException;
    break;
  case SWIG_SystemError:
  case SWIG_RuntimeError:
    exception_code = SWIG_JavaRuntimeException;
    break;
  case SWIG_OverflowError:
  case SWIG_IndexError:
    exception_code = SWIG_JavaIndexOutOfBoundsException;
    break;
  case SWIG_DivisionByZero:
    exception_code = SWIG_JavaArithmeticException;
    break;
  case SWIG_SyntaxError:
  case SWIG_ValueError:
  case SWIG_TypeError:
    exception_code = SWIG_JavaIllegalArgumentException;
    break;
  case SWIG_UnknownError:
  default:
    exception_code = SWIG_JavaUnknownError;
    break;
  }
  SWIG_JavaThrowException(jenv, exception_code, msg);
}
#define SWIG_exception(code, msg) { SWIG_JavaException(jenv, code, msg); }


#include "db_cxx.h"
#include "dbxml/DbXml.hpp"
#include <errno.h>
#include <fstream>

using namespace DbXml;

class XmlIndexDeclaration {
public:
	XmlIndexDeclaration() {}
	XmlIndexDeclaration(const std::string &uri, const std::string &name, const std::string &index) : uri(uri), name(name), index(index) {}

	std::string uri, name, index;
};


#include <string>


/* don't use SWIG's array handling - save code space */
#define SWIG_NOINCLUDE 1

jclass dbt_class;
jclass env_class;
jclass txn_class;
jclass xml_indexdecl_class;

jclass xmlex_class;
jclass dbex_class;

jfieldID dbt_data_fid;
jfieldID dbt_size_fid;
jfieldID dbt_ulen_fid;
jfieldID dbt_dlen_fid;
jfieldID dbt_doff_fid;

jfieldID env_private_fid;
jfieldID txn_private_fid;

jmethodID dbt_construct;
jmethodID xml_indexdecl_construct;
jmethodID xmlex_construct;
jmethodID dbex_construct;

extern "C"
JNIEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_initialize
  (JNIEnv *jenv, jclass clazz)
{
	(void)clazz; /* unused */
	
#define DB_PKG "com/sleepycat/db/"
#define XML_PKG "com/sleepycat/dbxml/"

	/* XXX TODO: better error handling during initialization */
	dbt_class = jenv->FindClass(DB_PKG "Dbt");
	env_class = jenv->FindClass(DB_PKG "DbEnv");
	txn_class = jenv->FindClass(DB_PKG "DbTxn");
	xml_indexdecl_class = jenv->FindClass(XML_PKG "XmlIndexDeclaration");
	
	xmlex_class = jenv->FindClass("com/sleepycat/dbxml/XmlException");
	dbex_class = jenv->FindClass(DB_PKG "DbException");

	if (!env_class || !txn_class || !xmlex_class || !dbex_class) {
		fprintf(stderr, "Failed to load com.sleepycat.db.* - check CLASSPATH\n");
		return;
	}

	/* Wrap classes in GlobalRefs so that we can keep them between calls */
	dbt_class = (jclass)jenv->NewGlobalRef(dbt_class);
	env_class = (jclass)jenv->NewGlobalRef(env_class);
	txn_class = (jclass)jenv->NewGlobalRef(txn_class);
	xml_indexdecl_class = (jclass)jenv->NewGlobalRef(xml_indexdecl_class);

	xmlex_class = (jclass)jenv->NewGlobalRef(xmlex_class);
	dbex_class = (jclass)jenv->NewGlobalRef(dbex_class);

	/* Get field IDs */
	dbt_data_fid = jenv->GetFieldID(dbt_class, "data", "[B");
	dbt_size_fid = jenv->GetFieldID(dbt_class, "size", "I");
	dbt_ulen_fid = jenv->GetFieldID(dbt_class, "ulen", "I");
	dbt_dlen_fid = jenv->GetFieldID(dbt_class, "dlen", "I");
	dbt_doff_fid = jenv->GetFieldID(dbt_class, "doff", "I");

#if DB_VERSION_MAJOR < 4 || (DB_VERSION_MAJOR == 4 && DB_VERSION_MINOR <= 1)
	env_private_fid = jenv->GetFieldID(env_class, "private_dbobj_", "J");
	txn_private_fid = jenv->GetFieldID(txn_class, "private_dbobj_", "J");
#else
	env_private_fid = jenv->GetFieldID(env_class, "swigCPtr", "J");
	txn_private_fid = jenv->GetFieldID(txn_class, "swigCPtr", "J");
#endif

	/* Get method IDs */
	dbt_construct = jenv->GetMethodID(dbt_class, "<init>",
	    "()V");
	xml_indexdecl_construct = jenv->GetMethodID(xml_indexdecl_class, "<init>",
	    "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V");

	xmlex_construct = jenv->GetMethodID(xmlex_class, "<init>",
	    "(ILjava/lang/String;I)V");
	dbex_construct = jenv->GetMethodID(dbex_class, "<init>",
	    "(Ljava/lang/String;I)V");
}

/* Union to convert longs to pointers (see {get,set}_private_dbobj). */
typedef union {
	jlong java_long;
	void *ptr;
} long_to_ptr;

static DbEnv *get_DbEnv(JNIEnv *jenv, jobject jdbenv)
{
	if (jdbenv == NULL)
		return NULL;
	else {
#if DB_VERSION_MAJOR < 4 || (DB_VERSION_MAJOR == 4 && DB_VERSION_MINOR <= 1)
		long_to_ptr lp;
		lp.java_long = jenv->GetLongField(jdbenv, env_private_fid);
		return DbEnv::wrap_DB_ENV((DB_ENV *)lp.ptr);
#else
		jlong swigCPtr = jenv->GetLongField(jdbenv, env_private_fid);
		return DbEnv::wrap_DB_ENV(*(DB_ENV **)&swigCPtr);
#endif
	}
}

static DbTxn *get_DbTxn(JNIEnv *jenv, jobject jtxn)
{
	if (jtxn == NULL)
		return NULL;
	else {
#if DB_VERSION_MAJOR < 4 || (DB_VERSION_MAJOR == 4 && DB_VERSION_MINOR <= 1)
		long_to_ptr lp;
		lp.java_long = jenv->GetLongField(jtxn, txn_private_fid);
		return DbTxn::wrap_DB_TXN((DB_TXN *)lp.ptr);
#else
		jlong swigCPtr = jenv->GetLongField(jtxn, txn_private_fid);
		return DbTxn::wrap_DB_TXN(*(DB_TXN **)&swigCPtr);
#endif
	}
}

struct DBT_INFO {
	Dbt dbt;
	jbyte *orig_data;
};


static XmlIndexSpecification *XmlContainer_getIndexSpecification(XmlContainer const *self,DbTxn *txn){
		return new XmlIndexSpecification(self->getIndexSpecification(txn));
	}
static XmlDocument *XmlContainer_getDocument(XmlContainer *self,DbTxn *txn,u_int32_t id,u_int32_t flags){
		return new XmlDocument(self->getDocument(txn, id, flags));
	}
static XmlQueryExpression *XmlContainer_parseXPathExpression(XmlContainer const *self,DbTxn *txn,std::string const &query,XmlQueryContext *context){
		return new XmlQueryExpression(self->parseXPathExpression(txn, query, context));
	}
static XmlResults *XmlContainer_queryWithXPath__SWIG_0(XmlContainer const *self,DbTxn *txn,std::string const &query,XmlQueryContext *context,u_int32_t flags){
		return new XmlResults(self->queryWithXPath(txn, query, context, flags));
	}
static XmlResults *XmlContainer_queryWithXPath__SWIG_1(XmlContainer const *self,DbTxn *txn,XmlQueryExpression &query,u_int32_t flags){
		return new XmlResults(self->queryWithXPath(txn, query, flags));
	}
static void XmlContainer_dump(XmlContainer *self,char const *filename,u_int32_t flags){
		std::ofstream out(filename);
		self->dump(&out, flags);
		out.close();
	}
static void XmlContainer_load(XmlContainer *self,char const *filename,u_int32_t flags){
		std::ifstream in(filename);
		unsigned long lineno = 0;
		self->load(&in, &lineno, flags);
		in.close();
	}
static void XmlContainer_verify(XmlContainer *self,char const *filename,u_int32_t flags){
		std::ofstream out;
		if (flags & DB_SALVAGE)
			out.open(filename);
		self->verify(&out, flags);
		if (flags & DB_SALVAGE)
			out.close();
	}
void XmlContainer_setLogLevel(LogLevel level,bool enabled){
		DbXml::setLogLevel(level, enabled);
	}
void XmlContainer_setLogCategory(LogCategory category,bool enabled){
		DbXml::setLogCategory(category, enabled);
	}
int XmlContainer_get_version_major(){
		int major;
		(void)dbxml_version(&major, NULL, NULL);
		return major;
	}
int XmlContainer_get_version_minor(){
		int minor;
		(void)dbxml_version(NULL, &minor, NULL);
		return minor;
	}
int XmlContainer_get_version_patch(){
		int patch;
		(void)dbxml_version(NULL, NULL, &patch);
		return patch;
	}
char const *XmlContainer_get_version_string(){
		return dbxml_version(NULL, NULL, NULL);
	}
static std::string XmlDocument_getContentAsString(XmlDocument const *self){
		std::string s;
		return self->getContentAsString(s);
	}
static XmlResults *XmlDocument_queryWithXPath__SWIG_0(XmlDocument const *self,std::string const &query,XmlQueryContext *context){
		return new XmlResults(self->queryWithXPath(query, context));
	}
static XmlResults *XmlDocument_queryWithXPath__SWIG_1(XmlDocument const *self,XmlQueryExpression &query){
		return new XmlResults(self->queryWithXPath(query));
	}
static XmlValue *XmlQueryContext_getVariableValue(XmlQueryContext *self,std::string const &name){
		XmlValue *value = new XmlValue;
		if (self->getVariableValue(name, *value))
			return value;
		else {
			delete value;
			return NULL;
		}
	}
static XmlValue *XmlResults_next__SWIG_0(XmlResults *self){
		XmlValue *value = new XmlValue;
		if (self->next(*value))
			return value;
		else {
			delete value;
			return NULL;
		}
	}
static XmlValue *XmlResults_next__SWIG_3(XmlResults *self,DbTxn *txn){
	        XmlValue *value = new XmlValue;
		if (self->next(*value))
			return value;
		else {
			delete value;
			return NULL;
		}
	}
static bool XmlResults_nextDocument(XmlResults *self,DbTxn *txn,XmlDocument &document){
                return (self->next(document));
        }
static bool XmlResults_nextDocumentAndValue(XmlResults *self,DbTxn *txn,XmlDocument &document,XmlValue &value){
                return (self->next(document, value));
        }
static XmlIndexDeclaration *XmlIndexSpecification_find(XmlIndexSpecification *self,std::string const &uri,std::string const &name){
		XmlIndexDeclaration *idecl = new XmlIndexDeclaration(uri, name, "");
		if (self->find(idecl->uri, idecl->name, idecl->index))
			return idecl;
		else {
			delete idecl;
			return NULL;
		}
	}
static XmlIndexDeclaration *XmlIndexSpecification_next(XmlIndexSpecification *self){
		XmlIndexDeclaration *idecl = new XmlIndexDeclaration;
		if (self->next(idecl->uri, idecl->name, idecl->index))
			return idecl;
		else {
			delete idecl;
			return NULL;
		}
	}
static char const *XmlQueryExpression_getXPathQuery(XmlQueryExpression const *self){
		return self->getXPathQuery().c_str();
	}
#ifdef __cplusplus
extern "C" {
#endif

JNIEXPORT jstring JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_get_1metaDataNamespace_1uri(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    {
        jthrowable t = NULL;
        
        try {
            result = (char *) "DbXml::metaDataNamespace_uri";
            
        }catch (XmlException &xe) {
            t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
            xe.getExceptionCode(), jenv->NewStringUTF(xe.what()),
            xe.getDbErrno());
        }catch (...) {
            fprintf(stderr, "Uncaught exception from C++ API!\n");
            t = (jthrowable)jenv->NewObject(dbex_class, dbex_construct,
            jenv->NewStringUTF("Uncaught exception from C++ API"), 0);
        }
        
        if (t)
        jenv->Throw(t);
    }
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_get_1metaDataNamespace_1prefix(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    {
        jthrowable t = NULL;
        
        try {
            result = (char *) "DbXml::metaDataNamespace_prefix";
            
        }catch (XmlException &xe) {
            t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
            xe.getExceptionCode(), jenv->NewStringUTF(xe.what()),
            xe.getDbErrno());
        }catch (...) {
            fprintf(stderr, "Uncaught exception from C++ API!\n");
            t = (jthrowable)jenv->NewObject(dbex_class, dbex_construct,
            jenv->NewStringUTF("Uncaught exception from C++ API"), 0);
        }
        
        if (t)
        jenv->Throw(t);
    }
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_get_1metaDataName_1id(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    {
        jthrowable t = NULL;
        
        try {
            result = (char *) "DbXml::metaDataName_id";
            
        }catch (XmlException &xe) {
            t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
            xe.getExceptionCode(), jenv->NewStringUTF(xe.what()),
            xe.getDbErrno());
        }catch (...) {
            fprintf(stderr, "Uncaught exception from C++ API!\n");
            t = (jthrowable)jenv->NewObject(dbex_class, dbex_construct,
            jenv->NewStringUTF("Uncaught exception from C++ API"), 0);
        }
        
        if (t)
        jenv->Throw(t);
    }
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_get_1metaDataName_1name(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    {
        jthrowable t = NULL;
        
        try {
            result = (char *) "DbXml::metaDataName_name";
            
        }catch (XmlException &xe) {
            t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
            xe.getExceptionCode(), jenv->NewStringUTF(xe.what()),
            xe.getDbErrno());
        }catch (...) {
            fprintf(stderr, "Uncaught exception from C++ API!\n");
            t = (jthrowable)jenv->NewObject(dbex_class, dbex_construct,
            jenv->NewStringUTF("Uncaught exception from C++ API"), 0);
        }
        
        if (t)
        jenv->Throw(t);
    }
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_get_1metaDataName_1content(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    {
        jthrowable t = NULL;
        
        try {
            result = (char *) "DbXml::metaDataName_content";
            
        }catch (XmlException &xe) {
            t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
            xe.getExceptionCode(), jenv->NewStringUTF(xe.what()),
            xe.getDbErrno());
        }catch (...) {
            fprintf(stderr, "Uncaught exception from C++ API!\n");
            t = (jthrowable)jenv->NewObject(dbex_class, dbex_construct,
            jenv->NewStringUTF("Uncaught exception from C++ API"), 0);
        }
        
        if (t)
        jenv->Throw(t);
    }
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_get_1metaDataName_1default(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    {
        jthrowable t = NULL;
        
        try {
            result = (char *) "DbXml::metaDataName_default";
            
        }catch (XmlException &xe) {
            t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
            xe.getExceptionCode(), jenv->NewStringUTF(xe.what()),
            xe.getDbErrno());
        }catch (...) {
            fprintf(stderr, "Uncaught exception from C++ API!\n");
            t = (jthrowable)jenv->NewObject(dbex_class, dbex_construct,
            jenv->NewStringUTF("Uncaught exception from C++ API"), 0);
        }
        
        if (t)
        jenv->Throw(t);
    }
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_get_1metaDataNamespace_1prefix_1debug(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    {
        jthrowable t = NULL;
        
        try {
            result = (char *) "DbXml::metaDataNamespace_prefix_debug";
            
        }catch (XmlException &xe) {
            t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
            xe.getExceptionCode(), jenv->NewStringUTF(xe.what()),
            xe.getDbErrno());
        }catch (...) {
            fprintf(stderr, "Uncaught exception from C++ API!\n");
            t = (jthrowable)jenv->NewObject(dbex_class, dbex_construct,
            jenv->NewStringUTF("Uncaught exception from C++ API"), 0);
        }
        
        if (t)
        jenv->Throw(t);
    }
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_get_1LEVEL_1NONE(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    {
        jthrowable t = NULL;
        
        try {
            result = (int)LEVEL_NONE;
            
        }catch (XmlException &xe) {
            t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
            xe.getExceptionCode(), jenv->NewStringUTF(xe.what()),
            xe.getDbErrno());
        }catch (...) {
            fprintf(stderr, "Uncaught exception from C++ API!\n");
            t = (jthrowable)jenv->NewObject(dbex_class, dbex_construct,
            jenv->NewStringUTF("Uncaught exception from C++ API"), 0);
        }
        
        if (t)
        jenv->Throw(t);
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_get_1LEVEL_1DEBUG(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    {
        jthrowable t = NULL;
        
        try {
            result = (int)LEVEL_DEBUG;
            
        }catch (XmlException &xe) {
            t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
            xe.getExceptionCode(), jenv->NewStringUTF(xe.what()),
            xe.getDbErrno());
        }catch (...) {
            fprintf(stderr, "Uncaught exception from C++ API!\n");
            t = (jthrowable)jenv->NewObject(dbex_class, dbex_construct,
            jenv->NewStringUTF("Uncaught exception from C++ API"), 0);
        }
        
        if (t)
        jenv->Throw(t);
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_get_1LEVEL_1INFO(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    {
        jthrowable t = NULL;
        
        try {
            result = (int)LEVEL_INFO;
            
        }catch (XmlException &xe) {
            t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
            xe.getExceptionCode(), jenv->NewStringUTF(xe.what()),
            xe.getDbErrno());
        }catch (...) {
            fprintf(stderr, "Uncaught exception from C++ API!\n");
            t = (jthrowable)jenv->NewObject(dbex_class, dbex_construct,
            jenv->NewStringUTF("Uncaught exception from C++ API"), 0);
        }
        
        if (t)
        jenv->Throw(t);
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_get_1LEVEL_1WARNING(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    {
        jthrowable t = NULL;
        
        try {
            result = (int)LEVEL_WARNING;
            
        }catch (XmlException &xe) {
            t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
            xe.getExceptionCode(), jenv->NewStringUTF(xe.what()),
            xe.getDbErrno());
        }catch (...) {
            fprintf(stderr, "Uncaught exception from C++ API!\n");
            t = (jthrowable)jenv->NewObject(dbex_class, dbex_construct,
            jenv->NewStringUTF("Uncaught exception from C++ API"), 0);
        }
        
        if (t)
        jenv->Throw(t);
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_get_1LEVEL_1ERROR(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    {
        jthrowable t = NULL;
        
        try {
            result = (int)LEVEL_ERROR;
            
        }catch (XmlException &xe) {
            t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
            xe.getExceptionCode(), jenv->NewStringUTF(xe.what()),
            xe.getDbErrno());
        }catch (...) {
            fprintf(stderr, "Uncaught exception from C++ API!\n");
            t = (jthrowable)jenv->NewObject(dbex_class, dbex_construct,
            jenv->NewStringUTF("Uncaught exception from C++ API"), 0);
        }
        
        if (t)
        jenv->Throw(t);
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_get_1LEVEL_1ALL(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    {
        jthrowable t = NULL;
        
        try {
            result = (int)LEVEL_ALL;
            
        }catch (XmlException &xe) {
            t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
            xe.getExceptionCode(), jenv->NewStringUTF(xe.what()),
            xe.getDbErrno());
        }catch (...) {
            fprintf(stderr, "Uncaught exception from C++ API!\n");
            t = (jthrowable)jenv->NewObject(dbex_class, dbex_construct,
            jenv->NewStringUTF("Uncaught exception from C++ API"), 0);
        }
        
        if (t)
        jenv->Throw(t);
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_get_1CATEGORY_1NONE(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    {
        jthrowable t = NULL;
        
        try {
            result = (int)CATEGORY_NONE;
            
        }catch (XmlException &xe) {
            t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
            xe.getExceptionCode(), jenv->NewStringUTF(xe.what()),
            xe.getDbErrno());
        }catch (...) {
            fprintf(stderr, "Uncaught exception from C++ API!\n");
            t = (jthrowable)jenv->NewObject(dbex_class, dbex_construct,
            jenv->NewStringUTF("Uncaught exception from C++ API"), 0);
        }
        
        if (t)
        jenv->Throw(t);
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_get_1CATEGORY_1INDEXER(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    {
        jthrowable t = NULL;
        
        try {
            result = (int)CATEGORY_INDEXER;
            
        }catch (XmlException &xe) {
            t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
            xe.getExceptionCode(), jenv->NewStringUTF(xe.what()),
            xe.getDbErrno());
        }catch (...) {
            fprintf(stderr, "Uncaught exception from C++ API!\n");
            t = (jthrowable)jenv->NewObject(dbex_class, dbex_construct,
            jenv->NewStringUTF("Uncaught exception from C++ API"), 0);
        }
        
        if (t)
        jenv->Throw(t);
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_get_1CATEGORY_1QUERY(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    {
        jthrowable t = NULL;
        
        try {
            result = (int)CATEGORY_QUERY;
            
        }catch (XmlException &xe) {
            t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
            xe.getExceptionCode(), jenv->NewStringUTF(xe.what()),
            xe.getDbErrno());
        }catch (...) {
            fprintf(stderr, "Uncaught exception from C++ API!\n");
            t = (jthrowable)jenv->NewObject(dbex_class, dbex_construct,
            jenv->NewStringUTF("Uncaught exception from C++ API"), 0);
        }
        
        if (t)
        jenv->Throw(t);
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_get_1CATEGORY_1OPTIMIZER(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    {
        jthrowable t = NULL;
        
        try {
            result = (int)CATEGORY_OPTIMIZER;
            
        }catch (XmlException &xe) {
            t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
            xe.getExceptionCode(), jenv->NewStringUTF(xe.what()),
            xe.getDbErrno());
        }catch (...) {
            fprintf(stderr, "Uncaught exception from C++ API!\n");
            t = (jthrowable)jenv->NewObject(dbex_class, dbex_construct,
            jenv->NewStringUTF("Uncaught exception from C++ API"), 0);
        }
        
        if (t)
        jenv->Throw(t);
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_get_1CATEGORY_1DICTIONARY(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    {
        jthrowable t = NULL;
        
        try {
            result = (int)CATEGORY_DICTIONARY;
            
        }catch (XmlException &xe) {
            t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
            xe.getExceptionCode(), jenv->NewStringUTF(xe.what()),
            xe.getDbErrno());
        }catch (...) {
            fprintf(stderr, "Uncaught exception from C++ API!\n");
            t = (jthrowable)jenv->NewObject(dbex_class, dbex_construct,
            jenv->NewStringUTF("Uncaught exception from C++ API"), 0);
        }
        
        if (t)
        jenv->Throw(t);
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_get_1CATEGORY_1CONTAINER(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    {
        jthrowable t = NULL;
        
        try {
            result = (int)CATEGORY_CONTAINER;
            
        }catch (XmlException &xe) {
            t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
            xe.getExceptionCode(), jenv->NewStringUTF(xe.what()),
            xe.getDbErrno());
        }catch (...) {
            fprintf(stderr, "Uncaught exception from C++ API!\n");
            t = (jthrowable)jenv->NewObject(dbex_class, dbex_construct,
            jenv->NewStringUTF("Uncaught exception from C++ API"), 0);
        }
        
        if (t)
        jenv->Throw(t);
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_get_1CATEGORY_1ALL(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    {
        jthrowable t = NULL;
        
        try {
            result = (int)CATEGORY_ALL;
            
        }catch (XmlException &xe) {
            t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
            xe.getExceptionCode(), jenv->NewStringUTF(xe.what()),
            xe.getDbErrno());
        }catch (...) {
            fprintf(stderr, "Uncaught exception from C++ API!\n");
            t = (jthrowable)jenv->NewObject(dbex_class, dbex_construct,
            jenv->NewStringUTF("Uncaught exception from C++ API"), 0);
        }
        
        if (t)
        jenv->Throw(t);
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_new_1XmlContainer(JNIEnv *jenv, jclass jcls, jobject jarg1, jstring jarg2, jint jarg3) {
    jlong jresult = 0 ;
    DbEnv *arg1 = (DbEnv *) 0 ;
    std::string *arg2 = 0 ;
    u_int32_t arg3 = (u_int32_t) 0 ;
    XmlContainer *result;
    
    (void)jenv;
    (void)jcls;
    {
        arg1 = get_DbEnv(jenv, jarg1);
    }
    arg2 = NULL;
    if(jarg2) {
        const char *pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
        if (!pstr) return 0;
        arg2 =  new std::string(pstr);
        jenv->ReleaseStringUTFChars(jarg2, pstr);
    }
    else {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null std::string");
        return 0;
    }
    arg3 = (u_int32_t)jarg3; 
    {
        jthrowable t = NULL;
        
        try {
            result = (XmlContainer *)new XmlContainer(arg1,(std::string const &)*arg2,arg3);
            
        }catch (XmlException &xe) {
            t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
            xe.getExceptionCode(), jenv->NewStringUTF(xe.what()),
            xe.getDbErrno());
        }catch (...) {
            fprintf(stderr, "Uncaught exception from C++ API!\n");
            t = (jthrowable)jenv->NewObject(dbex_class, dbex_construct,
            jenv->NewStringUTF("Uncaught exception from C++ API"), 0);
        }
        
        if (t)
        jenv->Throw(t);
    }
    *(XmlContainer **)&jresult = result; 
    delete arg2; 
    return jresult;
}


JNIEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_delete_1XmlContainer(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    XmlContainer *arg1 = (XmlContainer *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(XmlContainer **)&jarg1; 
    
    if (!jarg1) {
        jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        EINVAL));
        return ;
    }
    
    {
        jthrowable t = NULL;
        
        try {
            delete arg1;
            
        }catch (XmlException &xe) {
            t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
            xe.getExceptionCode(), jenv->NewStringUTF(xe.what()),
            xe.getDbErrno());
        }catch (...) {
            fprintf(stderr, "Uncaught exception from C++ API!\n");
            t = (jthrowable)jenv->NewObject(dbex_class, dbex_construct,
            jenv->NewStringUTF("Uncaught exception from C++ API"), 0);
        }
        
        if (t)
        jenv->Throw(t);
    }
}


JNIEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlContainer_1setPageSize(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    XmlContainer *arg1 = (XmlContainer *) 0 ;
    u_int32_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(XmlContainer **)&jarg1; 
    arg2 = (u_int32_t)jarg2; 
    
    if (!jarg1) {
        jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        EINVAL));
        return ;
    }
    
    {
        jthrowable t = NULL;
        
        try {
            (arg1)->setPageSize(arg2);
            
        }catch (XmlException &xe) {
            t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
            xe.getExceptionCode(), jenv->NewStringUTF(xe.what()),
            xe.getDbErrno());
        }catch (...) {
            fprintf(stderr, "Uncaught exception from C++ API!\n");
            t = (jthrowable)jenv->NewObject(dbex_class, dbex_construct,
            jenv->NewStringUTF("Uncaught exception from C++ API"), 0);
        }
        
        if (t)
        jenv->Throw(t);
    }
}


JNIEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlContainer_1open(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg2, jint jarg3, jint jarg4) {
    XmlContainer *arg1 = (XmlContainer *) 0 ;
    DbTxn *arg2 = (DbTxn *) 0 ;
    u_int32_t arg3 = (u_int32_t) 0 ;
    int arg4 = (int) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(XmlContainer **)&jarg1; 
    {
        arg2 = get_DbTxn(jenv, jarg2);
    }
    arg3 = (u_int32_t)jarg3; 
    arg4 = (int)jarg4; 
    
    if (!jarg1) {
        jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        EINVAL));
        return ;
    }
    
    {
        jthrowable t = NULL;
        
        try {
            (arg1)->open(arg2,arg3,arg4);
            
        }catch (XmlException &xe) {
            t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
            xe.getExceptionCode(), jenv->NewStringUTF(xe.what()),
            xe.getDbErrno());
        }catch (...) {
            fprintf(stderr, "Uncaught exception from C++ API!\n");
            t = (jthrowable)jenv->NewObject(dbex_class, dbex_construct,
            jenv->NewStringUTF("Uncaught exception from C++ API"), 0);
        }
        
        if (t)
        jenv->Throw(t);
    }
}


JNIEXPORT jboolean JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlContainer_1exists(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg2) {
    jboolean jresult = 0 ;
    XmlContainer *arg1 = (XmlContainer *) 0 ;
    DbTxn *arg2 = (DbTxn *) 0 ;
    bool result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(XmlContainer **)&jarg1; 
    {
        arg2 = get_DbTxn(jenv, jarg2);
    }
    
    if (!jarg1) {
        jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        EINVAL));
        return 0;
    }
    
    {
        jthrowable t = NULL;
        
        try {
            result = (bool)(arg1)->exists(arg2);
            
        }catch (XmlException &xe) {
            t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
            xe.getExceptionCode(), jenv->NewStringUTF(xe.what()),
            xe.getDbErrno());
        }catch (...) {
            fprintf(stderr, "Uncaught exception from C++ API!\n");
            t = (jthrowable)jenv->NewObject(dbex_class, dbex_construct,
            jenv->NewStringUTF("Uncaught exception from C++ API"), 0);
        }
        
        if (t)
        jenv->Throw(t);
    }
    
    jresult = result ? JNI_TRUE : JNI_FALSE;
    
    return jresult;
}


JNIEXPORT jboolean JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlContainer_1isOpen(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jboolean jresult = 0 ;
    XmlContainer *arg1 = (XmlContainer *) 0 ;
    bool result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(XmlContainer **)&jarg1; 
    
    if (!jarg1) {
        jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        EINVAL));
        return 0;
    }
    
    {
        jthrowable t = NULL;
        
        try {
            result = (bool)((XmlContainer const *)arg1)->isOpen();
            
        }catch (XmlException &xe) {
            t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
            xe.getExceptionCode(), jenv->NewStringUTF(xe.what()),
            xe.getDbErrno());
        }catch (...) {
            fprintf(stderr, "Uncaught exception from C++ API!\n");
            t = (jthrowable)jenv->NewObject(dbex_class, dbex_construct,
            jenv->NewStringUTF("Uncaught exception from C++ API"), 0);
        }
        
        if (t)
        jenv->Throw(t);
    }
    
    jresult = result ? JNI_TRUE : JNI_FALSE;
    
    return jresult;
}


JNIEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlContainer_1close(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    XmlContainer *arg1 = (XmlContainer *) 0 ;
    u_int32_t arg2 = (u_int32_t) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(XmlContainer **)&jarg1; 
    arg2 = (u_int32_t)jarg2; 
    
    if (!jarg1) {
        jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        EINVAL));
        return ;
    }
    
    {
        jthrowable t = NULL;
        
        try {
            (arg1)->close(arg2);
            
        }catch (XmlException &xe) {
            t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
            xe.getExceptionCode(), jenv->NewStringUTF(xe.what()),
            xe.getDbErrno());
        }catch (...) {
            fprintf(stderr, "Uncaught exception from C++ API!\n");
            t = (jthrowable)jenv->NewObject(dbex_class, dbex_construct,
            jenv->NewStringUTF("Uncaught exception from C++ API"), 0);
        }
        
        if (t)
        jenv->Throw(t);
    }
}


JNIEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlContainer_1setIndexSpecification(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg2, jlong jarg3) {
    XmlContainer *arg1 = (XmlContainer *) 0 ;
    DbTxn *arg2 = (DbTxn *) 0 ;
    XmlIndexSpecification *arg3 = 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(XmlContainer **)&jarg1; 
    {
        arg2 = get_DbTxn(jenv, jarg2);
    }
    arg3 = *(XmlIndexSpecification **)&jarg3;
    if(!arg3) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlIndexSpecification const & reference is null");
        return ;
    }
    
    if (!jarg1) {
        jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        EINVAL));
        return ;
    }
    
    {
        jthrowable t = NULL;
        
        try {
            (arg1)->setIndexSpecification(arg2,(XmlIndexSpecification const &)*arg3);
            
        }catch (XmlException &xe) {
            t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
            xe.getExceptionCode(), jenv->NewStringUTF(xe.what()),
            xe.getDbErrno());
        }catch (...) {
            fprintf(stderr, "Uncaught exception from C++ API!\n");
            t = (jthrowable)jenv->NewObject(dbex_class, dbex_construct,
            jenv->NewStringUTF("Uncaught exception from C++ API"), 0);
        }
        
        if (t)
        jenv->Throw(t);
    }
}


JNIEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlContainer_1addIndex(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg2, jstring jarg3, jstring jarg4, jstring jarg5) {
    XmlContainer *arg1 = (XmlContainer *) 0 ;
    DbTxn *arg2 = (DbTxn *) 0 ;
    std::string *arg3 = 0 ;
    std::string *arg4 = 0 ;
    std::string *arg5 = 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(XmlContainer **)&jarg1; 
    {
        arg2 = get_DbTxn(jenv, jarg2);
    }
    arg3 = NULL;
    if(jarg3) {
        const char *pstr = (const char *)jenv->GetStringUTFChars(jarg3, 0); 
        if (!pstr) return ;
        arg3 =  new std::string(pstr);
        jenv->ReleaseStringUTFChars(jarg3, pstr);
    }
    else {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null std::string");
        return ;
    }
    arg4 = NULL;
    if(jarg4) {
        const char *pstr = (const char *)jenv->GetStringUTFChars(jarg4, 0); 
        if (!pstr) return ;
        arg4 =  new std::string(pstr);
        jenv->ReleaseStringUTFChars(jarg4, pstr);
    }
    else {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null std::string");
        return ;
    }
    arg5 = NULL;
    if(jarg5) {
        const char *pstr = (const char *)jenv->GetStringUTFChars(jarg5, 0); 
        if (!pstr) return ;
        arg5 =  new std::string(pstr);
        jenv->ReleaseStringUTFChars(jarg5, pstr);
    }
    else {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null std::string");
        return ;
    }
    
    if (!jarg1) {
        jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        EINVAL));
        return ;
    }
    
    {
        jthrowable t = NULL;
        
        try {
            (arg1)->addIndex(arg2,(std::string const &)*arg3,(std::string const &)*arg4,(std::string const &)*arg5);
            
        }catch (XmlException &xe) {
            t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
            xe.getExceptionCode(), jenv->NewStringUTF(xe.what()),
            xe.getDbErrno());
        }catch (...) {
            fprintf(stderr, "Uncaught exception from C++ API!\n");
            t = (jthrowable)jenv->NewObject(dbex_class, dbex_construct,
            jenv->NewStringUTF("Uncaught exception from C++ API"), 0);
        }
        
        if (t)
        jenv->Throw(t);
    }
    delete arg3; 
    delete arg4; 
    delete arg5; 
}


JNIEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlContainer_1deleteIndex(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg2, jstring jarg3, jstring jarg4, jstring jarg5) {
    XmlContainer *arg1 = (XmlContainer *) 0 ;
    DbTxn *arg2 = (DbTxn *) 0 ;
    std::string *arg3 = 0 ;
    std::string *arg4 = 0 ;
    std::string *arg5 = 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(XmlContainer **)&jarg1; 
    {
        arg2 = get_DbTxn(jenv, jarg2);
    }
    arg3 = NULL;
    if(jarg3) {
        const char *pstr = (const char *)jenv->GetStringUTFChars(jarg3, 0); 
        if (!pstr) return ;
        arg3 =  new std::string(pstr);
        jenv->ReleaseStringUTFChars(jarg3, pstr);
    }
    else {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null std::string");
        return ;
    }
    arg4 = NULL;
    if(jarg4) {
        const char *pstr = (const char *)jenv->GetStringUTFChars(jarg4, 0); 
        if (!pstr) return ;
        arg4 =  new std::string(pstr);
        jenv->ReleaseStringUTFChars(jarg4, pstr);
    }
    else {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null std::string");
        return ;
    }
    arg5 = NULL;
    if(jarg5) {
        const char *pstr = (const char *)jenv->GetStringUTFChars(jarg5, 0); 
        if (!pstr) return ;
        arg5 =  new std::string(pstr);
        jenv->ReleaseStringUTFChars(jarg5, pstr);
    }
    else {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null std::string");
        return ;
    }
    
    if (!jarg1) {
        jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        EINVAL));
        return ;
    }
    
    {
        jthrowable t = NULL;
        
        try {
            (arg1)->deleteIndex(arg2,(std::string const &)*arg3,(std::string const &)*arg4,(std::string const &)*arg5);
            
        }catch (XmlException &xe) {
            t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
            xe.getExceptionCode(), jenv->NewStringUTF(xe.what()),
            xe.getDbErrno());
        }catch (...) {
            fprintf(stderr, "Uncaught exception from C++ API!\n");
            t = (jthrowable)jenv->NewObject(dbex_class, dbex_construct,
            jenv->NewStringUTF("Uncaught exception from C++ API"), 0);
        }
        
        if (t)
        jenv->Throw(t);
    }
    delete arg3; 
    delete arg4; 
    delete arg5; 
}


JNIEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlContainer_1replaceIndex(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg2, jstring jarg3, jstring jarg4, jstring jarg5) {
    XmlContainer *arg1 = (XmlContainer *) 0 ;
    DbTxn *arg2 = (DbTxn *) 0 ;
    std::string *arg3 = 0 ;
    std::string *arg4 = 0 ;
    std::string *arg5 = 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(XmlContainer **)&jarg1; 
    {
        arg2 = get_DbTxn(jenv, jarg2);
    }
    arg3 = NULL;
    if(jarg3) {
        const char *pstr = (const char *)jenv->GetStringUTFChars(jarg3, 0); 
        if (!pstr) return ;
        arg3 =  new std::string(pstr);
        jenv->ReleaseStringUTFChars(jarg3, pstr);
    }
    else {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null std::string");
        return ;
    }
    arg4 = NULL;
    if(jarg4) {
        const char *pstr = (const char *)jenv->GetStringUTFChars(jarg4, 0); 
        if (!pstr) return ;
        arg4 =  new std::string(pstr);
        jenv->ReleaseStringUTFChars(jarg4, pstr);
    }
    else {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null std::string");
        return ;
    }
    arg5 = NULL;
    if(jarg5) {
        const char *pstr = (const char *)jenv->GetStringUTFChars(jarg5, 0); 
        if (!pstr) return ;
        arg5 =  new std::string(pstr);
        jenv->ReleaseStringUTFChars(jarg5, pstr);
    }
    else {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null std::string");
        return ;
    }
    
    if (!jarg1) {
        jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        EINVAL));
        return ;
    }
    
    {
        jthrowable t = NULL;
        
        try {
            (arg1)->replaceIndex(arg2,(std::string const &)*arg3,(std::string const &)*arg4,(std::string const &)*arg5);
            
        }catch (XmlException &xe) {
            t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
            xe.getExceptionCode(), jenv->NewStringUTF(xe.what()),
            xe.getDbErrno());
        }catch (...) {
            fprintf(stderr, "Uncaught exception from C++ API!\n");
            t = (jthrowable)jenv->NewObject(dbex_class, dbex_construct,
            jenv->NewStringUTF("Uncaught exception from C++ API"), 0);
        }
        
        if (t)
        jenv->Throw(t);
    }
    delete arg3; 
    delete arg4; 
    delete arg5; 
}


JNIEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlContainer_1upgrade(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    XmlContainer *arg1 = (XmlContainer *) 0 ;
    u_int32_t arg2 = (u_int32_t) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(XmlContainer **)&jarg1; 
    arg2 = (u_int32_t)jarg2; 
    
    if (!jarg1) {
        jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        EINVAL));
        return ;
    }
    
    {
        jthrowable t = NULL;
        
        try {
            (arg1)->upgrade(arg2);
            
        }catch (XmlException &xe) {
            t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
            xe.getExceptionCode(), jenv->NewStringUTF(xe.what()),
            xe.getDbErrno());
        }catch (...) {
            fprintf(stderr, "Uncaught exception from C++ API!\n");
            t = (jthrowable)jenv->NewObject(dbex_class, dbex_construct,
            jenv->NewStringUTF("Uncaught exception from C++ API"), 0);
        }
        
        if (t)
        jenv->Throw(t);
    }
}


JNIEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlContainer_1getIndexSpecification(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg2) {
    jlong jresult = 0 ;
    XmlContainer *arg1 = (XmlContainer *) 0 ;
    DbTxn *arg2 = (DbTxn *) 0 ;
    XmlIndexSpecification *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(XmlContainer **)&jarg1; 
    {
        arg2 = get_DbTxn(jenv, jarg2);
    }
    
    if (!jarg1) {
        jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        EINVAL));
        return 0;
    }
    
    {
        jthrowable t = NULL;
        
        try {
            result = (XmlIndexSpecification *)XmlContainer_getIndexSpecification((XmlContainer const *)arg1,arg2);
            
        }catch (XmlException &xe) {
            t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
            xe.getExceptionCode(), jenv->NewStringUTF(xe.what()),
            xe.getDbErrno());
        }catch (...) {
            fprintf(stderr, "Uncaught exception from C++ API!\n");
            t = (jthrowable)jenv->NewObject(dbex_class, dbex_construct,
            jenv->NewStringUTF("Uncaught exception from C++ API"), 0);
        }
        
        if (t)
        jenv->Throw(t);
    }
    *(XmlIndexSpecification **)&jresult = result; 
    return jresult;
}


JNIEXPORT jstring JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlContainer_1getName(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    XmlContainer *arg1 = (XmlContainer *) 0 ;
    std::string *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(XmlContainer **)&jarg1; 
    
    if (!jarg1) {
        jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        EINVAL));
        return 0;
    }
    
    {
        jthrowable t = NULL;
        
        try {
            {
                std::string const &_result_ref = ((XmlContainer const *)arg1)->getName();
                result = (std::string *) &_result_ref;
            }
            
        }catch (XmlException &xe) {
            t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
            xe.getExceptionCode(), jenv->NewStringUTF(xe.what()),
            xe.getDbErrno());
        }catch (...) {
            fprintf(stderr, "Uncaught exception from C++ API!\n");
            t = (jthrowable)jenv->NewObject(dbex_class, dbex_construct,
            jenv->NewStringUTF("Uncaught exception from C++ API"), 0);
        }
        
        if (t)
        jenv->Throw(t);
    }
    jresult = jenv->NewStringUTF(result->c_str()); 
    return jresult;
}


JNIEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlContainer_1setName(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    XmlContainer *arg1 = (XmlContainer *) 0 ;
    std::string *arg2 = 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(XmlContainer **)&jarg1; 
    arg2 = NULL;
    if(jarg2) {
        const char *pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
        if (!pstr) return ;
        arg2 =  new std::string(pstr);
        jenv->ReleaseStringUTFChars(jarg2, pstr);
    }
    else {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null std::string");
        return ;
    }
    
    if (!jarg1) {
        jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        EINVAL));
        return ;
    }
    
    {
        jthrowable t = NULL;
        
        try {
            (arg1)->setName((std::string const &)*arg2);
            
        }catch (XmlException &xe) {
            t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
            xe.getExceptionCode(), jenv->NewStringUTF(xe.what()),
            xe.getDbErrno());
        }catch (...) {
            fprintf(stderr, "Uncaught exception from C++ API!\n");
            t = (jthrowable)jenv->NewObject(dbex_class, dbex_construct,
            jenv->NewStringUTF("Uncaught exception from C++ API"), 0);
        }
        
        if (t)
        jenv->Throw(t);
    }
    delete arg2; 
}


JNIEXPORT jint JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlContainer_1putDocument(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg2, jlong jarg3, jlong jarg4, jint jarg5) {
    jint jresult = 0 ;
    XmlContainer *arg1 = (XmlContainer *) 0 ;
    DbTxn *arg2 = (DbTxn *) 0 ;
    XmlDocument *arg3 = 0 ;
    XmlUpdateContext *arg4 = (XmlUpdateContext *) 0 ;
    u_int32_t arg5 = (u_int32_t) 0 ;
    u_int32_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(XmlContainer **)&jarg1; 
    {
        arg2 = get_DbTxn(jenv, jarg2);
    }
    arg3 = *(XmlDocument **)&jarg3;
    if(!arg3) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlDocument & reference is null");
        return 0;
    }
    arg4 = *(XmlUpdateContext **)&jarg4; 
    arg5 = (u_int32_t)jarg5; 
    
    if (!jarg1) {
        jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        EINVAL));
        return 0;
    }
    
    {
        jthrowable t = NULL;
        
        try {
            result = (u_int32_t)(arg1)->putDocument(arg2,*arg3,arg4,arg5);
            
        }catch (XmlException &xe) {
            t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
            xe.getExceptionCode(), jenv->NewStringUTF(xe.what()),
            xe.getDbErrno());
        }catch (...) {
            fprintf(stderr, "Uncaught exception from C++ API!\n");
            t = (jthrowable)jenv->NewObject(dbex_class, dbex_construct,
            jenv->NewStringUTF("Uncaught exception from C++ API"), 0);
        }
        
        if (t)
        jenv->Throw(t);
    }
    jresult = (jlong)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlContainer_1updateDocument(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg2, jlong jarg3, jlong jarg4) {
    XmlContainer *arg1 = (XmlContainer *) 0 ;
    DbTxn *arg2 = (DbTxn *) 0 ;
    XmlDocument *arg3 = 0 ;
    XmlUpdateContext *arg4 = (XmlUpdateContext *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(XmlContainer **)&jarg1; 
    {
        arg2 = get_DbTxn(jenv, jarg2);
    }
    arg3 = *(XmlDocument **)&jarg3;
    if(!arg3) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlDocument & reference is null");
        return ;
    }
    arg4 = *(XmlUpdateContext **)&jarg4; 
    
    if (!jarg1) {
        jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        EINVAL));
        return ;
    }
    
    {
        jthrowable t = NULL;
        
        try {
            (arg1)->updateDocument(arg2,*arg3,arg4);
            
        }catch (XmlException &xe) {
            t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
            xe.getExceptionCode(), jenv->NewStringUTF(xe.what()),
            xe.getDbErrno());
        }catch (...) {
            fprintf(stderr, "Uncaught exception from C++ API!\n");
            t = (jthrowable)jenv->NewObject(dbex_class, dbex_construct,
            jenv->NewStringUTF("Uncaught exception from C++ API"), 0);
        }
        
        if (t)
        jenv->Throw(t);
    }
}


JNIEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlContainer_1remove(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg2, jint jarg3) {
    XmlContainer *arg1 = (XmlContainer *) 0 ;
    DbTxn *arg2 = (DbTxn *) 0 ;
    u_int32_t arg3 = (u_int32_t) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(XmlContainer **)&jarg1; 
    {
        arg2 = get_DbTxn(jenv, jarg2);
    }
    arg3 = (u_int32_t)jarg3; 
    
    if (!jarg1) {
        jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        EINVAL));
        return ;
    }
    
    {
        jthrowable t = NULL;
        
        try {
            (arg1)->remove(arg2,arg3);
            
        }catch (XmlException &xe) {
            t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
            xe.getExceptionCode(), jenv->NewStringUTF(xe.what()),
            xe.getDbErrno());
        }catch (...) {
            fprintf(stderr, "Uncaught exception from C++ API!\n");
            t = (jthrowable)jenv->NewObject(dbex_class, dbex_construct,
            jenv->NewStringUTF("Uncaught exception from C++ API"), 0);
        }
        
        if (t)
        jenv->Throw(t);
    }
}


JNIEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlContainer_1rename(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg2, jstring jarg3, jint jarg4) {
    XmlContainer *arg1 = (XmlContainer *) 0 ;
    DbTxn *arg2 = (DbTxn *) 0 ;
    std::string *arg3 = 0 ;
    u_int32_t arg4 = (u_int32_t) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(XmlContainer **)&jarg1; 
    {
        arg2 = get_DbTxn(jenv, jarg2);
    }
    arg3 = NULL;
    if(jarg3) {
        const char *pstr = (const char *)jenv->GetStringUTFChars(jarg3, 0); 
        if (!pstr) return ;
        arg3 =  new std::string(pstr);
        jenv->ReleaseStringUTFChars(jarg3, pstr);
    }
    else {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null std::string");
        return ;
    }
    arg4 = (u_int32_t)jarg4; 
    
    if (!jarg1) {
        jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        EINVAL));
        return ;
    }
    
    {
        jthrowable t = NULL;
        
        try {
            (arg1)->rename(arg2,(std::string const &)*arg3,arg4);
            
        }catch (XmlException &xe) {
            t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
            xe.getExceptionCode(), jenv->NewStringUTF(xe.what()),
            xe.getDbErrno());
        }catch (...) {
            fprintf(stderr, "Uncaught exception from C++ API!\n");
            t = (jthrowable)jenv->NewObject(dbex_class, dbex_construct,
            jenv->NewStringUTF("Uncaught exception from C++ API"), 0);
        }
        
        if (t)
        jenv->Throw(t);
    }
    delete arg3; 
}


JNIEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlContainer_1deleteDocument_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg2, jint jarg3, jlong jarg4, jint jarg5) {
    XmlContainer *arg1 = (XmlContainer *) 0 ;
    DbTxn *arg2 = (DbTxn *) 0 ;
    u_int32_t arg3 ;
    XmlUpdateContext *arg4 = (XmlUpdateContext *) 0 ;
    u_int32_t arg5 = (u_int32_t) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(XmlContainer **)&jarg1; 
    {
        arg2 = get_DbTxn(jenv, jarg2);
    }
    arg3 = (u_int32_t)jarg3; 
    arg4 = *(XmlUpdateContext **)&jarg4; 
    arg5 = (u_int32_t)jarg5; 
    
    if (!jarg1) {
        jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        EINVAL));
        return ;
    }
    
    {
        jthrowable t = NULL;
        
        try {
            (arg1)->deleteDocument(arg2,arg3,arg4,arg5);
            
        }catch (XmlException &xe) {
            t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
            xe.getExceptionCode(), jenv->NewStringUTF(xe.what()),
            xe.getDbErrno());
        }catch (...) {
            fprintf(stderr, "Uncaught exception from C++ API!\n");
            t = (jthrowable)jenv->NewObject(dbex_class, dbex_construct,
            jenv->NewStringUTF("Uncaught exception from C++ API"), 0);
        }
        
        if (t)
        jenv->Throw(t);
    }
}


JNIEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlContainer_1deleteDocument_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg2, jlong jarg3, jlong jarg4, jint jarg5) {
    XmlContainer *arg1 = (XmlContainer *) 0 ;
    DbTxn *arg2 = (DbTxn *) 0 ;
    XmlDocument *arg3 = 0 ;
    XmlUpdateContext *arg4 = (XmlUpdateContext *) 0 ;
    u_int32_t arg5 = (u_int32_t) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(XmlContainer **)&jarg1; 
    {
        arg2 = get_DbTxn(jenv, jarg2);
    }
    arg3 = *(XmlDocument **)&jarg3;
    if(!arg3) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlDocument & reference is null");
        return ;
    }
    arg4 = *(XmlUpdateContext **)&jarg4; 
    arg5 = (u_int32_t)jarg5; 
    
    if (!jarg1) {
        jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        EINVAL));
        return ;
    }
    
    {
        jthrowable t = NULL;
        
        try {
            (arg1)->deleteDocument(arg2,*arg3,arg4,arg5);
            
        }catch (XmlException &xe) {
            t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
            xe.getExceptionCode(), jenv->NewStringUTF(xe.what()),
            xe.getDbErrno());
        }catch (...) {
            fprintf(stderr, "Uncaught exception from C++ API!\n");
            t = (jthrowable)jenv->NewObject(dbex_class, dbex_construct,
            jenv->NewStringUTF("Uncaught exception from C++ API"), 0);
        }
        
        if (t)
        jenv->Throw(t);
    }
}


JNIEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlContainer_1modifyDocument(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg2, jlong jarg3, jlong jarg4, jint jarg5) {
    XmlContainer *arg1 = (XmlContainer *) 0 ;
    DbTxn *arg2 = (DbTxn *) 0 ;
    XmlModify *arg3 = 0 ;
    XmlUpdateContext *arg4 = (XmlUpdateContext *) 0 ;
    u_int32_t arg5 = (u_int32_t) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(XmlContainer **)&jarg1; 
    {
        arg2 = get_DbTxn(jenv, jarg2);
    }
    arg3 = *(XmlModify **)&jarg3;
    if(!arg3) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlModify & reference is null");
        return ;
    }
    arg4 = *(XmlUpdateContext **)&jarg4; 
    arg5 = (u_int32_t)jarg5; 
    
    if (!jarg1) {
        jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        EINVAL));
        return ;
    }
    
    {
        jthrowable t = NULL;
        
        try {
            (arg1)->modifyDocument(arg2,*arg3,arg4,arg5);
            
        }catch (XmlException &xe) {
            t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
            xe.getExceptionCode(), jenv->NewStringUTF(xe.what()),
            xe.getDbErrno());
        }catch (...) {
            fprintf(stderr, "Uncaught exception from C++ API!\n");
            t = (jthrowable)jenv->NewObject(dbex_class, dbex_construct,
            jenv->NewStringUTF("Uncaught exception from C++ API"), 0);
        }
        
        if (t)
        jenv->Throw(t);
    }
}


JNIEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlContainer_1getDocument(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg2, jint jarg3, jint jarg4) {
    jlong jresult = 0 ;
    XmlContainer *arg1 = (XmlContainer *) 0 ;
    DbTxn *arg2 = (DbTxn *) 0 ;
    u_int32_t arg3 ;
    u_int32_t arg4 = (u_int32_t) 0 ;
    XmlDocument *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(XmlContainer **)&jarg1; 
    {
        arg2 = get_DbTxn(jenv, jarg2);
    }
    arg3 = (u_int32_t)jarg3; 
    arg4 = (u_int32_t)jarg4; 
    
    if (!jarg1) {
        jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        EINVAL));
        return 0;
    }
    
    {
        jthrowable t = NULL;
        
        try {
            result = (XmlDocument *)XmlContainer_getDocument(arg1,arg2,arg3,arg4);
            
        }catch (XmlException &xe) {
            t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
            xe.getExceptionCode(), jenv->NewStringUTF(xe.what()),
            xe.getDbErrno());
        }catch (...) {
            fprintf(stderr, "Uncaught exception from C++ API!\n");
            t = (jthrowable)jenv->NewObject(dbex_class, dbex_construct,
            jenv->NewStringUTF("Uncaught exception from C++ API"), 0);
        }
        
        if (t)
        jenv->Throw(t);
    }
    *(XmlDocument **)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlContainer_1parseXPathExpression(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg2, jstring jarg3, jlong jarg4) {
    jlong jresult = 0 ;
    XmlContainer *arg1 = (XmlContainer *) 0 ;
    DbTxn *arg2 = (DbTxn *) 0 ;
    std::string *arg3 = 0 ;
    XmlQueryContext *arg4 = (XmlQueryContext *) 0 ;
    XmlQueryExpression *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(XmlContainer **)&jarg1; 
    {
        arg2 = get_DbTxn(jenv, jarg2);
    }
    arg3 = NULL;
    if(jarg3) {
        const char *pstr = (const char *)jenv->GetStringUTFChars(jarg3, 0); 
        if (!pstr) return 0;
        arg3 =  new std::string(pstr);
        jenv->ReleaseStringUTFChars(jarg3, pstr);
    }
    else {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null std::string");
        return 0;
    }
    arg4 = *(XmlQueryContext **)&jarg4; 
    
    if (!jarg1) {
        jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        EINVAL));
        return 0;
    }
    
    {
        jthrowable t = NULL;
        
        try {
            result = (XmlQueryExpression *)XmlContainer_parseXPathExpression((XmlContainer const *)arg1,arg2,(std::string const &)*arg3,arg4);
            
        }catch (XmlException &xe) {
            t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
            xe.getExceptionCode(), jenv->NewStringUTF(xe.what()),
            xe.getDbErrno());
        }catch (...) {
            fprintf(stderr, "Uncaught exception from C++ API!\n");
            t = (jthrowable)jenv->NewObject(dbex_class, dbex_construct,
            jenv->NewStringUTF("Uncaught exception from C++ API"), 0);
        }
        
        if (t)
        jenv->Throw(t);
    }
    *(XmlQueryExpression **)&jresult = result; 
    delete arg3; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlContainer_1queryWithXPath_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg2, jstring jarg3, jlong jarg4, jint jarg5) {
    jlong jresult = 0 ;
    XmlContainer *arg1 = (XmlContainer *) 0 ;
    DbTxn *arg2 = (DbTxn *) 0 ;
    std::string *arg3 = 0 ;
    XmlQueryContext *arg4 = (XmlQueryContext *) 0 ;
    u_int32_t arg5 = (u_int32_t) 0 ;
    XmlResults *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(XmlContainer **)&jarg1; 
    {
        arg2 = get_DbTxn(jenv, jarg2);
    }
    arg3 = NULL;
    if(jarg3) {
        const char *pstr = (const char *)jenv->GetStringUTFChars(jarg3, 0); 
        if (!pstr) return 0;
        arg3 =  new std::string(pstr);
        jenv->ReleaseStringUTFChars(jarg3, pstr);
    }
    else {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null std::string");
        return 0;
    }
    arg4 = *(XmlQueryContext **)&jarg4; 
    arg5 = (u_int32_t)jarg5; 
    
    if (!jarg1) {
        jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        EINVAL));
        return 0;
    }
    
    {
        jthrowable t = NULL;
        
        try {
            result = (XmlResults *)XmlContainer_queryWithXPath__SWIG_0((XmlContainer const *)arg1,arg2,(std::string const &)*arg3,arg4,arg5);
            
        }catch (XmlException &xe) {
            t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
            xe.getExceptionCode(), jenv->NewStringUTF(xe.what()),
            xe.getDbErrno());
        }catch (...) {
            fprintf(stderr, "Uncaught exception from C++ API!\n");
            t = (jthrowable)jenv->NewObject(dbex_class, dbex_construct,
            jenv->NewStringUTF("Uncaught exception from C++ API"), 0);
        }
        
        if (t)
        jenv->Throw(t);
    }
    *(XmlResults **)&jresult = result; 
    delete arg3; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlContainer_1queryWithXPath_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg2, jlong jarg3, jint jarg4) {
    jlong jresult = 0 ;
    XmlContainer *arg1 = (XmlContainer *) 0 ;
    DbTxn *arg2 = (DbTxn *) 0 ;
    XmlQueryExpression *arg3 = 0 ;
    u_int32_t arg4 = (u_int32_t) 0 ;
    XmlResults *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(XmlContainer **)&jarg1; 
    {
        arg2 = get_DbTxn(jenv, jarg2);
    }
    arg3 = *(XmlQueryExpression **)&jarg3;
    if(!arg3) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlQueryExpression & reference is null");
        return 0;
    }
    arg4 = (u_int32_t)jarg4; 
    
    if (!jarg1) {
        jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        EINVAL));
        return 0;
    }
    
    {
        jthrowable t = NULL;
        
        try {
            result = (XmlResults *)XmlContainer_queryWithXPath__SWIG_1((XmlContainer const *)arg1,arg2,*arg3,arg4);
            
        }catch (XmlException &xe) {
            t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
            xe.getExceptionCode(), jenv->NewStringUTF(xe.what()),
            xe.getDbErrno());
        }catch (...) {
            fprintf(stderr, "Uncaught exception from C++ API!\n");
            t = (jthrowable)jenv->NewObject(dbex_class, dbex_construct,
            jenv->NewStringUTF("Uncaught exception from C++ API"), 0);
        }
        
        if (t)
        jenv->Throw(t);
    }
    *(XmlResults **)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlContainer_1dump(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jint jarg3) {
    XmlContainer *arg1 = (XmlContainer *) 0 ;
    char *arg2 ;
    u_int32_t arg3 = (u_int32_t) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(XmlContainer **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
            if (!arg2) return ;
        }
    }
    arg3 = (u_int32_t)jarg3; 
    
    if (!jarg1) {
        jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        EINVAL));
        return ;
    }
    
    {
        jthrowable t = NULL;
        
        try {
            XmlContainer_dump(arg1,(char const *)arg2,arg3);
            
        }catch (XmlException &xe) {
            t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
            xe.getExceptionCode(), jenv->NewStringUTF(xe.what()),
            xe.getDbErrno());
        }catch (...) {
            fprintf(stderr, "Uncaught exception from C++ API!\n");
            t = (jthrowable)jenv->NewObject(dbex_class, dbex_construct,
            jenv->NewStringUTF("Uncaught exception from C++ API"), 0);
        }
        
        if (t)
        jenv->Throw(t);
    }
    {
        if (arg2) jenv->ReleaseStringUTFChars(jarg2, arg2); 
    }
}


JNIEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlContainer_1load(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jint jarg3) {
    XmlContainer *arg1 = (XmlContainer *) 0 ;
    char *arg2 ;
    u_int32_t arg3 = (u_int32_t) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(XmlContainer **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
            if (!arg2) return ;
        }
    }
    arg3 = (u_int32_t)jarg3; 
    
    if (!jarg1) {
        jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        EINVAL));
        return ;
    }
    
    {
        jthrowable t = NULL;
        
        try {
            XmlContainer_load(arg1,(char const *)arg2,arg3);
            
        }catch (XmlException &xe) {
            t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
            xe.getExceptionCode(), jenv->NewStringUTF(xe.what()),
            xe.getDbErrno());
        }catch (...) {
            fprintf(stderr, "Uncaught exception from C++ API!\n");
            t = (jthrowable)jenv->NewObject(dbex_class, dbex_construct,
            jenv->NewStringUTF("Uncaught exception from C++ API"), 0);
        }
        
        if (t)
        jenv->Throw(t);
    }
    {
        if (arg2) jenv->ReleaseStringUTFChars(jarg2, arg2); 
    }
}


JNIEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlContainer_1verify(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jint jarg3) {
    XmlContainer *arg1 = (XmlContainer *) 0 ;
    char *arg2 ;
    u_int32_t arg3 = (u_int32_t) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(XmlContainer **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
            if (!arg2) return ;
        }
    }
    arg3 = (u_int32_t)jarg3; 
    
    if (!jarg1) {
        jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        EINVAL));
        return ;
    }
    
    {
        jthrowable t = NULL;
        
        try {
            XmlContainer_verify(arg1,(char const *)arg2,arg3);
            
        }catch (XmlException &xe) {
            t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
            xe.getExceptionCode(), jenv->NewStringUTF(xe.what()),
            xe.getDbErrno());
        }catch (...) {
            fprintf(stderr, "Uncaught exception from C++ API!\n");
            t = (jthrowable)jenv->NewObject(dbex_class, dbex_construct,
            jenv->NewStringUTF("Uncaught exception from C++ API"), 0);
        }
        
        if (t)
        jenv->Throw(t);
    }
    {
        if (arg2) jenv->ReleaseStringUTFChars(jarg2, arg2); 
    }
}


JNIEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlContainer_1setLogLevel(JNIEnv *jenv, jclass jcls, jint jarg1, jboolean jarg2) {
    int arg1 ;
    bool arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = (int)jarg1; 
    
    arg2 = (jarg2 != JNI_FALSE);
    
    {
        jthrowable t = NULL;
        
        try {
            XmlContainer_setLogLevel((LogLevel )arg1,arg2);
            
        }catch (XmlException &xe) {
            t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
            xe.getExceptionCode(), jenv->NewStringUTF(xe.what()),
            xe.getDbErrno());
        }catch (...) {
            fprintf(stderr, "Uncaught exception from C++ API!\n");
            t = (jthrowable)jenv->NewObject(dbex_class, dbex_construct,
            jenv->NewStringUTF("Uncaught exception from C++ API"), 0);
        }
        
        if (t)
        jenv->Throw(t);
    }
}


JNIEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlContainer_1setLogCategory(JNIEnv *jenv, jclass jcls, jint jarg1, jboolean jarg2) {
    int arg1 ;
    bool arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = (int)jarg1; 
    
    arg2 = (jarg2 != JNI_FALSE);
    
    {
        jthrowable t = NULL;
        
        try {
            XmlContainer_setLogCategory((LogCategory )arg1,arg2);
            
        }catch (XmlException &xe) {
            t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
            xe.getExceptionCode(), jenv->NewStringUTF(xe.what()),
            xe.getDbErrno());
        }catch (...) {
            fprintf(stderr, "Uncaught exception from C++ API!\n");
            t = (jthrowable)jenv->NewObject(dbex_class, dbex_construct,
            jenv->NewStringUTF("Uncaught exception from C++ API"), 0);
        }
        
        if (t)
        jenv->Throw(t);
    }
}


JNIEXPORT jint JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlContainer_1get_1version_1major(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    {
        jthrowable t = NULL;
        
        try {
            result = (int)XmlContainer_get_version_major();
            
        }catch (XmlException &xe) {
            t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
            xe.getExceptionCode(), jenv->NewStringUTF(xe.what()),
            xe.getDbErrno());
        }catch (...) {
            fprintf(stderr, "Uncaught exception from C++ API!\n");
            t = (jthrowable)jenv->NewObject(dbex_class, dbex_construct,
            jenv->NewStringUTF("Uncaught exception from C++ API"), 0);
        }
        
        if (t)
        jenv->Throw(t);
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlContainer_1get_1version_1minor(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    {
        jthrowable t = NULL;
        
        try {
            result = (int)XmlContainer_get_version_minor();
            
        }catch (XmlException &xe) {
            t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
            xe.getExceptionCode(), jenv->NewStringUTF(xe.what()),
            xe.getDbErrno());
        }catch (...) {
            fprintf(stderr, "Uncaught exception from C++ API!\n");
            t = (jthrowable)jenv->NewObject(dbex_class, dbex_construct,
            jenv->NewStringUTF("Uncaught exception from C++ API"), 0);
        }
        
        if (t)
        jenv->Throw(t);
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlContainer_1get_1version_1patch(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    {
        jthrowable t = NULL;
        
        try {
            result = (int)XmlContainer_get_version_patch();
            
        }catch (XmlException &xe) {
            t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
            xe.getExceptionCode(), jenv->NewStringUTF(xe.what()),
            xe.getDbErrno());
        }catch (...) {
            fprintf(stderr, "Uncaught exception from C++ API!\n");
            t = (jthrowable)jenv->NewObject(dbex_class, dbex_construct,
            jenv->NewStringUTF("Uncaught exception from C++ API"), 0);
        }
        
        if (t)
        jenv->Throw(t);
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jstring JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlContainer_1get_1version_1string(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    {
        jthrowable t = NULL;
        
        try {
            result = (char *)XmlContainer_get_version_string();
            
        }catch (XmlException &xe) {
            t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
            xe.getExceptionCode(), jenv->NewStringUTF(xe.what()),
            xe.getDbErrno());
        }catch (...) {
            fprintf(stderr, "Uncaught exception from C++ API!\n");
            t = (jthrowable)jenv->NewObject(dbex_class, dbex_construct,
            jenv->NewStringUTF("Uncaught exception from C++ API"), 0);
        }
        
        if (t)
        jenv->Throw(t);
    }
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_new_1XmlDocument(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    XmlDocument *result;
    
    (void)jenv;
    (void)jcls;
    {
        jthrowable t = NULL;
        
        try {
            result = (XmlDocument *)new XmlDocument();
            
        }catch (XmlException &xe) {
            t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
            xe.getExceptionCode(), jenv->NewStringUTF(xe.what()),
            xe.getDbErrno());
        }catch (...) {
            fprintf(stderr, "Uncaught exception from C++ API!\n");
            t = (jthrowable)jenv->NewObject(dbex_class, dbex_construct,
            jenv->NewStringUTF("Uncaught exception from C++ API"), 0);
        }
        
        if (t)
        jenv->Throw(t);
    }
    *(XmlDocument **)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_delete_1XmlDocument(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    XmlDocument *arg1 = (XmlDocument *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(XmlDocument **)&jarg1; 
    
    if (!jarg1) {
        jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        EINVAL));
        return ;
    }
    
    {
        jthrowable t = NULL;
        
        try {
            delete arg1;
            
        }catch (XmlException &xe) {
            t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
            xe.getExceptionCode(), jenv->NewStringUTF(xe.what()),
            xe.getDbErrno());
        }catch (...) {
            fprintf(stderr, "Uncaught exception from C++ API!\n");
            t = (jthrowable)jenv->NewObject(dbex_class, dbex_construct,
            jenv->NewStringUTF("Uncaught exception from C++ API"), 0);
        }
        
        if (t)
        jenv->Throw(t);
    }
}


JNIEXPORT jint JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlDocument_1getID(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    XmlDocument *arg1 = (XmlDocument *) 0 ;
    u_int32_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(XmlDocument **)&jarg1; 
    
    if (!jarg1) {
        jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        EINVAL));
        return 0;
    }
    
    {
        jthrowable t = NULL;
        
        try {
            result = (u_int32_t)((XmlDocument const *)arg1)->getID();
            
        }catch (XmlException &xe) {
            t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
            xe.getExceptionCode(), jenv->NewStringUTF(xe.what()),
            xe.getDbErrno());
        }catch (...) {
            fprintf(stderr, "Uncaught exception from C++ API!\n");
            t = (jthrowable)jenv->NewObject(dbex_class, dbex_construct,
            jenv->NewStringUTF("Uncaught exception from C++ API"), 0);
        }
        
        if (t)
        jenv->Throw(t);
    }
    jresult = (jlong)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlDocument_1setName(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    XmlDocument *arg1 = (XmlDocument *) 0 ;
    std::string *arg2 = 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(XmlDocument **)&jarg1; 
    arg2 = NULL;
    if(jarg2) {
        const char *pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
        if (!pstr) return ;
        arg2 =  new std::string(pstr);
        jenv->ReleaseStringUTFChars(jarg2, pstr);
    }
    else {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null std::string");
        return ;
    }
    
    if (!jarg1) {
        jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        EINVAL));
        return ;
    }
    
    {
        jthrowable t = NULL;
        
        try {
            (arg1)->setName((std::string const &)*arg2);
            
        }catch (XmlException &xe) {
            t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
            xe.getExceptionCode(), jenv->NewStringUTF(xe.what()),
            xe.getDbErrno());
        }catch (...) {
            fprintf(stderr, "Uncaught exception from C++ API!\n");
            t = (jthrowable)jenv->NewObject(dbex_class, dbex_construct,
            jenv->NewStringUTF("Uncaught exception from C++ API"), 0);
        }
        
        if (t)
        jenv->Throw(t);
    }
    delete arg2; 
}


JNIEXPORT jstring JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlDocument_1getName(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    XmlDocument *arg1 = (XmlDocument *) 0 ;
    std::string result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(XmlDocument **)&jarg1; 
    
    if (!jarg1) {
        jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        EINVAL));
        return 0;
    }
    
    {
        jthrowable t = NULL;
        
        try {
            result = ((XmlDocument const *)arg1)->getName();
            
        }catch (XmlException &xe) {
            t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
            xe.getExceptionCode(), jenv->NewStringUTF(xe.what()),
            xe.getDbErrno());
        }catch (...) {
            fprintf(stderr, "Uncaught exception from C++ API!\n");
            t = (jthrowable)jenv->NewObject(dbex_class, dbex_construct,
            jenv->NewStringUTF("Uncaught exception from C++ API"), 0);
        }
        
        if (t)
        jenv->Throw(t);
    }
    jresult = jenv->NewStringUTF((&result)->c_str()); 
    return jresult;
}


JNIEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlDocument_1setContent_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jbyteArray jarg2) {
    XmlDocument *arg1 = (XmlDocument *) 0 ;
    Dbt *arg2 = 0 ;
    struct DBT_INFO ldbt2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(XmlDocument **)&jarg1; 
    
    if (jarg2 != NULL) {
        ldbt2.dbt.set_data(ldbt2.orig_data = jenv->GetByteArrayElements(jarg2, (jboolean *)0));
        ldbt2.dbt.set_size(jenv->GetArrayLength(jarg2));
    }
    ldbt2.dbt.set_flags(DB_DBT_MALLOC);
    arg2 = &ldbt2.dbt;
    
    
    if (!jarg1) {
        jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        EINVAL));
        return ;
    }
    
    {
        jthrowable t = NULL;
        
        try {
            (arg1)->setContent(*arg2);
            
        }catch (XmlException &xe) {
            t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
            xe.getExceptionCode(), jenv->NewStringUTF(xe.what()),
            xe.getDbErrno());
        }catch (...) {
            fprintf(stderr, "Uncaught exception from C++ API!\n");
            t = (jthrowable)jenv->NewObject(dbex_class, dbex_construct,
            jenv->NewStringUTF("Uncaught exception from C++ API"), 0);
        }
        
        if (t)
        jenv->Throw(t);
    }
    
    if (jarg2 != NULL)
    jenv->ReleaseByteArrayElements(jarg2, ldbt2.orig_data, 0);
    
}


JNIEXPORT jbyteArray JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlDocument_1getContent(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jbyteArray jresult = 0 ;
    XmlDocument *arg1 = (XmlDocument *) 0 ;
    Dbt *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(XmlDocument **)&jarg1; 
    
    if (!jarg1) {
        jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        EINVAL));
        return 0;
    }
    
    {
        jthrowable t = NULL;
        
        try {
            result = (Dbt *)((XmlDocument const *)arg1)->getContent();
            
        }catch (XmlException &xe) {
            t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
            xe.getExceptionCode(), jenv->NewStringUTF(xe.what()),
            xe.getDbErrno());
        }catch (...) {
            fprintf(stderr, "Uncaught exception from C++ API!\n");
            t = (jthrowable)jenv->NewObject(dbex_class, dbex_construct,
            jenv->NewStringUTF("Uncaught exception from C++ API"), 0);
        }
        
        if (t)
        jenv->Throw(t);
    }
    
    jresult = jenv->NewByteArray(result->get_size());
    jenv->SetByteArrayRegion(jresult, 0, result->get_size(), (jbyte *)result->get_data());
    
    return jresult;
}


JNIEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlDocument_1setContent_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    XmlDocument *arg1 = (XmlDocument *) 0 ;
    std::string *arg2 = 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(XmlDocument **)&jarg1; 
    arg2 = NULL;
    if(jarg2) {
        const char *pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
        if (!pstr) return ;
        arg2 =  new std::string(pstr);
        jenv->ReleaseStringUTFChars(jarg2, pstr);
    }
    else {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null std::string");
        return ;
    }
    
    if (!jarg1) {
        jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        EINVAL));
        return ;
    }
    
    {
        jthrowable t = NULL;
        
        try {
            (arg1)->setContent((std::string const &)*arg2);
            
        }catch (XmlException &xe) {
            t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
            xe.getExceptionCode(), jenv->NewStringUTF(xe.what()),
            xe.getDbErrno());
        }catch (...) {
            fprintf(stderr, "Uncaught exception from C++ API!\n");
            t = (jthrowable)jenv->NewObject(dbex_class, dbex_construct,
            jenv->NewStringUTF("Uncaught exception from C++ API"), 0);
        }
        
        if (t)
        jenv->Throw(t);
    }
    delete arg2; 
}


JNIEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlDocument_1modifyDocument(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    XmlDocument *arg1 = (XmlDocument *) 0 ;
    XmlModify *arg2 = 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(XmlDocument **)&jarg1; 
    arg2 = *(XmlModify **)&jarg2;
    if(!arg2) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlModify & reference is null");
        return ;
    }
    
    if (!jarg1) {
        jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        EINVAL));
        return ;
    }
    
    {
        jthrowable t = NULL;
        
        try {
            (arg1)->modifyDocument(*arg2);
            
        }catch (XmlException &xe) {
            t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
            xe.getExceptionCode(), jenv->NewStringUTF(xe.what()),
            xe.getDbErrno());
        }catch (...) {
            fprintf(stderr, "Uncaught exception from C++ API!\n");
            t = (jthrowable)jenv->NewObject(dbex_class, dbex_construct,
            jenv->NewStringUTF("Uncaught exception from C++ API"), 0);
        }
        
        if (t)
        jenv->Throw(t);
    }
}


JNIEXPORT jstring JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlDocument_1getContentAsString(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    XmlDocument *arg1 = (XmlDocument *) 0 ;
    std::string result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(XmlDocument **)&jarg1; 
    
    if (!jarg1) {
        jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        EINVAL));
        return 0;
    }
    
    {
        jthrowable t = NULL;
        
        try {
            result = XmlDocument_getContentAsString((XmlDocument const *)arg1);
            
        }catch (XmlException &xe) {
            t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
            xe.getExceptionCode(), jenv->NewStringUTF(xe.what()),
            xe.getDbErrno());
        }catch (...) {
            fprintf(stderr, "Uncaught exception from C++ API!\n");
            t = (jthrowable)jenv->NewObject(dbex_class, dbex_construct,
            jenv->NewStringUTF("Uncaught exception from C++ API"), 0);
        }
        
        if (t)
        jenv->Throw(t);
    }
    jresult = jenv->NewStringUTF((&result)->c_str()); 
    return jresult;
}


JNIEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlDocument_1setMetaData(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jstring jarg3, jstring jarg4, jlong jarg5) {
    XmlDocument *arg1 = (XmlDocument *) 0 ;
    std::string *arg2 = 0 ;
    std::string *arg3 = 0 ;
    std::string *arg4 = 0 ;
    XmlValue *arg5 = 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(XmlDocument **)&jarg1; 
    arg2 = NULL;
    if(jarg2) {
        const char *pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
        if (!pstr) return ;
        arg2 =  new std::string(pstr);
        jenv->ReleaseStringUTFChars(jarg2, pstr);
    }
    else {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null std::string");
        return ;
    }
    arg3 = NULL;
    if(jarg3) {
        const char *pstr = (const char *)jenv->GetStringUTFChars(jarg3, 0); 
        if (!pstr) return ;
        arg3 =  new std::string(pstr);
        jenv->ReleaseStringUTFChars(jarg3, pstr);
    }
    else {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null std::string");
        return ;
    }
    arg4 = NULL;
    if(jarg4) {
        const char *pstr = (const char *)jenv->GetStringUTFChars(jarg4, 0); 
        if (!pstr) return ;
        arg4 =  new std::string(pstr);
        jenv->ReleaseStringUTFChars(jarg4, pstr);
    }
    else {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null std::string");
        return ;
    }
    arg5 = *(XmlValue **)&jarg5;
    if(!arg5) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlValue const & reference is null");
        return ;
    }
    
    if (!jarg1) {
        jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        EINVAL));
        return ;
    }
    
    {
        jthrowable t = NULL;
        
        try {
            (arg1)->setMetaData((std::string const &)*arg2,(std::string const &)*arg3,(std::string const &)*arg4,(XmlValue const &)*arg5);
            
        }catch (XmlException &xe) {
            t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
            xe.getExceptionCode(), jenv->NewStringUTF(xe.what()),
            xe.getDbErrno());
        }catch (...) {
            fprintf(stderr, "Uncaught exception from C++ API!\n");
            t = (jthrowable)jenv->NewObject(dbex_class, dbex_construct,
            jenv->NewStringUTF("Uncaught exception from C++ API"), 0);
        }
        
        if (t)
        jenv->Throw(t);
    }
    delete arg2; 
    delete arg3; 
    delete arg4; 
}


JNIEXPORT jboolean JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlDocument_1getMetaData(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jstring jarg3, jlong jarg4) {
    jboolean jresult = 0 ;
    XmlDocument *arg1 = (XmlDocument *) 0 ;
    std::string *arg2 = 0 ;
    std::string *arg3 = 0 ;
    XmlValue *arg4 = 0 ;
    bool result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(XmlDocument **)&jarg1; 
    arg2 = NULL;
    if(jarg2) {
        const char *pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
        if (!pstr) return 0;
        arg2 =  new std::string(pstr);
        jenv->ReleaseStringUTFChars(jarg2, pstr);
    }
    else {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null std::string");
        return 0;
    }
    arg3 = NULL;
    if(jarg3) {
        const char *pstr = (const char *)jenv->GetStringUTFChars(jarg3, 0); 
        if (!pstr) return 0;
        arg3 =  new std::string(pstr);
        jenv->ReleaseStringUTFChars(jarg3, pstr);
    }
    else {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null std::string");
        return 0;
    }
    arg4 = *(XmlValue **)&jarg4;
    if(!arg4) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlValue & reference is null");
        return 0;
    }
    
    if (!jarg1) {
        jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        EINVAL));
        return 0;
    }
    
    {
        jthrowable t = NULL;
        
        try {
            result = (bool)(arg1)->getMetaData((std::string const &)*arg2,(std::string const &)*arg3,*arg4);
            
        }catch (XmlException &xe) {
            t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
            xe.getExceptionCode(), jenv->NewStringUTF(xe.what()),
            xe.getDbErrno());
        }catch (...) {
            fprintf(stderr, "Uncaught exception from C++ API!\n");
            t = (jthrowable)jenv->NewObject(dbex_class, dbex_construct,
            jenv->NewStringUTF("Uncaught exception from C++ API"), 0);
        }
        
        if (t)
        jenv->Throw(t);
    }
    
    jresult = result ? JNI_TRUE : JNI_FALSE;
    
    delete arg2; 
    delete arg3; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlDocument_1queryWithXPath_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jlong jarg3) {
    jlong jresult = 0 ;
    XmlDocument *arg1 = (XmlDocument *) 0 ;
    std::string *arg2 = 0 ;
    XmlQueryContext *arg3 = (XmlQueryContext *) 0 ;
    XmlResults *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(XmlDocument **)&jarg1; 
    arg2 = NULL;
    if(jarg2) {
        const char *pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
        if (!pstr) return 0;
        arg2 =  new std::string(pstr);
        jenv->ReleaseStringUTFChars(jarg2, pstr);
    }
    else {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null std::string");
        return 0;
    }
    arg3 = *(XmlQueryContext **)&jarg3; 
    
    if (!jarg1) {
        jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        EINVAL));
        return 0;
    }
    
    {
        jthrowable t = NULL;
        
        try {
            result = (XmlResults *)XmlDocument_queryWithXPath__SWIG_0((XmlDocument const *)arg1,(std::string const &)*arg2,arg3);
            
        }catch (XmlException &xe) {
            t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
            xe.getExceptionCode(), jenv->NewStringUTF(xe.what()),
            xe.getDbErrno());
        }catch (...) {
            fprintf(stderr, "Uncaught exception from C++ API!\n");
            t = (jthrowable)jenv->NewObject(dbex_class, dbex_construct,
            jenv->NewStringUTF("Uncaught exception from C++ API"), 0);
        }
        
        if (t)
        jenv->Throw(t);
    }
    *(XmlResults **)&jresult = result; 
    delete arg2; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlDocument_1queryWithXPath_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    jlong jresult = 0 ;
    XmlDocument *arg1 = (XmlDocument *) 0 ;
    XmlQueryExpression *arg2 = 0 ;
    XmlResults *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(XmlDocument **)&jarg1; 
    arg2 = *(XmlQueryExpression **)&jarg2;
    if(!arg2) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlQueryExpression & reference is null");
        return 0;
    }
    
    if (!jarg1) {
        jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        EINVAL));
        return 0;
    }
    
    {
        jthrowable t = NULL;
        
        try {
            result = (XmlResults *)XmlDocument_queryWithXPath__SWIG_1((XmlDocument const *)arg1,*arg2);
            
        }catch (XmlException &xe) {
            t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
            xe.getExceptionCode(), jenv->NewStringUTF(xe.what()),
            xe.getDbErrno());
        }catch (...) {
            fprintf(stderr, "Uncaught exception from C++ API!\n");
            t = (jthrowable)jenv->NewObject(dbex_class, dbex_construct,
            jenv->NewStringUTF("Uncaught exception from C++ API"), 0);
        }
        
        if (t)
        jenv->Throw(t);
    }
    *(XmlResults **)&jresult = result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_get_1XmlQueryContext_1ResultDocuments(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    {
        jthrowable t = NULL;
        
        try {
            result = (int)XmlQueryContext::ResultDocuments;
            
        }catch (XmlException &xe) {
            t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
            xe.getExceptionCode(), jenv->NewStringUTF(xe.what()),
            xe.getDbErrno());
        }catch (...) {
            fprintf(stderr, "Uncaught exception from C++ API!\n");
            t = (jthrowable)jenv->NewObject(dbex_class, dbex_construct,
            jenv->NewStringUTF("Uncaught exception from C++ API"), 0);
        }
        
        if (t)
        jenv->Throw(t);
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_get_1XmlQueryContext_1ResultValues(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    {
        jthrowable t = NULL;
        
        try {
            result = (int)XmlQueryContext::ResultValues;
            
        }catch (XmlException &xe) {
            t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
            xe.getExceptionCode(), jenv->NewStringUTF(xe.what()),
            xe.getDbErrno());
        }catch (...) {
            fprintf(stderr, "Uncaught exception from C++ API!\n");
            t = (jthrowable)jenv->NewObject(dbex_class, dbex_construct,
            jenv->NewStringUTF("Uncaught exception from C++ API"), 0);
        }
        
        if (t)
        jenv->Throw(t);
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_get_1XmlQueryContext_1CandidateDocuments(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    {
        jthrowable t = NULL;
        
        try {
            result = (int)XmlQueryContext::CandidateDocuments;
            
        }catch (XmlException &xe) {
            t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
            xe.getExceptionCode(), jenv->NewStringUTF(xe.what()),
            xe.getDbErrno());
        }catch (...) {
            fprintf(stderr, "Uncaught exception from C++ API!\n");
            t = (jthrowable)jenv->NewObject(dbex_class, dbex_construct,
            jenv->NewStringUTF("Uncaught exception from C++ API"), 0);
        }
        
        if (t)
        jenv->Throw(t);
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_get_1XmlQueryContext_1ResultDocumentsAndValues(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    {
        jthrowable t = NULL;
        
        try {
            result = (int)XmlQueryContext::ResultDocumentsAndValues;
            
        }catch (XmlException &xe) {
            t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
            xe.getExceptionCode(), jenv->NewStringUTF(xe.what()),
            xe.getDbErrno());
        }catch (...) {
            fprintf(stderr, "Uncaught exception from C++ API!\n");
            t = (jthrowable)jenv->NewObject(dbex_class, dbex_construct,
            jenv->NewStringUTF("Uncaught exception from C++ API"), 0);
        }
        
        if (t)
        jenv->Throw(t);
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_get_1XmlQueryContext_1Eager(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    {
        jthrowable t = NULL;
        
        try {
            result = (int)XmlQueryContext::Eager;
            
        }catch (XmlException &xe) {
            t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
            xe.getExceptionCode(), jenv->NewStringUTF(xe.what()),
            xe.getDbErrno());
        }catch (...) {
            fprintf(stderr, "Uncaught exception from C++ API!\n");
            t = (jthrowable)jenv->NewObject(dbex_class, dbex_construct,
            jenv->NewStringUTF("Uncaught exception from C++ API"), 0);
        }
        
        if (t)
        jenv->Throw(t);
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_get_1XmlQueryContext_1Lazy(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    {
        jthrowable t = NULL;
        
        try {
            result = (int)XmlQueryContext::Lazy;
            
        }catch (XmlException &xe) {
            t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
            xe.getExceptionCode(), jenv->NewStringUTF(xe.what()),
            xe.getDbErrno());
        }catch (...) {
            fprintf(stderr, "Uncaught exception from C++ API!\n");
            t = (jthrowable)jenv->NewObject(dbex_class, dbex_construct,
            jenv->NewStringUTF("Uncaught exception from C++ API"), 0);
        }
        
        if (t)
        jenv->Throw(t);
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_new_1XmlQueryContext(JNIEnv *jenv, jclass jcls, jint jarg1, jint jarg2) {
    jlong jresult = 0 ;
    int arg1 = (int) XmlQueryContext::ResultDocuments ;
    int arg2 = (int) XmlQueryContext::Eager ;
    XmlQueryContext *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = (int)jarg1; 
    arg2 = (int)jarg2; 
    {
        jthrowable t = NULL;
        
        try {
            result = (XmlQueryContext *)new XmlQueryContext((XmlQueryContext::ReturnType )arg1,(XmlQueryContext::EvaluationType )arg2);
            
        }catch (XmlException &xe) {
            t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
            xe.getExceptionCode(), jenv->NewStringUTF(xe.what()),
            xe.getDbErrno());
        }catch (...) {
            fprintf(stderr, "Uncaught exception from C++ API!\n");
            t = (jthrowable)jenv->NewObject(dbex_class, dbex_construct,
            jenv->NewStringUTF("Uncaught exception from C++ API"), 0);
        }
        
        if (t)
        jenv->Throw(t);
    }
    *(XmlQueryContext **)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_delete_1XmlQueryContext(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    XmlQueryContext *arg1 = (XmlQueryContext *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(XmlQueryContext **)&jarg1; 
    
    if (!jarg1) {
        jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        EINVAL));
        return ;
    }
    
    {
        jthrowable t = NULL;
        
        try {
            delete arg1;
            
        }catch (XmlException &xe) {
            t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
            xe.getExceptionCode(), jenv->NewStringUTF(xe.what()),
            xe.getDbErrno());
        }catch (...) {
            fprintf(stderr, "Uncaught exception from C++ API!\n");
            t = (jthrowable)jenv->NewObject(dbex_class, dbex_construct,
            jenv->NewStringUTF("Uncaught exception from C++ API"), 0);
        }
        
        if (t)
        jenv->Throw(t);
    }
}


JNIEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlQueryContext_1setNamespace(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jstring jarg3) {
    XmlQueryContext *arg1 = (XmlQueryContext *) 0 ;
    std::string *arg2 = 0 ;
    std::string *arg3 = 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(XmlQueryContext **)&jarg1; 
    arg2 = NULL;
    if(jarg2) {
        const char *pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
        if (!pstr) return ;
        arg2 =  new std::string(pstr);
        jenv->ReleaseStringUTFChars(jarg2, pstr);
    }
    else {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null std::string");
        return ;
    }
    arg3 = NULL;
    if(jarg3) {
        const char *pstr = (const char *)jenv->GetStringUTFChars(jarg3, 0); 
        if (!pstr) return ;
        arg3 =  new std::string(pstr);
        jenv->ReleaseStringUTFChars(jarg3, pstr);
    }
    else {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null std::string");
        return ;
    }
    
    if (!jarg1) {
        jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        EINVAL));
        return ;
    }
    
    {
        jthrowable t = NULL;
        
        try {
            (arg1)->setNamespace((std::string const &)*arg2,(std::string const &)*arg3);
            
        }catch (XmlException &xe) {
            t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
            xe.getExceptionCode(), jenv->NewStringUTF(xe.what()),
            xe.getDbErrno());
        }catch (...) {
            fprintf(stderr, "Uncaught exception from C++ API!\n");
            t = (jthrowable)jenv->NewObject(dbex_class, dbex_construct,
            jenv->NewStringUTF("Uncaught exception from C++ API"), 0);
        }
        
        if (t)
        jenv->Throw(t);
    }
    delete arg2; 
    delete arg3; 
}


JNIEXPORT jstring JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlQueryContext_1getNamespace(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    jstring jresult = 0 ;
    XmlQueryContext *arg1 = (XmlQueryContext *) 0 ;
    std::string *arg2 = 0 ;
    std::string result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(XmlQueryContext **)&jarg1; 
    arg2 = NULL;
    if(jarg2) {
        const char *pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
        if (!pstr) return 0;
        arg2 =  new std::string(pstr);
        jenv->ReleaseStringUTFChars(jarg2, pstr);
    }
    else {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null std::string");
        return 0;
    }
    
    if (!jarg1) {
        jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        EINVAL));
        return 0;
    }
    
    {
        jthrowable t = NULL;
        
        try {
            result = (arg1)->getNamespace((std::string const &)*arg2);
            
        }catch (XmlException &xe) {
            t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
            xe.getExceptionCode(), jenv->NewStringUTF(xe.what()),
            xe.getDbErrno());
        }catch (...) {
            fprintf(stderr, "Uncaught exception from C++ API!\n");
            t = (jthrowable)jenv->NewObject(dbex_class, dbex_construct,
            jenv->NewStringUTF("Uncaught exception from C++ API"), 0);
        }
        
        if (t)
        jenv->Throw(t);
    }
    jresult = jenv->NewStringUTF((&result)->c_str()); 
    delete arg2; 
    return jresult;
}


JNIEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlQueryContext_1removeNamespace(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    XmlQueryContext *arg1 = (XmlQueryContext *) 0 ;
    std::string *arg2 = 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(XmlQueryContext **)&jarg1; 
    arg2 = NULL;
    if(jarg2) {
        const char *pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
        if (!pstr) return ;
        arg2 =  new std::string(pstr);
        jenv->ReleaseStringUTFChars(jarg2, pstr);
    }
    else {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null std::string");
        return ;
    }
    
    if (!jarg1) {
        jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        EINVAL));
        return ;
    }
    
    {
        jthrowable t = NULL;
        
        try {
            (arg1)->removeNamespace((std::string const &)*arg2);
            
        }catch (XmlException &xe) {
            t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
            xe.getExceptionCode(), jenv->NewStringUTF(xe.what()),
            xe.getDbErrno());
        }catch (...) {
            fprintf(stderr, "Uncaught exception from C++ API!\n");
            t = (jthrowable)jenv->NewObject(dbex_class, dbex_construct,
            jenv->NewStringUTF("Uncaught exception from C++ API"), 0);
        }
        
        if (t)
        jenv->Throw(t);
    }
    delete arg2; 
}


JNIEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlQueryContext_1clearNamespaces(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    XmlQueryContext *arg1 = (XmlQueryContext *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(XmlQueryContext **)&jarg1; 
    
    if (!jarg1) {
        jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        EINVAL));
        return ;
    }
    
    {
        jthrowable t = NULL;
        
        try {
            (arg1)->clearNamespaces();
            
        }catch (XmlException &xe) {
            t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
            xe.getExceptionCode(), jenv->NewStringUTF(xe.what()),
            xe.getDbErrno());
        }catch (...) {
            fprintf(stderr, "Uncaught exception from C++ API!\n");
            t = (jthrowable)jenv->NewObject(dbex_class, dbex_construct,
            jenv->NewStringUTF("Uncaught exception from C++ API"), 0);
        }
        
        if (t)
        jenv->Throw(t);
    }
}


JNIEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlQueryContext_1setVariableValue(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jlong jarg3) {
    XmlQueryContext *arg1 = (XmlQueryContext *) 0 ;
    std::string *arg2 = 0 ;
    XmlValue *arg3 = 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(XmlQueryContext **)&jarg1; 
    arg2 = NULL;
    if(jarg2) {
        const char *pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
        if (!pstr) return ;
        arg2 =  new std::string(pstr);
        jenv->ReleaseStringUTFChars(jarg2, pstr);
    }
    else {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null std::string");
        return ;
    }
    arg3 = *(XmlValue **)&jarg3;
    if(!arg3) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlValue const & reference is null");
        return ;
    }
    
    if (!jarg1) {
        jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        EINVAL));
        return ;
    }
    
    {
        jthrowable t = NULL;
        
        try {
            (arg1)->setVariableValue((std::string const &)*arg2,(XmlValue const &)*arg3);
            
        }catch (XmlException &xe) {
            t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
            xe.getExceptionCode(), jenv->NewStringUTF(xe.what()),
            xe.getDbErrno());
        }catch (...) {
            fprintf(stderr, "Uncaught exception from C++ API!\n");
            t = (jthrowable)jenv->NewObject(dbex_class, dbex_construct,
            jenv->NewStringUTF("Uncaught exception from C++ API"), 0);
        }
        
        if (t)
        jenv->Throw(t);
    }
    delete arg2; 
}


JNIEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlQueryContext_1setReturnType(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    XmlQueryContext *arg1 = (XmlQueryContext *) 0 ;
    int arg2 = (int) XmlQueryContext::ResultDocuments ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(XmlQueryContext **)&jarg1; 
    arg2 = (int)jarg2; 
    
    if (!jarg1) {
        jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        EINVAL));
        return ;
    }
    
    {
        jthrowable t = NULL;
        
        try {
            (arg1)->setReturnType((XmlQueryContext::ReturnType )arg2);
            
        }catch (XmlException &xe) {
            t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
            xe.getExceptionCode(), jenv->NewStringUTF(xe.what()),
            xe.getDbErrno());
        }catch (...) {
            fprintf(stderr, "Uncaught exception from C++ API!\n");
            t = (jthrowable)jenv->NewObject(dbex_class, dbex_construct,
            jenv->NewStringUTF("Uncaught exception from C++ API"), 0);
        }
        
        if (t)
        jenv->Throw(t);
    }
}


JNIEXPORT jint JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlQueryContext_1getReturnType(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    XmlQueryContext *arg1 = (XmlQueryContext *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(XmlQueryContext **)&jarg1; 
    
    if (!jarg1) {
        jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        EINVAL));
        return 0;
    }
    
    {
        jthrowable t = NULL;
        
        try {
            result = (int)((XmlQueryContext const *)arg1)->getReturnType();
            
        }catch (XmlException &xe) {
            t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
            xe.getExceptionCode(), jenv->NewStringUTF(xe.what()),
            xe.getDbErrno());
        }catch (...) {
            fprintf(stderr, "Uncaught exception from C++ API!\n");
            t = (jthrowable)jenv->NewObject(dbex_class, dbex_construct,
            jenv->NewStringUTF("Uncaught exception from C++ API"), 0);
        }
        
        if (t)
        jenv->Throw(t);
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlQueryContext_1setEvaluationType(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    XmlQueryContext *arg1 = (XmlQueryContext *) 0 ;
    int arg2 = (int) XmlQueryContext::Eager ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(XmlQueryContext **)&jarg1; 
    arg2 = (int)jarg2; 
    
    if (!jarg1) {
        jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        EINVAL));
        return ;
    }
    
    {
        jthrowable t = NULL;
        
        try {
            (arg1)->setEvaluationType((XmlQueryContext::EvaluationType )arg2);
            
        }catch (XmlException &xe) {
            t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
            xe.getExceptionCode(), jenv->NewStringUTF(xe.what()),
            xe.getDbErrno());
        }catch (...) {
            fprintf(stderr, "Uncaught exception from C++ API!\n");
            t = (jthrowable)jenv->NewObject(dbex_class, dbex_construct,
            jenv->NewStringUTF("Uncaught exception from C++ API"), 0);
        }
        
        if (t)
        jenv->Throw(t);
    }
}


JNIEXPORT jint JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlQueryContext_1getEvaluationType(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    XmlQueryContext *arg1 = (XmlQueryContext *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(XmlQueryContext **)&jarg1; 
    
    if (!jarg1) {
        jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        EINVAL));
        return 0;
    }
    
    {
        jthrowable t = NULL;
        
        try {
            result = (int)((XmlQueryContext const *)arg1)->getEvaluationType();
            
        }catch (XmlException &xe) {
            t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
            xe.getExceptionCode(), jenv->NewStringUTF(xe.what()),
            xe.getDbErrno());
        }catch (...) {
            fprintf(stderr, "Uncaught exception from C++ API!\n");
            t = (jthrowable)jenv->NewObject(dbex_class, dbex_construct,
            jenv->NewStringUTF("Uncaught exception from C++ API"), 0);
        }
        
        if (t)
        jenv->Throw(t);
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlQueryContext_1setWithMetaData(JNIEnv *jenv, jclass jcls, jlong jarg1, jboolean jarg2) {
    XmlQueryContext *arg1 = (XmlQueryContext *) 0 ;
    bool arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(XmlQueryContext **)&jarg1; 
    
    arg2 = (jarg2 != JNI_FALSE);
    
    
    if (!jarg1) {
        jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        EINVAL));
        return ;
    }
    
    {
        jthrowable t = NULL;
        
        try {
            (arg1)->setWithMetaData(arg2);
            
        }catch (XmlException &xe) {
            t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
            xe.getExceptionCode(), jenv->NewStringUTF(xe.what()),
            xe.getDbErrno());
        }catch (...) {
            fprintf(stderr, "Uncaught exception from C++ API!\n");
            t = (jthrowable)jenv->NewObject(dbex_class, dbex_construct,
            jenv->NewStringUTF("Uncaught exception from C++ API"), 0);
        }
        
        if (t)
        jenv->Throw(t);
    }
}


JNIEXPORT jboolean JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlQueryContext_1getWithMetaData(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jboolean jresult = 0 ;
    XmlQueryContext *arg1 = (XmlQueryContext *) 0 ;
    bool result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(XmlQueryContext **)&jarg1; 
    
    if (!jarg1) {
        jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        EINVAL));
        return 0;
    }
    
    {
        jthrowable t = NULL;
        
        try {
            result = (bool)((XmlQueryContext const *)arg1)->getWithMetaData();
            
        }catch (XmlException &xe) {
            t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
            xe.getExceptionCode(), jenv->NewStringUTF(xe.what()),
            xe.getDbErrno());
        }catch (...) {
            fprintf(stderr, "Uncaught exception from C++ API!\n");
            t = (jthrowable)jenv->NewObject(dbex_class, dbex_construct,
            jenv->NewStringUTF("Uncaught exception from C++ API"), 0);
        }
        
        if (t)
        jenv->Throw(t);
    }
    
    jresult = result ? JNI_TRUE : JNI_FALSE;
    
    return jresult;
}


JNIEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlQueryContext_1getVariableValue(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    jlong jresult = 0 ;
    XmlQueryContext *arg1 = (XmlQueryContext *) 0 ;
    std::string *arg2 = 0 ;
    XmlValue *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(XmlQueryContext **)&jarg1; 
    arg2 = NULL;
    if(jarg2) {
        const char *pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
        if (!pstr) return 0;
        arg2 =  new std::string(pstr);
        jenv->ReleaseStringUTFChars(jarg2, pstr);
    }
    else {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null std::string");
        return 0;
    }
    
    if (!jarg1) {
        jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        EINVAL));
        return 0;
    }
    
    {
        jthrowable t = NULL;
        
        try {
            result = (XmlValue *)XmlQueryContext_getVariableValue(arg1,(std::string const &)*arg2);
            
        }catch (XmlException &xe) {
            t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
            xe.getExceptionCode(), jenv->NewStringUTF(xe.what()),
            xe.getDbErrno());
        }catch (...) {
            fprintf(stderr, "Uncaught exception from C++ API!\n");
            t = (jthrowable)jenv->NewObject(dbex_class, dbex_construct,
            jenv->NewStringUTF("Uncaught exception from C++ API"), 0);
        }
        
        if (t)
        jenv->Throw(t);
    }
    *(XmlValue **)&jresult = result; 
    delete arg2; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_new_1XmlResults(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg2) {
    jlong jresult = 0 ;
    XmlQueryContext *arg1 = 0 ;
    DbTxn *arg2 = (DbTxn *) NULL ;
    XmlResults *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(XmlQueryContext **)&jarg1;
    if(!arg1) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlQueryContext & reference is null");
        return 0;
    }
    {
        arg2 = get_DbTxn(jenv, jarg2);
    }
    {
        jthrowable t = NULL;
        
        try {
            result = (XmlResults *)new XmlResults(*arg1,arg2);
            
        }catch (XmlException &xe) {
            t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
            xe.getExceptionCode(), jenv->NewStringUTF(xe.what()),
            xe.getDbErrno());
        }catch (...) {
            fprintf(stderr, "Uncaught exception from C++ API!\n");
            t = (jthrowable)jenv->NewObject(dbex_class, dbex_construct,
            jenv->NewStringUTF("Uncaught exception from C++ API"), 0);
        }
        
        if (t)
        jenv->Throw(t);
    }
    *(XmlResults **)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_delete_1XmlResults(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    XmlResults *arg1 = (XmlResults *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(XmlResults **)&jarg1; 
    
    if (!jarg1) {
        jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        EINVAL));
        return ;
    }
    
    {
        jthrowable t = NULL;
        
        try {
            delete arg1;
            
        }catch (XmlException &xe) {
            t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
            xe.getExceptionCode(), jenv->NewStringUTF(xe.what()),
            xe.getDbErrno());
        }catch (...) {
            fprintf(stderr, "Uncaught exception from C++ API!\n");
            t = (jthrowable)jenv->NewObject(dbex_class, dbex_construct,
            jenv->NewStringUTF("Uncaught exception from C++ API"), 0);
        }
        
        if (t)
        jenv->Throw(t);
    }
}


JNIEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlResults_1next_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    XmlResults *arg1 = (XmlResults *) 0 ;
    XmlValue *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(XmlResults **)&jarg1; 
    
    if (!jarg1) {
        jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        EINVAL));
        return 0;
    }
    
    {
        jthrowable t = NULL;
        
        try {
            result = (XmlValue *)XmlResults_next__SWIG_0(arg1);
            
        }catch (XmlException &xe) {
            t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
            xe.getExceptionCode(), jenv->NewStringUTF(xe.what()),
            xe.getDbErrno());
        }catch (...) {
            fprintf(stderr, "Uncaught exception from C++ API!\n");
            t = (jthrowable)jenv->NewObject(dbex_class, dbex_construct,
            jenv->NewStringUTF("Uncaught exception from C++ API"), 0);
        }
        
        if (t)
        jenv->Throw(t);
    }
    *(XmlValue **)&jresult = result; 
    return jresult;
}


JNIEXPORT jboolean JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlResults_1next_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    jboolean jresult = 0 ;
    XmlResults *arg1 = (XmlResults *) 0 ;
    XmlDocument *arg2 = 0 ;
    bool result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(XmlResults **)&jarg1; 
    arg2 = *(XmlDocument **)&jarg2;
    if(!arg2) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlDocument & reference is null");
        return 0;
    }
    
    if (!jarg1) {
        jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        EINVAL));
        return 0;
    }
    
    {
        jthrowable t = NULL;
        
        try {
            result = (bool)(arg1)->next(*arg2);
            
        }catch (XmlException &xe) {
            t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
            xe.getExceptionCode(), jenv->NewStringUTF(xe.what()),
            xe.getDbErrno());
        }catch (...) {
            fprintf(stderr, "Uncaught exception from C++ API!\n");
            t = (jthrowable)jenv->NewObject(dbex_class, dbex_construct,
            jenv->NewStringUTF("Uncaught exception from C++ API"), 0);
        }
        
        if (t)
        jenv->Throw(t);
    }
    
    jresult = result ? JNI_TRUE : JNI_FALSE;
    
    return jresult;
}


JNIEXPORT jboolean JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlResults_1next_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jlong jarg3) {
    jboolean jresult = 0 ;
    XmlResults *arg1 = (XmlResults *) 0 ;
    XmlDocument *arg2 = 0 ;
    XmlValue *arg3 = 0 ;
    bool result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(XmlResults **)&jarg1; 
    arg2 = *(XmlDocument **)&jarg2;
    if(!arg2) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlDocument & reference is null");
        return 0;
    }
    arg3 = *(XmlValue **)&jarg3;
    if(!arg3) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlValue & reference is null");
        return 0;
    }
    
    if (!jarg1) {
        jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        EINVAL));
        return 0;
    }
    
    {
        jthrowable t = NULL;
        
        try {
            result = (bool)(arg1)->next(*arg2,*arg3);
            
        }catch (XmlException &xe) {
            t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
            xe.getExceptionCode(), jenv->NewStringUTF(xe.what()),
            xe.getDbErrno());
        }catch (...) {
            fprintf(stderr, "Uncaught exception from C++ API!\n");
            t = (jthrowable)jenv->NewObject(dbex_class, dbex_construct,
            jenv->NewStringUTF("Uncaught exception from C++ API"), 0);
        }
        
        if (t)
        jenv->Throw(t);
    }
    
    jresult = result ? JNI_TRUE : JNI_FALSE;
    
    return jresult;
}


JNIEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlResults_1next_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg2) {
    jlong jresult = 0 ;
    XmlResults *arg1 = (XmlResults *) 0 ;
    DbTxn *arg2 = (DbTxn *) 0 ;
    XmlValue *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(XmlResults **)&jarg1; 
    {
        arg2 = get_DbTxn(jenv, jarg2);
    }
    
    if (!jarg1) {
        jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        EINVAL));
        return 0;
    }
    
    {
        jthrowable t = NULL;
        
        try {
            result = (XmlValue *)XmlResults_next__SWIG_3(arg1,arg2);
            
        }catch (XmlException &xe) {
            t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
            xe.getExceptionCode(), jenv->NewStringUTF(xe.what()),
            xe.getDbErrno());
        }catch (...) {
            fprintf(stderr, "Uncaught exception from C++ API!\n");
            t = (jthrowable)jenv->NewObject(dbex_class, dbex_construct,
            jenv->NewStringUTF("Uncaught exception from C++ API"), 0);
        }
        
        if (t)
        jenv->Throw(t);
    }
    *(XmlValue **)&jresult = result; 
    return jresult;
}


JNIEXPORT jboolean JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlResults_1nextDocument(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg2, jlong jarg3) {
    jboolean jresult = 0 ;
    XmlResults *arg1 = (XmlResults *) 0 ;
    DbTxn *arg2 = (DbTxn *) 0 ;
    XmlDocument *arg3 = 0 ;
    bool result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(XmlResults **)&jarg1; 
    {
        arg2 = get_DbTxn(jenv, jarg2);
    }
    arg3 = *(XmlDocument **)&jarg3;
    if(!arg3) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlDocument & reference is null");
        return 0;
    }
    
    if (!jarg1) {
        jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        EINVAL));
        return 0;
    }
    
    {
        jthrowable t = NULL;
        
        try {
            result = (bool)XmlResults_nextDocument(arg1,arg2,*arg3);
            
        }catch (XmlException &xe) {
            t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
            xe.getExceptionCode(), jenv->NewStringUTF(xe.what()),
            xe.getDbErrno());
        }catch (...) {
            fprintf(stderr, "Uncaught exception from C++ API!\n");
            t = (jthrowable)jenv->NewObject(dbex_class, dbex_construct,
            jenv->NewStringUTF("Uncaught exception from C++ API"), 0);
        }
        
        if (t)
        jenv->Throw(t);
    }
    
    jresult = result ? JNI_TRUE : JNI_FALSE;
    
    return jresult;
}


JNIEXPORT jboolean JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlResults_1nextDocumentAndValue(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg2, jlong jarg3, jlong jarg4) {
    jboolean jresult = 0 ;
    XmlResults *arg1 = (XmlResults *) 0 ;
    DbTxn *arg2 = (DbTxn *) 0 ;
    XmlDocument *arg3 = 0 ;
    XmlValue *arg4 = 0 ;
    bool result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(XmlResults **)&jarg1; 
    {
        arg2 = get_DbTxn(jenv, jarg2);
    }
    arg3 = *(XmlDocument **)&jarg3;
    if(!arg3) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlDocument & reference is null");
        return 0;
    }
    arg4 = *(XmlValue **)&jarg4;
    if(!arg4) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlValue & reference is null");
        return 0;
    }
    
    if (!jarg1) {
        jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        EINVAL));
        return 0;
    }
    
    {
        jthrowable t = NULL;
        
        try {
            result = (bool)XmlResults_nextDocumentAndValue(arg1,arg2,*arg3,*arg4);
            
        }catch (XmlException &xe) {
            t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
            xe.getExceptionCode(), jenv->NewStringUTF(xe.what()),
            xe.getDbErrno());
        }catch (...) {
            fprintf(stderr, "Uncaught exception from C++ API!\n");
            t = (jthrowable)jenv->NewObject(dbex_class, dbex_construct,
            jenv->NewStringUTF("Uncaught exception from C++ API"), 0);
        }
        
        if (t)
        jenv->Throw(t);
    }
    
    jresult = result ? JNI_TRUE : JNI_FALSE;
    
    return jresult;
}


JNIEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlResults_1reset(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    XmlResults *arg1 = (XmlResults *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(XmlResults **)&jarg1; 
    
    if (!jarg1) {
        jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        EINVAL));
        return ;
    }
    
    {
        jthrowable t = NULL;
        
        try {
            (arg1)->reset();
            
        }catch (XmlException &xe) {
            t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
            xe.getExceptionCode(), jenv->NewStringUTF(xe.what()),
            xe.getDbErrno());
        }catch (...) {
            fprintf(stderr, "Uncaught exception from C++ API!\n");
            t = (jthrowable)jenv->NewObject(dbex_class, dbex_construct,
            jenv->NewStringUTF("Uncaught exception from C++ API"), 0);
        }
        
        if (t)
        jenv->Throw(t);
    }
}


JNIEXPORT jint JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlResults_1size(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    XmlResults *arg1 = (XmlResults *) 0 ;
    size_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(XmlResults **)&jarg1; 
    
    if (!jarg1) {
        jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        EINVAL));
        return 0;
    }
    
    {
        jthrowable t = NULL;
        
        try {
            result = ((XmlResults const *)arg1)->size();
            
        }catch (XmlException &xe) {
            t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
            xe.getExceptionCode(), jenv->NewStringUTF(xe.what()),
            xe.getDbErrno());
        }catch (...) {
            fprintf(stderr, "Uncaught exception from C++ API!\n");
            t = (jthrowable)jenv->NewObject(dbex_class, dbex_construct,
            jenv->NewStringUTF("Uncaught exception from C++ API"), 0);
        }
        
        if (t)
        jenv->Throw(t);
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlResults_1add(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    XmlResults *arg1 = (XmlResults *) 0 ;
    XmlValue *arg2 = 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(XmlResults **)&jarg1; 
    arg2 = *(XmlValue **)&jarg2;
    if(!arg2) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlValue const & reference is null");
        return ;
    }
    
    if (!jarg1) {
        jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        EINVAL));
        return ;
    }
    
    {
        jthrowable t = NULL;
        
        try {
            (arg1)->add((XmlValue const &)*arg2);
            
        }catch (XmlException &xe) {
            t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
            xe.getExceptionCode(), jenv->NewStringUTF(xe.what()),
            xe.getDbErrno());
        }catch (...) {
            fprintf(stderr, "Uncaught exception from C++ API!\n");
            t = (jthrowable)jenv->NewObject(dbex_class, dbex_construct,
            jenv->NewStringUTF("Uncaught exception from C++ API"), 0);
        }
        
        if (t)
        jenv->Throw(t);
    }
}


JNIEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_new_1XmlUpdateContext(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    XmlContainer *arg1 = 0 ;
    XmlUpdateContext *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(XmlContainer **)&jarg1;
    if(!arg1) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlContainer & reference is null");
        return 0;
    }
    {
        jthrowable t = NULL;
        
        try {
            result = (XmlUpdateContext *)new XmlUpdateContext(*arg1);
            
        }catch (XmlException &xe) {
            t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
            xe.getExceptionCode(), jenv->NewStringUTF(xe.what()),
            xe.getDbErrno());
        }catch (...) {
            fprintf(stderr, "Uncaught exception from C++ API!\n");
            t = (jthrowable)jenv->NewObject(dbex_class, dbex_construct,
            jenv->NewStringUTF("Uncaught exception from C++ API"), 0);
        }
        
        if (t)
        jenv->Throw(t);
    }
    *(XmlUpdateContext **)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_delete_1XmlUpdateContext(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    XmlUpdateContext *arg1 = (XmlUpdateContext *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(XmlUpdateContext **)&jarg1; 
    
    if (!jarg1) {
        jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        EINVAL));
        return ;
    }
    
    {
        jthrowable t = NULL;
        
        try {
            delete arg1;
            
        }catch (XmlException &xe) {
            t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
            xe.getExceptionCode(), jenv->NewStringUTF(xe.what()),
            xe.getDbErrno());
        }catch (...) {
            fprintf(stderr, "Uncaught exception from C++ API!\n");
            t = (jthrowable)jenv->NewObject(dbex_class, dbex_construct,
            jenv->NewStringUTF("Uncaught exception from C++ API"), 0);
        }
        
        if (t)
        jenv->Throw(t);
    }
}


JNIEXPORT jint JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_get_1XmlValue_1NONE(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    {
        jthrowable t = NULL;
        
        try {
            result = (int)XmlValue::NONE;
            
        }catch (XmlException &xe) {
            t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
            xe.getExceptionCode(), jenv->NewStringUTF(xe.what()),
            xe.getDbErrno());
        }catch (...) {
            fprintf(stderr, "Uncaught exception from C++ API!\n");
            t = (jthrowable)jenv->NewObject(dbex_class, dbex_construct,
            jenv->NewStringUTF("Uncaught exception from C++ API"), 0);
        }
        
        if (t)
        jenv->Throw(t);
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_get_1XmlValue_1STRING(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    {
        jthrowable t = NULL;
        
        try {
            result = (int)XmlValue::STRING;
            
        }catch (XmlException &xe) {
            t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
            xe.getExceptionCode(), jenv->NewStringUTF(xe.what()),
            xe.getDbErrno());
        }catch (...) {
            fprintf(stderr, "Uncaught exception from C++ API!\n");
            t = (jthrowable)jenv->NewObject(dbex_class, dbex_construct,
            jenv->NewStringUTF("Uncaught exception from C++ API"), 0);
        }
        
        if (t)
        jenv->Throw(t);
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_get_1XmlValue_1NUMBER(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    {
        jthrowable t = NULL;
        
        try {
            result = (int)XmlValue::NUMBER;
            
        }catch (XmlException &xe) {
            t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
            xe.getExceptionCode(), jenv->NewStringUTF(xe.what()),
            xe.getDbErrno());
        }catch (...) {
            fprintf(stderr, "Uncaught exception from C++ API!\n");
            t = (jthrowable)jenv->NewObject(dbex_class, dbex_construct,
            jenv->NewStringUTF("Uncaught exception from C++ API"), 0);
        }
        
        if (t)
        jenv->Throw(t);
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_get_1XmlValue_1BOOLEAN(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    {
        jthrowable t = NULL;
        
        try {
            result = (int)XmlValue::BOOLEAN;
            
        }catch (XmlException &xe) {
            t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
            xe.getExceptionCode(), jenv->NewStringUTF(xe.what()),
            xe.getDbErrno());
        }catch (...) {
            fprintf(stderr, "Uncaught exception from C++ API!\n");
            t = (jthrowable)jenv->NewObject(dbex_class, dbex_construct,
            jenv->NewStringUTF("Uncaught exception from C++ API"), 0);
        }
        
        if (t)
        jenv->Throw(t);
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_get_1XmlValue_1DOCUMENT(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    {
        jthrowable t = NULL;
        
        try {
            result = (int)XmlValue::DOCUMENT;
            
        }catch (XmlException &xe) {
            t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
            xe.getExceptionCode(), jenv->NewStringUTF(xe.what()),
            xe.getDbErrno());
        }catch (...) {
            fprintf(stderr, "Uncaught exception from C++ API!\n");
            t = (jthrowable)jenv->NewObject(dbex_class, dbex_construct,
            jenv->NewStringUTF("Uncaught exception from C++ API"), 0);
        }
        
        if (t)
        jenv->Throw(t);
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_get_1XmlValue_1NODE(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    {
        jthrowable t = NULL;
        
        try {
            result = (int)XmlValue::NODE;
            
        }catch (XmlException &xe) {
            t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
            xe.getExceptionCode(), jenv->NewStringUTF(xe.what()),
            xe.getDbErrno());
        }catch (...) {
            fprintf(stderr, "Uncaught exception from C++ API!\n");
            t = (jthrowable)jenv->NewObject(dbex_class, dbex_construct,
            jenv->NewStringUTF("Uncaught exception from C++ API"), 0);
        }
        
        if (t)
        jenv->Throw(t);
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_get_1XmlValue_1VARIABLE(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    {
        jthrowable t = NULL;
        
        try {
            result = (int)XmlValue::VARIABLE;
            
        }catch (XmlException &xe) {
            t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
            xe.getExceptionCode(), jenv->NewStringUTF(xe.what()),
            xe.getDbErrno());
        }catch (...) {
            fprintf(stderr, "Uncaught exception from C++ API!\n");
            t = (jthrowable)jenv->NewObject(dbex_class, dbex_construct,
            jenv->NewStringUTF("Uncaught exception from C++ API"), 0);
        }
        
        if (t)
        jenv->Throw(t);
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_get_1XmlValue_1BINARY(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    {
        jthrowable t = NULL;
        
        try {
            result = (int)XmlValue::BINARY;
            
        }catch (XmlException &xe) {
            t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
            xe.getExceptionCode(), jenv->NewStringUTF(xe.what()),
            xe.getDbErrno());
        }catch (...) {
            fprintf(stderr, "Uncaught exception from C++ API!\n");
            t = (jthrowable)jenv->NewObject(dbex_class, dbex_construct,
            jenv->NewStringUTF("Uncaught exception from C++ API"), 0);
        }
        
        if (t)
        jenv->Throw(t);
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_new_1XmlValue_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    XmlValue *result;
    
    (void)jenv;
    (void)jcls;
    {
        jthrowable t = NULL;
        
        try {
            result = (XmlValue *)new XmlValue();
            
        }catch (XmlException &xe) {
            t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
            xe.getExceptionCode(), jenv->NewStringUTF(xe.what()),
            xe.getDbErrno());
        }catch (...) {
            fprintf(stderr, "Uncaught exception from C++ API!\n");
            t = (jthrowable)jenv->NewObject(dbex_class, dbex_construct,
            jenv->NewStringUTF("Uncaught exception from C++ API"), 0);
        }
        
        if (t)
        jenv->Throw(t);
    }
    *(XmlValue **)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_new_1XmlValue_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    XmlDocument *arg1 = 0 ;
    XmlValue *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(XmlDocument **)&jarg1;
    if(!arg1) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlDocument & reference is null");
        return 0;
    }
    {
        jthrowable t = NULL;
        
        try {
            result = (XmlValue *)new XmlValue(*arg1);
            
        }catch (XmlException &xe) {
            t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
            xe.getExceptionCode(), jenv->NewStringUTF(xe.what()),
            xe.getDbErrno());
        }catch (...) {
            fprintf(stderr, "Uncaught exception from C++ API!\n");
            t = (jthrowable)jenv->NewObject(dbex_class, dbex_construct,
            jenv->NewStringUTF("Uncaught exception from C++ API"), 0);
        }
        
        if (t)
        jenv->Throw(t);
    }
    *(XmlValue **)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_new_1XmlValue_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jdouble jarg1) {
    jlong jresult = 0 ;
    double arg1 ;
    XmlValue *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = (double)jarg1; 
    {
        jthrowable t = NULL;
        
        try {
            result = (XmlValue *)new XmlValue(arg1);
            
        }catch (XmlException &xe) {
            t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
            xe.getExceptionCode(), jenv->NewStringUTF(xe.what()),
            xe.getDbErrno());
        }catch (...) {
            fprintf(stderr, "Uncaught exception from C++ API!\n");
            t = (jthrowable)jenv->NewObject(dbex_class, dbex_construct,
            jenv->NewStringUTF("Uncaught exception from C++ API"), 0);
        }
        
        if (t)
        jenv->Throw(t);
    }
    *(XmlValue **)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_new_1XmlValue_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jstring jarg1) {
    jlong jresult = 0 ;
    char *arg1 ;
    XmlValue *result;
    
    (void)jenv;
    (void)jcls;
    {
        arg1 = 0;
        if (jarg1) {
            arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
            if (!arg1) return 0;
        }
    }
    {
        jthrowable t = NULL;
        
        try {
            result = (XmlValue *)new XmlValue((char const *)arg1);
            
        }catch (XmlException &xe) {
            t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
            xe.getExceptionCode(), jenv->NewStringUTF(xe.what()),
            xe.getDbErrno());
        }catch (...) {
            fprintf(stderr, "Uncaught exception from C++ API!\n");
            t = (jthrowable)jenv->NewObject(dbex_class, dbex_construct,
            jenv->NewStringUTF("Uncaught exception from C++ API"), 0);
        }
        
        if (t)
        jenv->Throw(t);
    }
    *(XmlValue **)&jresult = result; 
    {
        if (arg1) jenv->ReleaseStringUTFChars(jarg1, arg1); 
    }
    return jresult;
}


JNIEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_new_1XmlValue_1_1SWIG_14(JNIEnv *jenv, jclass jcls, jboolean jarg1) {
    jlong jresult = 0 ;
    bool arg1 ;
    XmlValue *result;
    
    (void)jenv;
    (void)jcls;
    
    arg1 = (jarg1 != JNI_FALSE);
    
    {
        jthrowable t = NULL;
        
        try {
            result = (XmlValue *)new XmlValue(arg1);
            
        }catch (XmlException &xe) {
            t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
            xe.getExceptionCode(), jenv->NewStringUTF(xe.what()),
            xe.getDbErrno());
        }catch (...) {
            fprintf(stderr, "Uncaught exception from C++ API!\n");
            t = (jthrowable)jenv->NewObject(dbex_class, dbex_construct,
            jenv->NewStringUTF("Uncaught exception from C++ API"), 0);
        }
        
        if (t)
        jenv->Throw(t);
    }
    *(XmlValue **)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_new_1XmlValue_1_1SWIG_15(JNIEnv *jenv, jclass jcls, jint jarg1, jstring jarg2) {
    jlong jresult = 0 ;
    int arg1 ;
    char *arg2 ;
    XmlValue *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = (int)jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
            if (!arg2) return 0;
        }
    }
    {
        jthrowable t = NULL;
        
        try {
            result = (XmlValue *)new XmlValue((XmlValue::Type )arg1,(char const *)arg2);
            
        }catch (XmlException &xe) {
            t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
            xe.getExceptionCode(), jenv->NewStringUTF(xe.what()),
            xe.getDbErrno());
        }catch (...) {
            fprintf(stderr, "Uncaught exception from C++ API!\n");
            t = (jthrowable)jenv->NewObject(dbex_class, dbex_construct,
            jenv->NewStringUTF("Uncaught exception from C++ API"), 0);
        }
        
        if (t)
        jenv->Throw(t);
    }
    *(XmlValue **)&jresult = result; 
    {
        if (arg2) jenv->ReleaseStringUTFChars(jarg2, arg2); 
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_delete_1XmlValue(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    XmlValue *arg1 = (XmlValue *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(XmlValue **)&jarg1; 
    
    if (!jarg1) {
        jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        EINVAL));
        return ;
    }
    
    {
        jthrowable t = NULL;
        
        try {
            delete arg1;
            
        }catch (XmlException &xe) {
            t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
            xe.getExceptionCode(), jenv->NewStringUTF(xe.what()),
            xe.getDbErrno());
        }catch (...) {
            fprintf(stderr, "Uncaught exception from C++ API!\n");
            t = (jthrowable)jenv->NewObject(dbex_class, dbex_construct,
            jenv->NewStringUTF("Uncaught exception from C++ API"), 0);
        }
        
        if (t)
        jenv->Throw(t);
    }
}


JNIEXPORT jint JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlValue_1getType(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    jint jresult = 0 ;
    XmlValue *arg1 = (XmlValue *) 0 ;
    XmlQueryContext *arg2 = (XmlQueryContext *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(XmlValue **)&jarg1; 
    arg2 = *(XmlQueryContext **)&jarg2; 
    
    if (!jarg1) {
        jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        EINVAL));
        return 0;
    }
    
    {
        jthrowable t = NULL;
        
        try {
            result = (int)((XmlValue const *)arg1)->getType((XmlQueryContext const *)arg2);
            
        }catch (XmlException &xe) {
            t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
            xe.getExceptionCode(), jenv->NewStringUTF(xe.what()),
            xe.getDbErrno());
        }catch (...) {
            fprintf(stderr, "Uncaught exception from C++ API!\n");
            t = (jthrowable)jenv->NewObject(dbex_class, dbex_construct,
            jenv->NewStringUTF("Uncaught exception from C++ API"), 0);
        }
        
        if (t)
        jenv->Throw(t);
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jboolean JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlValue_1isNumber(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    jboolean jresult = 0 ;
    XmlValue *arg1 = (XmlValue *) 0 ;
    XmlQueryContext *arg2 = (XmlQueryContext *) 0 ;
    bool result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(XmlValue **)&jarg1; 
    arg2 = *(XmlQueryContext **)&jarg2; 
    
    if (!jarg1) {
        jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        EINVAL));
        return 0;
    }
    
    {
        jthrowable t = NULL;
        
        try {
            result = (bool)((XmlValue const *)arg1)->isNumber((XmlQueryContext const *)arg2);
            
        }catch (XmlException &xe) {
            t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
            xe.getExceptionCode(), jenv->NewStringUTF(xe.what()),
            xe.getDbErrno());
        }catch (...) {
            fprintf(stderr, "Uncaught exception from C++ API!\n");
            t = (jthrowable)jenv->NewObject(dbex_class, dbex_construct,
            jenv->NewStringUTF("Uncaught exception from C++ API"), 0);
        }
        
        if (t)
        jenv->Throw(t);
    }
    
    jresult = result ? JNI_TRUE : JNI_FALSE;
    
    return jresult;
}


JNIEXPORT jboolean JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlValue_1isString(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    jboolean jresult = 0 ;
    XmlValue *arg1 = (XmlValue *) 0 ;
    XmlQueryContext *arg2 = (XmlQueryContext *) 0 ;
    bool result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(XmlValue **)&jarg1; 
    arg2 = *(XmlQueryContext **)&jarg2; 
    
    if (!jarg1) {
        jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        EINVAL));
        return 0;
    }
    
    {
        jthrowable t = NULL;
        
        try {
            result = (bool)((XmlValue const *)arg1)->isString((XmlQueryContext const *)arg2);
            
        }catch (XmlException &xe) {
            t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
            xe.getExceptionCode(), jenv->NewStringUTF(xe.what()),
            xe.getDbErrno());
        }catch (...) {
            fprintf(stderr, "Uncaught exception from C++ API!\n");
            t = (jthrowable)jenv->NewObject(dbex_class, dbex_construct,
            jenv->NewStringUTF("Uncaught exception from C++ API"), 0);
        }
        
        if (t)
        jenv->Throw(t);
    }
    
    jresult = result ? JNI_TRUE : JNI_FALSE;
    
    return jresult;
}


JNIEXPORT jboolean JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlValue_1isBoolean(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    jboolean jresult = 0 ;
    XmlValue *arg1 = (XmlValue *) 0 ;
    XmlQueryContext *arg2 = (XmlQueryContext *) 0 ;
    bool result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(XmlValue **)&jarg1; 
    arg2 = *(XmlQueryContext **)&jarg2; 
    
    if (!jarg1) {
        jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        EINVAL));
        return 0;
    }
    
    {
        jthrowable t = NULL;
        
        try {
            result = (bool)((XmlValue const *)arg1)->isBoolean((XmlQueryContext const *)arg2);
            
        }catch (XmlException &xe) {
            t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
            xe.getExceptionCode(), jenv->NewStringUTF(xe.what()),
            xe.getDbErrno());
        }catch (...) {
            fprintf(stderr, "Uncaught exception from C++ API!\n");
            t = (jthrowable)jenv->NewObject(dbex_class, dbex_construct,
            jenv->NewStringUTF("Uncaught exception from C++ API"), 0);
        }
        
        if (t)
        jenv->Throw(t);
    }
    
    jresult = result ? JNI_TRUE : JNI_FALSE;
    
    return jresult;
}


JNIEXPORT jboolean JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlValue_1isNode(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    jboolean jresult = 0 ;
    XmlValue *arg1 = (XmlValue *) 0 ;
    XmlQueryContext *arg2 = (XmlQueryContext *) 0 ;
    bool result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(XmlValue **)&jarg1; 
    arg2 = *(XmlQueryContext **)&jarg2; 
    
    if (!jarg1) {
        jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        EINVAL));
        return 0;
    }
    
    {
        jthrowable t = NULL;
        
        try {
            result = (bool)((XmlValue const *)arg1)->isNode((XmlQueryContext const *)arg2);
            
        }catch (XmlException &xe) {
            t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
            xe.getExceptionCode(), jenv->NewStringUTF(xe.what()),
            xe.getDbErrno());
        }catch (...) {
            fprintf(stderr, "Uncaught exception from C++ API!\n");
            t = (jthrowable)jenv->NewObject(dbex_class, dbex_construct,
            jenv->NewStringUTF("Uncaught exception from C++ API"), 0);
        }
        
        if (t)
        jenv->Throw(t);
    }
    
    jresult = result ? JNI_TRUE : JNI_FALSE;
    
    return jresult;
}


JNIEXPORT jboolean JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlValue_1isDocument(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    jboolean jresult = 0 ;
    XmlValue *arg1 = (XmlValue *) 0 ;
    XmlQueryContext *arg2 = (XmlQueryContext *) 0 ;
    bool result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(XmlValue **)&jarg1; 
    arg2 = *(XmlQueryContext **)&jarg2; 
    
    if (!jarg1) {
        jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        EINVAL));
        return 0;
    }
    
    {
        jthrowable t = NULL;
        
        try {
            result = (bool)((XmlValue const *)arg1)->isDocument((XmlQueryContext const *)arg2);
            
        }catch (XmlException &xe) {
            t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
            xe.getExceptionCode(), jenv->NewStringUTF(xe.what()),
            xe.getDbErrno());
        }catch (...) {
            fprintf(stderr, "Uncaught exception from C++ API!\n");
            t = (jthrowable)jenv->NewObject(dbex_class, dbex_construct,
            jenv->NewStringUTF("Uncaught exception from C++ API"), 0);
        }
        
        if (t)
        jenv->Throw(t);
    }
    
    jresult = result ? JNI_TRUE : JNI_FALSE;
    
    return jresult;
}


JNIEXPORT jboolean JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlValue_1isVariable(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    jboolean jresult = 0 ;
    XmlValue *arg1 = (XmlValue *) 0 ;
    XmlQueryContext *arg2 = (XmlQueryContext *) 0 ;
    bool result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(XmlValue **)&jarg1; 
    arg2 = *(XmlQueryContext **)&jarg2; 
    
    if (!jarg1) {
        jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        EINVAL));
        return 0;
    }
    
    {
        jthrowable t = NULL;
        
        try {
            result = (bool)((XmlValue const *)arg1)->isVariable((XmlQueryContext const *)arg2);
            
        }catch (XmlException &xe) {
            t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
            xe.getExceptionCode(), jenv->NewStringUTF(xe.what()),
            xe.getDbErrno());
        }catch (...) {
            fprintf(stderr, "Uncaught exception from C++ API!\n");
            t = (jthrowable)jenv->NewObject(dbex_class, dbex_construct,
            jenv->NewStringUTF("Uncaught exception from C++ API"), 0);
        }
        
        if (t)
        jenv->Throw(t);
    }
    
    jresult = result ? JNI_TRUE : JNI_FALSE;
    
    return jresult;
}


JNIEXPORT jboolean JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlValue_1isNull(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jboolean jresult = 0 ;
    XmlValue *arg1 = (XmlValue *) 0 ;
    bool result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(XmlValue **)&jarg1; 
    
    if (!jarg1) {
        jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        EINVAL));
        return 0;
    }
    
    {
        jthrowable t = NULL;
        
        try {
            result = (bool)((XmlValue const *)arg1)->isNull();
            
        }catch (XmlException &xe) {
            t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
            xe.getExceptionCode(), jenv->NewStringUTF(xe.what()),
            xe.getDbErrno());
        }catch (...) {
            fprintf(stderr, "Uncaught exception from C++ API!\n");
            t = (jthrowable)jenv->NewObject(dbex_class, dbex_construct,
            jenv->NewStringUTF("Uncaught exception from C++ API"), 0);
        }
        
        if (t)
        jenv->Throw(t);
    }
    
    jresult = result ? JNI_TRUE : JNI_FALSE;
    
    return jresult;
}


JNIEXPORT jdouble JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlValue_1asNumber(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    jdouble jresult = 0 ;
    XmlValue *arg1 = (XmlValue *) 0 ;
    XmlQueryContext *arg2 = (XmlQueryContext *) 0 ;
    double result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(XmlValue **)&jarg1; 
    arg2 = *(XmlQueryContext **)&jarg2; 
    
    if (!jarg1) {
        jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        EINVAL));
        return 0;
    }
    
    {
        jthrowable t = NULL;
        
        try {
            result = (double)((XmlValue const *)arg1)->asNumber((XmlQueryContext const *)arg2);
            
        }catch (XmlException &xe) {
            t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
            xe.getExceptionCode(), jenv->NewStringUTF(xe.what()),
            xe.getDbErrno());
        }catch (...) {
            fprintf(stderr, "Uncaught exception from C++ API!\n");
            t = (jthrowable)jenv->NewObject(dbex_class, dbex_construct,
            jenv->NewStringUTF("Uncaught exception from C++ API"), 0);
        }
        
        if (t)
        jenv->Throw(t);
    }
    jresult = (jdouble)result; 
    return jresult;
}


JNIEXPORT jstring JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlValue_1asString(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    jstring jresult = 0 ;
    XmlValue *arg1 = (XmlValue *) 0 ;
    XmlQueryContext *arg2 = (XmlQueryContext *) 0 ;
    std::string result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(XmlValue **)&jarg1; 
    arg2 = *(XmlQueryContext **)&jarg2; 
    
    if (!jarg1) {
        jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        EINVAL));
        return 0;
    }
    
    {
        jthrowable t = NULL;
        
        try {
            result = ((XmlValue const *)arg1)->asString((XmlQueryContext const *)arg2);
            
        }catch (XmlException &xe) {
            t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
            xe.getExceptionCode(), jenv->NewStringUTF(xe.what()),
            xe.getDbErrno());
        }catch (...) {
            fprintf(stderr, "Uncaught exception from C++ API!\n");
            t = (jthrowable)jenv->NewObject(dbex_class, dbex_construct,
            jenv->NewStringUTF("Uncaught exception from C++ API"), 0);
        }
        
        if (t)
        jenv->Throw(t);
    }
    jresult = jenv->NewStringUTF((&result)->c_str()); 
    return jresult;
}


JNIEXPORT jboolean JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlValue_1asBoolean(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    jboolean jresult = 0 ;
    XmlValue *arg1 = (XmlValue *) 0 ;
    XmlQueryContext *arg2 = (XmlQueryContext *) 0 ;
    bool result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(XmlValue **)&jarg1; 
    arg2 = *(XmlQueryContext **)&jarg2; 
    
    if (!jarg1) {
        jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        EINVAL));
        return 0;
    }
    
    {
        jthrowable t = NULL;
        
        try {
            result = (bool)((XmlValue const *)arg1)->asBoolean((XmlQueryContext const *)arg2);
            
        }catch (XmlException &xe) {
            t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
            xe.getExceptionCode(), jenv->NewStringUTF(xe.what()),
            xe.getDbErrno());
        }catch (...) {
            fprintf(stderr, "Uncaught exception from C++ API!\n");
            t = (jthrowable)jenv->NewObject(dbex_class, dbex_construct,
            jenv->NewStringUTF("Uncaught exception from C++ API"), 0);
        }
        
        if (t)
        jenv->Throw(t);
    }
    
    jresult = result ? JNI_TRUE : JNI_FALSE;
    
    return jresult;
}


JNIEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlValue_1asDocument(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    jlong jresult = 0 ;
    XmlValue *arg1 = (XmlValue *) 0 ;
    XmlQueryContext *arg2 = (XmlQueryContext *) 0 ;
    XmlDocument result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(XmlValue **)&jarg1; 
    arg2 = *(XmlQueryContext **)&jarg2; 
    
    if (!jarg1) {
        jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        EINVAL));
        return 0;
    }
    
    {
        jthrowable t = NULL;
        
        try {
            result = ((XmlValue const *)arg1)->asDocument((XmlQueryContext const *)arg2);
            
        }catch (XmlException &xe) {
            t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
            xe.getExceptionCode(), jenv->NewStringUTF(xe.what()),
            xe.getDbErrno());
        }catch (...) {
            fprintf(stderr, "Uncaught exception from C++ API!\n");
            t = (jthrowable)jenv->NewObject(dbex_class, dbex_construct,
            jenv->NewStringUTF("Uncaught exception from C++ API"), 0);
        }
        
        if (t)
        jenv->Throw(t);
    }
    *(XmlDocument **)&jresult = new XmlDocument((XmlDocument &)result); 
    return jresult;
}


JNIEXPORT jboolean JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlValue_1equals(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jlong jarg3) {
    jboolean jresult = 0 ;
    XmlValue *arg1 = (XmlValue *) 0 ;
    XmlValue *arg2 = 0 ;
    XmlQueryContext *arg3 = (XmlQueryContext *) 0 ;
    bool result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(XmlValue **)&jarg1; 
    arg2 = *(XmlValue **)&jarg2;
    if(!arg2) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlValue const & reference is null");
        return 0;
    }
    arg3 = *(XmlQueryContext **)&jarg3; 
    
    if (!jarg1) {
        jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        EINVAL));
        return 0;
    }
    
    {
        jthrowable t = NULL;
        
        try {
            result = (bool)((XmlValue const *)arg1)->equals((XmlValue const &)*arg2,(XmlQueryContext const *)arg3);
            
        }catch (XmlException &xe) {
            t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
            xe.getExceptionCode(), jenv->NewStringUTF(xe.what()),
            xe.getDbErrno());
        }catch (...) {
            fprintf(stderr, "Uncaught exception from C++ API!\n");
            t = (jthrowable)jenv->NewObject(dbex_class, dbex_construct,
            jenv->NewStringUTF("Uncaught exception from C++ API"), 0);
        }
        
        if (t)
        jenv->Throw(t);
    }
    
    jresult = result ? JNI_TRUE : JNI_FALSE;
    
    return jresult;
}


JNIEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_new_1XmlIndexSpecification(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    XmlIndexSpecification *result;
    
    (void)jenv;
    (void)jcls;
    {
        jthrowable t = NULL;
        
        try {
            result = (XmlIndexSpecification *)new XmlIndexSpecification();
            
        }catch (XmlException &xe) {
            t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
            xe.getExceptionCode(), jenv->NewStringUTF(xe.what()),
            xe.getDbErrno());
        }catch (...) {
            fprintf(stderr, "Uncaught exception from C++ API!\n");
            t = (jthrowable)jenv->NewObject(dbex_class, dbex_construct,
            jenv->NewStringUTF("Uncaught exception from C++ API"), 0);
        }
        
        if (t)
        jenv->Throw(t);
    }
    *(XmlIndexSpecification **)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_delete_1XmlIndexSpecification(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    XmlIndexSpecification *arg1 = (XmlIndexSpecification *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(XmlIndexSpecification **)&jarg1; 
    
    if (!jarg1) {
        jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        EINVAL));
        return ;
    }
    
    {
        jthrowable t = NULL;
        
        try {
            delete arg1;
            
        }catch (XmlException &xe) {
            t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
            xe.getExceptionCode(), jenv->NewStringUTF(xe.what()),
            xe.getDbErrno());
        }catch (...) {
            fprintf(stderr, "Uncaught exception from C++ API!\n");
            t = (jthrowable)jenv->NewObject(dbex_class, dbex_construct,
            jenv->NewStringUTF("Uncaught exception from C++ API"), 0);
        }
        
        if (t)
        jenv->Throw(t);
    }
}


JNIEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlIndexSpecification_1addIndex(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jstring jarg3, jstring jarg4) {
    XmlIndexSpecification *arg1 = (XmlIndexSpecification *) 0 ;
    std::string *arg2 = 0 ;
    std::string *arg3 = 0 ;
    std::string *arg4 = 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(XmlIndexSpecification **)&jarg1; 
    arg2 = NULL;
    if(jarg2) {
        const char *pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
        if (!pstr) return ;
        arg2 =  new std::string(pstr);
        jenv->ReleaseStringUTFChars(jarg2, pstr);
    }
    else {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null std::string");
        return ;
    }
    arg3 = NULL;
    if(jarg3) {
        const char *pstr = (const char *)jenv->GetStringUTFChars(jarg3, 0); 
        if (!pstr) return ;
        arg3 =  new std::string(pstr);
        jenv->ReleaseStringUTFChars(jarg3, pstr);
    }
    else {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null std::string");
        return ;
    }
    arg4 = NULL;
    if(jarg4) {
        const char *pstr = (const char *)jenv->GetStringUTFChars(jarg4, 0); 
        if (!pstr) return ;
        arg4 =  new std::string(pstr);
        jenv->ReleaseStringUTFChars(jarg4, pstr);
    }
    else {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null std::string");
        return ;
    }
    
    if (!jarg1) {
        jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        EINVAL));
        return ;
    }
    
    {
        jthrowable t = NULL;
        
        try {
            (arg1)->addIndex((std::string const &)*arg2,(std::string const &)*arg3,(std::string const &)*arg4);
            
        }catch (XmlException &xe) {
            t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
            xe.getExceptionCode(), jenv->NewStringUTF(xe.what()),
            xe.getDbErrno());
        }catch (...) {
            fprintf(stderr, "Uncaught exception from C++ API!\n");
            t = (jthrowable)jenv->NewObject(dbex_class, dbex_construct,
            jenv->NewStringUTF("Uncaught exception from C++ API"), 0);
        }
        
        if (t)
        jenv->Throw(t);
    }
    delete arg2; 
    delete arg3; 
    delete arg4; 
}


JNIEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlIndexSpecification_1deleteIndex(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jstring jarg3, jstring jarg4) {
    XmlIndexSpecification *arg1 = (XmlIndexSpecification *) 0 ;
    std::string *arg2 = 0 ;
    std::string *arg3 = 0 ;
    std::string *arg4 = 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(XmlIndexSpecification **)&jarg1; 
    arg2 = NULL;
    if(jarg2) {
        const char *pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
        if (!pstr) return ;
        arg2 =  new std::string(pstr);
        jenv->ReleaseStringUTFChars(jarg2, pstr);
    }
    else {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null std::string");
        return ;
    }
    arg3 = NULL;
    if(jarg3) {
        const char *pstr = (const char *)jenv->GetStringUTFChars(jarg3, 0); 
        if (!pstr) return ;
        arg3 =  new std::string(pstr);
        jenv->ReleaseStringUTFChars(jarg3, pstr);
    }
    else {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null std::string");
        return ;
    }
    arg4 = NULL;
    if(jarg4) {
        const char *pstr = (const char *)jenv->GetStringUTFChars(jarg4, 0); 
        if (!pstr) return ;
        arg4 =  new std::string(pstr);
        jenv->ReleaseStringUTFChars(jarg4, pstr);
    }
    else {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null std::string");
        return ;
    }
    
    if (!jarg1) {
        jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        EINVAL));
        return ;
    }
    
    {
        jthrowable t = NULL;
        
        try {
            (arg1)->deleteIndex((std::string const &)*arg2,(std::string const &)*arg3,(std::string const &)*arg4);
            
        }catch (XmlException &xe) {
            t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
            xe.getExceptionCode(), jenv->NewStringUTF(xe.what()),
            xe.getDbErrno());
        }catch (...) {
            fprintf(stderr, "Uncaught exception from C++ API!\n");
            t = (jthrowable)jenv->NewObject(dbex_class, dbex_construct,
            jenv->NewStringUTF("Uncaught exception from C++ API"), 0);
        }
        
        if (t)
        jenv->Throw(t);
    }
    delete arg2; 
    delete arg3; 
    delete arg4; 
}


JNIEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlIndexSpecification_1replaceIndex(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jstring jarg3, jstring jarg4) {
    XmlIndexSpecification *arg1 = (XmlIndexSpecification *) 0 ;
    std::string *arg2 = 0 ;
    std::string *arg3 = 0 ;
    std::string *arg4 = 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(XmlIndexSpecification **)&jarg1; 
    arg2 = NULL;
    if(jarg2) {
        const char *pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
        if (!pstr) return ;
        arg2 =  new std::string(pstr);
        jenv->ReleaseStringUTFChars(jarg2, pstr);
    }
    else {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null std::string");
        return ;
    }
    arg3 = NULL;
    if(jarg3) {
        const char *pstr = (const char *)jenv->GetStringUTFChars(jarg3, 0); 
        if (!pstr) return ;
        arg3 =  new std::string(pstr);
        jenv->ReleaseStringUTFChars(jarg3, pstr);
    }
    else {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null std::string");
        return ;
    }
    arg4 = NULL;
    if(jarg4) {
        const char *pstr = (const char *)jenv->GetStringUTFChars(jarg4, 0); 
        if (!pstr) return ;
        arg4 =  new std::string(pstr);
        jenv->ReleaseStringUTFChars(jarg4, pstr);
    }
    else {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null std::string");
        return ;
    }
    
    if (!jarg1) {
        jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        EINVAL));
        return ;
    }
    
    {
        jthrowable t = NULL;
        
        try {
            (arg1)->replaceIndex((std::string const &)*arg2,(std::string const &)*arg3,(std::string const &)*arg4);
            
        }catch (XmlException &xe) {
            t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
            xe.getExceptionCode(), jenv->NewStringUTF(xe.what()),
            xe.getDbErrno());
        }catch (...) {
            fprintf(stderr, "Uncaught exception from C++ API!\n");
            t = (jthrowable)jenv->NewObject(dbex_class, dbex_construct,
            jenv->NewStringUTF("Uncaught exception from C++ API"), 0);
        }
        
        if (t)
        jenv->Throw(t);
    }
    delete arg2; 
    delete arg3; 
    delete arg4; 
}


JNIEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlIndexSpecification_1reset(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    XmlIndexSpecification *arg1 = (XmlIndexSpecification *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(XmlIndexSpecification **)&jarg1; 
    
    if (!jarg1) {
        jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        EINVAL));
        return ;
    }
    
    {
        jthrowable t = NULL;
        
        try {
            (arg1)->reset();
            
        }catch (XmlException &xe) {
            t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
            xe.getExceptionCode(), jenv->NewStringUTF(xe.what()),
            xe.getDbErrno());
        }catch (...) {
            fprintf(stderr, "Uncaught exception from C++ API!\n");
            t = (jthrowable)jenv->NewObject(dbex_class, dbex_construct,
            jenv->NewStringUTF("Uncaught exception from C++ API"), 0);
        }
        
        if (t)
        jenv->Throw(t);
    }
}


JNIEXPORT jobject JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlIndexSpecification_1find(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jstring jarg3) {
    jobject jresult = 0 ;
    XmlIndexSpecification *arg1 = (XmlIndexSpecification *) 0 ;
    std::string *arg2 = 0 ;
    std::string *arg3 = 0 ;
    XmlIndexDeclaration *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(XmlIndexSpecification **)&jarg1; 
    arg2 = NULL;
    if(jarg2) {
        const char *pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
        if (!pstr) return 0;
        arg2 =  new std::string(pstr);
        jenv->ReleaseStringUTFChars(jarg2, pstr);
    }
    else {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null std::string");
        return 0;
    }
    arg3 = NULL;
    if(jarg3) {
        const char *pstr = (const char *)jenv->GetStringUTFChars(jarg3, 0); 
        if (!pstr) return 0;
        arg3 =  new std::string(pstr);
        jenv->ReleaseStringUTFChars(jarg3, pstr);
    }
    else {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null std::string");
        return 0;
    }
    
    if (!jarg1) {
        jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        EINVAL));
        return 0;
    }
    
    {
        jthrowable t = NULL;
        
        try {
            result = (XmlIndexDeclaration *)XmlIndexSpecification_find(arg1,(std::string const &)*arg2,(std::string const &)*arg3);
            
        }catch (XmlException &xe) {
            t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
            xe.getExceptionCode(), jenv->NewStringUTF(xe.what()),
            xe.getDbErrno());
        }catch (...) {
            fprintf(stderr, "Uncaught exception from C++ API!\n");
            t = (jthrowable)jenv->NewObject(dbex_class, dbex_construct,
            jenv->NewStringUTF("Uncaught exception from C++ API"), 0);
        }
        
        if (t)
        jenv->Throw(t);
    }
    
    if (result == NULL)
    jresult = NULL;
    else {
        jresult = jenv->NewObject(xml_indexdecl_class, xml_indexdecl_construct,
        jenv->NewStringUTF(result->uri.c_str()),
        jenv->NewStringUTF(result->name.c_str()),
        jenv->NewStringUTF(result->index.c_str()));
        delete result;
    }
    
    delete arg2; 
    delete arg3; 
    return jresult;
}


JNIEXPORT jobject JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlIndexSpecification_1next(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jobject jresult = 0 ;
    XmlIndexSpecification *arg1 = (XmlIndexSpecification *) 0 ;
    XmlIndexDeclaration *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(XmlIndexSpecification **)&jarg1; 
    
    if (!jarg1) {
        jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        EINVAL));
        return 0;
    }
    
    {
        jthrowable t = NULL;
        
        try {
            result = (XmlIndexDeclaration *)XmlIndexSpecification_next(arg1);
            
        }catch (XmlException &xe) {
            t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
            xe.getExceptionCode(), jenv->NewStringUTF(xe.what()),
            xe.getDbErrno());
        }catch (...) {
            fprintf(stderr, "Uncaught exception from C++ API!\n");
            t = (jthrowable)jenv->NewObject(dbex_class, dbex_construct,
            jenv->NewStringUTF("Uncaught exception from C++ API"), 0);
        }
        
        if (t)
        jenv->Throw(t);
    }
    
    if (result == NULL)
    jresult = NULL;
    else {
        jresult = jenv->NewObject(xml_indexdecl_class, xml_indexdecl_construct,
        jenv->NewStringUTF(result->uri.c_str()),
        jenv->NewStringUTF(result->name.c_str()),
        jenv->NewStringUTF(result->index.c_str()));
        delete result;
    }
    
    return jresult;
}


JNIEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_new_1XmlQueryExpression(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    jlong jresult = 0 ;
    XmlContainer *arg1 = 0 ;
    XmlQueryContext *arg2 = 0 ;
    XmlQueryExpression *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(XmlContainer **)&jarg1;
    if(!arg1) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlContainer & reference is null");
        return 0;
    }
    arg2 = *(XmlQueryContext **)&jarg2;
    if(!arg2) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlQueryContext & reference is null");
        return 0;
    }
    {
        jthrowable t = NULL;
        
        try {
            result = (XmlQueryExpression *)new XmlQueryExpression(*arg1,*arg2);
            
        }catch (XmlException &xe) {
            t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
            xe.getExceptionCode(), jenv->NewStringUTF(xe.what()),
            xe.getDbErrno());
        }catch (...) {
            fprintf(stderr, "Uncaught exception from C++ API!\n");
            t = (jthrowable)jenv->NewObject(dbex_class, dbex_construct,
            jenv->NewStringUTF("Uncaught exception from C++ API"), 0);
        }
        
        if (t)
        jenv->Throw(t);
    }
    *(XmlQueryExpression **)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_delete_1XmlQueryExpression(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    XmlQueryExpression *arg1 = (XmlQueryExpression *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(XmlQueryExpression **)&jarg1; 
    
    if (!jarg1) {
        jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        EINVAL));
        return ;
    }
    
    {
        jthrowable t = NULL;
        
        try {
            delete arg1;
            
        }catch (XmlException &xe) {
            t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
            xe.getExceptionCode(), jenv->NewStringUTF(xe.what()),
            xe.getDbErrno());
        }catch (...) {
            fprintf(stderr, "Uncaught exception from C++ API!\n");
            t = (jthrowable)jenv->NewObject(dbex_class, dbex_construct,
            jenv->NewStringUTF("Uncaught exception from C++ API"), 0);
        }
        
        if (t)
        jenv->Throw(t);
    }
}


JNIEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlQueryExpression_1getQueryContext(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    XmlQueryExpression *arg1 = (XmlQueryExpression *) 0 ;
    XmlQueryContext *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(XmlQueryExpression **)&jarg1; 
    
    if (!jarg1) {
        jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        EINVAL));
        return 0;
    }
    
    {
        jthrowable t = NULL;
        
        try {
            {
                XmlQueryContext &_result_ref = ((XmlQueryExpression const *)arg1)->getQueryContext();
                result = (XmlQueryContext *) &_result_ref;
            }
            
        }catch (XmlException &xe) {
            t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
            xe.getExceptionCode(), jenv->NewStringUTF(xe.what()),
            xe.getDbErrno());
        }catch (...) {
            fprintf(stderr, "Uncaught exception from C++ API!\n");
            t = (jthrowable)jenv->NewObject(dbex_class, dbex_construct,
            jenv->NewStringUTF("Uncaught exception from C++ API"), 0);
        }
        
        if (t)
        jenv->Throw(t);
    }
    *(XmlQueryContext **)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlQueryExpression_1getContainer(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    XmlQueryExpression *arg1 = (XmlQueryExpression *) 0 ;
    XmlContainer *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(XmlQueryExpression **)&jarg1; 
    
    if (!jarg1) {
        jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        EINVAL));
        return 0;
    }
    
    {
        jthrowable t = NULL;
        
        try {
            {
                XmlContainer const &_result_ref = ((XmlQueryExpression const *)arg1)->getContainer();
                result = (XmlContainer *) &_result_ref;
            }
            
        }catch (XmlException &xe) {
            t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
            xe.getExceptionCode(), jenv->NewStringUTF(xe.what()),
            xe.getDbErrno());
        }catch (...) {
            fprintf(stderr, "Uncaught exception from C++ API!\n");
            t = (jthrowable)jenv->NewObject(dbex_class, dbex_construct,
            jenv->NewStringUTF("Uncaught exception from C++ API"), 0);
        }
        
        if (t)
        jenv->Throw(t);
    }
    *(XmlContainer **)&jresult = result; 
    return jresult;
}


JNIEXPORT jstring JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlQueryExpression_1getXPathQuery(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    XmlQueryExpression *arg1 = (XmlQueryExpression *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(XmlQueryExpression **)&jarg1; 
    
    if (!jarg1) {
        jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        EINVAL));
        return 0;
    }
    
    {
        jthrowable t = NULL;
        
        try {
            result = (char *)XmlQueryExpression_getXPathQuery((XmlQueryExpression const *)arg1);
            
        }catch (XmlException &xe) {
            t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
            xe.getExceptionCode(), jenv->NewStringUTF(xe.what()),
            xe.getDbErrno());
        }catch (...) {
            fprintf(stderr, "Uncaught exception from C++ API!\n");
            t = (jthrowable)jenv->NewObject(dbex_class, dbex_construct,
            jenv->NewStringUTF("Uncaught exception from C++ API"), 0);
        }
        
        if (t)
        jenv->Throw(t);
    }
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_get_1XmlModify_1InsertAfter(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    {
        jthrowable t = NULL;
        
        try {
            result = (int)XmlModify::InsertAfter;
            
        }catch (XmlException &xe) {
            t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
            xe.getExceptionCode(), jenv->NewStringUTF(xe.what()),
            xe.getDbErrno());
        }catch (...) {
            fprintf(stderr, "Uncaught exception from C++ API!\n");
            t = (jthrowable)jenv->NewObject(dbex_class, dbex_construct,
            jenv->NewStringUTF("Uncaught exception from C++ API"), 0);
        }
        
        if (t)
        jenv->Throw(t);
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_get_1XmlModify_1InsertBefore(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    {
        jthrowable t = NULL;
        
        try {
            result = (int)XmlModify::InsertBefore;
            
        }catch (XmlException &xe) {
            t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
            xe.getExceptionCode(), jenv->NewStringUTF(xe.what()),
            xe.getDbErrno());
        }catch (...) {
            fprintf(stderr, "Uncaught exception from C++ API!\n");
            t = (jthrowable)jenv->NewObject(dbex_class, dbex_construct,
            jenv->NewStringUTF("Uncaught exception from C++ API"), 0);
        }
        
        if (t)
        jenv->Throw(t);
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_get_1XmlModify_1Append(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    {
        jthrowable t = NULL;
        
        try {
            result = (int)XmlModify::Append;
            
        }catch (XmlException &xe) {
            t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
            xe.getExceptionCode(), jenv->NewStringUTF(xe.what()),
            xe.getDbErrno());
        }catch (...) {
            fprintf(stderr, "Uncaught exception from C++ API!\n");
            t = (jthrowable)jenv->NewObject(dbex_class, dbex_construct,
            jenv->NewStringUTF("Uncaught exception from C++ API"), 0);
        }
        
        if (t)
        jenv->Throw(t);
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_get_1XmlModify_1Update(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    {
        jthrowable t = NULL;
        
        try {
            result = (int)XmlModify::Update;
            
        }catch (XmlException &xe) {
            t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
            xe.getExceptionCode(), jenv->NewStringUTF(xe.what()),
            xe.getDbErrno());
        }catch (...) {
            fprintf(stderr, "Uncaught exception from C++ API!\n");
            t = (jthrowable)jenv->NewObject(dbex_class, dbex_construct,
            jenv->NewStringUTF("Uncaught exception from C++ API"), 0);
        }
        
        if (t)
        jenv->Throw(t);
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_get_1XmlModify_1Remove(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    {
        jthrowable t = NULL;
        
        try {
            result = (int)XmlModify::Remove;
            
        }catch (XmlException &xe) {
            t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
            xe.getExceptionCode(), jenv->NewStringUTF(xe.what()),
            xe.getDbErrno());
        }catch (...) {
            fprintf(stderr, "Uncaught exception from C++ API!\n");
            t = (jthrowable)jenv->NewObject(dbex_class, dbex_construct,
            jenv->NewStringUTF("Uncaught exception from C++ API"), 0);
        }
        
        if (t)
        jenv->Throw(t);
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_get_1XmlModify_1Rename(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    {
        jthrowable t = NULL;
        
        try {
            result = (int)XmlModify::Rename;
            
        }catch (XmlException &xe) {
            t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
            xe.getExceptionCode(), jenv->NewStringUTF(xe.what()),
            xe.getDbErrno());
        }catch (...) {
            fprintf(stderr, "Uncaught exception from C++ API!\n");
            t = (jthrowable)jenv->NewObject(dbex_class, dbex_construct,
            jenv->NewStringUTF("Uncaught exception from C++ API"), 0);
        }
        
        if (t)
        jenv->Throw(t);
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_get_1XmlModify_1Element(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    {
        jthrowable t = NULL;
        
        try {
            result = (int)XmlModify::Element;
            
        }catch (XmlException &xe) {
            t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
            xe.getExceptionCode(), jenv->NewStringUTF(xe.what()),
            xe.getDbErrno());
        }catch (...) {
            fprintf(stderr, "Uncaught exception from C++ API!\n");
            t = (jthrowable)jenv->NewObject(dbex_class, dbex_construct,
            jenv->NewStringUTF("Uncaught exception from C++ API"), 0);
        }
        
        if (t)
        jenv->Throw(t);
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_get_1XmlModify_1Attribute(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    {
        jthrowable t = NULL;
        
        try {
            result = (int)XmlModify::Attribute;
            
        }catch (XmlException &xe) {
            t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
            xe.getExceptionCode(), jenv->NewStringUTF(xe.what()),
            xe.getDbErrno());
        }catch (...) {
            fprintf(stderr, "Uncaught exception from C++ API!\n");
            t = (jthrowable)jenv->NewObject(dbex_class, dbex_construct,
            jenv->NewStringUTF("Uncaught exception from C++ API"), 0);
        }
        
        if (t)
        jenv->Throw(t);
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_get_1XmlModify_1Text(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    {
        jthrowable t = NULL;
        
        try {
            result = (int)XmlModify::Text;
            
        }catch (XmlException &xe) {
            t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
            xe.getExceptionCode(), jenv->NewStringUTF(xe.what()),
            xe.getDbErrno());
        }catch (...) {
            fprintf(stderr, "Uncaught exception from C++ API!\n");
            t = (jthrowable)jenv->NewObject(dbex_class, dbex_construct,
            jenv->NewStringUTF("Uncaught exception from C++ API"), 0);
        }
        
        if (t)
        jenv->Throw(t);
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_get_1XmlModify_1ProcessingInstruction(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    {
        jthrowable t = NULL;
        
        try {
            result = (int)XmlModify::ProcessingInstruction;
            
        }catch (XmlException &xe) {
            t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
            xe.getExceptionCode(), jenv->NewStringUTF(xe.what()),
            xe.getDbErrno());
        }catch (...) {
            fprintf(stderr, "Uncaught exception from C++ API!\n");
            t = (jthrowable)jenv->NewObject(dbex_class, dbex_construct,
            jenv->NewStringUTF("Uncaught exception from C++ API"), 0);
        }
        
        if (t)
        jenv->Throw(t);
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_get_1XmlModify_1Comment(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    {
        jthrowable t = NULL;
        
        try {
            result = (int)XmlModify::Comment;
            
        }catch (XmlException &xe) {
            t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
            xe.getExceptionCode(), jenv->NewStringUTF(xe.what()),
            xe.getDbErrno());
        }catch (...) {
            fprintf(stderr, "Uncaught exception from C++ API!\n");
            t = (jthrowable)jenv->NewObject(dbex_class, dbex_construct,
            jenv->NewStringUTF("Uncaught exception from C++ API"), 0);
        }
        
        if (t)
        jenv->Throw(t);
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_get_1XmlModify_1None(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    {
        jthrowable t = NULL;
        
        try {
            result = (int)XmlModify::None;
            
        }catch (XmlException &xe) {
            t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
            xe.getExceptionCode(), jenv->NewStringUTF(xe.what()),
            xe.getDbErrno());
        }catch (...) {
            fprintf(stderr, "Uncaught exception from C++ API!\n");
            t = (jthrowable)jenv->NewObject(dbex_class, dbex_construct,
            jenv->NewStringUTF("Uncaught exception from C++ API"), 0);
        }
        
        if (t)
        jenv->Throw(t);
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_new_1XmlModify_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jstring jarg1, jint jarg2, jint jarg3, jstring jarg4, jstring jarg5, jint jarg6, jlong jarg7) {
    jlong jresult = 0 ;
    std::string *arg1 = 0 ;
    int arg2 ;
    int arg3 ;
    std::string *arg4 = 0 ;
    std::string *arg5 = 0 ;
    int32_t arg6 = (int32_t) -1 ;
    XmlQueryContext *arg7 = (XmlQueryContext *) NULL ;
    XmlModify *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = NULL;
    if(jarg1) {
        const char *pstr = (const char *)jenv->GetStringUTFChars(jarg1, 0); 
        if (!pstr) return 0;
        arg1 =  new std::string(pstr);
        jenv->ReleaseStringUTFChars(jarg1, pstr);
    }
    else {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null std::string");
        return 0;
    }
    arg2 = (int)jarg2; 
    arg3 = (int)jarg3; 
    arg4 = NULL;
    if(jarg4) {
        const char *pstr = (const char *)jenv->GetStringUTFChars(jarg4, 0); 
        if (!pstr) return 0;
        arg4 =  new std::string(pstr);
        jenv->ReleaseStringUTFChars(jarg4, pstr);
    }
    else {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null std::string");
        return 0;
    }
    arg5 = NULL;
    if(jarg5) {
        const char *pstr = (const char *)jenv->GetStringUTFChars(jarg5, 0); 
        if (!pstr) return 0;
        arg5 =  new std::string(pstr);
        jenv->ReleaseStringUTFChars(jarg5, pstr);
    }
    else {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null std::string");
        return 0;
    }
    arg6 = (int32_t)jarg6; 
    arg7 = *(XmlQueryContext **)&jarg7; 
    {
        jthrowable t = NULL;
        
        try {
            result = (XmlModify *)new XmlModify((std::string const &)*arg1,(XmlModify::ModificationType )arg2,(XmlModify::XmlObject )arg3,(std::string const &)*arg4,(std::string const &)*arg5,arg6,arg7);
            
        }catch (XmlException &xe) {
            t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
            xe.getExceptionCode(), jenv->NewStringUTF(xe.what()),
            xe.getDbErrno());
        }catch (...) {
            fprintf(stderr, "Uncaught exception from C++ API!\n");
            t = (jthrowable)jenv->NewObject(dbex_class, dbex_construct,
            jenv->NewStringUTF("Uncaught exception from C++ API"), 0);
        }
        
        if (t)
        jenv->Throw(t);
    }
    *(XmlModify **)&jresult = result; 
    delete arg1; 
    delete arg4; 
    delete arg5; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_new_1XmlModify_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2, jint jarg3, jstring jarg4, jstring jarg5, jint jarg6) {
    jlong jresult = 0 ;
    XmlQueryExpression *arg1 = 0 ;
    int arg2 ;
    int arg3 ;
    std::string *arg4 = 0 ;
    std::string *arg5 = 0 ;
    int32_t arg6 = (int32_t) -1 ;
    XmlModify *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(XmlQueryExpression **)&jarg1;
    if(!arg1) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlQueryExpression & reference is null");
        return 0;
    }
    arg2 = (int)jarg2; 
    arg3 = (int)jarg3; 
    arg4 = NULL;
    if(jarg4) {
        const char *pstr = (const char *)jenv->GetStringUTFChars(jarg4, 0); 
        if (!pstr) return 0;
        arg4 =  new std::string(pstr);
        jenv->ReleaseStringUTFChars(jarg4, pstr);
    }
    else {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null std::string");
        return 0;
    }
    arg5 = NULL;
    if(jarg5) {
        const char *pstr = (const char *)jenv->GetStringUTFChars(jarg5, 0); 
        if (!pstr) return 0;
        arg5 =  new std::string(pstr);
        jenv->ReleaseStringUTFChars(jarg5, pstr);
    }
    else {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null std::string");
        return 0;
    }
    arg6 = (int32_t)jarg6; 
    {
        jthrowable t = NULL;
        
        try {
            result = (XmlModify *)new XmlModify(*arg1,(XmlModify::ModificationType )arg2,(XmlModify::XmlObject )arg3,(std::string const &)*arg4,(std::string const &)*arg5,arg6);
            
        }catch (XmlException &xe) {
            t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
            xe.getExceptionCode(), jenv->NewStringUTF(xe.what()),
            xe.getDbErrno());
        }catch (...) {
            fprintf(stderr, "Uncaught exception from C++ API!\n");
            t = (jthrowable)jenv->NewObject(dbex_class, dbex_construct,
            jenv->NewStringUTF("Uncaught exception from C++ API"), 0);
        }
        
        if (t)
        jenv->Throw(t);
    }
    *(XmlModify **)&jresult = result; 
    delete arg4; 
    delete arg5; 
    return jresult;
}


JNIEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_delete_1XmlModify(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    XmlModify *arg1 = (XmlModify *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(XmlModify **)&jarg1; 
    
    if (!jarg1) {
        jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        EINVAL));
        return ;
    }
    
    {
        jthrowable t = NULL;
        
        try {
            delete arg1;
            
        }catch (XmlException &xe) {
            t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
            xe.getExceptionCode(), jenv->NewStringUTF(xe.what()),
            xe.getDbErrno());
        }catch (...) {
            fprintf(stderr, "Uncaught exception from C++ API!\n");
            t = (jthrowable)jenv->NewObject(dbex_class, dbex_construct,
            jenv->NewStringUTF("Uncaught exception from C++ API"), 0);
        }
        
        if (t)
        jenv->Throw(t);
    }
}


JNIEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlModify_1setNewEncoding(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    XmlModify *arg1 = (XmlModify *) 0 ;
    std::string *arg2 = 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(XmlModify **)&jarg1; 
    arg2 = NULL;
    if(jarg2) {
        const char *pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
        if (!pstr) return ;
        arg2 =  new std::string(pstr);
        jenv->ReleaseStringUTFChars(jarg2, pstr);
    }
    else {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null std::string");
        return ;
    }
    
    if (!jarg1) {
        jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        EINVAL));
        return ;
    }
    
    {
        jthrowable t = NULL;
        
        try {
            (arg1)->setNewEncoding((std::string const &)*arg2);
            
        }catch (XmlException &xe) {
            t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
            xe.getExceptionCode(), jenv->NewStringUTF(xe.what()),
            xe.getDbErrno());
        }catch (...) {
            fprintf(stderr, "Uncaught exception from C++ API!\n");
            t = (jthrowable)jenv->NewObject(dbex_class, dbex_construct,
            jenv->NewStringUTF("Uncaught exception from C++ API"), 0);
        }
        
        if (t)
        jenv->Throw(t);
    }
    delete arg2; 
}


JNIEXPORT jint JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlModify_1getNumModifications(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    XmlModify *arg1 = (XmlModify *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(XmlModify **)&jarg1; 
    
    if (!jarg1) {
        jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        EINVAL));
        return 0;
    }
    
    {
        jthrowable t = NULL;
        
        try {
            result = (int)(arg1)->getNumModifications();
            
        }catch (XmlException &xe) {
            t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
            xe.getExceptionCode(), jenv->NewStringUTF(xe.what()),
            xe.getDbErrno());
        }catch (...) {
            fprintf(stderr, "Uncaught exception from C++ API!\n");
            t = (jthrowable)jenv->NewObject(dbex_class, dbex_construct,
            jenv->NewStringUTF("Uncaught exception from C++ API"), 0);
        }
        
        if (t)
        jenv->Throw(t);
    }
    jresult = (jint)result; 
    return jresult;
}


#ifdef __cplusplus
}
#endif

