//
// See the file LICENSE for redistribution information.
//
// Copyright (c) 2002-2003
//	Sleepycat Software.  All rights reserved.
//

package com.sleepycat.dbxml;

/**
 *  The XmlException class represents an error condition that has
 *  occurred within the Berkeley DB XML system. The system throws an
 *  XmlException if an API method call results in an error condition.
 *  The XmlException class exposes the following methods:</p> <hr
 *  size=1 noshade> <h3>Description: XmlException.toString</h3> <hr
 *  size=1 noshade> <h3>Description: XmlException.getErrorCode</h3>
 *  <hr size=1 noshade> <h3>Description: XmlException.getDbError</h3>
 */
public class XmlException extends com.sleepycat.db.DbException {
    /**
     *
     *</ul>
     *
     */
    public final static int CONTAINER_CLOSED = 2;
    /**
     *
     *</ul>
     *
     */
    public final static int CONTAINER_EXISTS = 13;
    /**
     *
     *</ul>
     *
     */
    public final static int CONTAINER_NOT_EMPTY = 3;
    /**
     *
     *</ul>
     *
     */
    public final static int CONTAINER_OPEN = 1;
    /**
     *
     *</ul>
     *
     */
    public final static int DATABASE_ERROR = 6;
    /**
     *
     *</ul>
     *
     */
    public final static int DOCUMENT_NOT_FOUND = 12;
    /**
     *
     *</ul>
     *
     */
    public final static int DOM_PARSER_ERROR = 8;
    /**
     *
     *</ul>
     *
     */
    public final static int INDEXER_PARSER_ERROR = 5;
    /**
     *
     *</ul>
     *
     */
    public final static int INTERNAL_ERROR = 0;
    /**
     *
     *</ul>
     *
     */
    public final static int INVALID_VALUE = 15;
    /**
     *
     *</ul>
     *
     */
    public final static int LAZY_EVALUATION = 11;
    /**
     *
     *</ul>
     *
     */
    public final static int NO_VARIABLE_BINDING = 10;
    /**
     *
     *</ul>
     *
     */
    public final static int UNKNOWN_INDEX = 14;
    /**
     *
     *</ul>
     *
     */
    public final static int UNSUPPORTED_ENCODING = 4;
    /**
     *
     *</ul>
     *
     */
    public final static int XPATH_EVALUATION_ERROR = 9;
    /**
     *
     *</ul>
     *
     */
    public final static int XPATH_PARSER_ERROR = 7;

    final static String[] xml_strerror = {
            "INTERNAL_ERROR",
            "CONTAINER_OPEN",
            "CONTAINER_CLOSED",
            "CONTAINER_NOT_EMPTY",
            "UNSUPPORTED_ENCODING",
            "INDEXER_PARSER_ERROR",
            "DATABASE_ERROR",
            "XPATH_PARSER_ERROR",
            "DOM_PARSER_ERROR",
            "XPATH_EVALUATION_ERROR",
            "NO_VARIABLE_BINDING",
            "LAZY_EVALUATION",
            "DOCUMENT_NOT_FOUND",
            "CONTAINER_EXISTS",
            "UNKNOWN_INDEX",
            "INVALID_VALUE"
            };
    private int dberr;

    private int errcode;


    public XmlException(int errcode, String description, int dberr) {
        super(description, dberr);
        this.errcode = errcode;
        this.dberr = dberr;
    }


    /**
     * @return    The getDbError() method retrieves the Berkeley DB
     *      error number for an XmlException with ExceptionCode
     *      DATABASE_ERROR.</p>
     */
    public int getDbError() {
        return dberr;
    }


    /**
     * @return    The getErrorCode() method returns the exception
     *      code.</p>
     */
    public int getErrorCode() {
        return errcode;
    }


    public String toString() {
        return super.toString() + ", errcode = " + xml_strerror[errcode];
    }
}
