//
// See the file LICENSE for redistribution information.
//
// Copyright (c) 2002-2003
//	Sleepycat Software.  All rights reserved.
//

static const char revid[] = "$Id: XmlUpdateContext.cpp,v 1.5 2003/05/09 00:01:58 mjc Exp $";

#include "dbxml_config.h"
#include "dbxml/XmlPortability.hpp"
#include "dbxml/XmlUpdateContext.hpp"
#include "dbxml/XmlContainer.hpp"
#include "UpdateContext.hpp"
#include "Container.hpp"

using namespace DbXml;

XmlUpdateContext::XmlUpdateContext(XmlContainer &container)
	: container_(container),
	updateContext_(new UpdateContext((Container*)container))
{
	updateContext_->acquire();
}

XmlUpdateContext::~XmlUpdateContext()
{
	updateContext_->release();
}

XmlUpdateContext::XmlUpdateContext(const XmlUpdateContext &o)
	: container_(o.container_),
	updateContext_(o.updateContext_)
{
	if (updateContext_ != 0)
		updateContext_->acquire();
}

XmlUpdateContext &XmlUpdateContext::operator=(const XmlUpdateContext &o)
{
	if (this != &o && updateContext_ != o.updateContext_) {
		if (updateContext_ != 0)
			updateContext_->release();
		updateContext_ = o.updateContext_;
		if (updateContext_ != 0)
			updateContext_->acquire();
	}
	return *this;
}

