//
// See the file LICENSE for redistribution information.
//
// Copyright (c) 2002-2003
//	Sleepycat Software.  All rights reserved.
//

static const char revid[] = "$Id: XmlQueryExpression.cpp,v 1.16 2003/05/12 23:13:12 merrells Exp $";

#include "dbxml_config.h"
#include "dbxml/XmlPortability.hpp"
#include "dbxml/XmlQueryExpression.hpp"
#include "QueryExpression.hpp"

using namespace DbXml;

XmlQueryExpression::XmlQueryExpression(const XmlContainer &container, XmlQueryContext &context)
	: container_(&container),
	context_(new XmlQueryContext(context)),
	expression_(new QueryExpression(context))
{
	expression_->acquire();
}

XmlQueryExpression::~XmlQueryExpression()
{
	expression_->release();
	delete context_;
}

XmlQueryExpression::XmlQueryExpression(const XmlQueryExpression& o)
	: container_(o.container_),
	context_(new XmlQueryContext(*o.context_)),
	expression_(o.expression_)
{
	if (expression_ != 0)
		expression_->acquire();
}

XmlQueryExpression &XmlQueryExpression::operator=(const XmlQueryExpression& o)
{
	if (this != &o && expression_ != o.expression_) {
		if (expression_ != 0)
			expression_->release();
		container_ = o.container_;
		expression_ = o.expression_;
		*context_ = *o.context_;
		if (expression_ != 0)
			expression_->acquire();
	}
	return *this;
}

std::string XmlQueryExpression::getXPathQuery() const
{
	return expression_->getXPathQuery();
}
