//
// See the file LICENSE for redistribution information.
//
// Copyright (c) 2002-2003
//	Sleepycat Software.  All rights reserved.
//

static const char revid[] = "$Id: XmlQueryContext.cpp,v 1.22 2003/12/08 01:37:24 gmf Exp $";

#include "dbxml_config.h"
#include "dbxml/XmlPortability.hpp"
#include "dbxml/XmlQueryContext.hpp"
#include "QueryContext.hpp"

using namespace DbXml;

XmlQueryContext::XmlQueryContext(ReturnType rt, EvaluationType et)
	: queryContext_(new QueryContext(rt, et))
{
	queryContext_->acquire();
}

XmlQueryContext::~XmlQueryContext()
{
	queryContext_->release();
}

XmlQueryContext::XmlQueryContext(const XmlQueryContext &o)
	: queryContext_(o.queryContext_)
{
	if (queryContext_ != 0)
		queryContext_->acquire();
}

XmlQueryContext &XmlQueryContext::operator=(const XmlQueryContext &o)
{
	if (this != &o && queryContext_ != o.queryContext_) {
		if (queryContext_ != 0)
			queryContext_->release();
		queryContext_ = o.queryContext_;
		if (queryContext_ != 0)
			queryContext_->acquire();
	}
	return *this;
}

void XmlQueryContext::setVariableValue(const std::string &name, const XmlValue &value)
{
	queryContext_->setVariableValue(name, value);
}

bool XmlQueryContext::getVariableValue(const std::string &name, XmlValue &value) const
{
	return queryContext_->getVariableValue(name, value);
}

void XmlQueryContext::setNamespace(const std::string &prefix, const std::string &uri )
{
	queryContext_->setNamespace(prefix, uri);
}

std::string XmlQueryContext::getNamespace(const std::string &prefix )
{
	return queryContext_->getNamespace(prefix);
}

void XmlQueryContext::removeNamespace(const std::string &prefix )
{
	queryContext_->removeNamespace(prefix);
}

void XmlQueryContext::clearNamespaces()
{
	queryContext_->clearNamespaces();
}

void XmlQueryContext::setReturnType(ReturnType rt)
{
	queryContext_->setReturnType(rt);
}

XmlQueryContext::ReturnType XmlQueryContext::getReturnType() const
{
	return queryContext_->getReturnType();
}

void XmlQueryContext::setEvaluationType(EvaluationType et)
{
	queryContext_->setEvaluationType(et);
}

XmlQueryContext::EvaluationType XmlQueryContext::getEvaluationType() const
{
	return queryContext_->getEvaluationType();
}

void XmlQueryContext::setWithMetaData(bool withMetaData)
{
	queryContext_->setWithMetaData(withMetaData);
}

bool XmlQueryContext::getWithMetaData() const
{
	return queryContext_->getWithMetaData();
}
