//
// See the file LICENSE for redistribution information.
//
// Copyright (c) 2002-2003
//	Sleepycat Software.  All rights reserved.
//

static const char revid[] = "$Id: XmlModify.cpp,v 1.3 2003/12/04 21:57:04 merrells Exp $";

#include "dbxml_config.h"
#include "dbxml/XmlPortability.hpp"
#include "dbxml/XmlModify.hpp"
#include "Modify.hpp"

using namespace DbXml;

XmlModify::XmlModify(const std::string &xpath, ModificationType operation, XmlObject type,
		     const std::string &name, const std::string &content, int location,
		     XmlQueryContext *context)
	: modify_(new Modify(NULL, &xpath, operation, type, &name, &content, location, context))
{
	modify_->acquire();
}
			     

XmlModify::XmlModify(XmlQueryExpression &expression, ModificationType operation, XmlObject type,
		     const std::string &name, const std::string &content, int location)
	: modify_(new Modify(&expression, NULL, operation, type, &name, &content, location, NULL))
{
	modify_->acquire();
}

XmlModify::~XmlModify()
{
	modify_->release();
}

void XmlModify::setNewEncoding(const std::string &newEncoding)
{
	modify_->setNewEncoding(&newEncoding);
}

int XmlModify::getNumModifications() const
{
	return modify_->getNumOps();
}
