//
// See the file LICENSE for redistribution information.
//
// Copyright (c) 2002-2003
//	Sleepycat Software.  All rights reserved.
//

static const char revid[] = "$Id: XmlIndexSpecification.cpp,v 1.5 2003/05/09 03:13:57 merrells Exp $";

#include "dbxml_config.h"
#include "dbxml/XmlPortability.hpp"
#include "dbxml/XmlIndexSpecification.hpp"
#include "IndexSpecification.hpp"

using namespace DbXml;

XmlIndexSpecification::XmlIndexSpecification()
	: is_(new IndexSpecification),
	isi_(new IndexSpecificationIterator(*is_))
{
	is_->acquire();
}

XmlIndexSpecification::~XmlIndexSpecification()
{
	is_->release();
	delete isi_;
}

XmlIndexSpecification::XmlIndexSpecification(const XmlIndexSpecification &o)
	: is_(o.is_),
	isi_(new IndexSpecificationIterator(*is_))
{
	if (is_ != 0)
		is_->acquire();
}

XmlIndexSpecification &XmlIndexSpecification::operator=(const XmlIndexSpecification &o)
{
	if (this != &o && is_ != o.is_) {
		if (is_ != 0)
			is_->release();
		is_ = o.is_;
		if (is_ != 0)
			is_->acquire();
		delete isi_;
		isi_ = new IndexSpecificationIterator(*is_);
	}
	return *this;
}

void XmlIndexSpecification::addIndex(const std::string &uri, const std::string &name, const std::string &index)
{
	is_->addIndex(uri, name, index);
}

void XmlIndexSpecification::deleteIndex(const std::string &uri, const std::string &name, const std::string &index)
{
	is_->deleteIndex(uri, name, index);
}

void XmlIndexSpecification::replaceIndex(const std::string &uri, const std::string &name, const std::string &index)
{
	std::string oldindex;
	if(is_->find(uri, name, oldindex))
		is_->deleteIndex(uri, name, oldindex);
	is_->addIndex(uri, name, index);
}

bool XmlIndexSpecification::find(const std::string &uri, const std::string &name, std::string &index)
{
	return is_->find(uri, name, index);
}

bool XmlIndexSpecification::next(std::string &uri, std::string &name, std::string &index)
{
	return isi_->next(uri, name, index);
}

void XmlIndexSpecification::reset()
{
	isi_->reset();
}
