#ifndef INC_XPathSelectionTreeParser_hpp_
#define INC_XPathSelectionTreeParser_hpp_

#include <antlr/config.hpp>
#include "XPathSelectionTreeParserTokenTypes.hpp"
/* $ANTLR 2.7.2: "XPathSelection.g" -> "XPathSelectionTreeParser.hpp"$ */
#include <antlr/TreeParser.hpp>

#line 15 "XPathSelection.g"

	#include "dbxml/XmlPortability.hpp"
	#include "dbxml/XmlException.hpp"
	#include "QueryPlan.hpp"
	#include "tokenizer.hpp"
	#include <cmath>

	using namespace antlr;
	using namespace DbXml;

#line 21 "XPathSelectionTreeParser.hpp"
class XPathSelectionTreeParser : public ANTLR_USE_NAMESPACE(antlr)TreeParser, public XPathSelectionTreeParserTokenTypes
{
#line 1 "XPathSelection.g"
#line 25 "XPathSelectionTreeParser.hpp"
public:
	XPathSelectionTreeParser();
	void initializeASTFactory( ANTLR_USE_NAMESPACE(antlr)ASTFactory& factory );
	int getNumTokens() const
	{
		return XPathSelectionTreeParser::NUM_TOKENS;
	}
	const char* getTokenName( int type ) const
	{
		if( type > getNumTokens() ) return 0;
		return XPathSelectionTreeParser::tokenNames[type];
	}
	public: QueryPlan::SharedPtr  xpath(ANTLR_USE_NAMESPACE(antlr)RefAST _t,
		XmlQueryContext &context
	);
	public: QueryPlan::SharedPtr  expr(ANTLR_USE_NAMESPACE(antlr)RefAST _t,
		XmlQueryContext &context
	);
	public: void nodeTest(ANTLR_USE_NAMESPACE(antlr)RefAST _t);
private:
	static const char* tokenNames[];
#ifndef NO_STATIC_CONSTS
	static const int NUM_TOKENS = 67;
#else
	enum {
		NUM_TOKENS = 67
	};
#endif
	
};

#endif /*INC_XPathSelectionTreeParser_hpp_*/
