#ifndef INC_XPathProjectionTreeParser_hpp_
#define INC_XPathProjectionTreeParser_hpp_

#include <antlr/config.hpp>
#include "XPathProjectionTreeParserTokenTypes.hpp"
/* $ANTLR 2.7.2: "XPathProjection.g" -> "XPathProjectionTreeParser.hpp"$ */
#include <antlr/TreeParser.hpp>

#line 15 "XPathProjection.g"

	#include "dbxml/XmlPortability.hpp"
	#include "dbxml/XmlNamespace.hpp"
	#include "QueryPlan.hpp"

	using namespace antlr;
	using namespace DbXml;

#line 19 "XPathProjectionTreeParser.hpp"
class XPathProjectionTreeParser : public ANTLR_USE_NAMESPACE(antlr)TreeParser, public XPathProjectionTreeParserTokenTypes
{
#line 1 "XPathProjection.g"
#line 23 "XPathProjectionTreeParser.hpp"
public:
	XPathProjectionTreeParser();
	void initializeASTFactory( ANTLR_USE_NAMESPACE(antlr)ASTFactory& factory );
	int getNumTokens() const
	{
		return XPathProjectionTreeParser::NUM_TOKENS;
	}
	const char* getTokenName( int type ) const
	{
		if( type > getNumTokens() ) return 0;
		return XPathProjectionTreeParser::tokenNames[type];
	}
	public: QueryPlan::SharedPtr  xpath(ANTLR_USE_NAMESPACE(antlr)RefAST _t);
	public: QueryPlan::SharedPtr  expr(ANTLR_USE_NAMESPACE(antlr)RefAST _t);
	public: void nodeTest(ANTLR_USE_NAMESPACE(antlr)RefAST _t);
private:
	static const char* tokenNames[];
#ifndef NO_STATIC_CONSTS
	static const int NUM_TOKENS = 67;
#else
	enum {
		NUM_TOKENS = 67
	};
#endif
	
};

#endif /*INC_XPathProjectionTreeParser_hpp_*/
