/* $ANTLR 2.7.2: "XPathProjection.g" -> "XPathProjectionTreeParser.cpp"$ */
#include "XPathProjectionTreeParser.hpp"
#include <antlr/Token.hpp>
#include <antlr/AST.hpp>
#include <antlr/NoViableAltException.hpp>
#include <antlr/MismatchedTokenException.hpp>
#include <antlr/SemanticException.hpp>
#include <antlr/BitSet.hpp>
#line 1 "XPathProjection.g"
#line 11 "XPathProjectionTreeParser.cpp"
XPathProjectionTreeParser::XPathProjectionTreeParser()
	: ANTLR_USE_NAMESPACE(antlr)TreeParser() {
}

QueryPlan::SharedPtr  XPathProjectionTreeParser::xpath(ANTLR_USE_NAMESPACE(antlr)RefAST _t) {
#line 43 "XPathProjection.g"
	QueryPlan::SharedPtr r;
#line 19 "XPathProjectionTreeParser.cpp"
	ANTLR_USE_NAMESPACE(antlr)RefAST xpath_AST_in = _t;
	
	ANTLR_USE_NAMESPACE(antlr)RefAST __t2 = _t;
	ANTLR_USE_NAMESPACE(antlr)RefAST tmp1_AST_in = _t;
	match(_t,XPATH);
	_t = _t->getFirstChild();
	r=expr(_t);
	_t = _retTree;
	_t = __t2;
	_t = _t->getNextSibling();
	_retTree = _t;
	return r;
}

QueryPlan::SharedPtr  XPathProjectionTreeParser::expr(ANTLR_USE_NAMESPACE(antlr)RefAST _t) {
#line 47 "XPathProjection.g"
	QueryPlan::SharedPtr r;
#line 37 "XPathProjectionTreeParser.cpp"
	ANTLR_USE_NAMESPACE(antlr)RefAST expr_AST_in = _t;
	ANTLR_USE_NAMESPACE(antlr)RefAST a3 = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST b3 = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST a19 = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST a20 = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST a21 = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST a22 = ANTLR_USE_NAMESPACE(antlr)nullAST;
#line 47 "XPathProjection.g"
	
		QueryPlan::SharedPtr a;
		QueryPlan::SharedPtr b;
	
#line 50 "XPathProjectionTreeParser.cpp"
	
	if (_t == ANTLR_USE_NAMESPACE(antlr)nullAST )
		_t = ASTNULL;
	switch ( _t->getType()) {
	case CHAIN:
	{
		ANTLR_USE_NAMESPACE(antlr)RefAST __t4 = _t;
		ANTLR_USE_NAMESPACE(antlr)RefAST tmp2_AST_in = _t;
		match(_t,CHAIN);
		_t = _t->getFirstChild();
		a=expr(_t);
		_t = _retTree;
		b=expr(_t);
		_t = _retTree;
		_t = __t4;
		_t = _t->getNextSibling();
		if ( inputState->guessing==0 ) {
#line 54 "XPathProjection.g"
			
				if(b)
				{
					r= b; // always take the rightmost one.
				}
				else
				{
					r= a;
				}
			
#line 79 "XPathProjectionTreeParser.cpp"
		}
		break;
	}
	case PREDICATE:
	{
		ANTLR_USE_NAMESPACE(antlr)RefAST tmp3_AST_in = _t;
		match(_t,PREDICATE);
		_t = _t->getNextSibling();
		if ( inputState->guessing==0 ) {
#line 66 "XPathProjection.g"
			
			
#line 92 "XPathProjectionTreeParser.cpp"
		}
		break;
	}
	case ROOT:
	{
		ANTLR_USE_NAMESPACE(antlr)RefAST tmp4_AST_in = _t;
		match(_t,ROOT);
		_t = _t->getNextSibling();
		if ( inputState->guessing==0 ) {
#line 70 "XPathProjection.g"
			
			
#line 105 "XPathProjectionTreeParser.cpp"
		}
		break;
	}
	case DISCOVER:
	{
		ANTLR_USE_NAMESPACE(antlr)RefAST __t5 = _t;
		ANTLR_USE_NAMESPACE(antlr)RefAST tmp5_AST_in = _t;
		match(_t,DISCOVER);
		_t = _t->getFirstChild();
		a3 = _t;
		match(_t,AXIS);
		_t = _t->getNextSibling();
		b3 = (_t == ASTNULL) ? ANTLR_USE_NAMESPACE(antlr)nullAST : _t;
		nodeTest(_t);
		_t = _retTree;
		_t = __t5;
		_t = _t->getNextSibling();
		if ( inputState->guessing==0 ) {
#line 74 "XPathProjection.g"
			
				std::string s(b3->getText().substr(1));
				if(
					a3->getText().compare("attribute")==0 &&
					strncmp(s.c_str(),metaDataNamespace_uri,strlen(metaDataNamespace_uri))==0)
				{
					r.reset(new MetaDataAccessQP(s));
				}
			
#line 134 "XPathProjectionTreeParser.cpp"
		}
		break;
	}
	case UNION:
	{
		ANTLR_USE_NAMESPACE(antlr)RefAST __t6 = _t;
		ANTLR_USE_NAMESPACE(antlr)RefAST tmp6_AST_in = _t;
		match(_t,UNION);
		_t = _t->getFirstChild();
		a=expr(_t);
		_t = _retTree;
		b=expr(_t);
		_t = _retTree;
		_t = __t6;
		_t = _t->getNextSibling();
		if ( inputState->guessing==0 ) {
#line 85 "XPathProjection.g"
			
			
#line 154 "XPathProjectionTreeParser.cpp"
		}
		break;
	}
	case OR:
	{
		ANTLR_USE_NAMESPACE(antlr)RefAST __t7 = _t;
		ANTLR_USE_NAMESPACE(antlr)RefAST tmp7_AST_in = _t;
		match(_t,OR);
		_t = _t->getFirstChild();
		a=expr(_t);
		_t = _retTree;
		b=expr(_t);
		_t = _retTree;
		_t = __t7;
		_t = _t->getNextSibling();
		if ( inputState->guessing==0 ) {
#line 88 "XPathProjection.g"
			
			
#line 174 "XPathProjectionTreeParser.cpp"
		}
		break;
	}
	case AND:
	{
		ANTLR_USE_NAMESPACE(antlr)RefAST __t8 = _t;
		ANTLR_USE_NAMESPACE(antlr)RefAST tmp8_AST_in = _t;
		match(_t,AND);
		_t = _t->getFirstChild();
		a=expr(_t);
		_t = _retTree;
		b=expr(_t);
		_t = _retTree;
		_t = __t8;
		_t = _t->getNextSibling();
		if ( inputState->guessing==0 ) {
#line 92 "XPathProjection.g"
			
			
#line 194 "XPathProjectionTreeParser.cpp"
		}
		break;
	}
	case EQUAL:
	{
		ANTLR_USE_NAMESPACE(antlr)RefAST __t9 = _t;
		ANTLR_USE_NAMESPACE(antlr)RefAST tmp9_AST_in = _t;
		match(_t,EQUAL);
		_t = _t->getFirstChild();
		a=expr(_t);
		_t = _retTree;
		b=expr(_t);
		_t = _retTree;
		_t = __t9;
		_t = _t->getNextSibling();
		if ( inputState->guessing==0 ) {
#line 96 "XPathProjection.g"
			
			
#line 214 "XPathProjectionTreeParser.cpp"
		}
		break;
	}
	case NOTEQUAL:
	{
		ANTLR_USE_NAMESPACE(antlr)RefAST __t10 = _t;
		ANTLR_USE_NAMESPACE(antlr)RefAST tmp10_AST_in = _t;
		match(_t,NOTEQUAL);
		_t = _t->getFirstChild();
		a=expr(_t);
		_t = _retTree;
		b=expr(_t);
		_t = _retTree;
		_t = __t10;
		_t = _t->getNextSibling();
		if ( inputState->guessing==0 ) {
#line 100 "XPathProjection.g"
			
			
#line 234 "XPathProjectionTreeParser.cpp"
		}
		break;
	}
	case LTX:
	{
		ANTLR_USE_NAMESPACE(antlr)RefAST __t11 = _t;
		ANTLR_USE_NAMESPACE(antlr)RefAST tmp11_AST_in = _t;
		match(_t,LTX);
		_t = _t->getFirstChild();
		a=expr(_t);
		_t = _retTree;
		b=expr(_t);
		_t = _retTree;
		_t = __t11;
		_t = _t->getNextSibling();
		if ( inputState->guessing==0 ) {
#line 104 "XPathProjection.g"
			
			
#line 254 "XPathProjectionTreeParser.cpp"
		}
		break;
	}
	case GTX:
	{
		ANTLR_USE_NAMESPACE(antlr)RefAST __t12 = _t;
		ANTLR_USE_NAMESPACE(antlr)RefAST tmp12_AST_in = _t;
		match(_t,GTX);
		_t = _t->getFirstChild();
		a=expr(_t);
		_t = _retTree;
		b=expr(_t);
		_t = _retTree;
		_t = __t12;
		_t = _t->getNextSibling();
		if ( inputState->guessing==0 ) {
#line 108 "XPathProjection.g"
			
			
#line 274 "XPathProjectionTreeParser.cpp"
		}
		break;
	}
	case LTE:
	{
		ANTLR_USE_NAMESPACE(antlr)RefAST __t13 = _t;
		ANTLR_USE_NAMESPACE(antlr)RefAST tmp13_AST_in = _t;
		match(_t,LTE);
		_t = _t->getFirstChild();
		a=expr(_t);
		_t = _retTree;
		b=expr(_t);
		_t = _retTree;
		_t = __t13;
		_t = _t->getNextSibling();
		if ( inputState->guessing==0 ) {
#line 112 "XPathProjection.g"
			
			
#line 294 "XPathProjectionTreeParser.cpp"
		}
		break;
	}
	case GTE:
	{
		ANTLR_USE_NAMESPACE(antlr)RefAST __t14 = _t;
		ANTLR_USE_NAMESPACE(antlr)RefAST tmp14_AST_in = _t;
		match(_t,GTE);
		_t = _t->getFirstChild();
		a=expr(_t);
		_t = _retTree;
		b=expr(_t);
		_t = _retTree;
		_t = __t14;
		_t = _t->getNextSibling();
		if ( inputState->guessing==0 ) {
#line 116 "XPathProjection.g"
			
			
#line 314 "XPathProjectionTreeParser.cpp"
		}
		break;
	}
	case PLUS:
	{
		ANTLR_USE_NAMESPACE(antlr)RefAST __t15 = _t;
		ANTLR_USE_NAMESPACE(antlr)RefAST tmp15_AST_in = _t;
		match(_t,PLUS);
		_t = _t->getFirstChild();
		a=expr(_t);
		_t = _retTree;
		b=expr(_t);
		_t = _retTree;
		_t = __t15;
		_t = _t->getNextSibling();
		if ( inputState->guessing==0 ) {
#line 120 "XPathProjection.g"
			
			
#line 334 "XPathProjectionTreeParser.cpp"
		}
		break;
	}
	case STAR:
	{
		ANTLR_USE_NAMESPACE(antlr)RefAST __t21 = _t;
		ANTLR_USE_NAMESPACE(antlr)RefAST tmp16_AST_in = _t;
		match(_t,STAR);
		_t = _t->getFirstChild();
		a=expr(_t);
		_t = _retTree;
		b=expr(_t);
		_t = _retTree;
		_t = __t21;
		_t = _t->getNextSibling();
		if ( inputState->guessing==0 ) {
#line 132 "XPathProjection.g"
			
			
#line 354 "XPathProjectionTreeParser.cpp"
		}
		break;
	}
	case DIV:
	{
		ANTLR_USE_NAMESPACE(antlr)RefAST __t22 = _t;
		ANTLR_USE_NAMESPACE(antlr)RefAST tmp17_AST_in = _t;
		match(_t,DIV);
		_t = _t->getFirstChild();
		a=expr(_t);
		_t = _retTree;
		b=expr(_t);
		_t = _retTree;
		_t = __t22;
		_t = _t->getNextSibling();
		if ( inputState->guessing==0 ) {
#line 136 "XPathProjection.g"
			
			
#line 374 "XPathProjectionTreeParser.cpp"
		}
		break;
	}
	case MOD:
	{
		ANTLR_USE_NAMESPACE(antlr)RefAST __t23 = _t;
		ANTLR_USE_NAMESPACE(antlr)RefAST tmp18_AST_in = _t;
		match(_t,MOD);
		_t = _t->getFirstChild();
		a=expr(_t);
		_t = _retTree;
		b=expr(_t);
		_t = _retTree;
		_t = __t23;
		_t = _t->getNextSibling();
		if ( inputState->guessing==0 ) {
#line 140 "XPathProjection.g"
			
			
#line 394 "XPathProjectionTreeParser.cpp"
		}
		break;
	}
	case VARIABLE:
	{
		a19 = _t;
		match(_t,VARIABLE);
		_t = _t->getNextSibling();
		if ( inputState->guessing==0 ) {
#line 144 "XPathProjection.g"
			
			
#line 407 "XPathProjectionTreeParser.cpp"
		}
		break;
	}
	case LITERAL:
	{
		a20 = _t;
		match(_t,LITERAL);
		_t = _t->getNextSibling();
		if ( inputState->guessing==0 ) {
#line 148 "XPathProjection.g"
			
			
#line 420 "XPathProjectionTreeParser.cpp"
		}
		break;
	}
	case NUMBER:
	{
		a21 = _t;
		match(_t,NUMBER);
		_t = _t->getNextSibling();
		if ( inputState->guessing==0 ) {
#line 152 "XPathProjection.g"
			
			
#line 433 "XPathProjectionTreeParser.cpp"
		}
		break;
	}
	case FUNCTION:
	{
		a22 = _t;
		match(_t,FUNCTION);
		_t = _t->getNextSibling();
		if ( inputState->guessing==0 ) {
#line 156 "XPathProjection.g"
			
			
#line 446 "XPathProjectionTreeParser.cpp"
		}
		break;
	}
	default:
		bool synPredMatched18 = false;
		if (((_t->getType() == MINUS))) {
			ANTLR_USE_NAMESPACE(antlr)RefAST __t18 = _t;
			synPredMatched18 = true;
			inputState->guessing++;
			try {
				{
				ANTLR_USE_NAMESPACE(antlr)RefAST __t17 = _t;
				ANTLR_USE_NAMESPACE(antlr)RefAST tmp19_AST_in = _t;
				match(_t,MINUS);
				_t = _t->getFirstChild();
				expr(_t);
				_t = _retTree;
				expr(_t);
				_t = _retTree;
				_t = __t17;
				_t = _t->getNextSibling();
				}
			}
			catch (ANTLR_USE_NAMESPACE(antlr)RecognitionException& pe) {
				synPredMatched18 = false;
			}
			_t = __t18;
			inputState->guessing--;
		}
		if ( synPredMatched18 ) {
			ANTLR_USE_NAMESPACE(antlr)RefAST __t19 = _t;
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp20_AST_in = _t;
			match(_t,MINUS);
			_t = _t->getFirstChild();
			a=expr(_t);
			_t = _retTree;
			b=expr(_t);
			_t = _retTree;
			_t = __t19;
			_t = _t->getNextSibling();
			if ( inputState->guessing==0 ) {
#line 124 "XPathProjection.g"
				
				
#line 491 "XPathProjectionTreeParser.cpp"
			}
		}
		else if ((_t->getType() == MINUS)) {
			ANTLR_USE_NAMESPACE(antlr)RefAST __t20 = _t;
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp21_AST_in = _t;
			match(_t,MINUS);
			_t = _t->getFirstChild();
			a=expr(_t);
			_t = _retTree;
			_t = __t20;
			_t = _t->getNextSibling();
			if ( inputState->guessing==0 ) {
#line 128 "XPathProjection.g"
				
				
#line 507 "XPathProjectionTreeParser.cpp"
			}
		}
	else {
		throw ANTLR_USE_NAMESPACE(antlr)NoViableAltException(_t);
	}
	}
	_retTree = _t;
	return r;
}

void XPathProjectionTreeParser::nodeTest(ANTLR_USE_NAMESPACE(antlr)RefAST _t) {
	ANTLR_USE_NAMESPACE(antlr)RefAST nodeTest_AST_in = _t;
	
	if (_t == ANTLR_USE_NAMESPACE(antlr)nullAST )
		_t = ASTNULL;
	switch ( _t->getType()) {
	case NAME:
	{
		ANTLR_USE_NAMESPACE(antlr)RefAST tmp22_AST_in = _t;
		match(_t,NAME);
		_t = _t->getNextSibling();
		break;
	}
	case COMMENT:
	{
		ANTLR_USE_NAMESPACE(antlr)RefAST tmp23_AST_in = _t;
		match(_t,COMMENT);
		_t = _t->getNextSibling();
		break;
	}
	case TEXT:
	{
		ANTLR_USE_NAMESPACE(antlr)RefAST tmp24_AST_in = _t;
		match(_t,TEXT);
		_t = _t->getNextSibling();
		break;
	}
	case NODE:
	{
		ANTLR_USE_NAMESPACE(antlr)RefAST tmp25_AST_in = _t;
		match(_t,NODE);
		_t = _t->getNextSibling();
		break;
	}
	case PROCESSING_INSTRUCTION:
	{
		ANTLR_USE_NAMESPACE(antlr)RefAST tmp26_AST_in = _t;
		match(_t,PROCESSING_INSTRUCTION);
		_t = _t->getNextSibling();
		break;
	}
	default:
	{
		throw ANTLR_USE_NAMESPACE(antlr)NoViableAltException(_t);
	}
	}
	_retTree = _t;
}

void XPathProjectionTreeParser::initializeASTFactory( ANTLR_USE_NAMESPACE(antlr)ASTFactory& factory )
{
}
const char* XPathProjectionTreeParser::tokenNames[] = {
	"<0>",
	"EOF",
	"<2>",
	"NULL_TREE_LOOKAHEAD",
	"\"and\"",
	"\"or\"",
	"\"div\"",
	"\"mod\"",
	"\"ancestor\"",
	"\"ancestor-or-self\"",
	"\"attribute\"",
	"\"child\"",
	"\"descendant\"",
	"\"descendant-or-self\"",
	"\"following\"",
	"\"following-sibling\"",
	"\"namespace\"",
	"\"parent\"",
	"\"preceding\"",
	"\"preceding-sibling\"",
	"\"self\"",
	"whitespace",
	"a comment",
	"an identifier",
	"NCNAMECHAR",
	"a string literal",
	"LETTER",
	"a numeric literal",
	"a number",
	"STAR",
	"SLASH",
	"SLASHSLASH",
	"COLON",
	"COLONCOLON",
	"a left bracket '('",
	"a right bracket ')'",
	"a left square bracket '['",
	"a right square bracket ']'",
	"AT",
	"SEMICOLON",
	"a current node selector '.'",
	"a parent node selector '..'",
	"an equals operator '='",
	"a not equals operator '!='",
	"a subtraction or unary minus operator '-'",
	"an addition operator '+'",
	"a greater than operator '>'",
	"a greater than or equals operator '>='",
	"a less than operator '<'",
	"a less than or equals operator '<='",
	"an argument separator ','",
	"a union operator '|'",
	"a variable dereference operator '$'",
	"XPATH",
	"DISCOVER",
	"CHAIN",
	"ROOT",
	"AXIS",
	"OPERATION",
	"NAME",
	"FUNCTION",
	"VARIABLE",
	"TEXT",
	"NODE",
	"COMMENT",
	"PROCESSING_INSTRUCTION",
	"PREDICATE",
	0
};



