//
// See the file LICENSE for redistribution information.
//
// Copyright (c) 2002-2003
//	Sleepycat Software.  All rights reserved.
//

//
// XML Path Language (XPath) Version 1.0
// W3C Recommendation 16 November 1999
// http://www.w3.org/TR/1999/REC-xpath-19991116
//

header
{
	#include "dbxml/XmlPortability.hpp"
	#include "dbxml/XmlNamespace.hpp"
	#include "QueryPlan.hpp"

	using namespace antlr;
	using namespace DbXml;
}

options
{
	language="Cpp";
}


// ================================================================================
// T R E E P A R S E R
// ================================================================================

class XPathProjectionTreeParser extends TreeParser;

options
{
    buildAST= false;
	defaultErrorHandler= false; // The default handler sends output to stderr
	importVocab=XPathParser;
}

xpath returns [QueryPlan::SharedPtr r]
  : #(XPATH r=expr)
  ;

expr returns [QueryPlan::SharedPtr r]
  {
	QueryPlan::SharedPtr a;
	QueryPlan::SharedPtr b;
  }

  : #(CHAIN a=expr b=expr)
  {
	if(b)
	{
		r= b; // always take the rightmost one.
	}
	else
	{
		r= a;
	}
  }

  | PREDICATE
  {
  }

  | ROOT
  {
  }

  | #(DISCOVER a3:AXIS b3:nodeTest)
  {
	std::string s(b3->getText().substr(1));
	if(
		a3->getText().compare("attribute")==0 &&
		strncmp(s.c_str(),metaDataNamespace_uri,strlen(metaDataNamespace_uri))==0)
	{
		r.reset(new MetaDataAccessQP(s));
	}
  }

  | #(UNION a=expr b=expr)
  {
  }
  | #(OR a=expr b=expr)
  {
  }

  | #(AND a=expr b=expr)
  {
  }

  | #(EQUAL a=expr b=expr)
  {
  }

  | #(NOTEQUAL a=expr b=expr)
  {
  }

  | #(LTX a=expr b=expr)
  {
  }

  | #(GTX a=expr b=expr)
  {
  }

  | #(LTE a=expr b=expr)
  {
  }

  | #(GTE a=expr b=expr)
  {
  }

  | #(PLUS a=expr b=expr)
  {
  }

  | (#(MINUS expr expr))=>#(MINUS a=expr b=expr)
  {
  }

  | #(MINUS a=expr)
  {
  }

  | #(STAR a=expr b=expr)
  {
  }

  | #(DIV a=expr b=expr)
  {
  }

  | #(MOD a=expr b=expr)
  {
  }

  | a19:VARIABLE
  {
  }

  | a20:LITERAL
  { 
  }

  | a21:NUMBER
  {
  }

  | a22:FUNCTION
  {
  }
  ;

nodeTest: NAME | COMMENT | TEXT | NODE | PROCESSING_INSTRUCTION;
