/* $ANTLR 2.7.2: "XPathParser.g" -> "XPathParser.cpp"$ */
#include "XPathParser.hpp"
#include <antlr/NoViableAltException.hpp>
#include <antlr/SemanticException.hpp>
#include <antlr/ASTFactory.hpp>
#line 160 "XPathParser.g"


	void parserError(RecognitionException &ex, const char *description)
	{
		std::ostringstream s;
		if(description!=0)
		{
			s << description;
			s << " ";
		}
		if(ex.getLine() > 0)
		{
			s << "Line ";
			s << ex.getLine();
			s << ", ";
		}
		if(ex.getColumn() > 0)
		{
			s << "Column ";
			s << ex.getColumn();
			s << ", ";
		}
		s << ex.getMessage();
		throw ANTLRException(s.str().c_str());
	}

	std::string mapPrefixToUri(QueryContext &context, const std::string &prefix)
	{
	    // Lookup the URI for the prefix.
	    std::string uri(context.getNamespace(prefix));
	    if(uri.empty())
	    {
	    	throw XmlException(XmlException::XPATH_PARSER_ERROR,"The prefix '"+prefix+"' is not bound to a URI.");
	    }
		return uri;
	}

#line 45 "XPathParser.cpp"
XPathParser::XPathParser(ANTLR_USE_NAMESPACE(antlr)TokenBuffer& tokenBuf, int k)
: ANTLR_USE_NAMESPACE(antlr)LLkParser(tokenBuf,k)
{
}

XPathParser::XPathParser(ANTLR_USE_NAMESPACE(antlr)TokenBuffer& tokenBuf)
: ANTLR_USE_NAMESPACE(antlr)LLkParser(tokenBuf,3)
{
}

XPathParser::XPathParser(ANTLR_USE_NAMESPACE(antlr)TokenStream& lexer, int k)
: ANTLR_USE_NAMESPACE(antlr)LLkParser(lexer,k)
{
}

XPathParser::XPathParser(ANTLR_USE_NAMESPACE(antlr)TokenStream& lexer)
: ANTLR_USE_NAMESPACE(antlr)LLkParser(lexer,3)
{
}

XPathParser::XPathParser(const ANTLR_USE_NAMESPACE(antlr)ParserSharedInputState& state)
: ANTLR_USE_NAMESPACE(antlr)LLkParser(state,3)
{
}

void XPathParser::xpath(
	QueryContext &context
) {
	returnAST = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)ASTPair currentAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST xpath_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST a1_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
#line 235 "XPathParser.g"
	
		ParserContext pc;
		pc.push_step("", ".root");
	
#line 83 "XPathParser.cpp"
	
	try {      // for error handling
		switch ( LA(1)) {
		case DIV:
		case MOD:
		case LITERAL_ancestor:
		case LITERAL_ancestor_or_self:
		case LITERAL_attribute:
		case LITERAL_child:
		case LITERAL_descendant:
		case LITERAL_descendant_or_self:
		case LITERAL_following:
		case LITERAL_following_sibling:
		case LITERAL_namespace:
		case LITERAL_parent:
		case LITERAL_preceding:
		case LITERAL_preceding_sibling:
		case LITERAL_self:
		case NCNAME:
		case LITERAL:
		case NUMBER:
		case STAR:
		case SLASH:
		case SLASHSLASH:
		case LB:
		case AT:
		case DOT:
		case DOTDOT:
		case MINUS:
		case DOLLAR:
		{
			expr(context,pc);
			if (inputState->guessing==0) {
				a1_AST = returnAST;
				astFactory->addASTChild( currentAST, returnAST );
			}
			if ( inputState->guessing==0 ) {
				xpath_AST = ANTLR_USE_NAMESPACE(antlr)RefAST(currentAST.root);
#line 241 "XPathParser.g"
				xpath_AST= ANTLR_USE_NAMESPACE(antlr)RefAST(astFactory->make((new ANTLR_USE_NAMESPACE(antlr)ASTArray(2))->add(astFactory->create(XPATH,"X"))->add(a1_AST)));
#line 124 "XPathParser.cpp"
				currentAST.root = xpath_AST;
				if ( xpath_AST!=ANTLR_USE_NAMESPACE(antlr)nullAST &&
					xpath_AST->getFirstChild() != ANTLR_USE_NAMESPACE(antlr)nullAST )
					  currentAST.child = xpath_AST->getFirstChild();
				else
					currentAST.child = xpath_AST;
				currentAST.advanceChildToEnd();
			}
			xpath_AST = currentAST.root;
			break;
		}
		case ANTLR_USE_NAMESPACE(antlr)Token::EOF_TYPE:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp1_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
			if ( inputState->guessing == 0 ) {
				tmp1_AST = astFactory->create(LT(1));
				astFactory->addASTChild(currentAST, tmp1_AST);
			}
			match(ANTLR_USE_NAMESPACE(antlr)Token::EOF_TYPE);
			if ( inputState->guessing==0 ) {
				xpath_AST = ANTLR_USE_NAMESPACE(antlr)RefAST(currentAST.root);
#line 243 "XPathParser.g"
				xpath_AST= nullAST;
#line 148 "XPathParser.cpp"
				currentAST.root = xpath_AST;
				if ( xpath_AST!=ANTLR_USE_NAMESPACE(antlr)nullAST &&
					xpath_AST->getFirstChild() != ANTLR_USE_NAMESPACE(antlr)nullAST )
					  currentAST.child = xpath_AST->getFirstChild();
				else
					currentAST.child = xpath_AST;
				currentAST.advanceChildToEnd();
			}
			xpath_AST = currentAST.root;
			break;
		}
		default:
		{
			throw ANTLR_USE_NAMESPACE(antlr)NoViableAltException(LT(1), getFilename());
		}
		}
	}
	catch (RecognitionException &ex) {
		if (inputState->guessing==0) {
#line 247 "XPathParser.g"
			
				parserError(ex, 0);
			
#line 172 "XPathParser.cpp"
		} else {
			throw;
		}
	}
	returnAST = xpath_AST;
}

void XPathParser::expr(
	QueryContext &context,ParserContext &pc
) {
	returnAST = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)ASTPair currentAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST expr_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
	
	orExpr(context,pc);
	if (inputState->guessing==0) {
		astFactory->addASTChild( currentAST, returnAST );
	}
	expr_AST = currentAST.root;
	returnAST = expr_AST;
}

void XPathParser::locationPath(
	QueryContext &context,ParserContext &pc
) {
	returnAST = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)ASTPair currentAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST locationPath_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
	
	switch ( LA(1)) {
	case DIV:
	case MOD:
	case LITERAL_ancestor:
	case LITERAL_ancestor_or_self:
	case LITERAL_attribute:
	case LITERAL_child:
	case LITERAL_descendant:
	case LITERAL_descendant_or_self:
	case LITERAL_following:
	case LITERAL_following_sibling:
	case LITERAL_namespace:
	case LITERAL_parent:
	case LITERAL_preceding:
	case LITERAL_preceding_sibling:
	case LITERAL_self:
	case NCNAME:
	case STAR:
	case AT:
	case DOT:
	case DOTDOT:
	{
		relativeLocationPath(context,pc);
		if (inputState->guessing==0) {
			astFactory->addASTChild( currentAST, returnAST );
		}
		locationPath_AST = currentAST.root;
		break;
	}
	case SLASH:
	case SLASHSLASH:
	{
		absoluteLocationPath(context,pc);
		if (inputState->guessing==0) {
			astFactory->addASTChild( currentAST, returnAST );
		}
		locationPath_AST = currentAST.root;
		break;
	}
	default:
	{
		throw ANTLR_USE_NAMESPACE(antlr)NoViableAltException(LT(1), getFilename());
	}
	}
	returnAST = locationPath_AST;
}

void XPathParser::relativeLocationPath(
	QueryContext &context,ParserContext &pc
) {
	returnAST = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)ASTPair currentAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST relativeLocationPath_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST a1_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST b1_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
	
	step(context,pc);
	if (inputState->guessing==0) {
		a1_AST = returnAST;
	}
	steps(context,pc);
	if (inputState->guessing==0) {
		b1_AST = returnAST;
	}
	if ( inputState->guessing==0 ) {
		relativeLocationPath_AST = ANTLR_USE_NAMESPACE(antlr)RefAST(currentAST.root);
#line 293 "XPathParser.g"
		
			if(b1_AST==nullAST)
			{
				relativeLocationPath_AST= a1_AST;
			}
			else
			{
				relativeLocationPath_AST= ANTLR_USE_NAMESPACE(antlr)RefAST(astFactory->make((new ANTLR_USE_NAMESPACE(antlr)ASTArray(3))->add(astFactory->create(CHAIN,"C"))->add(a1_AST)->add(b1_AST)));
			}
		
#line 279 "XPathParser.cpp"
		currentAST.root = relativeLocationPath_AST;
		if ( relativeLocationPath_AST!=ANTLR_USE_NAMESPACE(antlr)nullAST &&
			relativeLocationPath_AST->getFirstChild() != ANTLR_USE_NAMESPACE(antlr)nullAST )
			  currentAST.child = relativeLocationPath_AST->getFirstChild();
		else
			currentAST.child = relativeLocationPath_AST;
		currentAST.advanceChildToEnd();
	}
	returnAST = relativeLocationPath_AST;
}

void XPathParser::absoluteLocationPath(
	QueryContext &context,ParserContext &pc
) {
	returnAST = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)ASTPair currentAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST absoluteLocationPath_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST a1_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST a2_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
	
	switch ( LA(1)) {
	case SLASH:
	{
		ANTLR_USE_NAMESPACE(antlr)RefAST tmp2_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
		if ( inputState->guessing == 0 ) {
			tmp2_AST = astFactory->create(LT(1));
		}
		match(SLASH);
		{
		bool synPredMatched6 = false;
		if (((_tokenSet_0.member(LA(1))) && (_tokenSet_1.member(LA(2))) && (_tokenSet_2.member(LA(3))))) {
			int _m6 = mark();
			synPredMatched6 = true;
			inputState->guessing++;
			try {
				{
				switch ( LA(1)) {
				case AT:
				{
					match(AT);
					break;
				}
				case STAR:
				{
					match(STAR);
					break;
				}
				case LITERAL_ancestor:
				case LITERAL_ancestor_or_self:
				case LITERAL_attribute:
				case LITERAL_child:
				case LITERAL_descendant:
				case LITERAL_descendant_or_self:
				case LITERAL_following:
				case LITERAL_following_sibling:
				case LITERAL_namespace:
				case LITERAL_parent:
				case LITERAL_preceding:
				case LITERAL_preceding_sibling:
				case LITERAL_self:
				{
					axisName();
					break;
				}
				case NCNAME:
				{
					match(NCNAME);
					break;
				}
				default:
				{
					throw ANTLR_USE_NAMESPACE(antlr)NoViableAltException(LT(1), getFilename());
				}
				}
				}
			}
			catch (ANTLR_USE_NAMESPACE(antlr)RecognitionException& pe) {
				synPredMatched6 = false;
			}
			rewind(_m6);
			inputState->guessing--;
		}
		if ( synPredMatched6 ) {
			try { // for error handling
				relativeLocationPath(context,pc);
				if (inputState->guessing==0) {
					a1_AST = returnAST;
				}
			}
			catch (RecognitionException &ex) {
				if (inputState->guessing==0) {
#line 280 "XPathParser.g"
					
						parserError(ex, "Expecting relative location path after '/'.");
					
#line 375 "XPathParser.cpp"
				} else {
					throw;
				}
			}
		}
		else if ((_tokenSet_3.member(LA(1))) && (_tokenSet_4.member(LA(2))) && (_tokenSet_5.member(LA(3)))) {
		}
		else {
			throw ANTLR_USE_NAMESPACE(antlr)NoViableAltException(LT(1), getFilename());
		}
		
		}
		if ( inputState->guessing==0 ) {
			absoluteLocationPath_AST = ANTLR_USE_NAMESPACE(antlr)RefAST(currentAST.root);
#line 262 "XPathParser.g"
			
				if(a1_AST==nullAST)
				{
					absoluteLocationPath_AST= ANTLR_USE_NAMESPACE(antlr)RefAST(astFactory->make((new ANTLR_USE_NAMESPACE(antlr)ASTArray(1))->add(astFactory->create(ROOT,"R"))));
				}
				else
				{
					absoluteLocationPath_AST= ANTLR_USE_NAMESPACE(antlr)RefAST(astFactory->make((new ANTLR_USE_NAMESPACE(antlr)ASTArray(3))->add(astFactory->create(CHAIN,"C"))->add(astFactory->create(ROOT,"R"))->add(a1_AST)));
				}
			
#line 401 "XPathParser.cpp"
			currentAST.root = absoluteLocationPath_AST;
			if ( absoluteLocationPath_AST!=ANTLR_USE_NAMESPACE(antlr)nullAST &&
				absoluteLocationPath_AST->getFirstChild() != ANTLR_USE_NAMESPACE(antlr)nullAST )
				  currentAST.child = absoluteLocationPath_AST->getFirstChild();
			else
				currentAST.child = absoluteLocationPath_AST;
			currentAST.advanceChildToEnd();
		}
		break;
	}
	case SLASHSLASH:
	{
		ANTLR_USE_NAMESPACE(antlr)RefAST tmp3_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
		if ( inputState->guessing == 0 ) {
			tmp3_AST = astFactory->create(LT(1));
		}
		match(SLASHSLASH);
		if ( inputState->guessing==0 ) {
#line 272 "XPathParser.g"
			pc.push_step("", ".any");
#line 422 "XPathParser.cpp"
		}
		try { // for error handling
			relativeLocationPath(context,pc);
			if (inputState->guessing==0) {
				a2_AST = returnAST;
			}
		}
		catch (RecognitionException &ex) {
			if (inputState->guessing==0) {
#line 285 "XPathParser.g"
				
					parserError(ex, "Expecting relative location path after '//'.");
				
#line 436 "XPathParser.cpp"
			} else {
				throw;
			}
		}
		if ( inputState->guessing==0 ) {
#line 272 "XPathParser.g"
			pc.pop_step();
#line 444 "XPathParser.cpp"
		}
		if ( inputState->guessing==0 ) {
			absoluteLocationPath_AST = ANTLR_USE_NAMESPACE(antlr)RefAST(currentAST.root);
#line 274 "XPathParser.g"
			
				absoluteLocationPath_AST= ANTLR_USE_NAMESPACE(antlr)RefAST(astFactory->make((new ANTLR_USE_NAMESPACE(antlr)ASTArray(3))->add(astFactory->create(CHAIN,"C"))->add(astFactory->create(ROOT,"R"))->add(a2_AST)));
			
#line 452 "XPathParser.cpp"
			currentAST.root = absoluteLocationPath_AST;
			if ( absoluteLocationPath_AST!=ANTLR_USE_NAMESPACE(antlr)nullAST &&
				absoluteLocationPath_AST->getFirstChild() != ANTLR_USE_NAMESPACE(antlr)nullAST )
				  currentAST.child = absoluteLocationPath_AST->getFirstChild();
			else
				currentAST.child = absoluteLocationPath_AST;
			currentAST.advanceChildToEnd();
		}
		break;
	}
	default:
	{
		throw ANTLR_USE_NAMESPACE(antlr)NoViableAltException(LT(1), getFilename());
	}
	}
	returnAST = absoluteLocationPath_AST;
}

void XPathParser::axisName() {
	returnAST = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)ASTPair currentAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST axisName_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
	
	switch ( LA(1)) {
	case LITERAL_ancestor:
	{
		ANTLR_USE_NAMESPACE(antlr)RefAST tmp4_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
		if ( inputState->guessing == 0 ) {
			tmp4_AST = astFactory->create(LT(1));
			astFactory->addASTChild(currentAST, tmp4_AST);
		}
		match(LITERAL_ancestor);
		axisName_AST = currentAST.root;
		break;
	}
	case LITERAL_ancestor_or_self:
	{
		ANTLR_USE_NAMESPACE(antlr)RefAST tmp5_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
		if ( inputState->guessing == 0 ) {
			tmp5_AST = astFactory->create(LT(1));
			astFactory->addASTChild(currentAST, tmp5_AST);
		}
		match(LITERAL_ancestor_or_self);
		axisName_AST = currentAST.root;
		break;
	}
	case LITERAL_attribute:
	{
		ANTLR_USE_NAMESPACE(antlr)RefAST tmp6_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
		if ( inputState->guessing == 0 ) {
			tmp6_AST = astFactory->create(LT(1));
			astFactory->addASTChild(currentAST, tmp6_AST);
		}
		match(LITERAL_attribute);
		axisName_AST = currentAST.root;
		break;
	}
	case LITERAL_child:
	{
		ANTLR_USE_NAMESPACE(antlr)RefAST tmp7_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
		if ( inputState->guessing == 0 ) {
			tmp7_AST = astFactory->create(LT(1));
			astFactory->addASTChild(currentAST, tmp7_AST);
		}
		match(LITERAL_child);
		axisName_AST = currentAST.root;
		break;
	}
	case LITERAL_descendant:
	{
		ANTLR_USE_NAMESPACE(antlr)RefAST tmp8_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
		if ( inputState->guessing == 0 ) {
			tmp8_AST = astFactory->create(LT(1));
			astFactory->addASTChild(currentAST, tmp8_AST);
		}
		match(LITERAL_descendant);
		axisName_AST = currentAST.root;
		break;
	}
	case LITERAL_descendant_or_self:
	{
		ANTLR_USE_NAMESPACE(antlr)RefAST tmp9_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
		if ( inputState->guessing == 0 ) {
			tmp9_AST = astFactory->create(LT(1));
			astFactory->addASTChild(currentAST, tmp9_AST);
		}
		match(LITERAL_descendant_or_self);
		axisName_AST = currentAST.root;
		break;
	}
	case LITERAL_following:
	{
		ANTLR_USE_NAMESPACE(antlr)RefAST tmp10_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
		if ( inputState->guessing == 0 ) {
			tmp10_AST = astFactory->create(LT(1));
			astFactory->addASTChild(currentAST, tmp10_AST);
		}
		match(LITERAL_following);
		axisName_AST = currentAST.root;
		break;
	}
	case LITERAL_following_sibling:
	{
		ANTLR_USE_NAMESPACE(antlr)RefAST tmp11_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
		if ( inputState->guessing == 0 ) {
			tmp11_AST = astFactory->create(LT(1));
			astFactory->addASTChild(currentAST, tmp11_AST);
		}
		match(LITERAL_following_sibling);
		axisName_AST = currentAST.root;
		break;
	}
	case LITERAL_namespace:
	{
		ANTLR_USE_NAMESPACE(antlr)RefAST tmp12_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
		if ( inputState->guessing == 0 ) {
			tmp12_AST = astFactory->create(LT(1));
			astFactory->addASTChild(currentAST, tmp12_AST);
		}
		match(LITERAL_namespace);
		axisName_AST = currentAST.root;
		break;
	}
	case LITERAL_parent:
	{
		ANTLR_USE_NAMESPACE(antlr)RefAST tmp13_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
		if ( inputState->guessing == 0 ) {
			tmp13_AST = astFactory->create(LT(1));
			astFactory->addASTChild(currentAST, tmp13_AST);
		}
		match(LITERAL_parent);
		axisName_AST = currentAST.root;
		break;
	}
	case LITERAL_preceding:
	{
		ANTLR_USE_NAMESPACE(antlr)RefAST tmp14_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
		if ( inputState->guessing == 0 ) {
			tmp14_AST = astFactory->create(LT(1));
			astFactory->addASTChild(currentAST, tmp14_AST);
		}
		match(LITERAL_preceding);
		axisName_AST = currentAST.root;
		break;
	}
	case LITERAL_preceding_sibling:
	{
		ANTLR_USE_NAMESPACE(antlr)RefAST tmp15_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
		if ( inputState->guessing == 0 ) {
			tmp15_AST = astFactory->create(LT(1));
			astFactory->addASTChild(currentAST, tmp15_AST);
		}
		match(LITERAL_preceding_sibling);
		axisName_AST = currentAST.root;
		break;
	}
	case LITERAL_self:
	{
		ANTLR_USE_NAMESPACE(antlr)RefAST tmp16_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
		if ( inputState->guessing == 0 ) {
			tmp16_AST = astFactory->create(LT(1));
			astFactory->addASTChild(currentAST, tmp16_AST);
		}
		match(LITERAL_self);
		axisName_AST = currentAST.root;
		break;
	}
	default:
	{
		throw ANTLR_USE_NAMESPACE(antlr)NoViableAltException(LT(1), getFilename());
	}
	}
	returnAST = axisName_AST;
}

void XPathParser::step(
	QueryContext &context,ParserContext &pc
) {
	returnAST = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)ASTPair currentAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST step_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST a1_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST b1_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST c1_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST a2_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST b2_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST a3_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
	
	bool synPredMatched12 = false;
	if (((_tokenSet_6.member(LA(1))) && (_tokenSet_1.member(LA(2))) && (_tokenSet_2.member(LA(3))))) {
		int _m12 = mark();
		synPredMatched12 = true;
		inputState->guessing++;
		try {
			{
			switch ( LA(1)) {
			case LITERAL_ancestor:
			case LITERAL_ancestor_or_self:
			case LITERAL_attribute:
			case LITERAL_child:
			case LITERAL_descendant:
			case LITERAL_descendant_or_self:
			case LITERAL_following:
			case LITERAL_following_sibling:
			case LITERAL_namespace:
			case LITERAL_parent:
			case LITERAL_preceding:
			case LITERAL_preceding_sibling:
			case LITERAL_self:
			{
				{
				axisName();
				match(COLONCOLON);
				}
				break;
			}
			case AT:
			{
				match(AT);
				break;
			}
			default:
			{
				throw ANTLR_USE_NAMESPACE(antlr)NoViableAltException(LT(1), getFilename());
			}
			}
			}
		}
		catch (ANTLR_USE_NAMESPACE(antlr)RecognitionException& pe) {
			synPredMatched12 = false;
		}
		rewind(_m12);
		inputState->guessing--;
	}
	if ( synPredMatched12 ) {
		axisSpecifier();
		if (inputState->guessing==0) {
			a1_AST = returnAST;
		}
		nodeTest(context,pc);
		if (inputState->guessing==0) {
			b1_AST = returnAST;
		}
		if ( inputState->guessing==0 ) {
#line 338 "XPathParser.g"
			
				if(b1_AST->getType()==NAME)
				{
				  	pc.push_step(a1_AST->getText(), b1_AST->getText());
				  	b1_AST->setText(pc.step());
				}
				else if(b1_AST->getType()==TEXT)
				{
				  	b1_AST->setText(pc.step());
				}
			
#line 709 "XPathParser.cpp"
		}
		predicates(context,pc);
		if (inputState->guessing==0) {
			c1_AST = returnAST;
		}
		if ( inputState->guessing==0 ) {
			step_AST = ANTLR_USE_NAMESPACE(antlr)RefAST(currentAST.root);
#line 350 "XPathParser.g"
			
				if(c1_AST==nullAST)
				{
					step_AST=ANTLR_USE_NAMESPACE(antlr)RefAST(astFactory->make((new ANTLR_USE_NAMESPACE(antlr)ASTArray(3))->add(astFactory->create(DISCOVER,"D"))->add(a1_AST)->add(b1_AST)));
					
				}
				else
				{
					step_AST= ANTLR_USE_NAMESPACE(antlr)RefAST(astFactory->make((new ANTLR_USE_NAMESPACE(antlr)ASTArray(3))->add(astFactory->create(CHAIN,"C"))->add(ANTLR_USE_NAMESPACE(antlr)RefAST(astFactory->make((new ANTLR_USE_NAMESPACE(antlr)ASTArray(3))->add(astFactory->create(DISCOVER,"D"))->add(a1_AST)->add(b1_AST))))->add(c1_AST)));
				}
			
#line 729 "XPathParser.cpp"
			currentAST.root = step_AST;
			if ( step_AST!=ANTLR_USE_NAMESPACE(antlr)nullAST &&
				step_AST->getFirstChild() != ANTLR_USE_NAMESPACE(antlr)nullAST )
				  currentAST.child = step_AST->getFirstChild();
			else
				currentAST.child = step_AST;
			currentAST.advanceChildToEnd();
		}
	}
	else if ((_tokenSet_7.member(LA(1))) && (_tokenSet_8.member(LA(2))) && (_tokenSet_4.member(LA(3)))) {
		nodeTest(context,pc);
		if (inputState->guessing==0) {
			a2_AST = returnAST;
		}
		if ( inputState->guessing==0 ) {
#line 363 "XPathParser.g"
			
				if(a2_AST->getType()==NAME)
				{
				  	pc.push_step("child", a2_AST->getText()); 
				  	a2_AST->setText(pc.step());
				}
				else if(a2_AST->getType()==TEXT)
				{
				  	a2_AST->setText(pc.step());
				}
			
#line 757 "XPathParser.cpp"
		}
		predicates(context,pc);
		if (inputState->guessing==0) {
			b2_AST = returnAST;
		}
		if ( inputState->guessing==0 ) {
			step_AST = ANTLR_USE_NAMESPACE(antlr)RefAST(currentAST.root);
#line 375 "XPathParser.g"
			
				if(b2_AST==nullAST)
				{
					step_AST=ANTLR_USE_NAMESPACE(antlr)RefAST(astFactory->make((new ANTLR_USE_NAMESPACE(antlr)ASTArray(3))->add(astFactory->create(DISCOVER,"D"))->add(ANTLR_USE_NAMESPACE(antlr)RefAST(astFactory->make((new ANTLR_USE_NAMESPACE(antlr)ASTArray(1))->add(astFactory->create(AXIS,"child")))))->add(a2_AST)));
				}
				else
				{
					step_AST= ANTLR_USE_NAMESPACE(antlr)RefAST(astFactory->make((new ANTLR_USE_NAMESPACE(antlr)ASTArray(3))->add(astFactory->create(CHAIN,"C"))->add(ANTLR_USE_NAMESPACE(antlr)RefAST(astFactory->make((new ANTLR_USE_NAMESPACE(antlr)ASTArray(3))->add(astFactory->create(DISCOVER,"D"))->add(ANTLR_USE_NAMESPACE(antlr)RefAST(astFactory->make((new ANTLR_USE_NAMESPACE(antlr)ASTArray(1))->add(astFactory->create(AXIS,"child")))))->add(a2_AST))))->add(b2_AST)));
				}
			
#line 776 "XPathParser.cpp"
			currentAST.root = step_AST;
			if ( step_AST!=ANTLR_USE_NAMESPACE(antlr)nullAST &&
				step_AST->getFirstChild() != ANTLR_USE_NAMESPACE(antlr)nullAST )
				  currentAST.child = step_AST->getFirstChild();
			else
				currentAST.child = step_AST;
			currentAST.advanceChildToEnd();
		}
	}
	else if ((LA(1) == DOT || LA(1) == DOTDOT)) {
		abbreviatedStep(context, pc);
		if (inputState->guessing==0) {
			a3_AST = returnAST;
		}
		if ( inputState->guessing==0 ) {
			step_AST = ANTLR_USE_NAMESPACE(antlr)RefAST(currentAST.root);
#line 386 "XPathParser.g"
			step_AST= a3_AST;
#line 795 "XPathParser.cpp"
			currentAST.root = step_AST;
			if ( step_AST!=ANTLR_USE_NAMESPACE(antlr)nullAST &&
				step_AST->getFirstChild() != ANTLR_USE_NAMESPACE(antlr)nullAST )
				  currentAST.child = step_AST->getFirstChild();
			else
				currentAST.child = step_AST;
			currentAST.advanceChildToEnd();
		}
	}
	else {
		throw ANTLR_USE_NAMESPACE(antlr)NoViableAltException(LT(1), getFilename());
	}
	
	returnAST = step_AST;
}

void XPathParser::steps(
	QueryContext &context,ParserContext &pc
) {
	returnAST = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)ASTPair currentAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST steps_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST a1_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST b1_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST a2_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST b2_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
	
	switch ( LA(1)) {
	case SLASH:
	{
		ANTLR_USE_NAMESPACE(antlr)RefAST tmp17_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
		if ( inputState->guessing == 0 ) {
			tmp17_AST = astFactory->create(LT(1));
		}
		match(SLASH);
		step(context,pc);
		if (inputState->guessing==0) {
			a1_AST = returnAST;
		}
		steps(context,pc);
		if (inputState->guessing==0) {
			b1_AST = returnAST;
		}
		if ( inputState->guessing==0 ) {
			steps_AST = ANTLR_USE_NAMESPACE(antlr)RefAST(currentAST.root);
#line 307 "XPathParser.g"
			
				if(b1_AST==nullAST)
				{
					steps_AST=a1_AST;
				}
				else
				{
					steps_AST= ANTLR_USE_NAMESPACE(antlr)RefAST(astFactory->make((new ANTLR_USE_NAMESPACE(antlr)ASTArray(3))->add(astFactory->create(CHAIN,"C"))->add(a1_AST)->add(b1_AST)));
				}
			
#line 852 "XPathParser.cpp"
			currentAST.root = steps_AST;
			if ( steps_AST!=ANTLR_USE_NAMESPACE(antlr)nullAST &&
				steps_AST->getFirstChild() != ANTLR_USE_NAMESPACE(antlr)nullAST )
				  currentAST.child = steps_AST->getFirstChild();
			else
				currentAST.child = steps_AST;
			currentAST.advanceChildToEnd();
		}
		break;
	}
	case SLASHSLASH:
	{
		ANTLR_USE_NAMESPACE(antlr)RefAST tmp18_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
		if ( inputState->guessing == 0 ) {
			tmp18_AST = astFactory->create(LT(1));
		}
		match(SLASHSLASH);
		if ( inputState->guessing==0 ) {
#line 317 "XPathParser.g"
			pc.push_step("", ".any");
#line 873 "XPathParser.cpp"
		}
		step(context,pc);
		if (inputState->guessing==0) {
			a2_AST = returnAST;
		}
		steps(context,pc);
		if (inputState->guessing==0) {
			b2_AST = returnAST;
		}
		if ( inputState->guessing==0 ) {
#line 317 "XPathParser.g"
			pc.pop_step();
#line 886 "XPathParser.cpp"
		}
		if ( inputState->guessing==0 ) {
			steps_AST = ANTLR_USE_NAMESPACE(antlr)RefAST(currentAST.root);
#line 319 "XPathParser.g"
			
				if(b1_AST==nullAST)
				{
					steps_AST= a2_AST;
				}
				else
				{
					steps_AST= ANTLR_USE_NAMESPACE(antlr)RefAST(astFactory->make((new ANTLR_USE_NAMESPACE(antlr)ASTArray(3))->add(astFactory->create(CHAIN,"C"))->add(a2_AST)->add(b2_AST)));
				}
			
#line 901 "XPathParser.cpp"
			currentAST.root = steps_AST;
			if ( steps_AST!=ANTLR_USE_NAMESPACE(antlr)nullAST &&
				steps_AST->getFirstChild() != ANTLR_USE_NAMESPACE(antlr)nullAST )
				  currentAST.child = steps_AST->getFirstChild();
			else
				currentAST.child = steps_AST;
			currentAST.advanceChildToEnd();
		}
		break;
	}
	case ANTLR_USE_NAMESPACE(antlr)Token::EOF_TYPE:
	case AND:
	case OR:
	case DIV:
	case MOD:
	case STAR:
	case RB:
	case RSB:
	case EQUAL:
	case NOTEQUAL:
	case MINUS:
	case PLUS:
	case GTX:
	case GTE:
	case LTX:
	case LTE:
	case COMMA:
	case UNION:
	{
		break;
	}
	default:
	{
		throw ANTLR_USE_NAMESPACE(antlr)NoViableAltException(LT(1), getFilename());
	}
	}
	returnAST = steps_AST;
}

void XPathParser::axisSpecifier() {
	returnAST = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)ASTPair currentAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST axisSpecifier_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST a1_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
	
	if (((LA(1) >= LITERAL_ancestor && LA(1) <= LITERAL_self)) && (LA(2) == COLONCOLON)) {
		axisName();
		if (inputState->guessing==0) {
			a1_AST = returnAST;
		}
		ANTLR_USE_NAMESPACE(antlr)RefAST tmp19_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
		if ( inputState->guessing == 0 ) {
			tmp19_AST = astFactory->create(LT(1));
		}
		match(COLONCOLON);
		if ( inputState->guessing==0 ) {
			axisSpecifier_AST = ANTLR_USE_NAMESPACE(antlr)RefAST(currentAST.root);
#line 410 "XPathParser.g"
			axisSpecifier_AST=ANTLR_USE_NAMESPACE(antlr)RefAST(astFactory->make((new ANTLR_USE_NAMESPACE(antlr)ASTArray(1))->add(astFactory->create(AXIS,a1_AST->getText()))));
#line 961 "XPathParser.cpp"
			currentAST.root = axisSpecifier_AST;
			if ( axisSpecifier_AST!=ANTLR_USE_NAMESPACE(antlr)nullAST &&
				axisSpecifier_AST->getFirstChild() != ANTLR_USE_NAMESPACE(antlr)nullAST )
				  currentAST.child = axisSpecifier_AST->getFirstChild();
			else
				currentAST.child = axisSpecifier_AST;
			currentAST.advanceChildToEnd();
		}
	}
	else if ((LA(1) == AT)) {
		ANTLR_USE_NAMESPACE(antlr)RefAST tmp20_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
		if ( inputState->guessing == 0 ) {
			tmp20_AST = astFactory->create(LT(1));
		}
		match(AT);
		if ( inputState->guessing==0 ) {
			axisSpecifier_AST = ANTLR_USE_NAMESPACE(antlr)RefAST(currentAST.root);
#line 412 "XPathParser.g"
			axisSpecifier_AST=ANTLR_USE_NAMESPACE(antlr)RefAST(astFactory->make((new ANTLR_USE_NAMESPACE(antlr)ASTArray(1))->add(astFactory->create(AXIS,"attribute"))));
#line 981 "XPathParser.cpp"
			currentAST.root = axisSpecifier_AST;
			if ( axisSpecifier_AST!=ANTLR_USE_NAMESPACE(antlr)nullAST &&
				axisSpecifier_AST->getFirstChild() != ANTLR_USE_NAMESPACE(antlr)nullAST )
				  currentAST.child = axisSpecifier_AST->getFirstChild();
			else
				currentAST.child = axisSpecifier_AST;
			currentAST.advanceChildToEnd();
		}
	}
	else if ((_tokenSet_7.member(LA(1))) && (_tokenSet_8.member(LA(2)))) {
		if ( inputState->guessing==0 ) {
			axisSpecifier_AST = ANTLR_USE_NAMESPACE(antlr)RefAST(currentAST.root);
#line 414 "XPathParser.g"
			axisSpecifier_AST=ANTLR_USE_NAMESPACE(antlr)RefAST(astFactory->make((new ANTLR_USE_NAMESPACE(antlr)ASTArray(1))->add(astFactory->create(AXIS,"child"))));
#line 996 "XPathParser.cpp"
			currentAST.root = axisSpecifier_AST;
			if ( axisSpecifier_AST!=ANTLR_USE_NAMESPACE(antlr)nullAST &&
				axisSpecifier_AST->getFirstChild() != ANTLR_USE_NAMESPACE(antlr)nullAST )
				  currentAST.child = axisSpecifier_AST->getFirstChild();
			else
				currentAST.child = axisSpecifier_AST;
			currentAST.advanceChildToEnd();
		}
	}
	else {
		throw ANTLR_USE_NAMESPACE(antlr)NoViableAltException(LT(1), getFilename());
	}
	
	returnAST = axisSpecifier_AST;
}

void XPathParser::nodeTest(
	QueryContext &context,ParserContext &pc
) {
	returnAST = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)ASTPair currentAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST nodeTest_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST a1_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)RefToken  b1 = ANTLR_USE_NAMESPACE(antlr)nullToken;
	ANTLR_USE_NAMESPACE(antlr)RefAST b1_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)RefToken  c1 = ANTLR_USE_NAMESPACE(antlr)nullToken;
	ANTLR_USE_NAMESPACE(antlr)RefAST c1_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
	
	if ((_tokenSet_7.member(LA(1))) && (_tokenSet_9.member(LA(2)))) {
		nameTest(context,pc);
		if (inputState->guessing==0) {
			a1_AST = returnAST;
		}
		if ( inputState->guessing==0 ) {
			nodeTest_AST = ANTLR_USE_NAMESPACE(antlr)RefAST(currentAST.root);
#line 436 "XPathParser.g"
			
				nodeTest_AST= ANTLR_USE_NAMESPACE(antlr)RefAST(astFactory->make((new ANTLR_USE_NAMESPACE(antlr)ASTArray(1))->add(astFactory->create(NAME,a1_AST->getText()))));
			
#line 1036 "XPathParser.cpp"
			currentAST.root = nodeTest_AST;
			if ( nodeTest_AST!=ANTLR_USE_NAMESPACE(antlr)nullAST &&
				nodeTest_AST->getFirstChild() != ANTLR_USE_NAMESPACE(antlr)nullAST )
				  currentAST.child = nodeTest_AST->getFirstChild();
			else
				currentAST.child = nodeTest_AST;
			currentAST.advanceChildToEnd();
		}
	}
	else if ((LA(1) == NCNAME) && (LA(2) == LB) && (LA(3) == RB)) {
		b1 = LT(1);
		if ( inputState->guessing == 0 ) {
			b1_AST = astFactory->create(b1);
			astFactory->addASTChild(currentAST, b1_AST);
		}
		match(NCNAME);
		ANTLR_USE_NAMESPACE(antlr)RefAST tmp21_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
		if ( inputState->guessing == 0 ) {
			tmp21_AST = astFactory->create(LT(1));
			astFactory->addASTChild(currentAST, tmp21_AST);
		}
		match(LB);
		ANTLR_USE_NAMESPACE(antlr)RefAST tmp22_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
		if ( inputState->guessing == 0 ) {
			tmp22_AST = astFactory->create(LT(1));
			astFactory->addASTChild(currentAST, tmp22_AST);
		}
		match(RB);
		if ( inputState->guessing==0 ) {
			nodeTest_AST = ANTLR_USE_NAMESPACE(antlr)RefAST(currentAST.root);
#line 440 "XPathParser.g"
			
			//  | COMMENT LB RB
				if(b1_AST->getText().compare("comment")==0)
				{
					nodeTest_AST= ANTLR_USE_NAMESPACE(antlr)RefAST(astFactory->make((new ANTLR_USE_NAMESPACE(antlr)ASTArray(1))->add(astFactory->create(COMMENT,b1->getText()))));
				}
			//  | TEXT LB RB
				else if(b1_AST->getText().compare("text")==0)
				{
					nodeTest_AST= ANTLR_USE_NAMESPACE(antlr)RefAST(astFactory->make((new ANTLR_USE_NAMESPACE(antlr)ASTArray(1))->add(astFactory->create(TEXT,b1->getText()))));
				}
			//  | NODE LB RB
				else if(b1_AST->getText().compare("node")==0)
				{
					nodeTest_AST= ANTLR_USE_NAMESPACE(antlr)RefAST(astFactory->make((new ANTLR_USE_NAMESPACE(antlr)ASTArray(1))->add(astFactory->create(NODE,b1->getText()))));
				}
				else
				{
					// JCM 
				}
			
#line 1089 "XPathParser.cpp"
			currentAST.root = nodeTest_AST;
			if ( nodeTest_AST!=ANTLR_USE_NAMESPACE(antlr)nullAST &&
				nodeTest_AST->getFirstChild() != ANTLR_USE_NAMESPACE(antlr)nullAST )
				  currentAST.child = nodeTest_AST->getFirstChild();
			else
				currentAST.child = nodeTest_AST;
			currentAST.advanceChildToEnd();
		}
		nodeTest_AST = currentAST.root;
	}
	else if ((LA(1) == NCNAME) && (LA(2) == LB) && (LA(3) == LITERAL)) {
		c1 = LT(1);
		if ( inputState->guessing == 0 ) {
			c1_AST = astFactory->create(c1);
			astFactory->addASTChild(currentAST, c1_AST);
		}
		match(NCNAME);
		ANTLR_USE_NAMESPACE(antlr)RefAST tmp23_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
		if ( inputState->guessing == 0 ) {
			tmp23_AST = astFactory->create(LT(1));
			astFactory->addASTChild(currentAST, tmp23_AST);
		}
		match(LB);
		ANTLR_USE_NAMESPACE(antlr)RefAST tmp24_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
		if ( inputState->guessing == 0 ) {
			tmp24_AST = astFactory->create(LT(1));
			astFactory->addASTChild(currentAST, tmp24_AST);
		}
		match(LITERAL);
		ANTLR_USE_NAMESPACE(antlr)RefAST tmp25_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
		if ( inputState->guessing == 0 ) {
			tmp25_AST = astFactory->create(LT(1));
			astFactory->addASTChild(currentAST, tmp25_AST);
		}
		match(RB);
		if ( inputState->guessing==0 ) {
			nodeTest_AST = ANTLR_USE_NAMESPACE(antlr)RefAST(currentAST.root);
#line 462 "XPathParser.g"
			
			//  | PROCESSING_INSTRUCTION LB LITERAL RB
				if(c1_AST->getText().compare("processing-instruction")==0)
				{
					nodeTest_AST= ANTLR_USE_NAMESPACE(antlr)RefAST(astFactory->make((new ANTLR_USE_NAMESPACE(antlr)ASTArray(1))->add(astFactory->create(PROCESSING_INSTRUCTION,c1->getText()))));
				}
				else
				{
					// JCM
				} 
			
#line 1139 "XPathParser.cpp"
			currentAST.root = nodeTest_AST;
			if ( nodeTest_AST!=ANTLR_USE_NAMESPACE(antlr)nullAST &&
				nodeTest_AST->getFirstChild() != ANTLR_USE_NAMESPACE(antlr)nullAST )
				  currentAST.child = nodeTest_AST->getFirstChild();
			else
				currentAST.child = nodeTest_AST;
			currentAST.advanceChildToEnd();
		}
		nodeTest_AST = currentAST.root;
	}
	else {
		throw ANTLR_USE_NAMESPACE(antlr)NoViableAltException(LT(1), getFilename());
	}
	
	returnAST = nodeTest_AST;
}

void XPathParser::predicates(
	QueryContext &context,ParserContext &pc
) {
	returnAST = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)ASTPair currentAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST predicates_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST a1_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST b1_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
	
	switch ( LA(1)) {
	case LSB:
	{
		predicate(context,pc);
		if (inputState->guessing==0) {
			a1_AST = returnAST;
		}
		predicates(context,pc);
		if (inputState->guessing==0) {
			b1_AST = returnAST;
		}
		if ( inputState->guessing==0 ) {
			predicates_AST = ANTLR_USE_NAMESPACE(antlr)RefAST(currentAST.root);
#line 391 "XPathParser.g"
			
				if(b1_AST==nullAST)
				{
					predicates_AST=a1_AST;
				}
				else
				{
					predicates_AST= ANTLR_USE_NAMESPACE(antlr)RefAST(astFactory->make((new ANTLR_USE_NAMESPACE(antlr)ASTArray(3))->add(astFactory->create(CHAIN,"C"))->add(a1_AST)->add(b1_AST)));
				}
			
#line 1190 "XPathParser.cpp"
			currentAST.root = predicates_AST;
			if ( predicates_AST!=ANTLR_USE_NAMESPACE(antlr)nullAST &&
				predicates_AST->getFirstChild() != ANTLR_USE_NAMESPACE(antlr)nullAST )
				  currentAST.child = predicates_AST->getFirstChild();
			else
				currentAST.child = predicates_AST;
			currentAST.advanceChildToEnd();
		}
		break;
	}
	case ANTLR_USE_NAMESPACE(antlr)Token::EOF_TYPE:
	case AND:
	case OR:
	case DIV:
	case MOD:
	case STAR:
	case SLASH:
	case SLASHSLASH:
	case RB:
	case RSB:
	case EQUAL:
	case NOTEQUAL:
	case MINUS:
	case PLUS:
	case GTX:
	case GTE:
	case LTX:
	case LTE:
	case COMMA:
	case UNION:
	{
		break;
	}
	default:
	{
		throw ANTLR_USE_NAMESPACE(antlr)NoViableAltException(LT(1), getFilename());
	}
	}
	returnAST = predicates_AST;
}

void XPathParser::abbreviatedStep(
	QueryContext &context,ParserContext &pc
) {
	returnAST = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)ASTPair currentAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST abbreviatedStep_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
	
	switch ( LA(1)) {
	case DOT:
	{
		ANTLR_USE_NAMESPACE(antlr)RefAST tmp26_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
		if ( inputState->guessing == 0 ) {
			tmp26_AST = astFactory->create(LT(1));
		}
		match(DOT);
		if ( inputState->guessing==0 ) {
			abbreviatedStep_AST = ANTLR_USE_NAMESPACE(antlr)RefAST(currentAST.root);
#line 485 "XPathParser.g"
			
				if(!pc.step_axis().empty())
				{
					abbreviatedStep_AST= ANTLR_USE_NAMESPACE(antlr)RefAST(astFactory->make((new ANTLR_USE_NAMESPACE(antlr)ASTArray(3))->add(astFactory->create(DISCOVER,"D"))->add(astFactory->create(AXIS,pc.step_axis()))->add(astFactory->create(NAME,pc.step())))); 
				}
				else
				{
					abbreviatedStep_AST= ANTLR_USE_NAMESPACE(antlr)RefAST(astFactory->make((new ANTLR_USE_NAMESPACE(antlr)ASTArray(3))->add(astFactory->create(DISCOVER,"D"))->add(astFactory->create(AXIS,"self"))->add(astFactory->create(NODE)))); // Abbreviation for self::node()
				}
			
#line 1260 "XPathParser.cpp"
			currentAST.root = abbreviatedStep_AST;
			if ( abbreviatedStep_AST!=ANTLR_USE_NAMESPACE(antlr)nullAST &&
				abbreviatedStep_AST->getFirstChild() != ANTLR_USE_NAMESPACE(antlr)nullAST )
				  currentAST.child = abbreviatedStep_AST->getFirstChild();
			else
				currentAST.child = abbreviatedStep_AST;
			currentAST.advanceChildToEnd();
		}
		break;
	}
	case DOTDOT:
	{
		ANTLR_USE_NAMESPACE(antlr)RefAST tmp27_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
		if ( inputState->guessing == 0 ) {
			tmp27_AST = astFactory->create(LT(1));
		}
		match(DOTDOT);
		if ( inputState->guessing==0 ) {
			abbreviatedStep_AST = ANTLR_USE_NAMESPACE(antlr)RefAST(currentAST.root);
#line 496 "XPathParser.g"
			abbreviatedStep_AST=ANTLR_USE_NAMESPACE(antlr)RefAST(astFactory->make((new ANTLR_USE_NAMESPACE(antlr)ASTArray(3))->add(astFactory->create(DISCOVER,"D"))->add(astFactory->create(AXIS,"parent"))->add(astFactory->create(NODE))));
#line 1282 "XPathParser.cpp"
			currentAST.root = abbreviatedStep_AST;
			if ( abbreviatedStep_AST!=ANTLR_USE_NAMESPACE(antlr)nullAST &&
				abbreviatedStep_AST->getFirstChild() != ANTLR_USE_NAMESPACE(antlr)nullAST )
				  currentAST.child = abbreviatedStep_AST->getFirstChild();
			else
				currentAST.child = abbreviatedStep_AST;
			currentAST.advanceChildToEnd();
		}
		break;
	}
	default:
	{
		throw ANTLR_USE_NAMESPACE(antlr)NoViableAltException(LT(1), getFilename());
	}
	}
	returnAST = abbreviatedStep_AST;
}

void XPathParser::predicate(
	QueryContext &context,ParserContext &pc
) {
	returnAST = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)ASTPair currentAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST predicate_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST a1_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
	
	ANTLR_USE_NAMESPACE(antlr)RefAST tmp28_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
	if ( inputState->guessing == 0 ) {
		tmp28_AST = astFactory->create(LT(1));
	}
	match(LSB);
	expr(context,pc);
	if (inputState->guessing==0) {
		a1_AST = returnAST;
	}
	ANTLR_USE_NAMESPACE(antlr)RefAST tmp29_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
	if ( inputState->guessing == 0 ) {
		tmp29_AST = astFactory->create(LT(1));
	}
	match(RSB);
	if ( inputState->guessing==0 ) {
		predicate_AST = ANTLR_USE_NAMESPACE(antlr)RefAST(currentAST.root);
#line 479 "XPathParser.g"
		predicate_AST= ANTLR_USE_NAMESPACE(antlr)RefAST(astFactory->make((new ANTLR_USE_NAMESPACE(antlr)ASTArray(2))->add(astFactory->create(PREDICATE,"P"))->add(a1_AST)));
#line 1327 "XPathParser.cpp"
		currentAST.root = predicate_AST;
		if ( predicate_AST!=ANTLR_USE_NAMESPACE(antlr)nullAST &&
			predicate_AST->getFirstChild() != ANTLR_USE_NAMESPACE(antlr)nullAST )
			  currentAST.child = predicate_AST->getFirstChild();
		else
			currentAST.child = predicate_AST;
		currentAST.advanceChildToEnd();
	}
	returnAST = predicate_AST;
}

void XPathParser::nameTest(
	QueryContext &context,ParserContext &pc
) {
	returnAST = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)ASTPair currentAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST nameTest_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)RefToken  a1 = ANTLR_USE_NAMESPACE(antlr)nullToken;
	ANTLR_USE_NAMESPACE(antlr)RefAST a1_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST a5_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
	
	switch ( LA(1)) {
	case STAR:
	{
		ANTLR_USE_NAMESPACE(antlr)RefAST tmp30_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
		if ( inputState->guessing == 0 ) {
			tmp30_AST = astFactory->create(LT(1));
			astFactory->addASTChild(currentAST, tmp30_AST);
		}
		match(STAR);
		if ( inputState->guessing==0 ) {
#line 652 "XPathParser.g"
			
				// JCM ???
			
#line 1363 "XPathParser.cpp"
		}
		nameTest_AST = currentAST.root;
		break;
	}
	case DIV:
	{
		ANTLR_USE_NAMESPACE(antlr)RefAST tmp31_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
		if ( inputState->guessing == 0 ) {
			tmp31_AST = astFactory->create(LT(1));
			astFactory->addASTChild(currentAST, tmp31_AST);
		}
		match(DIV);
		if ( inputState->guessing==0 ) {
			nameTest_AST = ANTLR_USE_NAMESPACE(antlr)RefAST(currentAST.root);
#line 668 "XPathParser.g"
			
				nameTest_AST=ANTLR_USE_NAMESPACE(antlr)RefAST(astFactory->make((new ANTLR_USE_NAMESPACE(antlr)ASTArray(1))->add(astFactory->create(NCNAME,"div"))));
			
#line 1382 "XPathParser.cpp"
			currentAST.root = nameTest_AST;
			if ( nameTest_AST!=ANTLR_USE_NAMESPACE(antlr)nullAST &&
				nameTest_AST->getFirstChild() != ANTLR_USE_NAMESPACE(antlr)nullAST )
				  currentAST.child = nameTest_AST->getFirstChild();
			else
				currentAST.child = nameTest_AST;
			currentAST.advanceChildToEnd();
		}
		nameTest_AST = currentAST.root;
		break;
	}
	case MOD:
	{
		ANTLR_USE_NAMESPACE(antlr)RefAST tmp32_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
		if ( inputState->guessing == 0 ) {
			tmp32_AST = astFactory->create(LT(1));
			astFactory->addASTChild(currentAST, tmp32_AST);
		}
		match(MOD);
		if ( inputState->guessing==0 ) {
			nameTest_AST = ANTLR_USE_NAMESPACE(antlr)RefAST(currentAST.root);
#line 672 "XPathParser.g"
			
				nameTest_AST=ANTLR_USE_NAMESPACE(antlr)RefAST(astFactory->make((new ANTLR_USE_NAMESPACE(antlr)ASTArray(1))->add(astFactory->create(NCNAME,"mod"))));
			
#line 1408 "XPathParser.cpp"
			currentAST.root = nameTest_AST;
			if ( nameTest_AST!=ANTLR_USE_NAMESPACE(antlr)nullAST &&
				nameTest_AST->getFirstChild() != ANTLR_USE_NAMESPACE(antlr)nullAST )
				  currentAST.child = nameTest_AST->getFirstChild();
			else
				currentAST.child = nameTest_AST;
			currentAST.advanceChildToEnd();
		}
		nameTest_AST = currentAST.root;
		break;
	}
	case LITERAL_ancestor:
	case LITERAL_ancestor_or_self:
	case LITERAL_attribute:
	case LITERAL_child:
	case LITERAL_descendant:
	case LITERAL_descendant_or_self:
	case LITERAL_following:
	case LITERAL_following_sibling:
	case LITERAL_namespace:
	case LITERAL_parent:
	case LITERAL_preceding:
	case LITERAL_preceding_sibling:
	case LITERAL_self:
	{
		axisName();
		if (inputState->guessing==0) {
			a5_AST = returnAST;
			astFactory->addASTChild( currentAST, returnAST );
		}
		if ( inputState->guessing==0 ) {
			nameTest_AST = ANTLR_USE_NAMESPACE(antlr)RefAST(currentAST.root);
#line 679 "XPathParser.g"
			
				nameTest_AST=ANTLR_USE_NAMESPACE(antlr)RefAST(astFactory->make((new ANTLR_USE_NAMESPACE(antlr)ASTArray(1))->add(astFactory->create(NCNAME,a5_AST->getText()))));
			
#line 1445 "XPathParser.cpp"
			currentAST.root = nameTest_AST;
			if ( nameTest_AST!=ANTLR_USE_NAMESPACE(antlr)nullAST &&
				nameTest_AST->getFirstChild() != ANTLR_USE_NAMESPACE(antlr)nullAST )
				  currentAST.child = nameTest_AST->getFirstChild();
			else
				currentAST.child = nameTest_AST;
			currentAST.advanceChildToEnd();
		}
		nameTest_AST = currentAST.root;
		break;
	}
	default:
		bool synPredMatched70 = false;
		if (((LA(1) == NCNAME) && (LA(2) == COLON) && (LA(3) == STAR))) {
			int _m70 = mark();
			synPredMatched70 = true;
			inputState->guessing++;
			try {
				{
				match(NCNAME);
				match(COLON);
				match(STAR);
				}
			}
			catch (ANTLR_USE_NAMESPACE(antlr)RecognitionException& pe) {
				synPredMatched70 = false;
			}
			rewind(_m70);
			inputState->guessing--;
		}
		if ( synPredMatched70 ) {
			a1 = LT(1);
			if ( inputState->guessing == 0 ) {
				a1_AST = astFactory->create(a1);
				astFactory->addASTChild(currentAST, a1_AST);
			}
			match(NCNAME);
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp33_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
			if ( inputState->guessing == 0 ) {
				tmp33_AST = astFactory->create(LT(1));
				astFactory->addASTChild(currentAST, tmp33_AST);
			}
			match(COLON);
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp34_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
			if ( inputState->guessing == 0 ) {
				tmp34_AST = astFactory->create(LT(1));
				astFactory->addASTChild(currentAST, tmp34_AST);
			}
			match(STAR);
			if ( inputState->guessing==0 ) {
				nameTest_AST = ANTLR_USE_NAMESPACE(antlr)RefAST(currentAST.root);
#line 656 "XPathParser.g"
				
					// Lookup the URI for the prefix.
					std::string uri(mapPrefixToUri(context, a1_AST->getText()));
					// JCM - Should use the STAR token instead of the token text?
					nameTest_AST->setText(uri+":*");
				
#line 1504 "XPathParser.cpp"
			}
			nameTest_AST = currentAST.root;
		}
		else if ((LA(1) == NCNAME) && (_tokenSet_9.member(LA(2))) && (_tokenSet_4.member(LA(3)))) {
			qName(context,pc);
			if (inputState->guessing==0) {
				astFactory->addASTChild( currentAST, returnAST );
			}
			nameTest_AST = currentAST.root;
		}
	else {
		throw ANTLR_USE_NAMESPACE(antlr)NoViableAltException(LT(1), getFilename());
	}
	}
	returnAST = nameTest_AST;
}

void XPathParser::orExpr(
	QueryContext &context,ParserContext &pc
) {
	returnAST = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)ASTPair currentAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST orExpr_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
	
	andExpr(context,pc);
	if (inputState->guessing==0) {
		astFactory->addASTChild( currentAST, returnAST );
	}
	{ // ( ... )*
	for (;;) {
		if ((LA(1) == OR)) {
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp35_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
			if ( inputState->guessing == 0 ) {
				tmp35_AST = astFactory->create(LT(1));
				astFactory->makeASTRoot(currentAST, tmp35_AST);
			}
			match(OR);
			andExpr(context,pc);
			if (inputState->guessing==0) {
				astFactory->addASTChild( currentAST, returnAST );
			}
		}
		else {
			goto _loop45;
		}
		
	}
	_loop45:;
	} // ( ... )*
	orExpr_AST = currentAST.root;
	returnAST = orExpr_AST;
}

void XPathParser::primaryExpr(
	QueryContext &context,ParserContext &pc
) {
	returnAST = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)ASTPair currentAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST primaryExpr_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
	
	switch ( LA(1)) {
	case DOLLAR:
	{
		variableReference(context,pc);
		if (inputState->guessing==0) {
			astFactory->addASTChild( currentAST, returnAST );
		}
		primaryExpr_AST = currentAST.root;
		break;
	}
	case LB:
	{
		match(LB);
		expr(context,pc);
		if (inputState->guessing==0) {
			astFactory->addASTChild( currentAST, returnAST );
		}
		match(RB);
		primaryExpr_AST = currentAST.root;
		break;
	}
	case LITERAL:
	{
		literal();
		if (inputState->guessing==0) {
			astFactory->addASTChild( currentAST, returnAST );
		}
		primaryExpr_AST = currentAST.root;
		break;
	}
	case NUMBER:
	{
		number();
		if (inputState->guessing==0) {
			astFactory->addASTChild( currentAST, returnAST );
		}
		primaryExpr_AST = currentAST.root;
		break;
	}
	case NCNAME:
	{
		functionCall(context,pc);
		if (inputState->guessing==0) {
			astFactory->addASTChild( currentAST, returnAST );
		}
		primaryExpr_AST = currentAST.root;
		break;
	}
	default:
	{
		throw ANTLR_USE_NAMESPACE(antlr)NoViableAltException(LT(1), getFilename());
	}
	}
	returnAST = primaryExpr_AST;
}

void XPathParser::variableReference(
	QueryContext &context,ParserContext &pc
) {
	returnAST = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)ASTPair currentAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST variableReference_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST a1_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
	
	ANTLR_USE_NAMESPACE(antlr)RefAST tmp38_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
	if ( inputState->guessing == 0 ) {
		tmp38_AST = astFactory->create(LT(1));
	}
	match(DOLLAR);
	qName(context,pc);
	if (inputState->guessing==0) {
		a1_AST = returnAST;
	}
	if ( inputState->guessing==0 ) {
		variableReference_AST = ANTLR_USE_NAMESPACE(antlr)RefAST(currentAST.root);
#line 644 "XPathParser.g"
		
			variableReference_AST=ANTLR_USE_NAMESPACE(antlr)RefAST(astFactory->make((new ANTLR_USE_NAMESPACE(antlr)ASTArray(1))->add(astFactory->create(VARIABLE,a1_AST->getText()))));
		
#line 1644 "XPathParser.cpp"
		currentAST.root = variableReference_AST;
		if ( variableReference_AST!=ANTLR_USE_NAMESPACE(antlr)nullAST &&
			variableReference_AST->getFirstChild() != ANTLR_USE_NAMESPACE(antlr)nullAST )
			  currentAST.child = variableReference_AST->getFirstChild();
		else
			currentAST.child = variableReference_AST;
		currentAST.advanceChildToEnd();
	}
	returnAST = variableReference_AST;
}

void XPathParser::literal() {
	returnAST = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)ASTPair currentAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST literal_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
	
	ANTLR_USE_NAMESPACE(antlr)RefAST tmp39_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
	if ( inputState->guessing == 0 ) {
		tmp39_AST = astFactory->create(LT(1));
		astFactory->makeASTRoot(currentAST, tmp39_AST);
	}
	match(LITERAL);
	literal_AST = currentAST.root;
	returnAST = literal_AST;
}

void XPathParser::number() {
	returnAST = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)ASTPair currentAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST number_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
	
	ANTLR_USE_NAMESPACE(antlr)RefAST tmp40_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
	if ( inputState->guessing == 0 ) {
		tmp40_AST = astFactory->create(LT(1));
		astFactory->makeASTRoot(currentAST, tmp40_AST);
	}
	match(NUMBER);
	number_AST = currentAST.root;
	returnAST = number_AST;
}

void XPathParser::functionCall(
	QueryContext &context,ParserContext &pc
) {
	returnAST = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)ASTPair currentAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST functionCall_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST a1_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST b1_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST c1_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
	
	functionName(context,pc);
	if (inputState->guessing==0) {
		a1_AST = returnAST;
	}
	if ( inputState->guessing==0 ) {
		functionCall_AST = ANTLR_USE_NAMESPACE(antlr)RefAST(currentAST.root);
#line 534 "XPathParser.g"
		
			if(context.isFunction(a1_AST->getText()))
			{
			    functionCall_AST=ANTLR_USE_NAMESPACE(antlr)RefAST(astFactory->make((new ANTLR_USE_NAMESPACE(antlr)ASTArray(1))->add(astFactory->create(FUNCTION,a1_AST->getText()))));
			}
			else
			{
				throw XmlException(XmlException::XPATH_PARSER_ERROR,"The XPath function '"+a1_AST->getText()+"' is not known.");
			}
		
#line 1713 "XPathParser.cpp"
		currentAST.root = functionCall_AST;
		if ( functionCall_AST!=ANTLR_USE_NAMESPACE(antlr)nullAST &&
			functionCall_AST->getFirstChild() != ANTLR_USE_NAMESPACE(antlr)nullAST )
			  currentAST.child = functionCall_AST->getFirstChild();
		else
			currentAST.child = functionCall_AST;
		currentAST.advanceChildToEnd();
	}
	ANTLR_USE_NAMESPACE(antlr)RefAST tmp41_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
	if ( inputState->guessing == 0 ) {
		tmp41_AST = astFactory->create(LT(1));
	}
	match(LB);
	{
	switch ( LA(1)) {
	case DIV:
	case MOD:
	case LITERAL_ancestor:
	case LITERAL_ancestor_or_self:
	case LITERAL_attribute:
	case LITERAL_child:
	case LITERAL_descendant:
	case LITERAL_descendant_or_self:
	case LITERAL_following:
	case LITERAL_following_sibling:
	case LITERAL_namespace:
	case LITERAL_parent:
	case LITERAL_preceding:
	case LITERAL_preceding_sibling:
	case LITERAL_self:
	case NCNAME:
	case LITERAL:
	case NUMBER:
	case STAR:
	case SLASH:
	case SLASHSLASH:
	case LB:
	case AT:
	case DOT:
	case DOTDOT:
	case MINUS:
	case DOLLAR:
	{
		argument(context,pc);
		if (inputState->guessing==0) {
			b1_AST = returnAST;
		}
		if ( inputState->guessing==0 ) {
			functionCall_AST = ANTLR_USE_NAMESPACE(antlr)RefAST(currentAST.root);
#line 545 "XPathParser.g"
			functionCall_AST->addChild(b1_AST);
#line 1765 "XPathParser.cpp"
		}
		{ // ( ... )*
		for (;;) {
			if ((LA(1) == COMMA)) {
				ANTLR_USE_NAMESPACE(antlr)RefAST tmp42_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
				if ( inputState->guessing == 0 ) {
					tmp42_AST = astFactory->create(LT(1));
				}
				match(COMMA);
				argument(context,pc);
				if (inputState->guessing==0) {
					c1_AST = returnAST;
				}
				if ( inputState->guessing==0 ) {
					functionCall_AST = ANTLR_USE_NAMESPACE(antlr)RefAST(currentAST.root);
#line 547 "XPathParser.g"
					functionCall_AST->addChild(c1_AST);
#line 1783 "XPathParser.cpp"
				}
			}
			else {
				goto _loop26;
			}
			
		}
		_loop26:;
		} // ( ... )*
		break;
	}
	case RB:
	{
		break;
	}
	default:
	{
		throw ANTLR_USE_NAMESPACE(antlr)NoViableAltException(LT(1), getFilename());
	}
	}
	}
	ANTLR_USE_NAMESPACE(antlr)RefAST tmp43_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
	if ( inputState->guessing == 0 ) {
		tmp43_AST = astFactory->create(LT(1));
	}
	match(RB);
	returnAST = functionCall_AST;
}

void XPathParser::functionName(
	QueryContext &context,ParserContext &pc
) {
	returnAST = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)ASTPair currentAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST functionName_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
	
	qName(context,pc);
	if (inputState->guessing==0) {
		astFactory->addASTChild( currentAST, returnAST );
	}
	functionName_AST = currentAST.root;
	returnAST = functionName_AST;
}

void XPathParser::argument(
	QueryContext &context,ParserContext &pc
) {
	returnAST = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)ASTPair currentAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST argument_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
	
	expr(context,pc);
	if (inputState->guessing==0) {
		astFactory->addASTChild( currentAST, returnAST );
	}
	argument_AST = currentAST.root;
	returnAST = argument_AST;
}

void XPathParser::unionExpr(
	QueryContext &context,ParserContext &pc
) {
	returnAST = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)ASTPair currentAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST unionExpr_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
	
	pathExpr(context,pc);
	if (inputState->guessing==0) {
		astFactory->addASTChild( currentAST, returnAST );
	}
	{ // ( ... )*
	for (;;) {
		if ((LA(1) == UNION)) {
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp44_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
			if ( inputState->guessing == 0 ) {
				tmp44_AST = astFactory->create(LT(1));
				astFactory->makeASTRoot(currentAST, tmp44_AST);
			}
			match(UNION);
			pathExpr(context,pc);
			if (inputState->guessing==0) {
				astFactory->addASTChild( currentAST, returnAST );
			}
		}
		else {
			goto _loop30;
		}
		
	}
	_loop30:;
	} // ( ... )*
	unionExpr_AST = currentAST.root;
	returnAST = unionExpr_AST;
}

void XPathParser::pathExpr(
	QueryContext &context,ParserContext &pc
) {
	returnAST = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)ASTPair currentAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST pathExpr_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
#line 564 "XPathParser.g"
	
		size_t stack_posn= pc.size();
	
#line 1889 "XPathParser.cpp"
	
	bool synPredMatched33 = false;
	if ((((_tokenSet_10.member(LA(1))) && (_tokenSet_11.member(LA(2))) && (_tokenSet_5.member(LA(3))))&&(
    LT(1)->getText().compare("text")==0 || 
    LT(1)->getText().compare("comment")==0 || 
    LT(1)->getText().compare("node")==0 || 
    LT(1)->getText().compare("processing-instruction")==0
  ))) {
		int _m33 = mark();
		synPredMatched33 = true;
		inputState->guessing++;
		try {
			{
			match(NCNAME);
			match(LB);
			}
		}
		catch (ANTLR_USE_NAMESPACE(antlr)RecognitionException& pe) {
			synPredMatched33 = false;
		}
		rewind(_m33);
		inputState->guessing--;
	}
	if ( synPredMatched33 ) {
		locationPath(context,pc);
		if (inputState->guessing==0) {
			astFactory->addASTChild( currentAST, returnAST );
		}
		if ( inputState->guessing==0 ) {
#line 575 "XPathParser.g"
			pc.pop_step(pc.size()-stack_posn);
#line 1921 "XPathParser.cpp"
		}
		pathExpr_AST = currentAST.root;
	}
	else {
		bool synPredMatched35 = false;
		if (((_tokenSet_12.member(LA(1))) && (_tokenSet_2.member(LA(2))) && (_tokenSet_5.member(LA(3))))) {
			int _m35 = mark();
			synPredMatched35 = true;
			inputState->guessing++;
			try {
				{
				switch ( LA(1)) {
				case DOLLAR:
				{
					match(DOLLAR);
					break;
				}
				case LB:
				{
					match(LB);
					break;
				}
				case LITERAL:
				{
					match(LITERAL);
					break;
				}
				case NUMBER:
				{
					match(NUMBER);
					break;
				}
				case NCNAME:
				{
					match(NCNAME);
					match(LB);
					break;
				}
				default:
				{
					throw ANTLR_USE_NAMESPACE(antlr)NoViableAltException(LT(1), getFilename());
				}
				}
				}
			}
			catch (ANTLR_USE_NAMESPACE(antlr)RecognitionException& pe) {
				synPredMatched35 = false;
			}
			rewind(_m35);
			inputState->guessing--;
		}
		if ( synPredMatched35 ) {
			filterExpr(context,pc);
			if (inputState->guessing==0) {
				astFactory->addASTChild( currentAST, returnAST );
			}
			if ( inputState->guessing==0 ) {
#line 577 "XPathParser.g"
				pc.pop_step(pc.size()-stack_posn);
#line 1981 "XPathParser.cpp"
			}
			pathExpr_AST = currentAST.root;
		}
		else {
			bool synPredMatched37 = false;
			if (((_tokenSet_10.member(LA(1))) && (_tokenSet_11.member(LA(2))) && (_tokenSet_5.member(LA(3))))) {
				int _m37 = mark();
				synPredMatched37 = true;
				inputState->guessing++;
				try {
					{
					switch ( LA(1)) {
					case DOT:
					{
						match(DOT);
						break;
					}
					case DOTDOT:
					{
						match(DOTDOT);
						break;
					}
					case SLASH:
					{
						match(SLASH);
						break;
					}
					case NCNAME:
					{
						match(NCNAME);
						break;
					}
					case LITERAL_ancestor:
					case LITERAL_ancestor_or_self:
					case LITERAL_attribute:
					case LITERAL_child:
					case LITERAL_descendant:
					case LITERAL_descendant_or_self:
					case LITERAL_following:
					case LITERAL_following_sibling:
					case LITERAL_namespace:
					case LITERAL_parent:
					case LITERAL_preceding:
					case LITERAL_preceding_sibling:
					case LITERAL_self:
					{
						axisName();
						break;
					}
					case SLASHSLASH:
					{
						match(SLASHSLASH);
						break;
					}
					case AT:
					{
						match(AT);
						break;
					}
					case STAR:
					{
						match(STAR);
						break;
					}
					default:
					{
						throw ANTLR_USE_NAMESPACE(antlr)NoViableAltException(LT(1), getFilename());
					}
					}
					}
				}
				catch (ANTLR_USE_NAMESPACE(antlr)RecognitionException& pe) {
					synPredMatched37 = false;
				}
				rewind(_m37);
				inputState->guessing--;
			}
			if ( synPredMatched37 ) {
				locationPath(context,pc);
				if (inputState->guessing==0) {
					astFactory->addASTChild( currentAST, returnAST );
				}
				if ( inputState->guessing==0 ) {
#line 579 "XPathParser.g"
					pc.pop_step(pc.size()-stack_posn);
#line 2067 "XPathParser.cpp"
				}
				pathExpr_AST = currentAST.root;
			}
			else if ((_tokenSet_12.member(LA(1))) && (_tokenSet_13.member(LA(2))) && (_tokenSet_14.member(LA(3)))) {
				filterExpr(context,pc);
				if (inputState->guessing==0) {
					astFactory->addASTChild( currentAST, returnAST );
				}
				{
				{
				switch ( LA(1)) {
				case SLASH:
				{
					ANTLR_USE_NAMESPACE(antlr)RefAST tmp45_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
					if ( inputState->guessing == 0 ) {
						tmp45_AST = astFactory->create(LT(1));
						astFactory->addASTChild(currentAST, tmp45_AST);
					}
					match(SLASH);
					break;
				}
				case SLASHSLASH:
				{
					ANTLR_USE_NAMESPACE(antlr)RefAST tmp46_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
					if ( inputState->guessing == 0 ) {
						tmp46_AST = astFactory->create(LT(1));
						astFactory->addASTChild(currentAST, tmp46_AST);
					}
					match(SLASHSLASH);
					break;
				}
				default:
				{
					throw ANTLR_USE_NAMESPACE(antlr)NoViableAltException(LT(1), getFilename());
				}
				}
				}
				relativeLocationPath(context,pc);
				if (inputState->guessing==0) {
					astFactory->addASTChild( currentAST, returnAST );
				}
				}
				if ( inputState->guessing==0 ) {
#line 581 "XPathParser.g"
					pc.pop_step(pc.size()-stack_posn);
#line 2113 "XPathParser.cpp"
				}
				pathExpr_AST = currentAST.root;
			}
	else {
		throw ANTLR_USE_NAMESPACE(antlr)NoViableAltException(LT(1), getFilename());
	}
	}}
	returnAST = pathExpr_AST;
}

void XPathParser::filterExpr(
	QueryContext &context,ParserContext &pc
) {
	returnAST = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)ASTPair currentAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST filterExpr_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
	
	primaryExpr(context,pc);
	if (inputState->guessing==0) {
		astFactory->addASTChild( currentAST, returnAST );
	}
	{ // ( ... )*
	for (;;) {
		if ((LA(1) == LSB)) {
			predicate(context,pc);
			if (inputState->guessing==0) {
				astFactory->addASTChild( currentAST, returnAST );
			}
		}
		else {
			goto _loop42;
		}
		
	}
	_loop42:;
	} // ( ... )*
	filterExpr_AST = currentAST.root;
	returnAST = filterExpr_AST;
}

void XPathParser::andExpr(
	QueryContext &context,ParserContext &pc
) {
	returnAST = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)ASTPair currentAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST andExpr_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
	
	equalityExpr(context,pc);
	if (inputState->guessing==0) {
		astFactory->addASTChild( currentAST, returnAST );
	}
	{ // ( ... )*
	for (;;) {
		if ((LA(1) == AND)) {
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp47_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
			if ( inputState->guessing == 0 ) {
				tmp47_AST = astFactory->create(LT(1));
				astFactory->makeASTRoot(currentAST, tmp47_AST);
			}
			match(AND);
			equalityExpr(context,pc);
			if (inputState->guessing==0) {
				astFactory->addASTChild( currentAST, returnAST );
			}
		}
		else {
			goto _loop48;
		}
		
	}
	_loop48:;
	} // ( ... )*
	andExpr_AST = currentAST.root;
	returnAST = andExpr_AST;
}

void XPathParser::equalityExpr(
	QueryContext &context,ParserContext &pc
) {
	returnAST = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)ASTPair currentAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST equalityExpr_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
	
	relationalExpr(context,pc);
	if (inputState->guessing==0) {
		astFactory->addASTChild( currentAST, returnAST );
	}
	{ // ( ... )*
	for (;;) {
		if ((LA(1) == EQUAL || LA(1) == NOTEQUAL)) {
			{
			switch ( LA(1)) {
			case EQUAL:
			{
				ANTLR_USE_NAMESPACE(antlr)RefAST tmp48_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
				if ( inputState->guessing == 0 ) {
					tmp48_AST = astFactory->create(LT(1));
					astFactory->makeASTRoot(currentAST, tmp48_AST);
				}
				match(EQUAL);
				break;
			}
			case NOTEQUAL:
			{
				ANTLR_USE_NAMESPACE(antlr)RefAST tmp49_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
				if ( inputState->guessing == 0 ) {
					tmp49_AST = astFactory->create(LT(1));
					astFactory->makeASTRoot(currentAST, tmp49_AST);
				}
				match(NOTEQUAL);
				break;
			}
			default:
			{
				throw ANTLR_USE_NAMESPACE(antlr)NoViableAltException(LT(1), getFilename());
			}
			}
			}
			relationalExpr(context,pc);
			if (inputState->guessing==0) {
				astFactory->addASTChild( currentAST, returnAST );
			}
		}
		else {
			goto _loop52;
		}
		
	}
	_loop52:;
	} // ( ... )*
	equalityExpr_AST = currentAST.root;
	returnAST = equalityExpr_AST;
}

void XPathParser::relationalExpr(
	QueryContext &context,ParserContext &pc
) {
	returnAST = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)ASTPair currentAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST relationalExpr_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
	
	additiveExpr(context,pc);
	if (inputState->guessing==0) {
		astFactory->addASTChild( currentAST, returnAST );
	}
	{ // ( ... )*
	for (;;) {
		if (((LA(1) >= GTX && LA(1) <= LTE))) {
			{
			switch ( LA(1)) {
			case LTX:
			{
				ANTLR_USE_NAMESPACE(antlr)RefAST tmp50_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
				if ( inputState->guessing == 0 ) {
					tmp50_AST = astFactory->create(LT(1));
					astFactory->makeASTRoot(currentAST, tmp50_AST);
				}
				match(LTX);
				break;
			}
			case GTX:
			{
				ANTLR_USE_NAMESPACE(antlr)RefAST tmp51_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
				if ( inputState->guessing == 0 ) {
					tmp51_AST = astFactory->create(LT(1));
					astFactory->makeASTRoot(currentAST, tmp51_AST);
				}
				match(GTX);
				break;
			}
			case LTE:
			{
				ANTLR_USE_NAMESPACE(antlr)RefAST tmp52_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
				if ( inputState->guessing == 0 ) {
					tmp52_AST = astFactory->create(LT(1));
					astFactory->makeASTRoot(currentAST, tmp52_AST);
				}
				match(LTE);
				break;
			}
			case GTE:
			{
				ANTLR_USE_NAMESPACE(antlr)RefAST tmp53_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
				if ( inputState->guessing == 0 ) {
					tmp53_AST = astFactory->create(LT(1));
					astFactory->makeASTRoot(currentAST, tmp53_AST);
				}
				match(GTE);
				break;
			}
			default:
			{
				throw ANTLR_USE_NAMESPACE(antlr)NoViableAltException(LT(1), getFilename());
			}
			}
			}
			additiveExpr(context,pc);
			if (inputState->guessing==0) {
				astFactory->addASTChild( currentAST, returnAST );
			}
		}
		else {
			goto _loop56;
		}
		
	}
	_loop56:;
	} // ( ... )*
	relationalExpr_AST = currentAST.root;
	returnAST = relationalExpr_AST;
}

void XPathParser::additiveExpr(
	QueryContext &context,ParserContext &pc
) {
	returnAST = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)ASTPair currentAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST additiveExpr_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
	
	multiplicativeExpr(context,pc);
	if (inputState->guessing==0) {
		astFactory->addASTChild( currentAST, returnAST );
	}
	{ // ( ... )*
	for (;;) {
		if ((LA(1) == MINUS || LA(1) == PLUS)) {
			{
			switch ( LA(1)) {
			case PLUS:
			{
				ANTLR_USE_NAMESPACE(antlr)RefAST tmp54_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
				if ( inputState->guessing == 0 ) {
					tmp54_AST = astFactory->create(LT(1));
					astFactory->makeASTRoot(currentAST, tmp54_AST);
				}
				match(PLUS);
				break;
			}
			case MINUS:
			{
				ANTLR_USE_NAMESPACE(antlr)RefAST tmp55_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
				if ( inputState->guessing == 0 ) {
					tmp55_AST = astFactory->create(LT(1));
					astFactory->makeASTRoot(currentAST, tmp55_AST);
				}
				match(MINUS);
				break;
			}
			default:
			{
				throw ANTLR_USE_NAMESPACE(antlr)NoViableAltException(LT(1), getFilename());
			}
			}
			}
			multiplicativeExpr(context,pc);
			if (inputState->guessing==0) {
				astFactory->addASTChild( currentAST, returnAST );
			}
		}
		else {
			goto _loop60;
		}
		
	}
	_loop60:;
	} // ( ... )*
	additiveExpr_AST = currentAST.root;
	returnAST = additiveExpr_AST;
}

void XPathParser::multiplicativeExpr(
	QueryContext &context,ParserContext &pc
) {
	returnAST = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)ASTPair currentAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST multiplicativeExpr_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
	
	unaryExpr(context,pc);
	if (inputState->guessing==0) {
		astFactory->addASTChild( currentAST, returnAST );
	}
	{ // ( ... )*
	for (;;) {
		if ((LA(1) == DIV || LA(1) == MOD || LA(1) == STAR)) {
			{
			switch ( LA(1)) {
			case STAR:
			{
				ANTLR_USE_NAMESPACE(antlr)RefAST tmp56_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
				if ( inputState->guessing == 0 ) {
					tmp56_AST = astFactory->create(LT(1));
					astFactory->makeASTRoot(currentAST, tmp56_AST);
				}
				match(STAR);
				break;
			}
			case DIV:
			{
				ANTLR_USE_NAMESPACE(antlr)RefAST tmp57_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
				if ( inputState->guessing == 0 ) {
					tmp57_AST = astFactory->create(LT(1));
					astFactory->makeASTRoot(currentAST, tmp57_AST);
				}
				match(DIV);
				break;
			}
			case MOD:
			{
				ANTLR_USE_NAMESPACE(antlr)RefAST tmp58_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
				if ( inputState->guessing == 0 ) {
					tmp58_AST = astFactory->create(LT(1));
					astFactory->makeASTRoot(currentAST, tmp58_AST);
				}
				match(MOD);
				break;
			}
			default:
			{
				throw ANTLR_USE_NAMESPACE(antlr)NoViableAltException(LT(1), getFilename());
			}
			}
			}
			unaryExpr(context,pc);
			if (inputState->guessing==0) {
				astFactory->addASTChild( currentAST, returnAST );
			}
		}
		else {
			goto _loop64;
		}
		
	}
	_loop64:;
	} // ( ... )*
	multiplicativeExpr_AST = currentAST.root;
	returnAST = multiplicativeExpr_AST;
}

void XPathParser::unaryExpr(
	QueryContext &context,ParserContext &pc
) {
	returnAST = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)ASTPair currentAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST unaryExpr_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
	
	switch ( LA(1)) {
	case DIV:
	case MOD:
	case LITERAL_ancestor:
	case LITERAL_ancestor_or_self:
	case LITERAL_attribute:
	case LITERAL_child:
	case LITERAL_descendant:
	case LITERAL_descendant_or_self:
	case LITERAL_following:
	case LITERAL_following_sibling:
	case LITERAL_namespace:
	case LITERAL_parent:
	case LITERAL_preceding:
	case LITERAL_preceding_sibling:
	case LITERAL_self:
	case NCNAME:
	case LITERAL:
	case NUMBER:
	case STAR:
	case SLASH:
	case SLASHSLASH:
	case LB:
	case AT:
	case DOT:
	case DOTDOT:
	case DOLLAR:
	{
		unionExpr(context,pc);
		if (inputState->guessing==0) {
			astFactory->addASTChild( currentAST, returnAST );
		}
		unaryExpr_AST = currentAST.root;
		break;
	}
	case MINUS:
	{
		ANTLR_USE_NAMESPACE(antlr)RefAST tmp59_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
		if ( inputState->guessing == 0 ) {
			tmp59_AST = astFactory->create(LT(1));
			astFactory->makeASTRoot(currentAST, tmp59_AST);
		}
		match(MINUS);
		unaryExpr(context,pc);
		if (inputState->guessing==0) {
			astFactory->addASTChild( currentAST, returnAST );
		}
		unaryExpr_AST = currentAST.root;
		break;
	}
	default:
	{
		throw ANTLR_USE_NAMESPACE(antlr)NoViableAltException(LT(1), getFilename());
	}
	}
	returnAST = unaryExpr_AST;
}

void XPathParser::qName(
	QueryContext &context,ParserContext &pc
) {
	returnAST = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)ASTPair currentAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST qName_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)RefToken  b1 = ANTLR_USE_NAMESPACE(antlr)nullToken;
	ANTLR_USE_NAMESPACE(antlr)RefAST b1_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)RefToken  a2 = ANTLR_USE_NAMESPACE(antlr)nullToken;
	ANTLR_USE_NAMESPACE(antlr)RefAST a2_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)RefToken  b2 = ANTLR_USE_NAMESPACE(antlr)nullToken;
	ANTLR_USE_NAMESPACE(antlr)RefAST b2_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)RefToken  a3 = ANTLR_USE_NAMESPACE(antlr)nullToken;
	ANTLR_USE_NAMESPACE(antlr)RefAST a3_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)RefToken  a4 = ANTLR_USE_NAMESPACE(antlr)nullToken;
	ANTLR_USE_NAMESPACE(antlr)RefAST a4_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
	
	if ((LA(1) == NCNAME) && (_tokenSet_15.member(LA(2)))) {
		b1 = LT(1);
		if ( inputState->guessing == 0 ) {
			b1_AST = astFactory->create(b1);
			astFactory->addASTChild(currentAST, b1_AST);
		}
		match(NCNAME);
		if ( inputState->guessing==0 ) {
			qName_AST = ANTLR_USE_NAMESPACE(antlr)RefAST(currentAST.root);
#line 689 "XPathParser.g"
			
				UNUSED(pc);
				qName_AST=b1_AST;
			
#line 2548 "XPathParser.cpp"
			currentAST.root = qName_AST;
			if ( qName_AST!=ANTLR_USE_NAMESPACE(antlr)nullAST &&
				qName_AST->getFirstChild() != ANTLR_USE_NAMESPACE(antlr)nullAST )
				  currentAST.child = qName_AST->getFirstChild();
			else
				currentAST.child = qName_AST;
			currentAST.advanceChildToEnd();
		}
		qName_AST = currentAST.root;
	}
	else if ((LA(1) == NCNAME) && (LA(2) == COLON) && (LA(3) == NCNAME)) {
		a2 = LT(1);
		if ( inputState->guessing == 0 ) {
			a2_AST = astFactory->create(a2);
			astFactory->addASTChild(currentAST, a2_AST);
		}
		match(NCNAME);
		ANTLR_USE_NAMESPACE(antlr)RefAST tmp60_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
		if ( inputState->guessing == 0 ) {
			tmp60_AST = astFactory->create(LT(1));
			astFactory->addASTChild(currentAST, tmp60_AST);
		}
		match(COLON);
		b2 = LT(1);
		if ( inputState->guessing == 0 ) {
			b2_AST = astFactory->create(b2);
			astFactory->addASTChild(currentAST, b2_AST);
		}
		match(NCNAME);
		if ( inputState->guessing==0 ) {
			qName_AST = ANTLR_USE_NAMESPACE(antlr)RefAST(currentAST.root);
#line 694 "XPathParser.g"
			
				// Lookup the URI for the prefix.
				std::string uri(mapPrefixToUri(context, a2_AST->getText()));
				qName_AST->setText(uri+":"+b2_AST->getText());
			
#line 2586 "XPathParser.cpp"
		}
		qName_AST = currentAST.root;
	}
	else if ((LA(1) == NCNAME) && (LA(2) == COLON) && (LA(3) == DIV)) {
		a3 = LT(1);
		if ( inputState->guessing == 0 ) {
			a3_AST = astFactory->create(a3);
			astFactory->addASTChild(currentAST, a3_AST);
		}
		match(NCNAME);
		ANTLR_USE_NAMESPACE(antlr)RefAST tmp61_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
		if ( inputState->guessing == 0 ) {
			tmp61_AST = astFactory->create(LT(1));
			astFactory->addASTChild(currentAST, tmp61_AST);
		}
		match(COLON);
		ANTLR_USE_NAMESPACE(antlr)RefAST tmp62_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
		if ( inputState->guessing == 0 ) {
			tmp62_AST = astFactory->create(LT(1));
			astFactory->addASTChild(currentAST, tmp62_AST);
		}
		match(DIV);
		if ( inputState->guessing==0 ) {
			qName_AST = ANTLR_USE_NAMESPACE(antlr)RefAST(currentAST.root);
#line 700 "XPathParser.g"
			
			// Lookup the URI for the prefix.
				std::string uri(mapPrefixToUri(context, a3_AST->getText()));
				qName_AST->setText(uri+":div");
			
#line 2617 "XPathParser.cpp"
		}
		qName_AST = currentAST.root;
	}
	else if ((LA(1) == NCNAME) && (LA(2) == COLON) && (LA(3) == MOD)) {
		a4 = LT(1);
		if ( inputState->guessing == 0 ) {
			a4_AST = astFactory->create(a4);
			astFactory->addASTChild(currentAST, a4_AST);
		}
		match(NCNAME);
		ANTLR_USE_NAMESPACE(antlr)RefAST tmp63_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
		if ( inputState->guessing == 0 ) {
			tmp63_AST = astFactory->create(LT(1));
			astFactory->addASTChild(currentAST, tmp63_AST);
		}
		match(COLON);
		ANTLR_USE_NAMESPACE(antlr)RefAST tmp64_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
		if ( inputState->guessing == 0 ) {
			tmp64_AST = astFactory->create(LT(1));
			astFactory->addASTChild(currentAST, tmp64_AST);
		}
		match(MOD);
		if ( inputState->guessing==0 ) {
			qName_AST = ANTLR_USE_NAMESPACE(antlr)RefAST(currentAST.root);
#line 706 "XPathParser.g"
			
			// Lookup the URI for the prefix.
				std::string uri(mapPrefixToUri(context, a4_AST->getText()));
				qName_AST->setText(uri+":mod");
			
#line 2648 "XPathParser.cpp"
		}
		qName_AST = currentAST.root;
	}
	else {
		throw ANTLR_USE_NAMESPACE(antlr)NoViableAltException(LT(1), getFilename());
	}
	
	returnAST = qName_AST;
}

void XPathParser::initializeASTFactory( ANTLR_USE_NAMESPACE(antlr)ASTFactory& factory )
{
	factory.setMaxNodeType(66);
}
const char* XPathParser::tokenNames[] = {
	"<0>",
	"EOF",
	"<2>",
	"NULL_TREE_LOOKAHEAD",
	"\"and\"",
	"\"or\"",
	"\"div\"",
	"\"mod\"",
	"\"ancestor\"",
	"\"ancestor-or-self\"",
	"\"attribute\"",
	"\"child\"",
	"\"descendant\"",
	"\"descendant-or-self\"",
	"\"following\"",
	"\"following-sibling\"",
	"\"namespace\"",
	"\"parent\"",
	"\"preceding\"",
	"\"preceding-sibling\"",
	"\"self\"",
	"whitespace",
	"a comment",
	"an identifier",
	"NCNAMECHAR",
	"a string literal",
	"LETTER",
	"a numeric literal",
	"a number",
	"STAR",
	"SLASH",
	"SLASHSLASH",
	"COLON",
	"COLONCOLON",
	"a left bracket '('",
	"a right bracket ')'",
	"a left square bracket '['",
	"a right square bracket ']'",
	"AT",
	"SEMICOLON",
	"a current node selector '.'",
	"a parent node selector '..'",
	"an equals operator '='",
	"a not equals operator '!='",
	"a subtraction or unary minus operator '-'",
	"an addition operator '+'",
	"a greater than operator '>'",
	"a greater than or equals operator '>='",
	"a less than operator '<'",
	"a less than or equals operator '<='",
	"an argument separator ','",
	"a union operator '|'",
	"a variable dereference operator '$'",
	"XPATH",
	"DISCOVER",
	"CHAIN",
	"ROOT",
	"AXIS",
	"OPERATION",
	"NAME",
	"FUNCTION",
	"VARIABLE",
	"TEXT",
	"NODE",
	"COMMENT",
	"PROCESSING_INSTRUCTION",
	"PREDICATE",
	0
};

const unsigned long XPathParser::_tokenSet_0_data_[] = { 547356608UL, 832UL, 0UL, 0UL };
// "div" "mod" "ancestor" "ancestor-or-self" "attribute" "child" "descendant" 
// "descendant-or-self" "following" "following-sibling" "namespace" "parent" 
// "preceding" "preceding-sibling" "self" NCNAME STAR AT DOT DOTDOT 
const ANTLR_USE_NAMESPACE(antlr)BitSet XPathParser::_tokenSet_0(_tokenSet_0_data_,4);
const unsigned long XPathParser::_tokenSet_1_data_[] = { 3768582130UL, 1047615UL, 0UL, 0UL };
// EOF "and" "or" "div" "mod" "ancestor" "ancestor-or-self" "attribute" 
// "child" "descendant" "descendant-or-self" "following" "following-sibling" 
// "namespace" "parent" "preceding" "preceding-sibling" "self" NCNAME STAR 
// SLASH SLASHSLASH COLON COLONCOLON LB RB LSB RSB EQUAL NOTEQUAL MINUS 
// PLUS GTX GTE LTX LTE COMMA UNION 
const ANTLR_USE_NAMESPACE(antlr)BitSet XPathParser::_tokenSet_1(_tokenSet_1_data_,4);
const unsigned long XPathParser::_tokenSet_2_data_[] = { 4070572018UL, 2097021UL, 0UL, 0UL };
// EOF "and" "or" "div" "mod" "ancestor" "ancestor-or-self" "attribute" 
// "child" "descendant" "descendant-or-self" "following" "following-sibling" 
// "namespace" "parent" "preceding" "preceding-sibling" "self" NCNAME LITERAL 
// NUMBER STAR SLASH SLASHSLASH COLON LB RB LSB RSB AT DOT DOTDOT EQUAL 
// NOTEQUAL MINUS PLUS GTX GTE LTX LTE COMMA UNION DOLLAR 
const ANTLR_USE_NAMESPACE(antlr)BitSet XPathParser::_tokenSet_2(_tokenSet_2_data_,4);
const unsigned long XPathParser::_tokenSet_3_data_[] = { 536871154UL, 1047592UL, 0UL, 0UL };
// EOF "and" "or" "div" "mod" STAR RB RSB EQUAL NOTEQUAL MINUS PLUS GTX 
// GTE LTX LTE COMMA UNION 
const ANTLR_USE_NAMESPACE(antlr)BitSet XPathParser::_tokenSet_3(_tokenSet_3_data_,4);
const unsigned long XPathParser::_tokenSet_4_data_[] = { 4070572018UL, 2097020UL, 0UL, 0UL };
// EOF "and" "or" "div" "mod" "ancestor" "ancestor-or-self" "attribute" 
// "child" "descendant" "descendant-or-self" "following" "following-sibling" 
// "namespace" "parent" "preceding" "preceding-sibling" "self" NCNAME LITERAL 
// NUMBER STAR SLASH SLASHSLASH LB RB LSB RSB AT DOT DOTDOT EQUAL NOTEQUAL 
// MINUS PLUS GTX GTE LTX LTE COMMA UNION DOLLAR 
const ANTLR_USE_NAMESPACE(antlr)BitSet XPathParser::_tokenSet_4(_tokenSet_4_data_,4);
const unsigned long XPathParser::_tokenSet_5_data_[] = { 4070572018UL, 2097023UL, 0UL, 0UL };
// EOF "and" "or" "div" "mod" "ancestor" "ancestor-or-self" "attribute" 
// "child" "descendant" "descendant-or-self" "following" "following-sibling" 
// "namespace" "parent" "preceding" "preceding-sibling" "self" NCNAME LITERAL 
// NUMBER STAR SLASH SLASHSLASH COLON COLONCOLON LB RB LSB RSB AT DOT DOTDOT 
// EQUAL NOTEQUAL MINUS PLUS GTX GTE LTX LTE COMMA UNION DOLLAR 
const ANTLR_USE_NAMESPACE(antlr)BitSet XPathParser::_tokenSet_5(_tokenSet_5_data_,4);
const unsigned long XPathParser::_tokenSet_6_data_[] = { 547356608UL, 64UL, 0UL, 0UL };
// "div" "mod" "ancestor" "ancestor-or-self" "attribute" "child" "descendant" 
// "descendant-or-self" "following" "following-sibling" "namespace" "parent" 
// "preceding" "preceding-sibling" "self" NCNAME STAR AT 
const ANTLR_USE_NAMESPACE(antlr)BitSet XPathParser::_tokenSet_6(_tokenSet_6_data_,4);
const unsigned long XPathParser::_tokenSet_7_data_[] = { 547356608UL, 0UL, 0UL, 0UL };
// "div" "mod" "ancestor" "ancestor-or-self" "attribute" "child" "descendant" 
// "descendant-or-self" "following" "following-sibling" "namespace" "parent" 
// "preceding" "preceding-sibling" "self" NCNAME STAR 
const ANTLR_USE_NAMESPACE(antlr)BitSet XPathParser::_tokenSet_7(_tokenSet_7_data_,4);
const unsigned long XPathParser::_tokenSet_8_data_[] = { 3758096626UL, 1047613UL, 0UL, 0UL };
// EOF "and" "or" "div" "mod" STAR SLASH SLASHSLASH COLON LB RB LSB RSB 
// EQUAL NOTEQUAL MINUS PLUS GTX GTE LTX LTE COMMA UNION 
const ANTLR_USE_NAMESPACE(antlr)BitSet XPathParser::_tokenSet_8(_tokenSet_8_data_,4);
const unsigned long XPathParser::_tokenSet_9_data_[] = { 3758096626UL, 1047609UL, 0UL, 0UL };
// EOF "and" "or" "div" "mod" STAR SLASH SLASHSLASH COLON RB LSB RSB EQUAL 
// NOTEQUAL MINUS PLUS GTX GTE LTX LTE COMMA UNION 
const ANTLR_USE_NAMESPACE(antlr)BitSet XPathParser::_tokenSet_9(_tokenSet_9_data_,4);
const unsigned long XPathParser::_tokenSet_10_data_[] = { 3768582080UL, 832UL, 0UL, 0UL };
// "div" "mod" "ancestor" "ancestor-or-self" "attribute" "child" "descendant" 
// "descendant-or-self" "following" "following-sibling" "namespace" "parent" 
// "preceding" "preceding-sibling" "self" NCNAME STAR SLASH SLASHSLASH 
// AT DOT DOTDOT 
const ANTLR_USE_NAMESPACE(antlr)BitSet XPathParser::_tokenSet_10(_tokenSet_10_data_,4);
const unsigned long XPathParser::_tokenSet_11_data_[] = { 3768582130UL, 1048447UL, 0UL, 0UL };
// EOF "and" "or" "div" "mod" "ancestor" "ancestor-or-self" "attribute" 
// "child" "descendant" "descendant-or-self" "following" "following-sibling" 
// "namespace" "parent" "preceding" "preceding-sibling" "self" NCNAME STAR 
// SLASH SLASHSLASH COLON COLONCOLON LB RB LSB RSB AT DOT DOTDOT EQUAL 
// NOTEQUAL MINUS PLUS GTX GTE LTX LTE COMMA UNION 
const ANTLR_USE_NAMESPACE(antlr)BitSet XPathParser::_tokenSet_11(_tokenSet_11_data_,4);
const unsigned long XPathParser::_tokenSet_12_data_[] = { 310378496UL, 1048580UL, 0UL, 0UL };
// NCNAME LITERAL NUMBER LB DOLLAR 
const ANTLR_USE_NAMESPACE(antlr)BitSet XPathParser::_tokenSet_12(_tokenSet_12_data_,4);
const unsigned long XPathParser::_tokenSet_13_data_[] = { 4070571968UL, 1053525UL, 0UL, 0UL };
// "div" "mod" "ancestor" "ancestor-or-self" "attribute" "child" "descendant" 
// "descendant-or-self" "following" "following-sibling" "namespace" "parent" 
// "preceding" "preceding-sibling" "self" NCNAME LITERAL NUMBER STAR SLASH 
// SLASHSLASH COLON LB LSB AT DOT DOTDOT MINUS DOLLAR 
const ANTLR_USE_NAMESPACE(antlr)BitSet XPathParser::_tokenSet_13(_tokenSet_13_data_,4);
const unsigned long XPathParser::_tokenSet_14_data_[] = { 4070572016UL, 1834847UL, 0UL, 0UL };
// "and" "or" "div" "mod" "ancestor" "ancestor-or-self" "attribute" "child" 
// "descendant" "descendant-or-self" "following" "following-sibling" "namespace" 
// "parent" "preceding" "preceding-sibling" "self" NCNAME LITERAL NUMBER 
// STAR SLASH SLASHSLASH COLON COLONCOLON LB RB LSB AT DOT DOTDOT EQUAL 
// NOTEQUAL MINUS PLUS GTX GTE LTX LTE UNION DOLLAR 
const ANTLR_USE_NAMESPACE(antlr)BitSet XPathParser::_tokenSet_14(_tokenSet_14_data_,4);
const unsigned long XPathParser::_tokenSet_15_data_[] = { 3758096626UL, 1047612UL, 0UL, 0UL };
// EOF "and" "or" "div" "mod" STAR SLASH SLASHSLASH LB RB LSB RSB EQUAL 
// NOTEQUAL MINUS PLUS GTX GTE LTX LTE COMMA UNION 
const ANTLR_USE_NAMESPACE(antlr)BitSet XPathParser::_tokenSet_15(_tokenSet_15_data_,4);


