//
// See the file LICENSE for redistribution information.
//
// Copyright (c) 2002-2003
//	Sleepycat Software.  All rights reserved.
//

//
// XML Path Language (XPath) Version 1.0
// W3C Recommendation 16 November 1999
// http://www.w3.org/TR/1999/REC-xpath-19991116
//

header
{
	using namespace antlr;
}

options
{
	language="Cpp";
}

// ================================================================================
// L E X E R
// ================================================================================

class XPathLexer extends Lexer;

options
{
	k = 2;
    exportVocab=XPathLexer;
	testLiterals=false;
	charVocabulary= '\3'..'\377'; // 8-bit ASCII
}

// JCM - Unicode-16 characters should be supported. '\u0003'..'\uffff' ?
// W3C XML defines a character to be...
// [2]    Char    ::=    #x9 | #xA | #xD | [#x20-#xD7FF] | [#xE000-#xFFFD] | [#x10000-#x10FFFF] /* any Unicode character, excluding the surrogate blocks, FFFE, and FFFF. */ 


tokens
{
	
	AND= "and";
	OR= "or";
	DIV= "div";
	MOD= "mod";
	LITERAL_ancestor= "ancestor";
	LITERAL_ancestor_or_self= "ancestor-or-self";
	LITERAL_attribute= "attribute";
	LITERAL_child= "child";
	LITERAL_descendant= "descendant";
	LITERAL_descendant_or_self= "descendant-or-self"; // antlr can't automatically make this token name because of the '-' characters
	LITERAL_following= "following";
	LITERAL_following_sibling= "following-sibling";
	LITERAL_namespace= "namespace";
	LITERAL_parent= "parent";
	LITERAL_preceding= "preceding";
	LITERAL_preceding_sibling= "preceding-sibling";
	LITERAL_self= "self";
}

// XML:[3]   S ::=  (#x20 | #x9 | #xD | #xA)+
S 
  options { paraphrase="whitespace"; }
  :
  (' '
  |'\t'
  |'\n' { newline(); }
  |'\r' { newline(); }
  ) { $setType(Token::SKIP); }
  ;

// Single-line comments
SL_COMMENT
  options { paraphrase="a comment"; }
  : "--" (~('\n'|'\r'))*
  { $setType(Token::SKIP); }
  ;

// Namespace:[4]  NCName ::=  (Letter | "_") (NCNameChar)* 
NCNAME
  options { testLiterals=true; paraphrase="an identifier"; }
  : (LETTER|'_') (NCNAMECHAR)*
  ;

// Namespace:[5]  NCNameChar ::=  Letter | Digit | "." | "-" | "_" | CombiningChar | Extender 
// JCM - See XML for complete definition of Letter, CombiningChar, Extender
protected
NCNAMECHAR: LETTER|'0'..'9'|'.'|'-'|'_';

// XPath:[29] Literal ::= '"' [^"]* '"' | "'" [^']* "'"
LITERAL
  options {paraphrase="a string literal";}
  : '"' (~('"'))* '"'
  | '\'' (~('\''))* '\''
  ;

protected
LETTER: ('a'..'z'|'A'..'Z'|'\200'..'\377');

// XPath:[31] Digits ::= [0-9]+
protected
DIGITS
  options {paraphrase="a numeric literal";}
  : ('0'..'9')+;

// XPath:[30] Number ::= Digits ("." Digits?)? | "." Digits
// JCM - unable to get ('.' DIGITS) working.
NUMBER
  options {paraphrase="a number";}
  : DIGITS ('.' (DIGITS)?)?
//  | '.' DIGITS
  ;

// XPath:[34] MultiplyOperator ::= '*'
STAR: '*';

SLASH: '/';
SLASHSLASH: "//";
COLON: ':';
COLONCOLON: "::";
LB options {paraphrase="a left bracket '('";} : '(';
RB options {paraphrase="a right bracket ')'";} : ')';
LSB options {paraphrase="a left square bracket '['";} : '[';
RSB options {paraphrase="a right square bracket ']'";} : ']';
AT: '@';
SEMICOLON: ';';
DOT options {paraphrase="a current node selector '.'";} : '.';
DOTDOT options {paraphrase="a parent node selector '..'";} : "..";
EQUAL options {paraphrase="an equals operator '='";} : '=';
NOTEQUAL options {paraphrase="a not equals operator '!='";} : "!=";
MINUS options {paraphrase="a subtraction or unary minus operator '-'";} : '-';
PLUS options {paraphrase="an addition operator '+'";} : '+';
GTX options {paraphrase="a greater than operator '>'";} : '>';
GTE options {paraphrase="a greater than or equals operator '>='";} : ">=";
LTX options {paraphrase="a less than operator '<'";} : '<';
LTE options {paraphrase="a less than or equals operator '<='";} : "<=";
COMMA options {paraphrase="an argument separator ','";} : ',';
UNION options {paraphrase="a union operator '|'";} : '|';
DOLLAR options {paraphrase="a variable dereference operator '$'";} : '$';
