//
// See the file LICENSE for redistribution information.
//
// Copyright (c) 2002-2003
//	Sleepycat Software.  All rights reserved.
//

static const char revid[] = "$Id: VariableBindings.cpp,v 1.14 2003/05/09 00:01:55 mjc Exp $";

#include "dbxml_config.h"
#include "dbxml/XmlPortability.hpp"
#include "VariableBindings.hpp"

using namespace DbXml;

// VariableBindings

VariableBindings::VariableBindings(const VariableBindings &o)
{
	*this = o;
}

VariableBindings &VariableBindings::operator = (const VariableBindings &o)
{
	if (this != &o) {
		values_ = o.values_;
	}
	return *this;
}

bool VariableBindings::getVariableValue(const std::string &name, XmlValue &value) const
{
	Values::const_iterator i = values_.find(name);
	if (i != values_.end()) {
		value = i->second;
	} else {
		value = XmlValue();
	}
	return !value.isNull();
}

void VariableBindings::setVariableValue(const std::string &name, const XmlValue &value)
{
	values_[name] = value;
}
