//
// See the file LICENSE for redistribution information.
//
// Copyright (c) 2002-2003
//	Sleepycat Software.  All rights reserved.
//
// $Id: UpdateContext.hpp,v 1.8 2003/05/09 00:01:54 mjc Exp $
//

#ifndef __UPDATECONTEXT_HPP
#define	__UPDATECONTEXT_HPP

#include "ReferenceCounted.hpp"
#include "Container.hpp"
#include "Indexer.hpp"
#include "IndexSpecification.hpp"
#include "OperationContext.hpp"

namespace DbXml
{

class UpdateContext : public ReferenceCounted
{
public:
	/// Constructor.
	UpdateContext(Container *container);
	virtual ~UpdateContext();

	Indexer &getIndexer();
	IndexSpecification &getIndexSpecification(DbTxn *txn);
	OperationContext &getOperationContext(DbTxn *txn);
private:
	// no need for copy and assignment
	UpdateContext(const UpdateContext&);
	UpdateContext &operator=(const UpdateContext &);

	Container &container_;
	Indexer indexer_;
	IndexSpecification is_;
	OperationContext oc_;
};

}

#endif

