//
// See the file LICENSE for redistribution information.
//
// Copyright (c) 2002-2003
//	Sleepycat Software.  All rights reserved.
//

static const char revid[] = "$Id: UpdateContext.cpp,v 1.5 2003/05/09 00:01:54 mjc Exp $";

#include "dbxml_config.h"
#include "dbxml/XmlPortability.hpp"
#include "UpdateContext.hpp"

using namespace DbXml;

UpdateContext::UpdateContext(Container *container)
	: container_(*container),
	indexer_(container)
{}

UpdateContext::~UpdateContext()
{}

Indexer &UpdateContext::getIndexer()
{
	indexer_.reset();
	return indexer_;
}

IndexSpecification &UpdateContext::getIndexSpecification(DbTxn *txn)
{
	is_.read(container_, txn, /*lock=*/false);
	return is_;
}

OperationContext &UpdateContext::getOperationContext(DbTxn *txn)
{
	oc_.set(txn);
	return oc_;
}
