//
// See the file LICENSE for redistribution information.
//
// Copyright (c) 2002-2003
//	Sleepycat Software.  All rights reserved.
//

static const char revid[] = "$Id: UTF8.cpp,v 1.5 2003/06/04 00:44:31 merrells Exp $";

#include "dbxml_config.h"
#include "dbxml/XmlPortability.hpp"
#include "UTF8.hpp"

#if defined(DBXML_DOM_XERCES2)
#include <xercesc/util/XMLString.hpp>
#if defined(XERCES_HAS_CPP_NAMESPACE)
  XERCES_CPP_NAMESPACE_USE
#endif
#endif

#if defined(DBXML_XPATH_PATHAN)

using namespace DbXml;

UTF8ToXMLCh::UTF8ToXMLCh(const std::string &s)
{
	XMLUTF8Transcoder t(0, 512);
	size_t l = s.length();
	xmlch_ = new XMLCh[l + 1];
	unsigned char *charSizes = new unsigned char[l + 1];
	unsigned int count = 0;
	t.transcodeFrom((XMLByte*)s.c_str(), l + 1, xmlch_, l + 1, count, charSizes);
	delete [] charSizes;
}

UTF8ToXMLCh::~UTF8ToXMLCh()
{
	delete [] xmlch_;
}

const XMLCh *UTF8ToXMLCh::str() const
{
	return xmlch_;
}

XMLChToUTF8::XMLChToUTF8(const XMLCh* const toTranscode)
{
	XMLUTF8Transcoder t(0, 512);
	size_t l = XMLString::stringLen(toTranscode);
	const unsigned int needed = l * 3 + 1; // 3 bytes per XMLCh is the worst case, + '\0'
	p_ = new XMLByte[needed];
	unsigned int charsEaten= 0;
    t.transcodeTo(toTranscode, l+1, p_, needed, charsEaten, XMLTranscoder::UnRep_Throw);
}

XMLChToUTF8::~XMLChToUTF8()
{
	delete [] p_;
}

const char *XMLChToUTF8::str() const
{
	return (const char *)p_;
}

#endif
