//
// See the file LICENSE for redistribution information.
//
// Copyright (c) 2002-2003
//	Sleepycat Software.  All rights reserved.
//
// $Id: TypeConversions.hpp,v 1.3 2003/05/09 00:01:53 mjc Exp $
//

#ifndef __TYPECONVERSIONS_HPP
#define	__TYPECONVERSIONS_HPP

#include <string>
#include <db_cxx.h>

namespace DbXml
{

inline std::string toString(int i)
{
	char buf[64];
	::sprintf(buf, "%d", i);
	return std::string(buf);
}

inline std::string toString(u_int32_t i)
{
	char buf[64];
	::sprintf(buf, "%u", i);
	return std::string(buf);
}

inline std::string toString(double d)
{
	char buf[128];
	::sprintf(buf, "%0.15g", d);
	return std::string(buf);
}

inline int stringToInt(const std::string &s)
{
	return ::atoi(s.c_str());
}

}

#endif

