//
// See the file LICENSE for redistribution information.
//
// Copyright (c) 2002-2003
//	Sleepycat Software.  All rights reserved.
//
// $Id: TransactedContainer.hpp,v 1.8 2003/12/01 15:52:01 gmf Exp $
//

#ifndef __TRANSACTEDCONTAINER_HPP
#define	__TRANSACTEDCONTAINER_HPP

#include "dbxml/XmlPortability.hpp"
#include "dbxml/DbXmlFwd.hpp"
#include "ID.hpp"
#include "Container.hpp"
#include <db_cxx.h>

#include <string>

namespace DbXml
{

class Functor;
class UpdateContext;
class Document;
class Modify;
	
/**
 * TransactedContainer wraps a Container with a Berkeley DB
 * environment, and the update methods with Berkeley DB
 * transactions (if they not provided by the caller).
 */
class TransactedContainer : public Container
{
public:
	TransactedContainer(DbEnv *environment, const std::string &name, u_int32_t flags);
	virtual ~TransactedContainer();

	// Container Operations
	int open(DbTxn *txn, u_int32_t flags, int mode, bool doVersionCheck);
	int remove(DbTxn *txn, u_int32_t flags);
	int rename(DbTxn *txn, const std::string &newName, u_int32_t flags);
	int addDocument(DbTxn *txn, Document &document, ID &id, UpdateContext &context, u_int32_t flags);
	int getDocument(DbTxn *txn, ID id, XmlDocument &document, u_int32_t flags) const;
	int deleteDocument(DbTxn *txn, ID id, UpdateContext &context, u_int32_t flags);
	int deleteDocument(DbTxn *txn, Document &document, UpdateContext &context, u_int32_t flags);
	int updateDocument(DbTxn *txn, Document &document, UpdateContext &context);
	int modifyDocument(DbTxn *txn, const Modify &modify, XmlUpdateContext *context, u_int32_t flags);
	int setIndexSpecification(DbTxn *txn, const XmlIndexSpecification &index);
	int getIndexSpecification(DbTxn *txn, XmlIndexSpecification &index) const;
	int addIndex(DbTxn *txn, const std::string &uri, const std::string &name, const std::string &index);
	int deleteIndex(DbTxn *txn, const std::string &uri, const std::string &name, const std::string &index);
	int replaceIndex(DbTxn *txn, const std::string &uri, const std::string &name, const std::string &index);
	DbEnv *getEnvironment();

private:
	// no need for copy and assignment
	TransactedContainer(const TransactedContainer&);
	void operator=(const TransactedContainer &);

	int transactedMethod(DbTxn *txn, u_int32_t flags, const Functor &f);

	DbEnv *environment_;
	bool autoCommit_;
	bool ownsEnvironment_;
};

}

#endif

