//
// See the file LICENSE for redistribution information.
//
// Copyright (c) 2002-2003
//	Sleepycat Software.  All rights reserved.
//
// $Id: Syntax.hpp,v 1.13 2003/10/02 21:54:41 merrells Exp $
//

#ifndef __SYNTAX_HPP
#define	__SYNTAX_HPP

#include "db_cxx.h"
#include "Database.hpp"
#include "KeyGenerator.hpp"

namespace DbXml
{

class Index;

class Syntax
{
public:
	enum Type
	{
	    NONE,
	    STRING,
	    NUMBER
	};
	virtual Type getType() const = 0;
	virtual const char *getName() const = 0;
	virtual bool test(const char *v, size_t len) const = 0;
	virtual int compare(const char *p1, size_t l1, const char *p2, size_t l2) const = 0;
	virtual int bt_compare(Db *db, const Dbt *dbt1, const Dbt *dbt2) const = 0;
	virtual Database::bt_compare_fn get_bt_compare() const = 0;
	virtual int structureKeyLength(const Index &index, size_t keyLength) const = 0;
	virtual const char *minimumValue() const = 0;
	virtual const char *maximumValue() const = 0;
	virtual size_t countKeys(const Index &index, const char *valueBuffer, size_t valueLength) const = 0; // returns 0, 1, or 2 for many
	virtual KeyGenerator::Ptr getKeyGenerator(const Index &index, const char *valueBuffer, size_t valueLength) const = 0;
};

class NoneSyntax : public Syntax
{
public:
	virtual Type getType() const;
	virtual const char *getName() const;
	virtual bool test(const char *v, size_t len) const;
	virtual int compare(const char *p1, size_t l1, const char *p2, size_t l2) const;
	virtual int bt_compare(Db *db, const Dbt *dbt1, const Dbt *dbt2) const;
	virtual Database::bt_compare_fn get_bt_compare() const;
	virtual int structureKeyLength(const Index &index, size_t keyLength) const;
	static int static_bt_compare(Db *db, const Dbt *dbt1, const Dbt *dbt2);
	virtual const char *minimumValue() const;
	virtual const char *maximumValue() const;
	virtual size_t countKeys(const Index &index, const char *valueBuffer, size_t valueLength) const; // returns 0, 1, or 2 for many
	virtual KeyGenerator::Ptr getKeyGenerator(const Index &index, const char *valueBuffer, size_t valueLength) const;
};

class StringSyntax : public Syntax
{
public:
	virtual Type getType() const;
	virtual const char *getName() const;
	virtual bool test(const char *v, size_t len) const;
	virtual int compare(const char *p1, size_t l1, const char *p2, size_t l2) const;
	virtual int bt_compare(Db *db, const Dbt *dbt1, const Dbt *dbt2) const;
	virtual Database::bt_compare_fn get_bt_compare() const;
	virtual int structureKeyLength(const Index &index, size_t keyLength) const;
	static int static_bt_compare(Db *db, const Dbt *dbt1, const Dbt *dbt2);
	virtual const char *minimumValue() const;
	virtual const char *maximumValue() const;
	virtual size_t countKeys(const Index &index, const char *valueBuffer, size_t valueLength) const; // returns 0, 1, or 2 for many
	virtual KeyGenerator::Ptr getKeyGenerator(const Index &index, const char *valueBuffer, size_t valueLength) const;
};

class NumberSyntax : public Syntax
{
public:
	virtual Type getType() const;
	virtual const char *getName() const;
	virtual bool test(const char *v, size_t len) const;
	virtual int compare(const char *p1, size_t l1, const char *p2, size_t l2) const;
	virtual int bt_compare(Db *db, const Dbt *dbt1, const Dbt *dbt2) const;
	virtual SecondaryDatabase::bt_compare_fn get_bt_compare() const;
	virtual int structureKeyLength(const Index &index, size_t keyLength) const;
	static int static_bt_compare(Db *db, const Dbt *dbt1, const Dbt *dbt2);
	virtual const char *minimumValue() const;
	virtual const char *maximumValue() const;
	virtual size_t countKeys(const Index &index, const char *valueBuffer, size_t valueLength) const; // returns 0, 1, or 2 for many
	virtual KeyGenerator::Ptr getKeyGenerator(const Index &index, const char *valueBuffer, size_t valueLength) const;
};

}

#endif
