//
// See the file LICENSE for redistribution information.
//
// Copyright (c) 2002-2003
//	Sleepycat Software.  All rights reserved.
//
// $Id: Statistics.hpp,v 1.20 2003/05/23 18:24:35 merrells Exp $
//

#ifndef __STATISTICS_HPP
#define	__STATISTICS_HPP

#include <map>
#include <vector>
#include "ID.hpp"
#include "KeyStatistics.hpp"
#include "ScopedDbt.hpp"

class DbTxn;

namespace DbXml
{

class Container;
class Key;
class Statistics;
class Index;
class Syntax;
class OperationContext;

// The indexer makes use of this class to maintain statistics about
// the keys being generated.
//
class Statistics
{
public:
	Statistics();
	~Statistics();
	// Reset the statistics object so that it can be reused.
	void reset();
	// Add a key to the statistics. We assume that key has the correct endianness.
	void addToKeyStatistics(const Syntax &syntax, const Index &index, void *keyBuffer, size_t keyLength, bool unique, bool add);
	// Write the statistics to the statistics databases
	int updateContainer(OperationContext &context, Container &container);
private:
	typedef std::map<DbtIn, KeyStatistics> Dbt2KSMap;
	typedef std::vector<Dbt2KSMap*> Dbt2KSMapVector;
	Dbt2KSMapVector dkv_;
};

}
#endif
