//
// See the file LICENSE for redistribution information.
//
// Copyright (c) 2002-2003
//	Sleepycat Software.  All rights reserved.
//
// $Id: Results.hpp,v 1.24 2003/12/09 14:07:04 merrells Exp $
//

#ifndef __RESULTS_HPP
#define	__RESULTS_HPP

#include <string>
#include "dbxml/XmlValue.hpp"
#include "dbxml/XmlQueryContext.hpp"
#include "QueryPlan.hpp"
#include "ReferenceCounted.hpp"
#include "Value.hpp"

namespace DbXml
{

class Container;

class Results : public ReferenceCounted
{
public:
	Results(QueryContext &context, DbTxn *txn);
	virtual ~Results();

	// Note that ownership of the query plan is passed in, and we bump
	// the reference count of the Container and Query Context.
	//
	int set(Container &container, QueryPlan::SharedPtr &qp);
	int next(XmlValue &value);
	void reset();
	void add(const XmlValue &value);
	void add(const XmlValueVector &vv);
	enum SizeType { Actual, Estimate, Unknown };
	void size(size_t &size, SizeType &type) const;

private:
	// no need for copy and assignment
	Results(const Results&);
	Results &operator=(const Results &);

	DbTxn *txn_;
	QueryContext &context_;

	// For Lazy evaluation we maintain references to the Container,
	// Query Context, and Query Plan.
	//
	Container *container_;
	QueryPlan::SharedPtr qp_;

	// For Eager evaluation we copy the values into a vector.
	//
	DbXml::XmlValueVector *vv_;
	DbXml::XmlValueVector::iterator *vvi_;
};

}

#endif

