//
// See the file LICENSE for redistribution information.
//
// Copyright (c) 2002-2003
//	Sleepycat Software.  All rights reserved.
//
// $Id: QueryExpression.hpp,v 1.12 2003/05/12 23:13:10 merrells Exp $
//

#ifndef __EXPRESSION_HPP
#define	__EXPRESSION_HPP

#include <string>
#include "dbxml/XmlQueryContext.hpp"
#include "QueryPlan.hpp"
#include "ReferenceCounted.hpp"

namespace DbXml
{

class QueryExpression : public ReferenceCounted
{
public:
	QueryExpression(QueryContext &context);
	virtual ~QueryExpression();

	void set(const std::string &xpath, QueryPlan::SharedPtr qp);
	std::string getXPathQuery() const
	{
		return xpath_;
	}
	QueryContext &getContext()
	{
		return context_;
	}
	QueryPlan::SharedPtr getQueryPlan() const
	{
		return qp_;
	}

private:
	QueryExpression(const QueryExpression&);
	QueryExpression &operator=(const QueryExpression &);

	std::string xpath_;
	QueryContext &context_;
	QueryPlan::SharedPtr qp_;
};

}

#endif

